/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.event.TransferStateChangeListener;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferMonitor;
import com.qcloud.cos.transfer.TransferProgress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractTransfer
implements Transfer {
    protected volatile Transfer.TransferState state = Transfer.TransferState.Waiting;
    protected TransferMonitor monitor;
    private final TransferProgress transferProgress;
    private final String description;
    protected final ProgressListenerChain listenerChain;
    protected final Collection<TransferStateChangeListener> stateChangeListeners = new LinkedList<TransferStateChangeListener>();

    public AbstractTransfer(String string, TransferProgress transferProgress, ProgressListenerChain progressListenerChain) {
        this(string, transferProgress, progressListenerChain, null);
    }

    public AbstractTransfer(String string, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, TransferStateChangeListener transferStateChangeListener) {
        this.description = string;
        this.listenerChain = progressListenerChain;
        this.transferProgress = transferProgress;
        this.addStateChangeListener(transferStateChangeListener);
    }

    @Override
    public final synchronized boolean isDone() {
        return this.state == Transfer.TransferState.Failed || this.state == Transfer.TransferState.Completed || this.state == Transfer.TransferState.Canceled;
    }

    @Override
    public void waitForCompletion() throws CosClientException, CosServiceException, InterruptedException {
        try {
            Object var1_1 = null;
            while (!this.monitor.isDone() || var1_1 == null) {
                Future<?> future = this.monitor.getFuture();
                var1_1 = future.get();
            }
        }
        catch (ExecutionException executionException) {
            this.rethrowExecutionException(executionException);
        }
    }

    @Override
    public CosClientException waitForException() throws InterruptedException {
        try {
            while (!this.monitor.isDone()) {
                this.monitor.getFuture().get();
            }
            this.monitor.getFuture().get();
            return null;
        }
        catch (ExecutionException executionException) {
            return this.unwrapExecutionException(executionException);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized Transfer.TransferState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(Transfer.TransferState transferState) {
        AbstractTransfer abstractTransfer = this;
        synchronized (abstractTransfer) {
            this.state = transferState;
        }
        for (TransferStateChangeListener transferStateChangeListener : this.stateChangeListeners) {
            transferStateChangeListener.transferStateChanged(this, transferState);
        }
    }

    public void notifyStateChangeListeners(Transfer.TransferState transferState) {
        for (TransferStateChangeListener transferStateChangeListener : this.stateChangeListeners) {
            transferStateChangeListener.transferStateChanged(this, transferState);
        }
    }

    @Override
    public synchronized void addProgressListener(ProgressListener progressListener) {
        this.listenerChain.addProgressListener(progressListener);
    }

    @Override
    public synchronized void removeProgressListener(ProgressListener progressListener) {
        this.listenerChain.removeProgressListener(progressListener);
    }

    public synchronized void addStateChangeListener(TransferStateChangeListener transferStateChangeListener) {
        if (transferStateChangeListener != null) {
            this.stateChangeListeners.add(transferStateChangeListener);
        }
    }

    public synchronized void removeStateChangeListener(TransferStateChangeListener transferStateChangeListener) {
        if (transferStateChangeListener != null) {
            this.stateChangeListeners.remove(transferStateChangeListener);
        }
    }

    @Override
    public TransferProgress getProgress() {
        return this.transferProgress;
    }

    public void setMonitor(TransferMonitor transferMonitor) {
        this.monitor = transferMonitor;
    }

    public TransferMonitor getMonitor() {
        return this.monitor;
    }

    protected void fireProgressEvent(ProgressEventType progressEventType) {
        SDKProgressPublisher.publishProgress(this.listenerChain, progressEventType);
    }

    protected void rethrowExecutionException(ExecutionException executionException) {
        throw this.unwrapExecutionException(executionException);
    }

    protected CosClientException unwrapExecutionException(ExecutionException executionException) {
        Throwable throwable = executionException.getCause();
        if (throwable instanceof CosClientException) {
            return (CosClientException)throwable;
        }
        return new CosClientException("Unable to complete transfer: " + throwable.getMessage(), throwable);
    }
}

