/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model.transform;

import com.qcloud.cos.annotation.SdkInternalApi;
import com.qcloud.cos.exception.SelectObjectContentEventException;
import com.qcloud.cos.internal.eventstreaming.HeaderType;
import com.qcloud.cos.internal.eventstreaming.HeaderValue;
import com.qcloud.cos.internal.eventstreaming.Message;
import com.qcloud.cos.model.SelectObjectContentEvent;
import com.qcloud.cos.model.transform.ProgressStaxUnmarshaller;
import com.qcloud.cos.model.transform.StatsStaxUnmarshaller;
import com.qcloud.cos.model.transform.StaxUnmarshallerContext;
import com.qcloud.cos.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;

@SdkInternalApi
public abstract class SelectObjectContentEventUnmarshaller {
    public static SelectObjectContentEvent unmarshalMessage(Message message) {
        String string = SelectObjectContentEventUnmarshaller.getStringHeader(message, ":message-type");
        if ("error".equals(string)) {
            throw SelectObjectContentEventUnmarshaller.unmarshalErrorMessage(message);
        }
        if ("event".equals(string)) {
            return SelectObjectContentEventUnmarshaller.unmarshalEventMessage(message);
        }
        throw new SelectObjectContentEventException("Service returned unknown message type: " + string);
    }

    private static SelectObjectContentEventException unmarshalErrorMessage(Message message) {
        String string = SelectObjectContentEventUnmarshaller.getStringHeader(message, ":error-code");
        String string2 = SelectObjectContentEventUnmarshaller.getStringHeader(message, ":error-message");
        SelectObjectContentEventException selectObjectContentEventException = new SelectObjectContentEventException("COS returned an error: " + string2 + " (" + string + ")");
        selectObjectContentEventException.setErrorCode(string);
        selectObjectContentEventException.setErrorMessage(string2);
        return selectObjectContentEventException;
    }

    private static SelectObjectContentEvent unmarshalEventMessage(Message message) {
        String string = SelectObjectContentEventUnmarshaller.getStringHeader(message, ":event-type");
        try {
            return SelectObjectContentEventUnmarshaller.forEventType(string).unmarshal(message);
        }
        catch (Exception exception) {
            throw new SelectObjectContentEventException("Failed to read response event of type " + string, exception);
        }
    }

    public static SelectObjectContentEventUnmarshaller forEventType(String string) {
        if ("Records".equals(string)) {
            return new RecordsEventUnmarshaller();
        }
        if ("Stats".equals(string)) {
            return new StatsEventUnmarshaller();
        }
        if ("Progress".equals(string)) {
            return new ProgressEventUnmarshaller();
        }
        if ("Cont".equals(string)) {
            return new ContinuationEventUnmarshaller();
        }
        if ("End".equals(string)) {
            return new EndEventUnmarshaller();
        }
        return new UnknownEventUnmarshaller();
    }

    private static String getStringHeader(Message message, String string) {
        HeaderValue headerValue = message.getHeaders().get(string);
        if (headerValue == null) {
            throw new SelectObjectContentEventException("Unexpected lack of '" + string + "' header from service.");
        }
        if (headerValue.getType() != HeaderType.STRING) {
            throw new SelectObjectContentEventException("Unexpected non-string '" + string + "' header: " + (Object)((Object)headerValue.getType()));
        }
        return headerValue.getString();
    }

    public abstract SelectObjectContentEvent unmarshal(Message var1) throws Exception;

    private static StaxUnmarshallerContext payloadUnmarshaller(Message message) throws XMLStreamException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(message.getPayload());
        XMLEventReader xMLEventReader = XmlUtils.getXmlInputFactory().createXMLEventReader(byteArrayInputStream);
        return new StaxUnmarshallerContext(xMLEventReader);
    }

    public static class UnknownEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent unmarshal(Message message) {
            return new SelectObjectContentEvent();
        }
    }

    public static class EndEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.EndEvent unmarshal(Message message) {
            return new SelectObjectContentEvent.EndEvent();
        }
    }

    public static class ContinuationEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.ContinuationEvent unmarshal(Message message) {
            return new SelectObjectContentEvent.ContinuationEvent();
        }
    }

    public static class ProgressEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.ProgressEvent unmarshal(Message message) throws Exception {
            StaxUnmarshallerContext staxUnmarshallerContext = SelectObjectContentEventUnmarshaller.payloadUnmarshaller(message);
            return new SelectObjectContentEvent.ProgressEvent().withDetails(ProgressStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
        }
    }

    public static class StatsEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.StatsEvent unmarshal(Message message) throws Exception {
            StaxUnmarshallerContext staxUnmarshallerContext = SelectObjectContentEventUnmarshaller.payloadUnmarshaller(message);
            return new SelectObjectContentEvent.StatsEvent().withDetails(StatsStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
        }
    }

    public static class RecordsEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.RecordsEvent unmarshal(Message message) {
            return new SelectObjectContentEvent.RecordsEvent().withPayload(ByteBuffer.wrap(message.getPayload()));
        }
    }
}

