/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.model.SSEAlgorithm;
import com.qcloud.cos.utils.Base64;
import java.io.Serializable;
import javax.crypto.SecretKey;

public class SSECustomerKey
implements Serializable {
    private final String base64EncodedKey;
    private String base64EncodedMd5;
    private String algorithm;

    public SSECustomerKey(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Encryption key must be specified");
        }
        this.algorithm = SSEAlgorithm.AES256.getAlgorithm();
        this.base64EncodedKey = string;
    }

    public SSECustomerKey(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Encryption key must be specified");
        }
        this.algorithm = SSEAlgorithm.AES256.getAlgorithm();
        this.base64EncodedKey = Base64.encodeAsString(byArray);
    }

    public SSECustomerKey(SecretKey secretKey) {
        if (secretKey == null) {
            throw new IllegalArgumentException("Encryption key must be specified");
        }
        this.algorithm = SSEAlgorithm.AES256.getAlgorithm();
        this.base64EncodedKey = Base64.encodeAsString(secretKey.getEncoded());
    }

    private SSECustomerKey() {
        this.base64EncodedKey = null;
    }

    public String getKey() {
        return this.base64EncodedKey;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public SSECustomerKey withAlgorithm(String string) {
        this.setAlgorithm(string);
        return this;
    }

    public String getMd5() {
        return this.base64EncodedMd5;
    }

    public void setMd5(String string) {
        this.base64EncodedMd5 = string;
    }

    public SSECustomerKey withMd5(String string) {
        this.setMd5(string);
        return this;
    }

    public static SSECustomerKey generateSSECustomerKeyForPresignUrl(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return new SSECustomerKey().withAlgorithm(string);
    }
}

