/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.eventstreaming;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;

final class Prelude {
    static final int LENGTH = 8;
    static final int LENGTH_WITH_CRC = 12;
    private final int totalLength;
    private final long headersLength;

    private Prelude(int n, long l) {
        this.totalLength = n;
        this.headersLength = l;
    }

    static Prelude decode(ByteBuffer byteBuffer) {
        byteBuffer = byteBuffer.duplicate();
        long l = Prelude.computePreludeCrc(byteBuffer);
        long l2 = Prelude.intToUnsignedLong(byteBuffer.getInt());
        long l3 = Prelude.intToUnsignedLong(byteBuffer.getInt());
        long l4 = Prelude.intToUnsignedLong(byteBuffer.getInt());
        if (l != l4) {
            throw new IllegalArgumentException(String.format("Prelude checksum failure: expected 0x%x, computed 0x%x", l4, l));
        }
        if (l3 < 0L || l3 > 131072L) {
            throw new IllegalArgumentException("Illegal headers_length value: " + l3);
        }
        long l5 = l2 - l3 - 16L;
        if (l5 < 0L || l5 > 0x1000000L) {
            throw new IllegalArgumentException("Illegal payload size: " + l5);
        }
        return new Prelude(Prelude.toIntExact(l2), l3);
    }

    private static long intToUnsignedLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    private static int toIntExact(long l) {
        if ((long)((int)l) != l) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)l;
    }

    private static long computePreludeCrc(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[8];
        byteBuffer.duplicate().get(byArray);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        return cRC32.getValue();
    }

    int getTotalLength() {
        return this.totalLength;
    }

    long getHeadersLength() {
        return this.headersLength;
    }
}

