/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectId;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.utils.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

public class COSObjectWrapper
implements Closeable {
    private final COSObject cosobj;
    private final COSObjectId id;

    COSObjectWrapper(COSObject cOSObject, COSObjectId cOSObjectId) {
        if (cOSObject == null) {
            throw new IllegalArgumentException();
        }
        this.cosobj = cOSObject;
        this.id = cOSObjectId;
    }

    public COSObjectId getCOSObjectId() {
        return this.id;
    }

    ObjectMetadata getObjectMetadata() {
        return this.cosobj.getObjectMetadata();
    }

    void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.cosobj.setObjectMetadata(objectMetadata);
    }

    COSObjectInputStream getObjectContent() {
        return this.cosobj.getObjectContent();
    }

    void setObjectContent(COSObjectInputStream cOSObjectInputStream) {
        this.cosobj.setObjectContent(cOSObjectInputStream);
    }

    void setObjectContent(InputStream inputStream2) {
        this.cosobj.setObjectContent(inputStream2);
    }

    String getBucketName() {
        return this.cosobj.getBucketName();
    }

    void setBucketName(String string) {
        this.cosobj.setBucketName(string);
    }

    String getKey() {
        return this.cosobj.getKey();
    }

    void setKey(String string) {
        this.cosobj.setKey(string);
    }

    public String toString() {
        return this.cosobj.toString();
    }

    final boolean hasEncryptionInfo() {
        ObjectMetadata objectMetadata = this.cosobj.getObjectMetadata();
        Map<String, String> map = objectMetadata.getUserMetadata();
        return map != null && (map.containsKey("x-cos-iv") || map.containsKey("client-side-encryption-start")) && (map.containsKey("x-cos-key-v2") || map.containsKey("x-cos-key")) || map.containsKey("client-side-encryption-key");
    }

    String toJsonString() {
        try {
            return COSObjectWrapper.from(this.cosobj.getObjectContent());
        }
        catch (Exception exception) {
            throw new CosClientException("Error parsing JSON: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String from(InputStream inputStream2) throws IOException {
        if (inputStream2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, StringUtils.UTF8));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        finally {
            inputStream2.close();
        }
        return stringBuilder.toString();
    }

    @Override
    public void close() throws IOException {
        this.cosobj.close();
    }

    COSObject getCOSObject() {
        return this.cosobj;
    }

    ContentCryptoScheme encryptionSchemeOf(Map<String, String> map) {
        if (map != null) {
            String string = map.get("x-cos-cek-alg");
            return ContentCryptoScheme.fromCEKAlgo(string);
        }
        ObjectMetadata objectMetadata = this.cosobj.getObjectMetadata();
        Map<String, String> map2 = objectMetadata.getUserMetadata();
        String string = map2.get("client-side-encryption-cek-alg");
        return ContentCryptoScheme.fromCEKAlgo(string);
    }
}

