/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.internal.COSDirect;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.InputSubstream;
import com.qcloud.cos.internal.LengthCheckInputStream;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.internal.ResettableInputStream;
import com.qcloud.cos.internal.SdkFilterInputStream;
import com.qcloud.cos.internal.ServerSideEncryptionResult;
import com.qcloud.cos.internal.crypto.COSCryptoModule;
import com.qcloud.cos.internal.crypto.COSCryptoScheme;
import com.qcloud.cos.internal.crypto.COSObjectWrapper;
import com.qcloud.cos.internal.crypto.CipherLite;
import com.qcloud.cos.internal.crypto.CipherLiteInputStream;
import com.qcloud.cos.internal.crypto.ContentCryptoMaterial;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoStorageMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterials;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsAccessor;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsFactory;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.KMSSecuredCEK;
import com.qcloud.cos.internal.crypto.MultipartUploadCryptoContext;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.qcloud.cos.internal.crypto.RenewableCipherLiteInputStream;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.AbstractPutObjectRequest;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectId;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.CosDataSource;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.InstructionFileId;
import com.qcloud.cos.model.MaterialsDescriptionProvider;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutInstructionFileRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.utils.Base64;
import com.qcloud.cos.utils.IOUtils;
import com.qcloud.cos.utils.Jackson;
import com.qcloud.cos.utils.StringUtils;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyRequest;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class COSCryptoModuleBase
extends COSCryptoModule {
    private static final boolean IS_MULTI_PART = true;
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterialsProvider kekMaterialsProvider;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final COSCryptoScheme cryptoScheme;
    protected final ContentCryptoScheme contentCryptoScheme;
    protected final CryptoConfiguration cryptoConfig;
    protected final Map<String, MultipartUploadCryptoContext> multipartUploadContexts = Collections.synchronizedMap(new HashMap());
    protected final COSDirect cos;
    protected final QCLOUDKMS kms;

    protected COSCryptoModuleBase(QCLOUDKMS qCLOUDKMS, COSDirect cOSDirect, COSCredentialsProvider cOSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        if (!cryptoConfiguration.isReadOnly()) {
            throw new IllegalArgumentException("The cryto configuration parameter is required to be read-only");
        }
        this.kekMaterialsProvider = encryptionMaterialsProvider;
        this.cos = cOSDirect;
        this.cryptoConfig = cryptoConfiguration;
        this.cryptoScheme = COSCryptoScheme.from(cryptoConfiguration.getCryptoMode());
        this.contentCryptoScheme = this.cryptoScheme.getContentCryptoScheme();
        this.kms = qCLOUDKMS;
        this.contentCryptoScheme.setIV(cryptoConfiguration.getIV());
    }

    protected COSCryptoModuleBase(COSDirect cOSDirect, COSCredentialsProvider cOSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        this.kekMaterialsProvider = encryptionMaterialsProvider;
        this.cos = cOSDirect;
        this.cryptoConfig = cryptoConfiguration;
        this.cryptoScheme = COSCryptoScheme.from(cryptoConfiguration.getCryptoMode());
        this.contentCryptoScheme = this.cryptoScheme.getContentCryptoScheme();
        this.kms = null;
    }

    protected abstract long ciphertextLength(long var1);

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) {
        return this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile ? this.putObjectUsingInstructionFile(putObjectRequest) : this.putObjectUsingMetadata(putObjectRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PutObjectResult putObjectUsingMetadata(PutObjectRequest putObjectRequest) {
        ContentCryptoMaterial contentCryptoMaterial = this.createContentCryptoMaterial(putObjectRequest);
        File file = putObjectRequest.getFile();
        InputStream inputStream2 = putObjectRequest.getInputStream();
        PutObjectRequest putObjectRequest2 = this.wrapWithCipher(putObjectRequest, contentCryptoMaterial);
        putObjectRequest.setMetadata(this.updateMetadataWithContentCryptoMaterial(putObjectRequest.getMetadata(), putObjectRequest.getFile(), contentCryptoMaterial));
        try {
            PutObjectResult putObjectResult = this.cos.putObject(putObjectRequest2);
            return putObjectResult;
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(putObjectRequest, file, inputStream2, putObjectRequest2.getInputStream(), this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PutObjectResult putObjectUsingInstructionFile(PutObjectRequest putObjectRequest) {
        PutObjectResult putObjectResult;
        File file = putObjectRequest.getFile();
        InputStream inputStream2 = putObjectRequest.getInputStream();
        PutObjectRequest putObjectRequest2 = putObjectRequest.clone().withFile(null).withInputStream(null);
        putObjectRequest2.setKey(putObjectRequest2.getKey() + "." + "instruction");
        ContentCryptoMaterial contentCryptoMaterial = this.createContentCryptoMaterial(putObjectRequest);
        PutObjectRequest putObjectRequest3 = this.wrapWithCipher(putObjectRequest, contentCryptoMaterial);
        try {
            putObjectResult = this.cos.putObject(putObjectRequest3);
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(putObjectRequest, file, inputStream2, putObjectRequest3.getInputStream(), this.log);
        }
        this.cos.putObject(this.updateInstructionPutRequest(putObjectRequest2, contentCryptoMaterial));
        return putObjectResult;
    }

    @Override
    public final void abortMultipartUploadSecurely(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        this.cos.abortMultipartUpload(abortMultipartUploadRequest);
        this.multipartUploadContexts.remove(abortMultipartUploadRequest.getUploadId());
    }

    @Override
    public final CopyPartResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        String string = copyPartRequest.getUploadId();
        MultipartUploadCryptoContext multipartUploadCryptoContext = this.multipartUploadContexts.get(string);
        CopyPartResult copyPartResult = this.cos.copyPart(copyPartRequest);
        if (multipartUploadCryptoContext != null && !multipartUploadCryptoContext.hasFinalPartBeenSeen()) {
            multipartUploadCryptoContext.setHasFinalPartBeenSeen(true);
        }
        return copyPartResult;
    }

    abstract MultipartUploadCryptoContext newUploadContext(InitiateMultipartUploadRequest var1, ContentCryptoMaterial var2);

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        ServerSideEncryptionResult serverSideEncryptionResult;
        ContentCryptoMaterial contentCryptoMaterial = this.createContentCryptoMaterial(initiateMultipartUploadRequest);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.ObjectMetadata) {
            serverSideEncryptionResult = initiateMultipartUploadRequest.getObjectMetadata();
            if (serverSideEncryptionResult == null) {
                serverSideEncryptionResult = new ObjectMetadata();
            }
            long l = initiateMultipartUploadRequest.getDataSize();
            long l2 = initiateMultipartUploadRequest.getPartSize();
            if (l < 0L || l2 < 0L) {
                throw new CosClientException("initiate multipart upload with encryption client must set dataSize and partSize");
            }
            if (l2 % 16L != 0L) {
                throw new CosClientException("initiat multipart uplaod with encryption client must set part size a mutiple of 16but got " + l2);
            }
            ((ObjectMetadata)serverSideEncryptionResult).addUserMetadata("client-side-encryption-data-size", Long.toString(l));
            ((ObjectMetadata)serverSideEncryptionResult).addUserMetadata("client-side-encryption-part-size", Long.toString(l2));
            initiateMultipartUploadRequest.setObjectMetadata(this.updateMetadataWithContentCryptoMaterial((ObjectMetadata)serverSideEncryptionResult, null, contentCryptoMaterial));
        }
        serverSideEncryptionResult = this.cos.initiateMultipartUpload(initiateMultipartUploadRequest);
        MultipartUploadCryptoContext multipartUploadCryptoContext = this.newUploadContext(initiateMultipartUploadRequest, contentCryptoMaterial);
        if (initiateMultipartUploadRequest instanceof MaterialsDescriptionProvider) {
            MaterialsDescriptionProvider materialsDescriptionProvider = (MaterialsDescriptionProvider)((Object)initiateMultipartUploadRequest);
            multipartUploadCryptoContext.setMaterialsDescription(materialsDescriptionProvider.getMaterialsDescription());
        }
        this.multipartUploadContexts.put(((InitiateMultipartUploadResult)serverSideEncryptionResult).getUploadId(), multipartUploadCryptoContext);
        return serverSideEncryptionResult;
    }

    abstract CipherLite cipherLiteForNextPart(MultipartUploadCryptoContext var1);

    abstract long computeLastPartSize(UploadPartRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest uploadPartRequest) {
        UploadPartResult uploadPartResult;
        boolean bl;
        int n = this.contentCryptoScheme.getBlockSizeInBytes();
        boolean bl2 = uploadPartRequest.isLastPart();
        String string = uploadPartRequest.getUploadId();
        long l = uploadPartRequest.getPartSize();
        boolean bl3 = bl = 0L == l % (long)n;
        if (!bl2 && !bl) {
            throw new CosClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + n + ") with the exception of the last part.");
        }
        MultipartUploadCryptoContext multipartUploadCryptoContext = this.multipartUploadContexts.get(string);
        if (multipartUploadCryptoContext == null) {
            throw new CosClientException("No client-side information available on upload ID " + string);
        }
        multipartUploadCryptoContext.beginPartUpload(uploadPartRequest.getPartNumber());
        CipherLite cipherLite = this.cipherLiteForNextPart(multipartUploadCryptoContext);
        File file = uploadPartRequest.getFile();
        InputStream inputStream2 = uploadPartRequest.getInputStream();
        CipherLiteInputStream cipherLiteInputStream = null;
        try {
            CipherLiteInputStream cipherLiteInputStream2;
            cipherLiteInputStream = cipherLiteInputStream2 = this.newMultipartCOSCipherInputStream(uploadPartRequest, cipherLite);
            uploadPartRequest.setInputStream(cipherLiteInputStream);
            uploadPartRequest.setFile(null);
            uploadPartRequest.setFileOffset(0L);
            if (bl2) {
                long l2 = this.computeLastPartSize(uploadPartRequest);
                if (l2 > -1L) {
                    uploadPartRequest.setPartSize(l2);
                }
                if (multipartUploadCryptoContext.hasFinalPartBeenSeen()) {
                    throw new CosClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part.");
                }
            }
            uploadPartResult = this.cos.uploadPart(uploadPartRequest);
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(uploadPartRequest, file, inputStream2, cipherLiteInputStream, this.log);
            multipartUploadCryptoContext.endPartUpload();
        }
        if (bl2) {
            multipartUploadCryptoContext.setHasFinalPartBeenSeen(true);
        }
        return uploadPartResult;
    }

    protected final CipherLiteInputStream newMultipartCOSCipherInputStream(UploadPartRequest uploadPartRequest, CipherLite cipherLite) {
        File file = uploadPartRequest.getFile();
        InputStream inputStream2 = uploadPartRequest.getInputStream();
        InputStream inputStream3 = null;
        try {
            if (file == null) {
                if (inputStream2 == null) {
                    throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
                }
                inputStream3 = inputStream2;
            } else {
                inputStream3 = new ResettableInputStream(file);
            }
            inputStream3 = new InputSubstream(inputStream3, uploadPartRequest.getFileOffset(), uploadPartRequest.getPartSize(), uploadPartRequest.isLastPart());
            return cipherLite.markSupported() ? new CipherLiteInputStream(inputStream3, cipherLite, 2048, true, uploadPartRequest.isLastPart()) : new RenewableCipherLiteInputStream(inputStream3, cipherLite, 2048, true, uploadPartRequest.isLastPart());
        }
        catch (Exception exception) {
            CosDataSource.Utils.cleanupDataSource(uploadPartRequest, file, inputStream2, inputStream3, this.log);
            throw new CosClientException("Unable to create cipher input stream", exception);
        }
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        String string = completeMultipartUploadRequest.getUploadId();
        MultipartUploadCryptoContext multipartUploadCryptoContext = this.multipartUploadContexts.get(string);
        if (multipartUploadCryptoContext != null && !multipartUploadCryptoContext.hasFinalPartBeenSeen()) {
            throw new CosClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in COS is incomplete and corrupt.");
        }
        CompleteMultipartUploadResult completeMultipartUploadResult = this.cos.completeMultipartUpload(completeMultipartUploadRequest);
        if (multipartUploadCryptoContext != null && this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            this.cos.putObject(this.createInstructionPutRequest(multipartUploadCryptoContext.getBucketName(), multipartUploadCryptoContext.getKey(), multipartUploadCryptoContext.getContentCryptoMaterial()));
        }
        this.multipartUploadContexts.remove(string);
        return completeMultipartUploadResult;
    }

    protected final ObjectMetadata updateMetadataWithContentCryptoMaterial(ObjectMetadata objectMetadata, File file, ContentCryptoMaterial contentCryptoMaterial) {
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        return contentCryptoMaterial.toObjectMetadata(objectMetadata, this.cryptoConfig.getCryptoMode());
    }

    protected final ContentCryptoMaterial createContentCryptoMaterial(CosServiceRequest cosServiceRequest) {
        Object object;
        Map<String, String> map;
        if (cosServiceRequest instanceof EncryptionMaterialsFactory && (map = (object = (EncryptionMaterialsFactory)((Object)cosServiceRequest)).getEncryptionMaterials()) != null) {
            return this.buildContentCryptoMaterial((EncryptionMaterials)((Object)map), this.cryptoConfig.getCryptoProvider(), cosServiceRequest);
        }
        if (cosServiceRequest instanceof MaterialsDescriptionProvider) {
            EncryptionMaterials encryptionMaterials;
            object = (MaterialsDescriptionProvider)((Object)cosServiceRequest);
            map = object.getMaterialsDescription();
            ContentCryptoMaterial contentCryptoMaterial = this.newContentCryptoMaterial(this.kekMaterialsProvider, map, this.cryptoConfig.getCryptoProvider(), cosServiceRequest);
            if (contentCryptoMaterial != null) {
                return contentCryptoMaterial;
            }
            if (map != null && !(encryptionMaterials = this.kekMaterialsProvider.getEncryptionMaterials()).isKMSEnabled()) {
                throw new CosClientException("No material available from the encryption material provider for description " + map);
            }
        }
        return this.newContentCryptoMaterial(this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), cosServiceRequest);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider encryptionMaterialsProvider, Map<String, String> map, Provider provider, CosServiceRequest cosServiceRequest) {
        EncryptionMaterials encryptionMaterials = encryptionMaterialsProvider.getEncryptionMaterials(map);
        if (encryptionMaterials == null) {
            return null;
        }
        return this.buildContentCryptoMaterial(encryptionMaterials, provider, cosServiceRequest);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider encryptionMaterialsProvider, Provider provider, CosServiceRequest cosServiceRequest) {
        EncryptionMaterials encryptionMaterials = encryptionMaterialsProvider.getEncryptionMaterials();
        if (encryptionMaterials == null) {
            throw new CosClientException("No material available from the encryption material provider");
        }
        return this.buildContentCryptoMaterial(encryptionMaterials, provider, cosServiceRequest);
    }

    private ContentCryptoMaterial buildContentCryptoMaterial(EncryptionMaterials encryptionMaterials, Provider provider, CosServiceRequest cosServiceRequest) {
        byte[] byArray = this.contentCryptoScheme.getIV();
        if (byArray == null) {
            byArray = new byte[this.contentCryptoScheme.getIVLengthInBytes()];
            this.cryptoScheme.getSecureRandom().nextBytes(byArray);
        }
        if (encryptionMaterials.isKMSEnabled()) {
            Object object;
            Map<String, String> map = ContentCryptoMaterial.mergeMaterialDescriptions(encryptionMaterials, cosServiceRequest);
            GenerateDataKeyRequest generateDataKeyRequest = new GenerateDataKeyRequest();
            try {
                object = new ObjectMapper();
                generateDataKeyRequest.setEncryptionContext(((ObjectMapper)object).writeValueAsString(map));
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new CosClientException("generate datakey request set encryption context got json processing exception", jsonProcessingException);
            }
            generateDataKeyRequest.setKeyId(encryptionMaterials.getCustomerMasterKeyId());
            generateDataKeyRequest.setKeySpec(this.contentCryptoScheme.getKeySpec());
            object = this.kms.generateDataKey(generateDataKeyRequest);
            byte[] byArray2 = Base64.decode(((GenerateDataKeyResponse)object).getPlaintext());
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, this.contentCryptoScheme.getKeyGeneratorAlgorithm());
            byte[] byArray3 = ((GenerateDataKeyResponse)object).getCiphertextBlob().getBytes();
            byte[] byArray4 = ContentCryptoMaterial.encryptIV(byArray, encryptionMaterials, this.cryptoScheme.getKeyWrapScheme(), this.cryptoScheme.getSecureRandom(), provider, this.kms, cosServiceRequest);
            return ContentCryptoMaterial.wrap(secretKeySpec, byArray, this.contentCryptoScheme, provider, new KMSSecuredCEK(byArray3, map), byArray4);
        }
        return ContentCryptoMaterial.create(this.generateCEK(encryptionMaterials, provider), byArray, encryptionMaterials, this.cryptoScheme, provider, this.kms, cosServiceRequest);
    }

    protected final SecretKey generateCEK(EncryptionMaterials encryptionMaterials, Provider provider) {
        String string = this.contentCryptoScheme.getKeyGeneratorAlgorithm();
        try {
            Object object;
            KeyGenerator keyGenerator = provider == null ? KeyGenerator.getInstance(string) : KeyGenerator.getInstance(string, provider);
            keyGenerator.init(this.contentCryptoScheme.getKeyLengthInBits(), this.cryptoScheme.getSecureRandom());
            boolean bl = false;
            KeyPair keyPair = encryptionMaterials.getKeyPair();
            if (keyPair != null && (object = this.cryptoScheme.getKeyWrapScheme().getKeyWrapAlgorithm(keyPair.getPublic())) == null) {
                Provider provider2 = keyGenerator.getProvider();
                String string2 = provider2 == null ? null : provider2.getName();
                bl = "BC".equals(string2);
            }
            object = keyGenerator.generateKey();
            if (!bl || object.getEncoded()[0] != 0) {
                return object;
            }
            for (int i = 0; i < 10; ++i) {
                object = keyGenerator.generateKey();
                if (object.getEncoded()[0] == 0) continue;
                return object;
            }
            throw new CosClientException("Failed to generate secret key");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CosClientException("Unable to generate envelope symmetric key:" + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    protected final <R extends AbstractPutObjectRequest> R wrapWithCipher(R r, ContentCryptoMaterial contentCryptoMaterial) {
        ObjectMetadata objectMetadata = r.getMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        if (objectMetadata.getContentMD5() != null) {
            objectMetadata.addUserMetadata("client-side-encryption-unencrypted-content-md5", objectMetadata.getContentMD5());
        }
        objectMetadata.setContentMD5(null);
        long l = this.plaintextLength(r, objectMetadata);
        if (l >= 0L) {
            objectMetadata.addUserMetadata("client-side-encryption-unencrypted-content-length", Long.toString(l));
            objectMetadata.setContentLength(this.ciphertextLength(l));
        }
        r.setMetadata(objectMetadata);
        r.setInputStream(this.newCOSCipherLiteInputStream(r, contentCryptoMaterial, l));
        r.setFile(null);
        return r;
    }

    private CipherLiteInputStream newCOSCipherLiteInputStream(AbstractPutObjectRequest abstractPutObjectRequest, ContentCryptoMaterial contentCryptoMaterial, long l) {
        File file = abstractPutObjectRequest.getFile();
        InputStream inputStream2 = abstractPutObjectRequest.getInputStream();
        SdkFilterInputStream sdkFilterInputStream = null;
        try {
            CipherLite cipherLite;
            sdkFilterInputStream = file == null ? (inputStream2 == null ? null : ReleasableInputStream.wrap(inputStream2)) : new ResettableInputStream(file);
            if (l > -1L) {
                sdkFilterInputStream = new LengthCheckInputStream(sdkFilterInputStream, l, false);
            }
            if ((cipherLite = contentCryptoMaterial.getCipherLite()).markSupported()) {
                return new CipherLiteInputStream(sdkFilterInputStream, cipherLite, 2048);
            }
            return new RenewableCipherLiteInputStream(sdkFilterInputStream, cipherLite, 2048);
        }
        catch (Exception exception) {
            CosDataSource.Utils.cleanupDataSource(abstractPutObjectRequest, file, inputStream2, sdkFilterInputStream, this.log);
            throw new CosClientException("Unable to create cipher input stream", exception);
        }
    }

    protected final long plaintextLength(AbstractPutObjectRequest abstractPutObjectRequest, ObjectMetadata objectMetadata) {
        if (abstractPutObjectRequest.getFile() != null) {
            return abstractPutObjectRequest.getFile().length();
        }
        if (abstractPutObjectRequest.getInputStream() != null && objectMetadata.getRawMetadataValue("Content-Length") != null) {
            return objectMetadata.getContentLength();
        }
        return -1L;
    }

    public final COSCryptoScheme getCOSCryptoScheme() {
        return this.cryptoScheme;
    }

    protected final PutObjectRequest updateInstructionPutRequest(PutObjectRequest putObjectRequest, ContentCryptoMaterial contentCryptoMaterial) {
        byte[] byArray = contentCryptoMaterial.toJsonString().getBytes(StringUtils.UTF8);
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
            putObjectRequest.setMetadata(objectMetadata);
        }
        objectMetadata.setContentLength(byArray.length);
        objectMetadata.addUserMetadata("x-cos-crypto-instr-file", "");
        putObjectRequest.setMetadata(objectMetadata);
        putObjectRequest.setInputStream(new ByteArrayInputStream(byArray));
        return putObjectRequest;
    }

    protected final PutObjectRequest createInstructionPutRequest(String string, String string2, ContentCryptoMaterial contentCryptoMaterial) {
        byte[] byArray = contentCryptoMaterial.toJsonString().getBytes(StringUtils.UTF8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(byArray.length);
        objectMetadata.addUserMetadata("x-cos-crypto-instr-file", "");
        InstructionFileId instructionFileId = new COSObjectId(string, string2).instructionFileId();
        return new PutObjectRequest(instructionFileId.getBucket(), instructionFileId.getKey(), byteArrayInputStream, objectMetadata);
    }

    protected void securityCheck(ContentCryptoMaterial contentCryptoMaterial, COSObjectWrapper cOSObjectWrapper) {
    }

    final COSObjectWrapper fetchInstructionFile(COSObjectId cOSObjectId, String string) {
        try {
            COSObject cOSObject = this.cos.getObject(this.createInstructionGetRequest(cOSObjectId, string));
            return cOSObject == null ? null : new COSObjectWrapper(cOSObject, cOSObjectId);
        }
        catch (CosServiceException cosServiceException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unable to retrieve instruction file : " + cosServiceException.getMessage());
            }
            return null;
        }
    }

    @Override
    public final PutObjectResult putInstructionFileSecurely(PutInstructionFileRequest putInstructionFileRequest) {
        COSObjectId cOSObjectId = putInstructionFileRequest.getCOSObjectId();
        GetObjectRequest getObjectRequest = new GetObjectRequest(cOSObjectId);
        COSObject cOSObject = this.cos.getObject(getObjectRequest);
        IOUtils.closeQuietly(cOSObject, this.log);
        if (cOSObject == null) {
            throw new IllegalArgumentException("The specified COS object (" + cOSObjectId + ") doesn't exist.");
        }
        COSObjectWrapper cOSObjectWrapper = new COSObjectWrapper(cOSObject, cOSObjectId);
        try {
            ContentCryptoMaterial contentCryptoMaterial = this.contentCryptoMaterialOf(cOSObjectWrapper);
            this.securityCheck(contentCryptoMaterial, cOSObjectWrapper);
            EncryptionMaterials encryptionMaterials = putInstructionFileRequest.getEncryptionMaterials();
            ContentCryptoMaterial contentCryptoMaterial2 = encryptionMaterials == null ? contentCryptoMaterial.recreate(putInstructionFileRequest.getMaterialsDescription(), (EncryptionMaterialsAccessor)this.kekMaterialsProvider, this.cryptoScheme, this.cryptoConfig.getCryptoProvider(), this.kms, (CosServiceRequest)putInstructionFileRequest) : contentCryptoMaterial.recreate(encryptionMaterials, (EncryptionMaterialsAccessor)this.kekMaterialsProvider, this.cryptoScheme, this.cryptoConfig.getCryptoProvider(), this.kms, (CosServiceRequest)putInstructionFileRequest);
            PutObjectRequest putObjectRequest = putInstructionFileRequest.createPutObjectRequest(cOSObject);
            return this.cos.putObject(this.updateInstructionPutRequest(putObjectRequest, contentCryptoMaterial2));
        }
        catch (RuntimeException runtimeException) {
            IOUtils.closeQuietly(cOSObject, this.log);
            throw runtimeException;
        }
        catch (Error error) {
            IOUtils.closeQuietly(cOSObject, this.log);
            throw error;
        }
    }

    private ContentCryptoMaterial contentCryptoMaterialOf(COSObjectWrapper cOSObjectWrapper) {
        if (cOSObjectWrapper.hasEncryptionInfo()) {
            return ContentCryptoMaterial.fromObjectMetadata(cOSObjectWrapper.getObjectMetadata(), this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), false, this.kms);
        }
        COSObjectWrapper cOSObjectWrapper2 = this.fetchInstructionFile(cOSObjectWrapper.getCOSObjectId(), null);
        if (cOSObjectWrapper2 == null) {
            throw new IllegalArgumentException("COS object is not encrypted: " + cOSObjectWrapper);
        }
        String string = cOSObjectWrapper2.toJsonString();
        return this.ccmFromJson(string);
    }

    private ContentCryptoMaterial ccmFromJson(String string) {
        Map<String, String> map = Collections.unmodifiableMap(Jackson.fromJsonString(string, Map.class));
        return ContentCryptoMaterial.fromInstructionFile(map, this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), false, this.kms);
    }

    final GetObjectRequest createInstructionGetRequest(COSObjectId cOSObjectId) {
        return this.createInstructionGetRequest(cOSObjectId, null);
    }

    final GetObjectRequest createInstructionGetRequest(COSObjectId cOSObjectId, String string) {
        return new GetObjectRequest(cOSObjectId.instructionFileId(string));
    }

    static long[] getAdjustedCryptoRange(long[] lArray) {
        if (lArray == null || lArray[0] > lArray[1]) {
            return null;
        }
        long[] lArray2 = new long[]{COSCryptoModuleBase.getCipherBlockLowerBound(lArray[0]), COSCryptoModuleBase.getCipherBlockUpperBound(lArray[1])};
        return lArray2;
    }

    private static long getCipherBlockLowerBound(long l) {
        long l2 = 16L;
        long l3 = l % l2;
        long l4 = l - l3 - l2;
        return l4 < 0L ? 0L : l4;
    }

    private static long getCipherBlockUpperBound(long l) {
        long l2 = 16L;
        long l3 = l2 - l % l2;
        long l4 = l + l3 + l2;
        return l4 < 0L ? Long.MAX_VALUE : l4;
    }
}

