/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.COSDirect;
import com.qcloud.cos.internal.crypto.AdjustedRangeInputStream;
import com.qcloud.cos.internal.crypto.COSCryptoModuleBase;
import com.qcloud.cos.internal.crypto.COSObjectWrapper;
import com.qcloud.cos.internal.crypto.CipherLite;
import com.qcloud.cos.internal.crypto.CipherLiteInputStream;
import com.qcloud.cos.internal.crypto.ContentCryptoMaterial;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoRuntime;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.MultipartUploadCryptoContext;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectId;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.EncryptedGetObjectRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.utils.IOUtils;
import com.qcloud.cos.utils.Jackson;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

public class COSCryptoModuleAE
extends COSCryptoModuleBase {
    public COSCryptoModuleAE(COSDirect cOSDirect, COSCredentialsProvider cOSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        this(null, cOSDirect, cOSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
    }

    public COSCryptoModuleAE(QCLOUDKMS qCLOUDKMS, COSDirect cOSDirect, COSCredentialsProvider cOSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        super(qCLOUDKMS, cOSDirect, cOSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
    }

    protected boolean isStrict() {
        return false;
    }

    @Override
    public COSObject getObjectSecurely(GetObjectRequest getObjectRequest) {
        COSObject cOSObject;
        long[] lArray = getObjectRequest.getRange();
        if (this.isStrict() && lArray != null) {
            throw new SecurityException("Range get and getting a part are not allowed in strict crypto mode");
        }
        long[] lArray2 = COSCryptoModuleAE.getAdjustedCryptoRange(lArray);
        if (lArray2 != null) {
            getObjectRequest.setRange(lArray2[0], lArray2[1]);
        }
        if ((cOSObject = this.cos.getObject(getObjectRequest)) == null) {
            return null;
        }
        String string = null;
        if (getObjectRequest instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest encryptedGetObjectRequest = (EncryptedGetObjectRequest)getObjectRequest;
            string = encryptedGetObjectRequest.getInstructionFileSuffix();
        }
        try {
            return string == null || string.trim().isEmpty() ? this.decipher(getObjectRequest, lArray, lArray2, cOSObject) : this.decipherWithInstFileSuffix(getObjectRequest, lArray, lArray2, cOSObject, string);
        }
        catch (RuntimeException runtimeException) {
            IOUtils.closeQuietly(cOSObject, this.log);
            throw runtimeException;
        }
        catch (Error error) {
            IOUtils.closeQuietly(cOSObject, this.log);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSObject decipher(GetObjectRequest getObjectRequest, long[] lArray, long[] lArray2, COSObject cOSObject) {
        COSObjectWrapper cOSObjectWrapper = new COSObjectWrapper(cOSObject, getObjectRequest.getCOSObjectId());
        if (cOSObjectWrapper.hasEncryptionInfo()) {
            return this.decipherWithMetadata(getObjectRequest, lArray, lArray2, cOSObjectWrapper);
        }
        COSObjectWrapper cOSObjectWrapper2 = this.fetchInstructionFile(getObjectRequest.getCOSObjectId(), null);
        if (cOSObjectWrapper2 != null) {
            try {
                COSObject cOSObject2 = this.decipherWithInstructionFile(getObjectRequest, lArray, lArray2, cOSObjectWrapper, cOSObjectWrapper2);
                return cOSObject2;
            }
            finally {
                IOUtils.closeQuietly(cOSObjectWrapper2, this.log);
            }
        }
        if (this.isStrict() || !this.cryptoConfig.isIgnoreMissingInstructionFile()) {
            IOUtils.closeQuietly(cOSObjectWrapper, this.log);
            throw new SecurityException("Instruction file not found for COS object with bucket name: " + cOSObject.getBucketName() + ", key: " + cOSObject.getKey());
        }
        this.log.warn(String.format("Unable to detect encryption information for object '%s' in bucket '%s'. Returning object without decryption.", cOSObject.getKey(), cOSObject.getBucketName()));
        COSObjectWrapper cOSObjectWrapper3 = this.adjustToDesiredRange(cOSObjectWrapper, lArray, null);
        return cOSObjectWrapper3.getCOSObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSObject decipherWithInstFileSuffix(GetObjectRequest getObjectRequest, long[] lArray, long[] lArray2, COSObject cOSObject, String string) {
        COSObjectId cOSObjectId = getObjectRequest.getCOSObjectId();
        COSObjectWrapper cOSObjectWrapper = this.fetchInstructionFile(cOSObjectId, string);
        if (cOSObjectWrapper == null) {
            throw new CosClientException("Instruction file with suffix " + string + " is not found for " + cOSObject);
        }
        try {
            COSObject cOSObject2 = this.decipherWithInstructionFile(getObjectRequest, lArray, lArray2, new COSObjectWrapper(cOSObject, cOSObjectId), cOSObjectWrapper);
            return cOSObject2;
        }
        finally {
            IOUtils.closeQuietly(cOSObjectWrapper, this.log);
        }
    }

    private COSObject decipherWithInstructionFile(GetObjectRequest getObjectRequest, long[] lArray, long[] lArray2, COSObjectWrapper cOSObjectWrapper, COSObjectWrapper cOSObjectWrapper2) {
        Object object;
        boolean bl = this.isStrict();
        if (getObjectRequest instanceof EncryptedGetObjectRequest) {
            object = (EncryptedGetObjectRequest)getObjectRequest;
            if (!bl) {
                bl = ((EncryptedGetObjectRequest)object).isKeyWrapExpected();
            }
        }
        object = cOSObjectWrapper2.toJsonString();
        Map<String, String> map = Collections.unmodifiableMap(Jackson.fromJsonString((String)object, Map.class));
        ContentCryptoMaterial contentCryptoMaterial = ContentCryptoMaterial.fromInstructionFile(map, this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), lArray2, bl, this.kms);
        this.securityCheck(contentCryptoMaterial, cOSObjectWrapper);
        COSObjectWrapper cOSObjectWrapper3 = this.decrypt(cOSObjectWrapper, contentCryptoMaterial, lArray2);
        COSObjectWrapper cOSObjectWrapper4 = this.adjustToDesiredRange(cOSObjectWrapper3, lArray, map);
        return cOSObjectWrapper4.getCOSObject();
    }

    private COSObject decipherWithMetadata(GetObjectRequest getObjectRequest, long[] lArray, long[] lArray2, COSObjectWrapper cOSObjectWrapper) {
        Object object;
        boolean bl = this.isStrict();
        if (getObjectRequest instanceof EncryptedGetObjectRequest) {
            object = (EncryptedGetObjectRequest)getObjectRequest;
            if (!bl) {
                bl = ((EncryptedGetObjectRequest)object).isKeyWrapExpected();
            }
        }
        object = ContentCryptoMaterial.fromObjectMetadata(cOSObjectWrapper.getObjectMetadata(), this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), lArray2, bl, this.kms);
        this.securityCheck((ContentCryptoMaterial)object, cOSObjectWrapper);
        COSObjectWrapper cOSObjectWrapper2 = this.decrypt(cOSObjectWrapper, (ContentCryptoMaterial)object, lArray2);
        COSObjectWrapper cOSObjectWrapper3 = this.adjustToDesiredRange(cOSObjectWrapper2, lArray, null);
        return cOSObjectWrapper3.getCOSObject();
    }

    protected final COSObjectWrapper adjustToDesiredRange(COSObjectWrapper cOSObjectWrapper, long[] lArray, Map<String, String> map) {
        if (lArray == null) {
            return cOSObjectWrapper;
        }
        ContentCryptoScheme contentCryptoScheme = cOSObjectWrapper.encryptionSchemeOf(map);
        long l = cOSObjectWrapper.getObjectMetadata().getInstanceLength();
        long l2 = l - (long)(contentCryptoScheme.getTagLengthInBits() / 8) - 1L;
        if (lArray[1] > l2) {
            lArray[1] = l2;
            if (lArray[0] > lArray[1]) {
                IOUtils.closeQuietly(cOSObjectWrapper.getObjectContent(), this.log);
                cOSObjectWrapper.setObjectContent(new ByteArrayInputStream(new byte[0]));
                return cOSObjectWrapper;
            }
        }
        if (lArray[0] > lArray[1]) {
            return cOSObjectWrapper;
        }
        try {
            COSObjectInputStream cOSObjectInputStream = cOSObjectWrapper.getObjectContent();
            AdjustedRangeInputStream adjustedRangeInputStream = new AdjustedRangeInputStream(cOSObjectInputStream, lArray[0], lArray[1]);
            cOSObjectWrapper.setObjectContent(new COSObjectInputStream(adjustedRangeInputStream, cOSObjectInputStream.getHttpRequest()));
            return cOSObjectWrapper;
        }
        catch (IOException iOException) {
            throw new CosClientException("Error adjusting output to desired byte range: " + iOException.getMessage());
        }
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File file) {
        this.assertParameterNotNull(file, "The destination file parameter must be specified when downloading an object directly to a file");
        COSObject cOSObject = this.getObjectSecurely(getObjectRequest);
        if (cOSObject == null) {
            return null;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[10240];
            while ((n = cOSObject.getObjectContent().read(byArray)) > -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            try {
                throw new CosClientException("Unable to store object contents to disk: " + iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedOutputStream, this.log);
                IOUtils.closeQuietly(cOSObject.getObjectContent(), this.log);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bufferedOutputStream, this.log);
        IOUtils.closeQuietly(cOSObject.getObjectContent(), this.log);
        return cOSObject.getObjectMetadata();
    }

    @Override
    final MultipartUploadCryptoContext newUploadContext(InitiateMultipartUploadRequest initiateMultipartUploadRequest, ContentCryptoMaterial contentCryptoMaterial) {
        return new MultipartUploadCryptoContext(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), contentCryptoMaterial);
    }

    @Override
    final CipherLite cipherLiteForNextPart(MultipartUploadCryptoContext multipartUploadCryptoContext) {
        return multipartUploadCryptoContext.getCipherLite();
    }

    @Override
    final long computeLastPartSize(UploadPartRequest uploadPartRequest) {
        return uploadPartRequest.getPartSize() + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    private COSObjectWrapper decrypt(COSObjectWrapper cOSObjectWrapper, ContentCryptoMaterial contentCryptoMaterial, long[] lArray) {
        COSObjectInputStream cOSObjectInputStream = cOSObjectWrapper.getObjectContent();
        cOSObjectWrapper.setObjectContent(new COSObjectInputStream(new CipherLiteInputStream(cOSObjectInputStream, contentCryptoMaterial.getCipherLite(), 2048), cOSObjectInputStream.getHttpRequest()));
        return cOSObjectWrapper;
    }

    private void assertParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    protected long ciphertextLength(long l) {
        return l + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

