/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.internal.crypto.ContentCryptoScheme;

class AesCtr
extends ContentCryptoScheme {
    private byte[] iv = null;

    AesCtr() {
    }

    @Override
    String getKeyGeneratorAlgorithm() {
        return AES_GCM.getKeyGeneratorAlgorithm();
    }

    @Override
    String getCipherAlgorithm() {
        return "AES/CTR/NoPadding";
    }

    @Override
    int getKeyLengthInBits() {
        return AES_GCM.getKeyLengthInBits();
    }

    @Override
    int getBlockSizeInBytes() {
        return AES_GCM.getBlockSizeInBytes();
    }

    @Override
    int getIVLengthInBytes() {
        return 16;
    }

    @Override
    long getMaxPlaintextSize() {
        return -1L;
    }

    @Override
    byte[] getIV() {
        return this.iv;
    }

    @Override
    void setIV(byte[] byArray) {
        this.iv = byArray;
    }

    @Override
    byte[] adjustIV(byte[] byArray, long l) {
        if (byArray.length != 12) {
            throw new UnsupportedOperationException();
        }
        int n = this.getBlockSizeInBytes();
        long l2 = l / (long)n;
        if (l2 * (long)n != l) {
            throw new IllegalArgumentException("Expecting byteOffset to be multiple of 16, but got blockOffset=" + l2 + ", blockSize=" + n + ", byteOffset=" + l);
        }
        byte[] byArray2 = this.computeJ0(byArray);
        return AesCtr.incrementBlocks(byArray2, l2);
    }

    private byte[] computeJ0(byte[] byArray) {
        int n = this.getBlockSizeInBytes();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[n - 1] = 1;
        return AesCtr.incrementBlocks(byArray2, 1L);
    }
}

