/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.MultiObjectDeleteException;
import com.qcloud.cos.internal.AbstractHandler;
import com.qcloud.cos.internal.AbstractSSEHandler;
import com.qcloud.cos.internal.DeleteObjectsResponse;
import com.qcloud.cos.internal.ObjectExpirationResult;
import com.qcloud.cos.internal.ParserMediaInfoUtils;
import com.qcloud.cos.internal.ServerSideEncryptionResult;
import com.qcloud.cos.internal.VIDResult;
import com.qcloud.cos.internal.cihandler.BatchJobResponseHandler;
import com.qcloud.cos.internal.cihandler.DetectCarHandler;
import com.qcloud.cos.internal.cihandler.FileProcessResponseHandler;
import com.qcloud.cos.internal.cihandler.GenerateQrcodeHandler;
import com.qcloud.cos.internal.cihandler.GetImageStyleHandler;
import com.qcloud.cos.internal.cihandler.MediaJobResponseHandler;
import com.qcloud.cos.internal.cihandler.ReportBadCaseHandler;
import com.qcloud.cos.internal.cihandler.SearchImageHandler;
import com.qcloud.cos.internal.cihandler.TriggerWorkflowListHandler;
import com.qcloud.cos.model.AbortIncompleteMultipartUpload;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.BucketCrossOriginConfiguration;
import com.qcloud.cos.model.BucketDomainConfiguration;
import com.qcloud.cos.model.BucketIntelligentTierConfiguration;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.BucketLoggingConfiguration;
import com.qcloud.cos.model.BucketRefererConfiguration;
import com.qcloud.cos.model.BucketReplicationConfiguration;
import com.qcloud.cos.model.BucketTaggingConfiguration;
import com.qcloud.cos.model.BucketVersioningConfiguration;
import com.qcloud.cos.model.BucketWebsiteConfiguration;
import com.qcloud.cos.model.CORSRule;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.COSVersionSummary;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.DecompressionResult;
import com.qcloud.cos.model.DeleteObjectsResult;
import com.qcloud.cos.model.DomainRule;
import com.qcloud.cos.model.GetBucketInventoryConfigurationResult;
import com.qcloud.cos.model.GetObjectTaggingResult;
import com.qcloud.cos.model.Grantee;
import com.qcloud.cos.model.GroupGrantee;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsResult;
import com.qcloud.cos.model.ListJobsResult;
import com.qcloud.cos.model.MultipartUpload;
import com.qcloud.cos.model.MultipartUploadListing;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.Owner;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.PartSummary;
import com.qcloud.cos.model.Permission;
import com.qcloud.cos.model.RedirectRule;
import com.qcloud.cos.model.ReplicationDestinationConfig;
import com.qcloud.cos.model.ReplicationRule;
import com.qcloud.cos.model.RoutingRule;
import com.qcloud.cos.model.RoutingRuleCondition;
import com.qcloud.cos.model.Tag.LifecycleTagPredicate;
import com.qcloud.cos.model.Tag.Tag;
import com.qcloud.cos.model.TagSet;
import com.qcloud.cos.model.UinGrantee;
import com.qcloud.cos.model.VersionListing;
import com.qcloud.cos.model.bucketcertificate.BucketGetDomainCertificate;
import com.qcloud.cos.model.ciModel.auditing.AudioAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.AudioSectionInfo;
import com.qcloud.cos.model.ciModel.auditing.AuditingJobsDetail;
import com.qcloud.cos.model.ciModel.auditing.AudtingCommonInfo;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.BatchImageJobDetail;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingJobsDetail;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.DocumentResultInfo;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.LanguageResult;
import com.qcloud.cos.model.ciModel.auditing.LibResult;
import com.qcloud.cos.model.ciModel.auditing.ListResult;
import com.qcloud.cos.model.ciModel.auditing.ObjectResults;
import com.qcloud.cos.model.ciModel.auditing.OcrResults;
import com.qcloud.cos.model.ciModel.auditing.ResultsImageAuditingDetail;
import com.qcloud.cos.model.ciModel.auditing.ResultsTextAuditingDetail;
import com.qcloud.cos.model.ciModel.auditing.SectionInfo;
import com.qcloud.cos.model.ciModel.auditing.SnapshotInfo;
import com.qcloud.cos.model.ciModel.auditing.TextAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingJobsDetail;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingResponse;
import com.qcloud.cos.model.ciModel.bucket.DocBucketObject;
import com.qcloud.cos.model.ciModel.bucket.DocBucketResponse;
import com.qcloud.cos.model.ciModel.bucket.MediaBucketObject;
import com.qcloud.cos.model.ciModel.bucket.MediaBucketResponse;
import com.qcloud.cos.model.ciModel.common.MediaCommonResponse;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.image.ImageLabelResponse;
import com.qcloud.cos.model.ciModel.image.ImageLabelV2Response;
import com.qcloud.cos.model.ciModel.image.Lobel;
import com.qcloud.cos.model.ciModel.image.LobelV2;
import com.qcloud.cos.model.ciModel.image.LocationLabel;
import com.qcloud.cos.model.ciModel.job.DocJobDetail;
import com.qcloud.cos.model.ciModel.job.DocJobListResponse;
import com.qcloud.cos.model.ciModel.job.DocJobResponse;
import com.qcloud.cos.model.ciModel.job.DocProcessObject;
import com.qcloud.cos.model.ciModel.job.DocProcessPageInfo;
import com.qcloud.cos.model.ciModel.job.DocProcessResult;
import com.qcloud.cos.model.ciModel.job.ExtractDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.Md5Info;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaPicProcessTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaRemoveWaterMark;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.job.OutputFile;
import com.qcloud.cos.model.ciModel.job.ProcessResult;
import com.qcloud.cos.model.ciModel.job.VideoTargetRec;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaFormat;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoAudio;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoResponse;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoStream;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoSubtitle;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoVideo;
import com.qcloud.cos.model.ciModel.persistence.CIObject;
import com.qcloud.cos.model.ciModel.persistence.CIUploadResult;
import com.qcloud.cos.model.ciModel.persistence.ImageInfo;
import com.qcloud.cos.model.ciModel.persistence.OriginalInfo;
import com.qcloud.cos.model.ciModel.persistence.ProcessResults;
import com.qcloud.cos.model.ciModel.queue.DocListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.MediaListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.MediaNotifyConfig;
import com.qcloud.cos.model.ciModel.queue.MediaQueueObject;
import com.qcloud.cos.model.ciModel.queue.MediaQueueResponse;
import com.qcloud.cos.model.ciModel.recognition.CodeLocation;
import com.qcloud.cos.model.ciModel.recognition.QRcodeInfo;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotResponse;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaSegmentObject;
import com.qcloud.cos.model.ciModel.template.MediaSnapshotObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateTransTplObject;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkImage;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkText;
import com.qcloud.cos.model.ciModel.template.MediaWatermark;
import com.qcloud.cos.model.ciModel.template.SpriteSnapshotConfig;
import com.qcloud.cos.model.ciModel.workflow.MediaTasks;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowDependency;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionObject;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionsResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowInput;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowListResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowNode;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowObject;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowResponse;
import com.qcloud.cos.model.inventory.InventoryConfiguration;
import com.qcloud.cos.model.inventory.InventoryCosBucketDestination;
import com.qcloud.cos.model.inventory.InventoryDestination;
import com.qcloud.cos.model.inventory.InventoryFilter;
import com.qcloud.cos.model.inventory.InventoryPrefixPredicate;
import com.qcloud.cos.model.inventory.InventorySchedule;
import com.qcloud.cos.model.inventory.ServerSideEncryptionCOS;
import com.qcloud.cos.model.lifecycle.LifecycleAndOperator;
import com.qcloud.cos.model.lifecycle.LifecycleFilter;
import com.qcloud.cos.model.lifecycle.LifecycleFilterPredicate;
import com.qcloud.cos.model.lifecycle.LifecyclePrefixPredicate;
import com.qcloud.cos.utils.DateUtils;
import com.qcloud.cos.utils.StringUtils;
import com.qcloud.cos.utils.UrlEncoderUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlResponsesSaxParser {
    private static final Logger log = LoggerFactory.getLogger(XmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private boolean sanitizeXmlDocument = true;

    public XmlResponsesSaxParser() throws CosClientException {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            throw new CosClientException("Couldn't initialize a SAX driver to create an XMLReader", sAXException);
        }
    }

    protected void parseXmlInputStream(DefaultHandler defaultHandler, InputStream inputStream2) throws IOException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Parsing XML response document with handler: " + defaultHandler.getClass());
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, StringUtils.UTF8));
            this.xr.setContentHandler(defaultHandler);
            this.xr.setErrorHandler(defaultHandler);
            this.xr.parse(new InputSource(bufferedReader));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            block6: {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error("Unable to close response InputStream up after XML parse failure", iOException);
                }
            }
            throw new CosClientException("Failed to parse XML document with handler " + defaultHandler.getClass(), throwable);
        }
    }

    protected InputStream sanitizeXmlDocument(DefaultHandler defaultHandler, InputStream inputStream2) throws IOException {
        if (!this.sanitizeXmlDocument) {
            return inputStream2;
        }
        if (log.isDebugEnabled()) {
            log.debug("Sanitizing XML document destined for handler " + defaultHandler.getClass());
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, StringUtils.UTF8));
            char[] cArray = new char[8192];
            int n = -1;
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            bufferedReader.close();
            String string = stringBuilder.toString().replaceAll("\r", "&#013;");
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StringUtils.UTF8));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            block8: {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error("Unable to close response InputStream after failure sanitizing XML document", iOException);
                }
            }
            throw new CosClientException("Failed to sanitize XML document destined for handler " + defaultHandler.getClass(), throwable);
        }
        return byteArrayInputStream;
    }

    private static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Unable to parse integer value '" + string + "'", numberFormatException);
            return -1;
        }
    }

    private static long parseLong(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Unable to parse long value '" + string + "'", numberFormatException);
            return -1L;
        }
    }

    private static String checkForEmptyString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private static String decodeIfSpecified(String string, boolean bl) {
        return bl ? UrlEncoderUtils.urlDecode(string) : string;
    }

    public ListBucketHandler parseListBucketObjectsResponse(InputStream inputStream2, boolean bl) throws IOException {
        ListBucketHandler listBucketHandler = new ListBucketHandler(bl);
        this.parseXmlInputStream(listBucketHandler, this.sanitizeXmlDocument(listBucketHandler, inputStream2));
        return listBucketHandler;
    }

    public ListVersionsHandler parseListVersionsResponse(InputStream inputStream2, boolean bl) throws IOException {
        ListVersionsHandler listVersionsHandler = new ListVersionsHandler(bl);
        this.parseXmlInputStream(listVersionsHandler, this.sanitizeXmlDocument(listVersionsHandler, inputStream2));
        return listVersionsHandler;
    }

    public ReportBadCaseHandler parseReportBadCase(InputStream inputStream2) throws IOException {
        ReportBadCaseHandler reportBadCaseHandler = new ReportBadCaseHandler();
        this.parseXmlInputStream(reportBadCaseHandler, this.sanitizeXmlDocument(reportBadCaseHandler, inputStream2));
        return reportBadCaseHandler;
    }

    public ListAllMyBucketsHandler parseListMyBucketsResponse(InputStream inputStream2) throws IOException {
        ListAllMyBucketsHandler listAllMyBucketsHandler = new ListAllMyBucketsHandler();
        this.parseXmlInputStream(listAllMyBucketsHandler, this.sanitizeXmlDocument(listAllMyBucketsHandler, inputStream2));
        return listAllMyBucketsHandler;
    }

    public AccessControlListHandler parseAccessControlListResponse(InputStream inputStream2) throws IOException {
        AccessControlListHandler accessControlListHandler = new AccessControlListHandler();
        this.parseXmlInputStream(accessControlListHandler, inputStream2);
        return accessControlListHandler;
    }

    public ImagePersistenceHandler parseImagePersistenceResponse(InputStream inputStream2) throws IOException {
        ImagePersistenceHandler imagePersistenceHandler = new ImagePersistenceHandler();
        this.parseXmlInputStream(imagePersistenceHandler, inputStream2);
        return imagePersistenceHandler;
    }

    public BucketLifecycleConfigurationHandler parseBucketLifecycleConfigurationResponse(InputStream inputStream2) throws IOException {
        BucketLifecycleConfigurationHandler bucketLifecycleConfigurationHandler = new BucketLifecycleConfigurationHandler();
        this.parseXmlInputStream(bucketLifecycleConfigurationHandler, inputStream2);
        return bucketLifecycleConfigurationHandler;
    }

    public BucketCrossOriginConfigurationHandler parseBucketCrossOriginConfigurationResponse(InputStream inputStream2) throws IOException {
        BucketCrossOriginConfigurationHandler bucketCrossOriginConfigurationHandler = new BucketCrossOriginConfigurationHandler();
        this.parseXmlInputStream(bucketCrossOriginConfigurationHandler, inputStream2);
        return bucketCrossOriginConfigurationHandler;
    }

    public BucketDomainConfigurationHandler parseBucketDomainConfigurationResponse(InputStream inputStream2) throws IOException {
        BucketDomainConfigurationHandler bucketDomainConfigurationHandler = new BucketDomainConfigurationHandler();
        this.parseXmlInputStream(bucketDomainConfigurationHandler, inputStream2);
        return bucketDomainConfigurationHandler;
    }

    public BucketDomainCertificateHandler parseBucketDomainCertificateResponse(InputStream inputStream2) throws IOException {
        BucketDomainCertificateHandler bucketDomainCertificateHandler = new BucketDomainCertificateHandler();
        this.parseXmlInputStream(bucketDomainCertificateHandler, inputStream2);
        return bucketDomainCertificateHandler;
    }

    public BucketRefererConfigurationHandler parseBucketRefererConfigurationResponse(InputStream inputStream2) throws IOException {
        BucketRefererConfigurationHandler bucketRefererConfigurationHandler = new BucketRefererConfigurationHandler();
        this.parseXmlInputStream(bucketRefererConfigurationHandler, inputStream2);
        return bucketRefererConfigurationHandler;
    }

    public String parseBucketLocationResponse(InputStream inputStream2) throws IOException {
        BucketLocationHandler bucketLocationHandler = new BucketLocationHandler();
        this.parseXmlInputStream(bucketLocationHandler, inputStream2);
        return bucketLocationHandler.getLocation();
    }

    public BucketVersioningConfigurationHandler parseVersioningConfigurationResponse(InputStream inputStream2) throws IOException {
        BucketVersioningConfigurationHandler bucketVersioningConfigurationHandler = new BucketVersioningConfigurationHandler();
        this.parseXmlInputStream(bucketVersioningConfigurationHandler, inputStream2);
        return bucketVersioningConfigurationHandler;
    }

    public BucketReplicationConfigurationHandler parseReplicationConfigurationResponse(InputStream inputStream2) throws IOException {
        BucketReplicationConfigurationHandler bucketReplicationConfigurationHandler = new BucketReplicationConfigurationHandler();
        this.parseXmlInputStream(bucketReplicationConfigurationHandler, inputStream2);
        return bucketReplicationConfigurationHandler;
    }

    public BucketTaggingConfigurationHandler parseTaggingConfigurationResponse(InputStream inputStream2) throws IOException {
        BucketTaggingConfigurationHandler bucketTaggingConfigurationHandler = new BucketTaggingConfigurationHandler();
        this.parseXmlInputStream(bucketTaggingConfigurationHandler, inputStream2);
        return bucketTaggingConfigurationHandler;
    }

    public DeleteObjectsHandler parseDeletedObjectsResult(InputStream inputStream2) throws IOException {
        DeleteObjectsHandler deleteObjectsHandler = new DeleteObjectsHandler();
        this.parseXmlInputStream(deleteObjectsHandler, inputStream2);
        return deleteObjectsHandler;
    }

    public CopyObjectResultHandler parseCopyObjectResponse(InputStream inputStream2) throws IOException {
        CopyObjectResultHandler copyObjectResultHandler = new CopyObjectResultHandler();
        this.parseXmlInputStream(copyObjectResultHandler, inputStream2);
        return copyObjectResultHandler;
    }

    public CompleteMultipartUploadHandler parseCompleteMultipartUploadResponse(InputStream inputStream2) throws IOException {
        CompleteMultipartUploadHandler completeMultipartUploadHandler = new CompleteMultipartUploadHandler();
        this.parseXmlInputStream(completeMultipartUploadHandler, inputStream2);
        return completeMultipartUploadHandler;
    }

    public InitiateMultipartUploadHandler parseInitiateMultipartUploadResponse(InputStream inputStream2) throws IOException {
        InitiateMultipartUploadHandler initiateMultipartUploadHandler = new InitiateMultipartUploadHandler();
        this.parseXmlInputStream(initiateMultipartUploadHandler, inputStream2);
        return initiateMultipartUploadHandler;
    }

    public ListMultipartUploadsHandler parseListMultipartUploadsResponse(InputStream inputStream2) throws IOException {
        ListMultipartUploadsHandler listMultipartUploadsHandler = new ListMultipartUploadsHandler();
        this.parseXmlInputStream(listMultipartUploadsHandler, inputStream2);
        return listMultipartUploadsHandler;
    }

    public ListPartsHandler parseListPartsResponse(InputStream inputStream2) throws IOException {
        ListPartsHandler listPartsHandler = new ListPartsHandler();
        this.parseXmlInputStream(listPartsHandler, inputStream2);
        return listPartsHandler;
    }

    public BucketWebsiteConfigurationHandler parseWebsiteConfigurationResponse(InputStream inputStream2) throws IOException {
        BucketWebsiteConfigurationHandler bucketWebsiteConfigurationHandler = new BucketWebsiteConfigurationHandler();
        this.parseXmlInputStream(bucketWebsiteConfigurationHandler, inputStream2);
        return bucketWebsiteConfigurationHandler;
    }

    public BucketLoggingConfigurationHandler parseLoggingStatusResponse(InputStream inputStream2) throws IOException {
        BucketLoggingConfigurationHandler bucketLoggingConfigurationHandler = new BucketLoggingConfigurationHandler();
        this.parseXmlInputStream(bucketLoggingConfigurationHandler, inputStream2);
        return bucketLoggingConfigurationHandler;
    }

    public GetBucketInventoryConfigurationHandler parseGetBucketInventoryConfigurationResponse(InputStream inputStream2) throws IOException {
        GetBucketInventoryConfigurationHandler getBucketInventoryConfigurationHandler = new GetBucketInventoryConfigurationHandler();
        this.parseXmlInputStream(getBucketInventoryConfigurationHandler, inputStream2);
        return getBucketInventoryConfigurationHandler;
    }

    public ListBucketInventoryConfigurationsHandler parseBucketListInventoryConfigurationsResponse(InputStream inputStream2) throws IOException {
        ListBucketInventoryConfigurationsHandler listBucketInventoryConfigurationsHandler = new ListBucketInventoryConfigurationsHandler();
        this.parseXmlInputStream(listBucketInventoryConfigurationsHandler, inputStream2);
        return listBucketInventoryConfigurationsHandler;
    }

    public GetObjectTaggingHandler parseObjectTaggingResponse(InputStream inputStream2) throws IOException {
        GetObjectTaggingHandler getObjectTaggingHandler = new GetObjectTaggingHandler();
        this.parseXmlInputStream(getObjectTaggingHandler, inputStream2);
        return getObjectTaggingHandler;
    }

    public GetBucketIntelligentTierConfigurationHandler parseBucketIntelligentTierConfigurationsResponse(InputStream inputStream2) throws IOException {
        GetBucketIntelligentTierConfigurationHandler getBucketIntelligentTierConfigurationHandler = new GetBucketIntelligentTierConfigurationHandler();
        this.parseXmlInputStream(getBucketIntelligentTierConfigurationHandler, inputStream2);
        return getBucketIntelligentTierConfigurationHandler;
    }

    public ListQueueHandler parseListQueueResponse(InputStream inputStream2) throws IOException {
        ListQueueHandler listQueueHandler = new ListQueueHandler();
        this.parseXmlInputStream(listQueueHandler, this.sanitizeXmlDocument(listQueueHandler, inputStream2));
        return listQueueHandler;
    }

    public DocListQueueHandler parseDocListQueueResponse(InputStream inputStream2) throws IOException {
        DocListQueueHandler docListQueueHandler = new DocListQueueHandler();
        this.parseXmlInputStream(docListQueueHandler, this.sanitizeXmlDocument(docListQueueHandler, inputStream2));
        return docListQueueHandler;
    }

    public MediaQueueResponseHandler parseUpdateMediaQueueResponse(InputStream inputStream2) throws IOException {
        MediaQueueResponseHandler mediaQueueResponseHandler = new MediaQueueResponseHandler();
        this.parseXmlInputStream(mediaQueueResponseHandler, this.sanitizeXmlDocument(mediaQueueResponseHandler, inputStream2));
        return mediaQueueResponseHandler;
    }

    public MediaTemplateHandler parseMediaTemplateResponse(InputStream inputStream2) throws IOException {
        MediaTemplateHandler mediaTemplateHandler = new MediaTemplateHandler();
        this.parseXmlInputStream(mediaTemplateHandler, this.sanitizeXmlDocument(mediaTemplateHandler, inputStream2));
        return mediaTemplateHandler;
    }

    public SnapshotHandler parseSnapshotResponse(InputStream inputStream2) throws IOException {
        SnapshotHandler snapshotHandler = new SnapshotHandler();
        this.parseXmlInputStream(snapshotHandler, this.sanitizeXmlDocument(snapshotHandler, inputStream2));
        return snapshotHandler;
    }

    public GenerateMediainfoHandler parseGenerateMediainfoResponse(InputStream inputStream2) throws IOException {
        GenerateMediainfoHandler generateMediainfoHandler = new GenerateMediainfoHandler();
        this.parseXmlInputStream(generateMediainfoHandler, this.sanitizeXmlDocument(generateMediainfoHandler, inputStream2));
        return generateMediainfoHandler;
    }

    public WorkflowExecutionsHandler parseMediaWorkflowExecutionsResponse(InputStream inputStream2) throws IOException {
        WorkflowExecutionsHandler workflowExecutionsHandler = new WorkflowExecutionsHandler();
        this.parseXmlInputStream(workflowExecutionsHandler, this.sanitizeXmlDocument(workflowExecutionsHandler, inputStream2));
        return workflowExecutionsHandler;
    }

    public MediaTemplatesHandler parseDescribeMediaTemplatesResponse(InputStream inputStream2) throws IOException {
        MediaTemplatesHandler mediaTemplatesHandler = new MediaTemplatesHandler();
        this.parseXmlInputStream(mediaTemplatesHandler, this.sanitizeXmlDocument(mediaTemplatesHandler, inputStream2));
        return mediaTemplatesHandler;
    }

    public ListMediaBucketHandler parseListBucketResponse(InputStream inputStream2) throws IOException {
        ListMediaBucketHandler listMediaBucketHandler = new ListMediaBucketHandler();
        this.parseXmlInputStream(listMediaBucketHandler, this.sanitizeXmlDocument(listMediaBucketHandler, inputStream2));
        return listMediaBucketHandler;
    }

    public ListDocBucketHandler parseDocListBucketResponse(InputStream inputStream2) throws IOException {
        ListDocBucketHandler listDocBucketHandler = new ListDocBucketHandler();
        this.parseXmlInputStream(listDocBucketHandler, this.sanitizeXmlDocument(listDocBucketHandler, inputStream2));
        return listDocBucketHandler;
    }

    public WorkflowListHandler parseWorkflowListResponse(InputStream inputStream2) throws IOException {
        WorkflowListHandler workflowListHandler = new WorkflowListHandler();
        this.parseXmlInputStream(workflowListHandler, this.sanitizeXmlDocument(workflowListHandler, inputStream2));
        return workflowListHandler;
    }

    public WorkflowHandler parseWorkflowResponse(InputStream inputStream2) throws IOException {
        WorkflowHandler workflowHandler = new WorkflowHandler();
        this.parseXmlInputStream(workflowHandler, this.sanitizeXmlDocument(workflowHandler, inputStream2));
        return workflowHandler;
    }

    public WorkflowExecutionHandler parseWorkflowExecutionResponse(InputStream inputStream2) throws IOException {
        WorkflowExecutionHandler workflowExecutionHandler = new WorkflowExecutionHandler();
        this.parseXmlInputStream(workflowExecutionHandler, this.sanitizeXmlDocument(workflowExecutionHandler, inputStream2));
        return workflowExecutionHandler;
    }

    public MediaJobCreatHandler parseJobCreatResponse(InputStream inputStream2) throws IOException {
        MediaJobCreatHandler mediaJobCreatHandler = new MediaJobCreatHandler();
        this.parseXmlInputStream(mediaJobCreatHandler, this.sanitizeXmlDocument(mediaJobCreatHandler, inputStream2));
        return mediaJobCreatHandler;
    }

    public MediaJobResponseHandler parseMediaJobRespones(InputStream inputStream2) throws IOException {
        MediaJobResponseHandler mediaJobResponseHandler = new MediaJobResponseHandler();
        this.parseXmlInputStream(mediaJobResponseHandler, this.sanitizeXmlDocument(mediaJobResponseHandler, inputStream2));
        return mediaJobResponseHandler;
    }

    public BatchJobResponseHandler parseBatchJobResponse(InputStream inputStream2) throws IOException {
        BatchJobResponseHandler batchJobResponseHandler = new BatchJobResponseHandler();
        this.parseXmlInputStream(batchJobResponseHandler, this.sanitizeXmlDocument(batchJobResponseHandler, inputStream2));
        return batchJobResponseHandler;
    }

    public DescribeMediaJobsHandler parseMediaJobsRespones(InputStream inputStream2) throws IOException {
        DescribeMediaJobsHandler describeMediaJobsHandler = new DescribeMediaJobsHandler();
        this.parseXmlInputStream(describeMediaJobsHandler, this.sanitizeXmlDocument(describeMediaJobsHandler, inputStream2));
        return describeMediaJobsHandler;
    }

    public DocJobHandler parseDocJobResponse(InputStream inputStream2) throws IOException {
        DocJobHandler docJobHandler = new DocJobHandler();
        this.parseXmlInputStream(docJobHandler, this.sanitizeXmlDocument(docJobHandler, inputStream2));
        return docJobHandler;
    }

    public DescribeDocProcessJobHandler parseDescribeDocJobResponse(InputStream inputStream2) throws IOException {
        DescribeDocProcessJobHandler describeDocProcessJobHandler = new DescribeDocProcessJobHandler();
        this.parseXmlInputStream(describeDocProcessJobHandler, this.sanitizeXmlDocument(describeDocProcessJobHandler, inputStream2));
        return describeDocProcessJobHandler;
    }

    public DescribeDocProcessJobsHandler parseDocJobListResponse(InputStream inputStream2) throws IOException {
        DescribeDocProcessJobsHandler describeDocProcessJobsHandler = new DescribeDocProcessJobsHandler();
        this.parseXmlInputStream(describeDocProcessJobsHandler, this.sanitizeXmlDocument(describeDocProcessJobsHandler, inputStream2));
        return describeDocProcessJobsHandler;
    }

    public ImageAuditingHandler parseImageAuditingResponse(InputStream inputStream2) throws IOException {
        ImageAuditingHandler imageAuditingHandler = new ImageAuditingHandler();
        this.parseXmlInputStream(imageAuditingHandler, this.sanitizeXmlDocument(imageAuditingHandler, inputStream2));
        return imageAuditingHandler;
    }

    public CreateVideoAuditingJobHandler parseVideoAuditingJobResponse(InputStream inputStream2) throws IOException {
        CreateVideoAuditingJobHandler createVideoAuditingJobHandler = new CreateVideoAuditingJobHandler();
        this.parseXmlInputStream(createVideoAuditingJobHandler, this.sanitizeXmlDocument(createVideoAuditingJobHandler, inputStream2));
        return createVideoAuditingJobHandler;
    }

    public CreateAudioAuditingJobHandler parseAudioAuditingJobResponse(InputStream inputStream2) throws IOException {
        CreateAudioAuditingJobHandler createAudioAuditingJobHandler = new CreateAudioAuditingJobHandler();
        this.parseXmlInputStream(createAudioAuditingJobHandler, this.sanitizeXmlDocument(createAudioAuditingJobHandler, inputStream2));
        return createAudioAuditingJobHandler;
    }

    public DescribeVideoAuditingJobHandler parseDescribeVideoAuditingJobResponse(InputStream inputStream2) throws IOException {
        DescribeVideoAuditingJobHandler describeVideoAuditingJobHandler = new DescribeVideoAuditingJobHandler();
        this.parseXmlInputStream(describeVideoAuditingJobHandler, this.sanitizeXmlDocument(describeVideoAuditingJobHandler, inputStream2));
        return describeVideoAuditingJobHandler;
    }

    public DescribeAudioAuditingJobHandler parseDescribeAudioAuditingJobResponse(InputStream inputStream2) throws IOException {
        DescribeAudioAuditingJobHandler describeAudioAuditingJobHandler = new DescribeAudioAuditingJobHandler();
        this.parseXmlInputStream(describeAudioAuditingJobHandler, this.sanitizeXmlDocument(describeAudioAuditingJobHandler, inputStream2));
        return describeAudioAuditingJobHandler;
    }

    public ImageLabelHandler parseImageLabelResponse(InputStream inputStream2) throws IOException {
        ImageLabelHandler imageLabelHandler = new ImageLabelHandler();
        this.parseXmlInputStream(imageLabelHandler, this.sanitizeXmlDocument(imageLabelHandler, inputStream2));
        return imageLabelHandler;
    }

    public ImageLabelV2Handler parseImageLabelV2Response(InputStream inputStream2) throws IOException {
        ImageLabelV2Handler imageLabelV2Handler = new ImageLabelV2Handler();
        this.parseXmlInputStream(imageLabelV2Handler, this.sanitizeXmlDocument(imageLabelV2Handler, inputStream2));
        return imageLabelV2Handler;
    }

    public TextAuditingJobHandler parseTextAuditingResponse(InputStream inputStream2) throws IOException {
        TextAuditingJobHandler textAuditingJobHandler = new TextAuditingJobHandler();
        this.parseXmlInputStream(textAuditingJobHandler, this.sanitizeXmlDocument(textAuditingJobHandler, inputStream2));
        return textAuditingJobHandler;
    }

    public TextAuditingDescribeJobHandler parseTextAuditingDescribeResponse(InputStream inputStream2) throws IOException {
        TextAuditingDescribeJobHandler textAuditingDescribeJobHandler = new TextAuditingDescribeJobHandler();
        this.parseXmlInputStream(textAuditingDescribeJobHandler, this.sanitizeXmlDocument(textAuditingDescribeJobHandler, inputStream2));
        return textAuditingDescribeJobHandler;
    }

    public DocumentAuditingJobHandler parseDocumentAuditingResponse(InputStream inputStream2) throws IOException {
        DocumentAuditingJobHandler documentAuditingJobHandler = new DocumentAuditingJobHandler();
        this.parseXmlInputStream(documentAuditingJobHandler, this.sanitizeXmlDocument(documentAuditingJobHandler, inputStream2));
        return documentAuditingJobHandler;
    }

    public DocumentAuditingDescribeJobHandler parseDocumentAuditingDescribeResponse(InputStream inputStream2) throws IOException {
        DocumentAuditingDescribeJobHandler documentAuditingDescribeJobHandler = new DocumentAuditingDescribeJobHandler();
        this.parseXmlInputStream(documentAuditingDescribeJobHandler, this.sanitizeXmlDocument(documentAuditingDescribeJobHandler, inputStream2));
        return documentAuditingDescribeJobHandler;
    }

    public BatchImageAuditingHandler parseBatchImageAuditingResponse(InputStream inputStream2) throws IOException {
        BatchImageAuditingHandler batchImageAuditingHandler = new BatchImageAuditingHandler();
        this.parseXmlInputStream(batchImageAuditingHandler, this.sanitizeXmlDocument(batchImageAuditingHandler, inputStream2));
        return batchImageAuditingHandler;
    }

    public WebpageAuditingJobHandler parseWebpageAuditingJobResponse(InputStream inputStream2) throws IOException {
        WebpageAuditingJobHandler webpageAuditingJobHandler = new WebpageAuditingJobHandler();
        this.parseXmlInputStream(webpageAuditingJobHandler, this.sanitizeXmlDocument(webpageAuditingJobHandler, inputStream2));
        return webpageAuditingJobHandler;
    }

    public WebpageAuditingDescribeJobHandler parseDWebpageAuditingDescribeResponse(InputStream inputStream2) throws IOException {
        WebpageAuditingDescribeJobHandler webpageAuditingDescribeJobHandler = new WebpageAuditingDescribeJobHandler();
        this.parseXmlInputStream(webpageAuditingDescribeJobHandler, this.sanitizeXmlDocument(webpageAuditingDescribeJobHandler, inputStream2));
        return webpageAuditingDescribeJobHandler;
    }

    public DescribeImageAuditingJobHandler parseImageAuditingDescribeResponse(InputStream inputStream2) throws IOException {
        DescribeImageAuditingJobHandler describeImageAuditingJobHandler = new DescribeImageAuditingJobHandler();
        this.parseXmlInputStream(describeImageAuditingJobHandler, this.sanitizeXmlDocument(describeImageAuditingJobHandler, inputStream2));
        return describeImageAuditingJobHandler;
    }

    public DetectCarHandler parseDetectCarResponse(InputStream inputStream2) throws IOException {
        DetectCarHandler detectCarHandler = new DetectCarHandler();
        this.parseXmlInputStream(detectCarHandler, this.sanitizeXmlDocument(detectCarHandler, inputStream2));
        return detectCarHandler;
    }

    public SearchImageHandler parseSearchImagesResponse(InputStream inputStream2) throws IOException {
        SearchImageHandler searchImageHandler = new SearchImageHandler();
        this.parseXmlInputStream(searchImageHandler, this.sanitizeXmlDocument(searchImageHandler, inputStream2));
        return searchImageHandler;
    }

    public TriggerWorkflowListHandler parsetriggerWorkflowListResponse(InputStream inputStream2) throws IOException {
        TriggerWorkflowListHandler triggerWorkflowListHandler = new TriggerWorkflowListHandler();
        this.parseXmlInputStream(triggerWorkflowListHandler, this.sanitizeXmlDocument(triggerWorkflowListHandler, inputStream2));
        return triggerWorkflowListHandler;
    }

    public GenerateQrcodeHandler parseGenerateQrcodeResponse(InputStream inputStream2) throws IOException {
        GenerateQrcodeHandler generateQrcodeHandler = new GenerateQrcodeHandler();
        this.parseXmlInputStream(generateQrcodeHandler, this.sanitizeXmlDocument(generateQrcodeHandler, inputStream2));
        return generateQrcodeHandler;
    }

    public GenerateQrcodeHandler parseImageStyleResponse(InputStream inputStream2) throws IOException {
        GenerateQrcodeHandler generateQrcodeHandler = new GenerateQrcodeHandler();
        this.parseXmlInputStream(generateQrcodeHandler, this.sanitizeXmlDocument(generateQrcodeHandler, inputStream2));
        return generateQrcodeHandler;
    }

    public GetImageStyleHandler parseGetImageStyleResponse(InputStream inputStream2) throws IOException {
        GetImageStyleHandler getImageStyleHandler = new GetImageStyleHandler();
        this.parseXmlInputStream(getImageStyleHandler, this.sanitizeXmlDocument(getImageStyleHandler, inputStream2));
        return getImageStyleHandler;
    }

    public DecompressionHandler parseDecompressionResult(InputStream inputStream2) throws IOException {
        DecompressionHandler decompressionHandler = new DecompressionHandler();
        this.parseXmlInputStream(decompressionHandler, this.sanitizeXmlDocument(decompressionHandler, inputStream2));
        return decompressionHandler;
    }

    public ListJobsResultHandler parseListJobsResult(InputStream inputStream2) throws IOException {
        ListJobsResultHandler listJobsResultHandler = new ListJobsResultHandler();
        this.parseXmlInputStream(listJobsResultHandler, this.sanitizeXmlDocument(listJobsResultHandler, inputStream2));
        return listJobsResultHandler;
    }

    public FileProcessResponseHandler parseFileProcessResponse(InputStream inputStream2) throws IOException {
        FileProcessResponseHandler fileProcessResponseHandler = new FileProcessResponseHandler();
        this.parseXmlInputStream(fileProcessResponseHandler, this.sanitizeXmlDocument(fileProcessResponseHandler, inputStream2));
        return fileProcessResponseHandler;
    }

    private static String findAttributeValue(String string, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string2 = attributes.getQName(i);
            if (!string2.trim().equalsIgnoreCase(string.trim())) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    public static class ListJobsResultHandler
    extends AbstractHandler {
        private final ListJobsResult listJobsResult = new ListJobsResult();
        private final List<ListJobsResult.DecompressionJob> jobList = new ArrayList<ListJobsResult.DecompressionJob>();
        private ListJobsResult.DecompressionJob job;

        public ListJobsResultHandler() {
            this.listJobsResult.setJobs(this.jobList);
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListJobsResult", "Jobs") && string2.equals("Job")) {
                this.job = new ListJobsResult.DecompressionJob();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("ListJobsResult", "Jobs", "Job")) {
                switch (string2) {
                    case "Key": {
                        this.job.setKey(this.getText());
                        break;
                    }
                    case "DecompressionPrefix": {
                        this.job.setDecompressionPrefix(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        this.job.setCreationTime(this.getText());
                        break;
                    }
                    case "TerminationTime": {
                        this.job.setTerminationTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        this.job.setJobId(this.getText());
                        break;
                    }
                    case "Status": {
                        this.job.setStatus(this.getText());
                    }
                }
            } else if (this.in("ListJobsResult", "Jobs")) {
                if (string2.equals("Job")) {
                    this.jobList.add(this.job);
                }
            } else if (this.in("ListJobsResult") && string2.equals("NextToken")) {
                this.listJobsResult.setNextToken(this.getText());
            }
        }

        public ListJobsResult getResult() {
            return this.listJobsResult;
        }
    }

    public static class DecompressionHandler
    extends AbstractHandler {
        private final DecompressionResult decompressionResult = new DecompressionResult();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("DecompressionResult")) {
                switch (string2) {
                    case "JobId": {
                        this.decompressionResult.setJobId(this.getText());
                        break;
                    }
                    case "Status": {
                        this.decompressionResult.setStatus(this.getText());
                        break;
                    }
                    case "Msg": {
                        this.decompressionResult.setMsg(this.getText());
                    }
                }
            }
        }

        public DecompressionResult getDecompressionResult() {
            return this.decompressionResult;
        }
    }

    public static class DescribeImageAuditingJobHandler
    extends AbstractHandler {
        private ImageAuditingResponse response = new ImageAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(string2)) {
                this.response.getListInfo().getListResults().add(new ListResult());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            List<ListResult> list;
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(string2)) {
                    this.response.setRequestId(this.getText());
                }
            } else if (this.in("Response", "JobsDetail")) {
                switch (string2) {
                    case "JobId": {
                        this.response.setJobId(this.getText());
                        break;
                    }
                    case "Label": {
                        this.response.setLabel(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        this.response.setCreationTime(this.getText());
                        break;
                    }
                    case "Object": {
                        this.response.setObject(this.getText());
                        break;
                    }
                    case "Result": {
                        this.response.setResult(this.getText());
                        break;
                    }
                    case "Code": {
                        this.response.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        this.response.setMessage(this.getText());
                        break;
                    }
                    case "DataId": {
                        this.response.setDataId(this.getText());
                        break;
                    }
                    case "Url": {
                        this.response.setUrl(this.getText());
                        break;
                    }
                    case "State": {
                        this.response.setState(this.getText());
                        break;
                    }
                    case "Text": {
                        this.response.setText(this.getText());
                        break;
                    }
                    case "Category": {
                        this.response.setCategory(this.getText());
                        break;
                    }
                    case "ForbidState": {
                        this.response.setForbidState(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "PornInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TeenagerInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getTeenagerInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getUserInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PornInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getPornInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getPoliticsInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getTerroristInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getAdsInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults") && !(list = this.response.getListInfo().getListResults()).isEmpty()) {
                ParserMediaInfoUtils.parsingAuditingListResultInfo(list.get(list.size() - 1), string2, this.getText());
            }
        }

        public ImageAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(ImageAuditingResponse imageAuditingResponse) {
            this.response = imageAuditingResponse;
        }
    }

    public static class WebpageAuditingDescribeJobHandler
    extends AbstractHandler {
        private WebpageAuditingResponse response = new WebpageAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            List<ResultsImageAuditingDetail> list = this.response.getJobsDetail().getImageResults();
            List<ResultsTextAuditingDetail> list2 = this.response.getJobsDetail().getTextResults();
            if (this.in("Response", "JobsDetail", "ImageResults") && "Results".equals(string2)) {
                list.add(new ResultsImageAuditingDetail());
            } else if (this.in("Response", "JobsDetail", "TextResults") && "Results".equals(string2)) {
                list2.add(new ResultsTextAuditingDetail());
            } else if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(string2)) {
                this.response.getJobsDetail().getListInfo().getListResults().add(new ListResult());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            WebpageAuditingJobsDetail webpageAuditingJobsDetail = this.response.getJobsDetail();
            List<ResultsImageAuditingDetail> list = webpageAuditingJobsDetail.getImageResults();
            List<ResultsTextAuditingDetail> list2 = webpageAuditingJobsDetail.getTextResults();
            ResultsImageAuditingDetail resultsImageAuditingDetail = null;
            ResultsTextAuditingDetail resultsTextAuditingDetail = null;
            resultsImageAuditingDetail = list.isEmpty() ? new ResultsImageAuditingDetail() : list.get(list.size() - 1);
            resultsTextAuditingDetail = list2.isEmpty() ? new ResultsTextAuditingDetail() : list2.get(list2.size() - 1);
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(string2)) {
                    this.response.setRequestId(this.getText());
                }
            } else if (this.in("Response", "JobsDetail")) {
                switch (string2) {
                    case "JobId": {
                        webpageAuditingJobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        webpageAuditingJobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        webpageAuditingJobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Suggestion": {
                        webpageAuditingJobsDetail.setSuggestion(this.getText());
                        break;
                    }
                    case "PageCount": {
                        webpageAuditingJobsDetail.setPageCount(this.getText());
                        break;
                    }
                    case "Url": {
                        webpageAuditingJobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "Label": {
                        webpageAuditingJobsDetail.setLabel(this.getText());
                        break;
                    }
                    case "Code": {
                        webpageAuditingJobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        webpageAuditingJobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "dataId": {
                        webpageAuditingJobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "HighlightHtml": {
                        webpageAuditingJobsDetail.setHighlightHtml(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "ImageResults", "Results")) {
                switch (string2) {
                    case "Text": {
                        resultsImageAuditingDetail.setText(this.getText());
                        break;
                    }
                    case "Url": {
                        resultsImageAuditingDetail.setUrl(this.getText());
                        break;
                    }
                    case "Label": {
                        resultsImageAuditingDetail.setLabel(this.getText());
                        break;
                    }
                    case "Suggestion": {
                        resultsImageAuditingDetail.setSuggestion(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "TextResults", "Results")) {
                switch (string2) {
                    case "Text": {
                        resultsTextAuditingDetail.setText(this.getText());
                        break;
                    }
                    case "Label": {
                        resultsTextAuditingDetail.setLabel(this.getText());
                        break;
                    }
                    case "Suggestion": {
                        resultsTextAuditingDetail.setSuggestion(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "ImageResults", "Results", "PoliticsInfo")) {
                this.parseInfo(resultsImageAuditingDetail.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "ImageResults", "Results", "PornInfo")) {
                this.parseInfo(resultsImageAuditingDetail.getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "ImageResults", "Results", "TerrorismInfo")) {
                this.parseInfo(resultsImageAuditingDetail.getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "ImageResults", "Results", "AdsInfo")) {
                this.parseInfo(resultsImageAuditingDetail.getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TextResults", "Results", "PoliticsInfo")) {
                this.parseInfo(resultsTextAuditingDetail.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TextResults", "Results", "PornInfo")) {
                this.parseInfo(resultsTextAuditingDetail.getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TextResults", "Results", "TerrorismInfo")) {
                this.parseInfo(resultsTextAuditingDetail.getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TextResults", "Results", "AdsInfo")) {
                this.parseInfo(resultsTextAuditingDetail.getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults")) {
                List<ListResult> list3 = this.response.getJobsDetail().getListInfo().getListResults();
                if (!list3.isEmpty()) {
                    ParserMediaInfoUtils.parsingAuditingListResultInfo(list3.get(list3.size() - 1), string2, this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Labels", "PoliticsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Labels", "PornInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Labels", "TerrorismInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Labels", "AdsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getAdsInfo(), string2, this.getText());
            }
        }

        private void parseInfo(AudtingCommonInfo audtingCommonInfo, String string, String string2) {
            switch (string) {
                case "Code": {
                    audtingCommonInfo.setCode(string2);
                    break;
                }
                case "HitFlag": {
                    audtingCommonInfo.setHitFlag(this.getText());
                    break;
                }
                case "Score": {
                    audtingCommonInfo.setScore(this.getText());
                    break;
                }
                case "Keywords": {
                    audtingCommonInfo.setLabel(this.getText());
                    break;
                }
                case "Count": {
                    audtingCommonInfo.setCount(this.getText());
                    break;
                }
                case "SubLabel": {
                    audtingCommonInfo.setSubLabel(this.getText());
                    break;
                }
            }
        }

        public WebpageAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(WebpageAuditingResponse webpageAuditingResponse) {
            this.response = webpageAuditingResponse;
        }
    }

    public static class WebpageAuditingJobHandler
    extends AbstractHandler {
        private WebpageAuditingResponse response = new WebpageAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response", "JobsDetail")) {
                WebpageAuditingJobsDetail webpageAuditingJobsDetail = this.response.getJobsDetail();
                switch (string2) {
                    case "JobId": {
                        webpageAuditingJobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        webpageAuditingJobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        webpageAuditingJobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Url": {
                        webpageAuditingJobsDetail.setUrl(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response") && "RequestId".equalsIgnoreCase(string2)) {
                this.response.setRequestId(this.getText());
            }
        }

        public WebpageAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(WebpageAuditingResponse webpageAuditingResponse) {
            this.response = webpageAuditingResponse;
        }
    }

    public static class BatchImageAuditingHandler
    extends AbstractHandler {
        private BatchImageAuditingResponse response = new BatchImageAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            List<BatchImageJobDetail> list = this.response.getJobList();
            if (this.in("Response") && "JobsDetail".equals(string2)) {
                list.add(new BatchImageJobDetail());
            } else if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(string2)) {
                if (!list.isEmpty()) {
                    List<ListResult> list2 = list.get(list.size() - 1).getListInfo().getListResults();
                    list2.add(new ListResult());
                }
            } else if (this.in("Response", "JobsDetail", "PornInfo") && "LibResults".equals(string2)) {
                list.get(list.size() - 1).getPornInfo().getLibResults().add(new LibResult());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo") && "LibResults".equals(string2)) {
                list.get(list.size() - 1).getPoliticsInfo().getLibResults().add(new LibResult());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo") && "LibResults".equals(string2) || this.in("Response", "JobsDetail", "TerrorismInfo") && "LibResults".equals(string2)) {
                list.get(list.size() - 1).getTerroristInfo().getLibResults().add(new LibResult());
            } else if (this.in("Response", "JobsDetail", "AdsInfo") && "LibResults".equals(string2)) {
                list.get(list.size() - 1).getAdsInfo().getLibResults().add(new LibResult());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            List<BatchImageJobDetail> list = this.response.getJobList();
            BatchImageJobDetail batchImageJobDetail = null;
            batchImageJobDetail = list != null && list.size() > 0 ? list.get(list.size() - 1) : new BatchImageJobDetail();
            if (this.in("Response", "JobsDetail")) {
                ParserMediaInfoUtils.ParsingAuditingBatchImageJobDetail(batchImageJobDetail, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PornInfo")) {
                this.parseInfo(batchImageJobDetail.getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo")) {
                this.parseInfo(batchImageJobDetail.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo") || this.in("Response", "JobsDetail", "TerrorismInfo")) {
                this.parseInfo(batchImageJobDetail.getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo")) {
                this.parseInfo(batchImageJobDetail.getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PornInfo", "LibResults")) {
                List<LibResult> list2 = batchImageJobDetail.getPornInfo().getLibResults();
                ParserMediaInfoUtils.parsingLastLibResult(list2, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo", "LibResults")) {
                List<LibResult> list3 = batchImageJobDetail.getPoliticsInfo().getLibResults();
                ParserMediaInfoUtils.parsingLastLibResult(list3, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo", "LibResults") || this.in("Response", "JobsDetail", "TerrorismInfo", "LibResults")) {
                List<LibResult> list4 = batchImageJobDetail.getTerroristInfo().getLibResults();
                ParserMediaInfoUtils.parsingLastLibResult(list4, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo", "LibResults")) {
                List<LibResult> list5 = batchImageJobDetail.getAdsInfo().getLibResults();
                ParserMediaInfoUtils.parsingLastLibResult(list5, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(batchImageJobDetail.getUserInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults")) {
                List<ListResult> list6 = batchImageJobDetail.getListInfo().getListResults();
                if (list6.isEmpty()) {
                    return;
                }
                ParserMediaInfoUtils.parsingAuditingListResultInfo(list6.get(list6.size() - 1), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PornInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(batchImageJobDetail.getPornInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(batchImageJobDetail.getPoliticsInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo", "ObjectResults")) {
                ParserMediaInfoUtils.parseObjectResultsInfo(batchImageJobDetail.getPoliticsInfo().getPoliticsInfoObjectResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo", "OcrResults") || this.in("Response", "JobsDetail", "TerrorismInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(batchImageJobDetail.getTerroristInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(batchImageJobDetail.getAdsInfo().getOcrResults(), string2, this.getText());
            }
        }

        public BatchImageAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(BatchImageAuditingResponse batchImageAuditingResponse) {
            this.response = batchImageAuditingResponse;
        }

        private void parseInfo(AudtingCommonInfo audtingCommonInfo, String string, String string2) {
            switch (string) {
                case "Code": {
                    audtingCommonInfo.setCode(string2);
                    break;
                }
                case "Msg": {
                    audtingCommonInfo.setMsg(this.getText());
                    break;
                }
                case "HitFlag": {
                    audtingCommonInfo.setHitFlag(this.getText());
                    break;
                }
                case "Score": {
                    audtingCommonInfo.setScore(this.getText());
                    break;
                }
                case "Label": {
                    audtingCommonInfo.setLabel(this.getText());
                    break;
                }
            }
        }
    }

    public static class DocumentAuditingDescribeJobHandler
    extends AbstractHandler {
        private DocumentAuditingResponse response = new DocumentAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            List<DocumentResultInfo> list = this.response.getJobsDetail().getPageSegment();
            if (this.in("Response", "JobsDetail", "PageSegment") && "Results".equals(string2)) {
                list.add(new DocumentResultInfo());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PoliticsInfo") && "ObjectResults".equals(string2)) {
                list.get(list.size() - 1).getPoliticsInfo().getObjectResults().add(new ObjectResults());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PornInfo") && "ObjectResults".equals(string2)) {
                list.get(list.size() - 1).getPornInfo().getObjectResults().add(new ObjectResults());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "AdsInfo") && "ObjectResults".equals(string2)) {
                list.get(list.size() - 1).getAdsInfo().getObjectResults().add(new ObjectResults());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "TerroristInfo") && "ObjectResults".equals(string2)) {
                list.get(list.size() - 1).getTerroristInfo().getObjectResults().add(new ObjectResults());
            } else if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(string2)) {
                this.response.getJobsDetail().getListInfo().getListResults().add(new ListResult());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            List<ListResult> list;
            DocumentAuditingJobsDetail documentAuditingJobsDetail = this.response.getJobsDetail();
            List<DocumentResultInfo> list2 = documentAuditingJobsDetail.getPageSegment();
            DocumentResultInfo documentResultInfo = new DocumentResultInfo();
            if (list2.size() != 0) {
                documentResultInfo = list2.get(list2.size() - 1);
            }
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(string2)) {
                    this.response.setRequestId(this.getText());
                }
            } else if (this.in("Response", "JobsDetail")) {
                switch (string2) {
                    case "Code": {
                        documentAuditingJobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        documentAuditingJobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "JobId": {
                        documentAuditingJobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        documentAuditingJobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        documentAuditingJobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Suggestion": {
                        documentAuditingJobsDetail.setSuggestion(this.getText());
                        break;
                    }
                    case "PageCount": {
                        documentAuditingJobsDetail.setPageCount(this.getText());
                        break;
                    }
                    case "Url": {
                        documentAuditingJobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "Object": {
                        documentAuditingJobsDetail.setObject(this.getText());
                        break;
                    }
                    case "DataId": {
                        documentAuditingJobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "ForbidState": {
                        documentAuditingJobsDetail.setForbidState(this.getText());
                        break;
                    }
                    case "Label": {
                        documentAuditingJobsDetail.setLabel(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Labels", "AdsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Labels", "PoliticsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Labels", "PornInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Labels", "TerrorismInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "AdsInfo")) {
                this.parseInfo(documentResultInfo.getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PoliticsInfo")) {
                this.parseInfo(documentResultInfo.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PornInfo")) {
                this.parseInfo(documentResultInfo.getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "TerrorismInfo")) {
                this.parseInfo(documentResultInfo.getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results")) {
                if ("Text".equalsIgnoreCase(string2)) {
                    documentResultInfo.setText(this.getText());
                } else if ("Url".equalsIgnoreCase(string2)) {
                    documentResultInfo.setUrl(this.getText());
                } else if ("Label".equalsIgnoreCase(string2)) {
                    documentResultInfo.setLabel(this.getText());
                } else if ("Suggestion".equalsIgnoreCase(string2)) {
                    documentResultInfo.setSuggestion(this.getText());
                } else if ("PageNumber".equalsIgnoreCase(string2)) {
                    documentResultInfo.setPageNumber(this.getText());
                } else if ("SheetNumber".equalsIgnoreCase(string2)) {
                    documentResultInfo.setSheetNumber(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PornInfo", "OcrResults")) {
                this.parseResultInfo(documentResultInfo.getPornInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PoliticsInfo", "OcrResults")) {
                this.parseResultInfo(documentResultInfo.getPoliticsInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "TerrorismInfo", "OcrResults")) {
                this.parseResultInfo(documentResultInfo.getTerroristInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "AdsInfo", "OcrResults")) {
                this.parseResultInfo(documentResultInfo.getAdsInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PornInfo", "ObjectResults")) {
                this.parseResultInfo(documentResultInfo.getPornInfo().getObjectResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PoliticsInfo", "ObjectResults")) {
                this.parseResultInfo(documentResultInfo.getPoliticsInfo().getObjectResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "TerrorismInfo", "ObjectResults")) {
                this.parseResultInfo(documentResultInfo.getTerroristInfo().getObjectResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "AdsInfo", "ObjectResults")) {
                this.parseResultInfo(documentResultInfo.getAdsInfo().getObjectResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PornInfo", "ObjectResults", "Location")) {
                this.parseResultInfo(documentResultInfo.getPornInfo().getObjectResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PoliticsInfo", "ObjectResults", "Location")) {
                this.parseResultInfo(documentResultInfo.getPoliticsInfo().getObjectResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "TerrorismInfo", "ObjectResults", "Location")) {
                this.parseResultInfo(documentResultInfo.getTerroristInfo().getObjectResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "AdsInfo", "ObjectResults", "Location")) {
                this.parseResultInfo(documentResultInfo.getAdsInfo().getObjectResults(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults") && !(list = this.response.getJobsDetail().getListInfo().getListResults()).isEmpty()) {
                ParserMediaInfoUtils.parsingAuditingListResultInfo(list.get(list.size() - 1), string2, this.getText());
            }
        }

        public DocumentAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(DocumentAuditingResponse documentAuditingResponse) {
            this.response = documentAuditingResponse;
        }

        private void parseInfo(AudtingCommonInfo audtingCommonInfo, String string, String string2) {
            switch (string) {
                case "Code": {
                    audtingCommonInfo.setCode(string2);
                    break;
                }
                case "HitFlag": {
                    audtingCommonInfo.setHitFlag(this.getText());
                    break;
                }
                case "Score": {
                    audtingCommonInfo.setScore(this.getText());
                    break;
                }
                case "Keywords": {
                    audtingCommonInfo.setKeywords(this.getText());
                    break;
                }
                case "Count": {
                    audtingCommonInfo.setCount(this.getText());
                    break;
                }
                case "Label": {
                    audtingCommonInfo.setLabel(this.getText());
                    break;
                }
                case "Category": {
                    audtingCommonInfo.setCategory(this.getText());
                    break;
                }
                case "SubLabel": {
                    audtingCommonInfo.setSubLabel(this.getText());
                    break;
                }
            }
        }

        private void parseResultInfo(List<ObjectResults> list, String string, String string2) {
            if (!list.isEmpty()) {
                ObjectResults objectResults = list.get(list.size() - 1);
                ObjectResults.Location location = objectResults.getLocation();
                switch (string) {
                    case "Name": {
                        objectResults.setName(string2);
                        break;
                    }
                    case "Height": {
                        location.setHeight(string2);
                        break;
                    }
                    case "Rotate": {
                        location.setRotate(string2);
                        break;
                    }
                    case "Width": {
                        location.setWidth(string2);
                        break;
                    }
                    case "X": {
                        location.setX(string2);
                        break;
                    }
                    case "Y": {
                        location.setY(string2);
                        break;
                    }
                }
            }
        }

        private void parseResultInfo(OcrResults ocrResults, String string, String string2) {
            switch (string) {
                case "Text": {
                    ocrResults.setText(string2);
                    break;
                }
                case "Keywords": {
                    ocrResults.setKeywords(this.getText());
                    break;
                }
            }
        }
    }

    public static class DocumentAuditingJobHandler
    extends AbstractHandler {
        private DocumentAuditingResponse response = new DocumentAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response", "JobsDetail")) {
                DocumentAuditingJobsDetail documentAuditingJobsDetail = this.response.getJobsDetail();
                switch (string2) {
                    case "JobId": {
                        documentAuditingJobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        documentAuditingJobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        documentAuditingJobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "DataId": {
                        documentAuditingJobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Url": {
                        documentAuditingJobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "Object": {
                        documentAuditingJobsDetail.setObject(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response") && "RequestId".equalsIgnoreCase(string2)) {
                this.response.setRequestId(this.getText());
            }
        }

        public DocumentAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(DocumentAuditingResponse documentAuditingResponse) {
            this.response = documentAuditingResponse;
        }
    }

    public static class TextAuditingDescribeJobHandler
    extends AbstractHandler {
        private TextAuditingResponse response = new TextAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            AuditingJobsDetail auditingJobsDetail = this.response.getJobsDetail();
            List<SectionInfo> list = auditingJobsDetail.getSectionList();
            if ((this.in("Response", "Detail") || this.in("Response", "JobsDetail")) && "Section".equals(string2)) {
                list.add(new SectionInfo());
            } else if (this.in("Response", "JobsDetail", "Section", "PornInfo") && "LibResults".equals(string2) && !list.isEmpty()) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                List<LibResult> list2 = sectionInfo.getPornInfo().getLibResults();
                list2.add(new LibResult());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            List<SectionInfo> list = this.response.getJobsDetail().getSectionList();
            if (this.in("Response", "Detail") || this.in("Response", "JobsDetail")) {
                AuditingJobsDetail auditingJobsDetail = this.response.getJobsDetail();
                switch (string2) {
                    case "Code": {
                        auditingJobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        auditingJobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "JobId": {
                        auditingJobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        auditingJobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        auditingJobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Object": {
                        auditingJobsDetail.setObject(this.getText());
                        break;
                    }
                    case "SectionCount": {
                        auditingJobsDetail.setSectionCount(this.getText());
                        break;
                    }
                    case "Result": {
                        auditingJobsDetail.setResult(this.getText());
                        break;
                    }
                    case "DataId": {
                        auditingJobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Label": {
                        auditingJobsDetail.setLabel(this.getText());
                        break;
                    }
                    case "SubLabel": {
                        auditingJobsDetail.setSubLabel(this.getText());
                        break;
                    }
                    case "Content": {
                        auditingJobsDetail.setContent(this.getText());
                        break;
                    }
                    case "ForbidState": {
                        auditingJobsDetail.setForbidState(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "Detail", "PornInfo") || this.in("Response", "JobsDetail", "PornInfo")) {
                this.parseInfo(this.response.getJobsDetail().getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "Detail", "PoliticsInfo") || this.in("Response", "JobsDetail", "PoliticsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "Detail", "TerrorismInfo") || this.in("Response", "JobsDetail", "TerrorismInfo")) {
                this.parseInfo(this.response.getJobsDetail().getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "Detail", "AdsInfo") || this.in("Response", "JobsDetail", "AdsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "Detail", "AbuseInfo") || this.in("Response", "JobsDetail", "AbuseInfo")) {
                this.parseInfo(this.response.getJobsDetail().getAbuseInfo(), string2, this.getText());
            } else if (this.in("Response", "Detail", "IllegalInfo") || this.in("Response", "JobsDetail", "IllegalInfo")) {
                this.parseInfo(this.response.getJobsDetail().getIllegalInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults")) {
                List<ListResult> list2 = this.response.getJobsDetail().getListInfo().getListResults();
                if (!list2.isEmpty()) {
                    ParserMediaInfoUtils.parsingAuditingListResultInfo(list2.get(list2.size() - 1), string2, this.getText());
                }
            } else if (this.in("Response", "Detail", "Section") || this.in("Response", "JobsDetail", "Section")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                ParserMediaInfoUtils.parseSectionInfo(sectionInfo, string2, this.getText());
            } else if (this.in("Response", "Detail", "Section", "PornInfo") || this.in("Response", "JobsDetail", "Section", "PornInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "Detail", "Section", "PoliticsInfo") || this.in("Response", "JobsDetail", "Section", "PoliticsInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "Detail", "Section", "TerrorismInfo") || this.in("Response", "JobsDetail", "Section", "TerrorismInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "Detail", "Section", "AdsInfo") || this.in("Response", "JobsDetail", "Section", "AdsInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "Detail", "Section", "AbuseInfo") || this.in("Response", "JobsDetail", "Section", "AbuseInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getAbuseInfo(), string2, this.getText());
            } else if (this.in("Response", "Detail", "Section", "IllegalInfo") || this.in("Response", "JobsDetail", "Section", "IllegalInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getIllegalInfo(), string2, this.getText());
            }
        }

        public TextAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(TextAuditingResponse textAuditingResponse) {
            this.response = textAuditingResponse;
        }

        private void parseInfo(AudtingCommonInfo audtingCommonInfo, String string, String string2) {
            switch (string) {
                case "Code": {
                    audtingCommonInfo.setCode(string2);
                    break;
                }
                case "HitFlag": {
                    audtingCommonInfo.setHitFlag(this.getText());
                    break;
                }
                case "Score": {
                    audtingCommonInfo.setScore(this.getText());
                    break;
                }
                case "Keywords": {
                    audtingCommonInfo.setKeywords(this.getText());
                    break;
                }
                case "Label": {
                    audtingCommonInfo.setLabel(this.getText());
                    break;
                }
                case "Count": {
                    audtingCommonInfo.setCount(this.getText());
                    break;
                }
            }
        }
    }

    public static class TextAuditingJobHandler
    extends AbstractHandler {
        private TextAuditingResponse response = new TextAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            List<SectionInfo> list = this.response.getJobsDetail().getSectionList();
            if ((this.in("Response", "Detail") || this.in("Response", "JobsDetail")) && "Section".equals(string2)) {
                list.add(new SectionInfo());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            List<SectionInfo> list = this.response.getJobsDetail().getSectionList();
            if (this.in("Response", "Detail") || this.in("Response", "JobsDetail")) {
                AuditingJobsDetail auditingJobsDetail = this.response.getJobsDetail();
                switch (string2) {
                    case "Code": {
                        auditingJobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        auditingJobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "JobId": {
                        auditingJobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        auditingJobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        auditingJobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Object": {
                        auditingJobsDetail.setObject(this.getText());
                        break;
                    }
                    case "SectionCount": {
                        auditingJobsDetail.setSectionCount(this.getText());
                        break;
                    }
                    case "Result": {
                        auditingJobsDetail.setResult(this.getText());
                        break;
                    }
                    case "Content": {
                        auditingJobsDetail.setContent(this.getText());
                    }
                    case "DataId": {
                        auditingJobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Url": {
                        auditingJobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "Label": {
                        auditingJobsDetail.setLabel(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "PornInfo")) {
                this.parseInfo(this.response.getJobsDetail().getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerrorismInfo")) {
                this.parseInfo(this.response.getJobsDetail().getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AbuseInfo")) {
                this.parseInfo(this.response.getJobsDetail().getAbuseInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "IllegalInfo")) {
                this.parseInfo(this.response.getJobsDetail().getIllegalInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                ParserMediaInfoUtils.parseSectionInfo(sectionInfo, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "PornInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "PoliticsInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "TerrorismInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "AdsInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "AbuseInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getAbuseInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "IllegalInfo")) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                this.parseInfo(sectionInfo.getIllegalInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), string2, this.getText());
            }
        }

        public TextAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(TextAuditingResponse textAuditingResponse) {
            this.response = textAuditingResponse;
        }

        private void parseInfo(AudtingCommonInfo audtingCommonInfo, String string, String string2) {
            switch (string) {
                case "Code": {
                    audtingCommonInfo.setCode(string2);
                    break;
                }
                case "HitFlag": {
                    audtingCommonInfo.setHitFlag(this.getText());
                    break;
                }
                case "Score": {
                    audtingCommonInfo.setScore(this.getText());
                    break;
                }
                case "Keywords": {
                    audtingCommonInfo.setKeywords(this.getText());
                    break;
                }
                case "Count": {
                    audtingCommonInfo.setCount(this.getText());
                    break;
                }
            }
        }
    }

    public static class ImageLabelV2Handler
    extends AbstractHandler {
        private ImageLabelV2Response response = new ImageLabelV2Response();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("RecognitionResult", "AlbumLabels") && "Label".equalsIgnoreCase(string2)) {
                this.response.getAlbumLabels().add(new LobelV2());
            } else if (this.in("RecognitionResult", "CameraLabels") && "Label".equalsIgnoreCase(string2)) {
                this.response.getCameraLabels().add(new LobelV2());
            } else if (this.in("RecognitionResult", "WebLabels") && "Label".equalsIgnoreCase(string2)) {
                this.response.getWebLabels().add(new LobelV2());
            } else if (this.in("RecognitionResult", "NewsLabels") && "Label".equalsIgnoreCase(string2)) {
                this.response.getNewsLabels().add(new LobelV2());
            } else if (this.in("RecognitionResult", "NoneCamLabels") && "Label".equalsIgnoreCase(string2)) {
                this.response.getNoneCamLabels().add(new LobelV2());
            } else if (this.in("RecognitionResult", "ProductLabels") && "Label".equalsIgnoreCase(string2)) {
                this.response.getProductLabels().add(new LocationLabel());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            LobelV2 lobelV2 = null;
            if (this.in("RecognitionResult", "AlbumLabels", "Label")) {
                List<LobelV2> list = this.response.getAlbumLabels();
                lobelV2 = this.getListLast(list);
            } else if (this.in("RecognitionResult", "CameraLabels", "Label")) {
                List<LobelV2> list = this.response.getCameraLabels();
                lobelV2 = this.getListLast(list);
            } else if (this.in("RecognitionResult", "WebLabels", "Label")) {
                List<LobelV2> list = this.response.getWebLabels();
                lobelV2 = this.getListLast(list);
            } else if (this.in("RecognitionResult", "ProductLabels", "Label")) {
                List<LocationLabel> list = this.response.getProductLabels();
                LocationLabel locationLabel = list.get(list.size() - 1);
                this.addLocationLabel(locationLabel, string2, this.getText());
            } else if (this.in("RecognitionResult", "NewsLabels", "Label")) {
                List<LobelV2> list = this.response.getNewsLabels();
                lobelV2 = this.getListLast(list);
            } else if (this.in("RecognitionResult", "NoneCamLabels", "Label")) {
                List<LobelV2> list = this.response.getNoneCamLabels();
                lobelV2 = this.getListLast(list);
            }
            if (lobelV2 != null) {
                this.addLabel(lobelV2, string2, this.getText());
            }
        }

        public ImageLabelV2Response getResponse() {
            return this.response;
        }

        public void setResponse(ImageLabelV2Response imageLabelV2Response) {
            this.response = imageLabelV2Response;
        }

        private void addLabel(LobelV2 lobelV2, String string, String string2) {
            switch (string) {
                case "Confidence": {
                    lobelV2.setConfidence(string2);
                    break;
                }
                case "Name": {
                    lobelV2.setName(string2);
                    break;
                }
                case "FirstCategory": {
                    lobelV2.setFirstCategory(string2);
                    break;
                }
                case "SecondCategory": {
                    lobelV2.setSecondCategory(string2);
                    break;
                }
            }
        }

        private void addLocationLabel(LocationLabel locationLabel, String string, String string2) {
            switch (string) {
                case "Confidence": {
                    locationLabel.setConfidence(string2);
                    break;
                }
                case "Name": {
                    locationLabel.setName(string2);
                    break;
                }
                case "Parents": {
                    locationLabel.setParents(string2);
                    break;
                }
                case "XMax": {
                    locationLabel.setxMax(string2);
                    break;
                }
                case "XMin": {
                    locationLabel.setxMin(string2);
                    break;
                }
                case "YMax": {
                    locationLabel.setyMax(string2);
                    break;
                }
                case "YMin": {
                    locationLabel.setyMin(string2);
                    break;
                }
            }
        }

        private LobelV2 getListLast(List<LobelV2> list) {
            return list.get(list.size() - 1);
        }
    }

    public static class ImageLabelHandler
    extends AbstractHandler {
        private ImageLabelResponse response = new ImageLabelResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("Labels".equalsIgnoreCase(string2)) {
                this.response.getRecognitionResult().add(new Lobel());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            List<Lobel> list = this.response.getRecognitionResult();
            Lobel lobel = list.get(list.size() - 1);
            if (this.in("RecognitionResult", "Labels")) {
                switch (string2) {
                    case "Confidence": {
                        lobel.setConfidence(this.getText());
                        break;
                    }
                    case "Name": {
                        lobel.setName(this.getText());
                        break;
                    }
                }
            }
        }

        public ImageLabelResponse getResponse() {
            return this.response;
        }

        public void setResponse(ImageLabelResponse imageLabelResponse) {
            this.response = imageLabelResponse;
        }
    }

    public static class CreateAudioAuditingJobHandler
    extends AbstractHandler {
        private AudioAuditingResponse response = new AudioAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response", "JobsDetail")) {
                AuditingJobsDetail auditingJobsDetail = this.response.getJobsDetail();
                switch (string2) {
                    case "JobId": {
                        auditingJobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        auditingJobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        auditingJobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "DataId": {
                        auditingJobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Object": {
                        auditingJobsDetail.setObject(this.getText());
                    }
                    case "Url": {
                        auditingJobsDetail.setUrl(this.getText());
                        break;
                    }
                }
            }
        }

        public AudioAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(AudioAuditingResponse audioAuditingResponse) {
            this.response = audioAuditingResponse;
        }
    }

    public static class DescribeAudioAuditingJobHandler
    extends AbstractHandler {
        private AudioAuditingResponse response = new AudioAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            List<SectionInfo> list = this.response.getJobsDetail().getSectionList();
            if (this.in("Response", "JobsDetail") && "Section".equals(string2)) {
                list.add(new SectionInfo());
            } else if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(string2)) {
                this.response.getJobsDetail().getListInfo().getListResults().add(new ListResult());
            } else if (this.in("Response", "JobsDetail", "Section") && "LanguageResults".equals(string2) && !list.isEmpty()) {
                SectionInfo sectionInfo = list.get(list.size() - 1);
                List<LanguageResult> list2 = sectionInfo.getLanguageResult();
                list2.add(new LanguageResult());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            List<SectionInfo> list;
            SectionInfo sectionInfo;
            List<LanguageResult> list2;
            if (this.in("Response", "JobsDetail")) {
                AuditingJobsDetail auditingJobsDetail = this.response.getJobsDetail();
                switch (string2) {
                    case "Code": {
                        auditingJobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        auditingJobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "JobId": {
                        auditingJobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        auditingJobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        auditingJobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Object": {
                        auditingJobsDetail.setObject(this.getText());
                        break;
                    }
                    case "Url": {
                        auditingJobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "Result": {
                        auditingJobsDetail.setResult(this.getText());
                        break;
                    }
                    case "AudioText": {
                        auditingJobsDetail.setAudioText(this.getText());
                        break;
                    }
                    case "DataId": {
                        auditingJobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Label": {
                        auditingJobsDetail.setLabel(this.getText());
                        break;
                    }
                    case "SubLabel": {
                        auditingJobsDetail.setSubLabel(this.getText());
                        break;
                    }
                    case "ForbidState": {
                        auditingJobsDetail.setForbidState(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "PornInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerrorismInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TeenagerInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getTeenagerInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "PornInfo")) {
                List<SectionInfo> list3 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo2 = list3.get(list3.size() - 1);
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(sectionInfo2.getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "PoliticsInfo")) {
                List<SectionInfo> list4 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo3 = list4.get(list4.size() - 1);
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(sectionInfo3.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "TerrorismInfo")) {
                List<SectionInfo> list5 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo4 = list5.get(list5.size() - 1);
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(sectionInfo4.getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "AdsInfo")) {
                List<SectionInfo> list6 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo5 = list6.get(list6.size() - 1);
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(sectionInfo5.getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "TeenagerInfo")) {
                List<SectionInfo> list7 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo6 = list7.get(list7.size() - 1);
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(sectionInfo6.getTeenagerInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section")) {
                List<SectionInfo> list8 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo7 = list8.get(list8.size() - 1);
                ParserMediaInfoUtils.parseSectionInfo(sectionInfo7, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults")) {
                List<ListResult> list9 = this.response.getJobsDetail().getListInfo().getListResults();
                if (!list9.isEmpty()) {
                    ParserMediaInfoUtils.parsingAuditingListResultInfo(list9.get(list9.size() - 1), string2, this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Section", "LanguageResults") && !(list2 = (sectionInfo = (list = this.response.getJobsDetail().getSectionList()).get(list.size() - 1)).getLanguageResult()).isEmpty()) {
                LanguageResult languageResult = list2.get(list2.size() - 1);
                ParserMediaInfoUtils.parseLanguageResult(languageResult, string2, this.getText());
            }
        }

        public AudioAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(AudioAuditingResponse audioAuditingResponse) {
            this.response = audioAuditingResponse;
        }
    }

    public static class CreateVideoAuditingJobHandler
    extends AbstractHandler {
        private VideoAuditingResponse response = new VideoAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response", "JobsDetail")) {
                AuditingJobsDetail auditingJobsDetail = this.response.getJobsDetail();
                switch (string2) {
                    case "JobId": {
                        auditingJobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        auditingJobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        auditingJobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "DataId": {
                        auditingJobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Object": {
                        auditingJobsDetail.setObject(this.getText());
                    }
                    case "Url": {
                        auditingJobsDetail.setUrl(this.getText());
                        break;
                    }
                }
            }
        }

        public VideoAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(VideoAuditingResponse videoAuditingResponse) {
            this.response = videoAuditingResponse;
        }
    }

    public static class DescribeVideoAuditingJobHandler
    extends AbstractHandler {
        private VideoAuditingResponse response = new VideoAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            List<SnapshotInfo> list = this.response.getJobsDetail().getSnapshotList();
            List<AudioSectionInfo> list2 = this.response.getJobsDetail().getAudioSectionList();
            if (this.in("Response", "JobsDetail") && "Snapshot".equals(string2)) {
                list.add(new SnapshotInfo());
            }
            if (this.in("Response", "JobsDetail") && "AudioSection".equals(string2)) {
                list2.add(new AudioSectionInfo());
            } else if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(string2)) {
                this.response.getJobsDetail().getListInfo().getListResults().add(new ListResult());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            List<ListResult> list;
            List<SnapshotInfo> list2 = this.response.getJobsDetail().getSnapshotList();
            List<AudioSectionInfo> list3 = this.response.getJobsDetail().getAudioSectionList();
            SnapshotInfo snapshotInfo = new SnapshotInfo();
            AudioSectionInfo audioSectionInfo = new AudioSectionInfo();
            if (list2 == null || !list2.isEmpty()) {
                snapshotInfo = list2.get(list2.size() - 1);
            }
            if (list3 == null || !list3.isEmpty()) {
                audioSectionInfo = list3.get(list3.size() - 1);
            }
            if (this.in("Response", "JobsDetail")) {
                AuditingJobsDetail auditingJobsDetail = this.response.getJobsDetail();
                switch (string2) {
                    case "Code": {
                        auditingJobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        auditingJobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "JobId": {
                        auditingJobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        auditingJobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        auditingJobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Object": {
                        auditingJobsDetail.setObject(this.getText());
                        break;
                    }
                    case "SnapshotCount": {
                        auditingJobsDetail.setSnapshotCount(this.getText());
                        break;
                    }
                    case "Result": {
                        auditingJobsDetail.setResult(this.getText());
                        break;
                    }
                    case "Url": {
                        auditingJobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "DataId": {
                        auditingJobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Label": {
                        auditingJobsDetail.setLabel(this.getText());
                        break;
                    }
                    case "ForbidState": {
                        auditingJobsDetail.setForbidState(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "PornInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerrorismInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "TeenagerInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getTeenagerInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot")) {
                if ("Url".equals(string2)) {
                    snapshotInfo.setUrl(URLDecoder.decode(this.getText()));
                }
            } else if (this.in("Response", "JobsDetail", "Snapshot", "PornInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(snapshotInfo.getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot", "PoliticsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(snapshotInfo.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot", "TerrorismInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(snapshotInfo.getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot", "AdsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(snapshotInfo.getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot", "TeenagerInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(snapshotInfo.getTeenagerInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AudioSection", "TerrorismInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(audioSectionInfo.getTerroristInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AudioSection", "PornInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(audioSectionInfo.getPornInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AudioSection", "PoliticsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(audioSectionInfo.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AudioSection", "AdsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(audioSectionInfo.getAdsInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot")) {
                ParserMediaInfoUtils.parseSnapshotInfo(snapshotInfo, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "AudioSection")) {
                ParserMediaInfoUtils.parseAudioSection(audioSectionInfo, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults") && !(list = this.response.getJobsDetail().getListInfo().getListResults()).isEmpty()) {
                ParserMediaInfoUtils.parsingAuditingListResultInfo(list.get(list.size() - 1), string2, this.getText());
            }
        }

        public VideoAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(VideoAuditingResponse videoAuditingResponse) {
            this.response = videoAuditingResponse;
        }
    }

    public static class ImageAuditingHandler
    extends AbstractHandler {
        private ImageAuditingResponse response = new ImageAuditingResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("RecognitionResult")) {
                switch (string2) {
                    case "JobId": {
                        this.response.setJobId(this.getText());
                        break;
                    }
                    case "CompressionResult": {
                        this.response.setCompressionResult(this.getText());
                        break;
                    }
                    case "Result": {
                        this.response.setResult(this.getText());
                        break;
                    }
                    case "Label": {
                        this.response.setLabel(this.getText());
                        break;
                    }
                    case "Category": {
                        this.response.setCategory(this.getText());
                        break;
                    }
                    case "SubLabel": {
                        this.response.setSubLabel(this.getText());
                        break;
                    }
                    case "Score": {
                        this.response.setScore(this.getText());
                        break;
                    }
                    case "Text": {
                        this.response.setText(this.getText());
                        break;
                    }
                    case "DataId": {
                        this.response.setDataId(this.getText());
                        break;
                    }
                    case "Object": {
                        this.response.setObject(this.getText());
                        break;
                    }
                    case "State": {
                        this.response.setState(this.getText());
                        break;
                    }
                    case "forbidState": {
                        this.response.setForbidState(this.getText());
                        break;
                    }
                }
            } else if (this.in("RecognitionResult", "PornInfo")) {
                this.parseInfo(this.response.getPornInfo(), string2, this.getText());
            } else if (this.in("RecognitionResult", "PoliticsInfo")) {
                this.parseInfo(this.response.getPoliticsInfo(), string2, this.getText());
            } else if (this.in("RecognitionResult", "TerroristInfo") || this.in("RecognitionResult", "TerrorismInfo")) {
                this.parseInfo(this.response.getTerroristInfo(), string2, this.getText());
            } else if (this.in("RecognitionResult", "AdsInfo")) {
                this.parseInfo(this.response.getAdsInfo(), string2, this.getText());
            } else if (this.in("RecognitionResult", "TeenagerInfo")) {
                this.parseInfo(this.response.getTeenagerInfo(), string2, this.getText());
            } else if (this.in("RecognitionResult", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getUserInfo(), string2, this.getText());
            } else if (this.in("RecognitionResult", "PornInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getPornInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("RecognitionResult", "PoliticsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getPoliticsInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("RecognitionResult", "TerroristInfo", "OcrResults") || this.in("RecognitionResult", "TerrorismInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getTerroristInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("RecognitionResult", "AdsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getAdsInfo().getOcrResults(), string2, this.getText());
            } else if (this.in("RecognitionResult", "TeenagerInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getTeenagerInfo().getOcrResults(), string2, this.getText());
            }
        }

        private void parseInfo(AudtingCommonInfo audtingCommonInfo, String string, String string2) {
            switch (string) {
                case "Code": {
                    audtingCommonInfo.setCode(string2);
                    break;
                }
                case "Msg": {
                    audtingCommonInfo.setMsg(this.getText());
                    break;
                }
                case "HitFlag": {
                    audtingCommonInfo.setHitFlag(this.getText());
                    break;
                }
                case "Score": {
                    audtingCommonInfo.setScore(this.getText());
                    break;
                }
                case "Label": {
                    audtingCommonInfo.setLabel(this.getText());
                    break;
                }
            }
        }

        public ImageAuditingResponse getResponse() {
            return this.response;
        }
    }

    public static class ListDocBucketHandler
    extends AbstractHandler {
        private DocBucketResponse response = new DocBucketResponse();
        boolean isNew = true;
        DocBucketObject bucketObject;

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("DocBucketList".equals(string2)) {
                this.isNew = true;
            }
            if (this.isNew) {
                this.bucketObject = new DocBucketObject();
                this.isNew = false;
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response")) {
                switch (string2) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                    case "TotalCount": {
                        this.response.setTotalCount(this.getText());
                        break;
                    }
                    case "PageNumber": {
                        this.response.setPageNumber(this.getText());
                        break;
                    }
                    case "PageSize": {
                        this.response.setPageSize(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "DocBucketList")) {
                switch (string2) {
                    case "BucketId": {
                        this.bucketObject.setBucketId(this.getText());
                        break;
                    }
                    case "Region": {
                        this.bucketObject.setRegion(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.bucketObject.setCreateTime(this.getText());
                        break;
                    }
                    case "AliasBucketId": {
                        this.bucketObject.setAliasBucketId(this.getText());
                        break;
                    }
                    case "Name": {
                        this.bucketObject.setName(this.getText());
                        break;
                    }
                }
            }
            if ("DocBucketList".equals(string2) && !this.isNew) {
                this.response.getDocBucketObjectList().add(this.bucketObject);
                this.bucketObject = null;
            }
        }

        public DocBucketResponse getResponse() {
            return this.response;
        }
    }

    public static class DescribeDocProcessJobsHandler
    extends AbstractHandler {
        DocJobListResponse response = new DocJobListResponse();
        DocJobDetail jobsDetail;
        DocProcessPageInfo pageInfo;

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("PageInfo".equalsIgnoreCase(string2)) {
                this.pageInfo = new DocProcessPageInfo();
            } else if ("JobsDetail".equalsIgnoreCase(string2)) {
                this.jobsDetail = new DocJobDetail();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            Object object;
            if (this.in("Response", "NextToken")) {
                this.response.setNextToken(this.getText());
            } else if (this.in("Response", "JobsDetail")) {
                switch (string2) {
                    case "Code": {
                        this.jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        this.jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        this.jobsDetail.setEndTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        this.jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "Message": {
                        this.jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "QueueId": {
                        this.jobsDetail.setQueueId(this.getText());
                        break;
                    }
                    case "State": {
                        this.jobsDetail.setState(this.getText());
                        break;
                    }
                    case "Tag": {
                        this.jobsDetail.setTag(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Input")) {
                if ("Object".equalsIgnoreCase(string2)) {
                    this.jobsDetail.getInput().setObject(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcess")) {
                object = this.jobsDetail.getOperation().getDocProcessObject();
                switch (string2) {
                    case "Comments": {
                        ((DocProcessObject)object).setComments(this.getText());
                        break;
                    }
                    case "DocPassword": {
                        ((DocProcessObject)object).setDocPassword(this.getText());
                        break;
                    }
                    case "EndPage": {
                        ((DocProcessObject)object).setEndPage(this.getText());
                        break;
                    }
                    case "ImageParams": {
                        ((DocProcessObject)object).setImageParams(this.getText());
                        break;
                    }
                    case "PaperDirection": {
                        ((DocProcessObject)object).setPaperDirection(this.getText());
                        break;
                    }
                    case "Quality": {
                        ((DocProcessObject)object).setQuality(this.getText());
                        break;
                    }
                    case "SrcType": {
                        ((DocProcessObject)object).setSrcType(this.getText());
                        break;
                    }
                    case "StartPage": {
                        ((DocProcessObject)object).setStartPage(this.getText());
                        break;
                    }
                    case "TgtType": {
                        ((DocProcessObject)object).setTgtType(this.getText());
                        break;
                    }
                    case "Zoom": {
                        ((DocProcessObject)object).setZoom(this.getText());
                        break;
                    }
                    case "SheetId": {
                        ((DocProcessObject)object).setSheetId(this.getText());
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcessResult")) {
                object = this.jobsDetail.getOperation().getDocProcessResult();
                switch (string2) {
                    case "FailPageCount": {
                        ((DocProcessResult)object).setFailPageCount(this.getText());
                        break;
                    }
                    case "SuccPageCount": {
                        ((DocProcessResult)object).setSuccPageCount(this.getText());
                        break;
                    }
                    case "TgtType": {
                        ((DocProcessResult)object).setTgtType(this.getText());
                        break;
                    }
                    case "TotalPageCount": {
                        ((DocProcessResult)object).setTotalPageCount(this.getText());
                        break;
                    }
                    case "TotalSheetCount": {
                        ((DocProcessResult)object).setTotalSheetCount(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
                object = this.jobsDetail.getOperation().getOutput();
                switch (string2) {
                    case "Bucket": {
                        ((MediaOutputObject)object).setBucket(this.getText());
                        break;
                    }
                    case "Object": {
                        ((MediaOutputObject)object).setObject(this.getText());
                        break;
                    }
                    case "Region": {
                        ((MediaOutputObject)object).setRegion(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcessResult", "PageInfo")) {
                switch (string2) {
                    case "PageNo": {
                        this.pageInfo.setPageNo(this.getText());
                        break;
                    }
                    case "PicIndex": {
                        this.pageInfo.setPicIndex(this.getText());
                        break;
                    }
                    case "PicNum": {
                        this.pageInfo.setPicNum(this.getText());
                        break;
                    }
                    case "TgtUri": {
                        this.pageInfo.setTgtUri(this.getText());
                        break;
                    }
                    case "X-SheetPics": {
                        this.pageInfo.setxSheetPics(this.getText());
                        break;
                    }
                }
            }
            if ("PageInfo".equalsIgnoreCase(string2)) {
                object = this.jobsDetail.getOperation().getDocProcessResult().getDocProcessPageInfoList();
                object.add(this.pageInfo);
            } else if ("JobsDetail".equalsIgnoreCase(string2)) {
                this.response.getDocJobDetailList().add(this.jobsDetail);
            }
        }

        public DocJobListResponse getResponse() {
            return this.response;
        }
    }

    public static class DescribeDocProcessJobHandler
    extends AbstractHandler {
        DocJobResponse response = new DocJobResponse();
        DocProcessPageInfo pageInfo = new DocProcessPageInfo();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("PageInfo".equalsIgnoreCase(string2)) {
                this.pageInfo = new DocProcessPageInfo();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            Object object;
            if (this.in("Response")) {
                if (string2.equals("NonExistJobIds")) {
                    this.response.setNonExistJobIds(this.getText());
                }
            } else if (this.in("Response", "JobsDetail")) {
                object = this.response.getJobsDetail();
                switch (string2) {
                    case "Code": {
                        ((DocJobDetail)object).setCode(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        ((DocJobDetail)object).setCreationTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        ((DocJobDetail)object).setEndTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        ((DocJobDetail)object).setJobId(this.getText());
                        break;
                    }
                    case "Message": {
                        ((DocJobDetail)object).setMessage(this.getText());
                        break;
                    }
                    case "QueueId": {
                        ((DocJobDetail)object).setQueueId(this.getText());
                        break;
                    }
                    case "State": {
                        ((DocJobDetail)object).setState(this.getText());
                        break;
                    }
                    case "Tag": {
                        ((DocJobDetail)object).setTag(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Input")) {
                if ("Object".equalsIgnoreCase(string2)) {
                    this.response.getJobsDetail().getInput().setObject(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcess")) {
                object = this.response.getJobsDetail().getOperation().getDocProcessObject();
                switch (string2) {
                    case "Comments": {
                        ((DocProcessObject)object).setComments(this.getText());
                        break;
                    }
                    case "DocPassword": {
                        ((DocProcessObject)object).setDocPassword(this.getText());
                        break;
                    }
                    case "EndPage": {
                        ((DocProcessObject)object).setEndPage(this.getText());
                        break;
                    }
                    case "ImageParams": {
                        ((DocProcessObject)object).setImageParams(this.getText());
                        break;
                    }
                    case "PaperDirection": {
                        ((DocProcessObject)object).setPaperDirection(this.getText());
                        break;
                    }
                    case "Quality": {
                        ((DocProcessObject)object).setQuality(this.getText());
                        break;
                    }
                    case "SrcType": {
                        ((DocProcessObject)object).setSrcType(this.getText());
                        break;
                    }
                    case "StartPage": {
                        ((DocProcessObject)object).setStartPage(this.getText());
                        break;
                    }
                    case "TgtType": {
                        ((DocProcessObject)object).setTgtType(this.getText());
                        break;
                    }
                    case "Zoom": {
                        ((DocProcessObject)object).setZoom(this.getText());
                        break;
                    }
                    case "SheetId": {
                        ((DocProcessObject)object).setSheetId(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcessResult")) {
                object = this.response.getJobsDetail().getOperation().getDocProcessResult();
                switch (string2) {
                    case "FailPageCount": {
                        ((DocProcessResult)object).setFailPageCount(this.getText());
                        break;
                    }
                    case "SuccPageCount": {
                        ((DocProcessResult)object).setSuccPageCount(this.getText());
                        break;
                    }
                    case "TgtType": {
                        ((DocProcessResult)object).setTgtType(this.getText());
                        break;
                    }
                    case "TotalPageCount": {
                        ((DocProcessResult)object).setTotalPageCount(this.getText());
                        break;
                    }
                    case "TotalSheetCount": {
                        ((DocProcessResult)object).setTotalSheetCount(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
                object = this.response.getJobsDetail().getOperation().getOutput();
                switch (string2) {
                    case "Bucket": {
                        ((MediaOutputObject)object).setBucket(this.getText());
                        break;
                    }
                    case "Object": {
                        ((MediaOutputObject)object).setObject(this.getText());
                        break;
                    }
                    case "Region": {
                        ((MediaOutputObject)object).setRegion(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcessResult", "PageInfo")) {
                switch (string2) {
                    case "PageNo": {
                        this.pageInfo.setPageNo(this.getText());
                        break;
                    }
                    case "PicIndex": {
                        this.pageInfo.setPicIndex(this.getText());
                        break;
                    }
                    case "PicNum": {
                        this.pageInfo.setPicNum(this.getText());
                        break;
                    }
                    case "TgtUri": {
                        this.pageInfo.setTgtUri(this.getText());
                        break;
                    }
                    case "X-SheetPics": {
                        this.pageInfo.setxSheetPics(this.getText());
                        break;
                    }
                }
            }
            if ("PageInfo".equalsIgnoreCase(string2)) {
                object = this.response.getJobsDetail().getOperation().getDocProcessResult().getDocProcessPageInfoList();
                object.add((DocProcessPageInfo)this.pageInfo);
            }
        }

        public DocJobResponse getResponse() {
            return this.response;
        }
    }

    public static class DocJobHandler
    extends AbstractHandler {
        DocJobResponse response = new DocJobResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response", "JobsDetail")) {
                DocJobDetail docJobDetail = this.response.getJobsDetail();
                switch (string2) {
                    case "Code": {
                        docJobDetail.setCode(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        docJobDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        docJobDetail.setEndTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        docJobDetail.setJobId(this.getText());
                        break;
                    }
                    case "Message": {
                        docJobDetail.setMessage(this.getText());
                        break;
                    }
                    case "QueueId": {
                        docJobDetail.setQueueId(this.getText());
                        break;
                    }
                    case "State": {
                        docJobDetail.setState(this.getText());
                        break;
                    }
                    case "Tag": {
                        docJobDetail.setTag(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Input")) {
                if ("Object".equalsIgnoreCase(string2)) {
                    this.response.getJobsDetail().getInput().setObject(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
                MediaOutputObject mediaOutputObject = this.response.getJobsDetail().getOperation().getOutput();
                switch (string2) {
                    case "Bucket": {
                        mediaOutputObject.setBucket(this.getText());
                        break;
                    }
                    case "Object": {
                        mediaOutputObject.setObject(this.getText());
                        break;
                    }
                    case "Region": {
                        mediaOutputObject.setRegion(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcess")) {
                DocProcessObject docProcessObject = this.response.getJobsDetail().getOperation().getDocProcessObject();
                switch (string2) {
                    case "Comments": {
                        docProcessObject.setComments(this.getText());
                        break;
                    }
                    case "DocPassword": {
                        docProcessObject.setDocPassword(this.getText());
                        break;
                    }
                    case "EndPage": {
                        docProcessObject.setEndPage(this.getText());
                        break;
                    }
                    case "ImageParams": {
                        docProcessObject.setImageParams(this.getText());
                        break;
                    }
                    case "PaperDirection": {
                        docProcessObject.setPaperDirection(this.getText());
                        break;
                    }
                    case "Quality": {
                        docProcessObject.setQuality(this.getText());
                        break;
                    }
                    case "SrcType": {
                        docProcessObject.setSrcType(this.getText());
                        break;
                    }
                    case "StartPage": {
                        docProcessObject.setStartPage(this.getText());
                        break;
                    }
                    case "TgtType": {
                        docProcessObject.setTgtType(this.getText());
                        break;
                    }
                    case "Zoom": {
                        docProcessObject.setZoom(this.getText());
                        break;
                    }
                    case "SheetId": {
                        docProcessObject.setSheetId(this.getText());
                        break;
                    }
                }
            }
        }

        public DocJobResponse getResponse() {
            return this.response;
        }
    }

    public static class WorkflowExecutionsHandler
    extends AbstractHandler {
        MediaWorkflowExecutionsResponse response = new MediaWorkflowExecutionsResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("WorkflowExecutionList".equalsIgnoreCase(string2)) {
                List<MediaWorkflowExecutionObject> list = this.response.getWorkflowExecutionList();
                list.add(new MediaWorkflowExecutionObject());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(string2)) {
                    this.response.setRequestId(this.getText());
                } else if ("NextToken".equalsIgnoreCase(string2)) {
                    this.response.setNextToken(this.getText());
                }
            } else if (this.in("Response", "WorkflowExecutionList")) {
                List<MediaWorkflowExecutionObject> list = this.response.getWorkflowExecutionList();
                MediaWorkflowExecutionObject mediaWorkflowExecutionObject = list.size() != 0 ? list.get(list.size() - 1) : new MediaWorkflowExecutionObject();
                switch (string2) {
                    case "RunId": {
                        mediaWorkflowExecutionObject.setRunId(this.getText());
                        break;
                    }
                    case "WorkflowId": {
                        mediaWorkflowExecutionObject.setWorkflowId(this.getText());
                        break;
                    }
                    case "Object": {
                        mediaWorkflowExecutionObject.setObject(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        mediaWorkflowExecutionObject.setCreateTime(this.getText());
                        break;
                    }
                    case "State": {
                        mediaWorkflowExecutionObject.setState(this.getText());
                    }
                }
            }
        }

        public MediaWorkflowExecutionsResponse getResponse() {
            return this.response;
        }
    }

    public static class GenerateMediainfoHandler
    extends AbstractHandler {
        MediaInfoResponse response = new MediaInfoResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            List<Object> list;
            if (this.in("Response", "MediaInfo", "Stream") && "Video".equalsIgnoreCase(string2)) {
                list = this.response.getMediaInfo().getStream().getMediaInfoVideoList();
                list.add(new MediaInfoVideo());
            }
            if (this.in("Response", "MediaInfo", "Stream") && "Audio".equalsIgnoreCase(string2)) {
                list = this.response.getMediaInfo().getStream().getMediaInfoAudioList();
                list.add((MediaInfoVideo)((Object)new MediaInfoAudio()));
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            List<MediaInfoVideo> list;
            MediaInfoStream mediaInfoStream = this.response.getMediaInfo().getStream();
            if (this.in("Response", "MediaInfo", "Format")) {
                MediaFormat mediaFormat = this.response.getMediaInfo().getFormat();
                ParserMediaInfoUtils.ParsingMediaFormat(mediaFormat, string2, this.getText());
            } else if (this.in("Response", "MediaInfo", "Stream", "Audio")) {
                List<MediaInfoAudio> list2 = mediaInfoStream.getMediaInfoAudioList();
                if (!list2.isEmpty()) {
                    MediaInfoAudio mediaInfoAudio = mediaInfoStream.getMediaInfoAudioList().get(list2.size() - 1);
                    ParserMediaInfoUtils.ParsingStreamAudio(mediaInfoAudio, string2, this.getText());
                }
            } else if (this.in("Response", "MediaInfo", "Stream", "Subtitle")) {
                MediaInfoSubtitle mediaInfoSubtitle = mediaInfoStream.getSubtitle();
                ParserMediaInfoUtils.ParsingSubtitle(mediaInfoSubtitle, string2, this.getText());
            } else if (this.in("Response", "MediaInfo", "Stream", "Video") && !(list = mediaInfoStream.getMediaInfoVideoList()).isEmpty()) {
                MediaInfoVideo mediaInfoVideo = mediaInfoStream.getMediaInfoVideoList().get(list.size() - 1);
                ParserMediaInfoUtils.ParsingMediaVideo(mediaInfoVideo, string2, this.getText());
            }
        }

        public MediaInfoResponse getResponse() {
            return this.response;
        }
    }

    public static class MediaTemplatesHandler
    extends AbstractHandler {
        MediaListTemplateResponse response = new MediaListTemplateResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            List<MediaTemplateObject> list;
            if ("TemplateList".equalsIgnoreCase(string2)) {
                List<MediaTemplateObject> list2 = this.response.getTemplateList();
                list2.add(new MediaTemplateObject());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate") && "ConcatFragment".equalsIgnoreCase(string2) && (list = this.response.getTemplateList()) != null && !list.isEmpty()) {
                MediaTemplateObject mediaTemplateObject = list.get(list.size() - 1);
                List<MediaConcatFragmentObject> list3 = mediaTemplateObject.getConcatTemplate().getConcatFragmentList();
                list3.add(new MediaConcatFragmentObject());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            List<MediaTemplateObject> list;
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(string2)) {
                    this.response.setRequestId(this.getText());
                }
                if ("TotalCount".equalsIgnoreCase(string2)) {
                    this.response.setTotalCount(this.getText());
                }
                if ("PageNumber".equalsIgnoreCase(string2)) {
                    this.response.setPageNumber(this.getText());
                }
                if ("PageSize".equalsIgnoreCase(string2)) {
                    this.response.setPageSize(this.getText());
                }
            }
            MediaTemplateObject mediaTemplateObject = (list = this.response.getTemplateList()).size() != 0 ? list.get(list.size() - 1) : new MediaTemplateObject();
            if (this.in("Response", "TemplateList")) {
                switch (string2) {
                    case "TemplateId": {
                        mediaTemplateObject.setTemplateId(this.getText());
                        break;
                    }
                    case "Name": {
                        mediaTemplateObject.setName(this.getText());
                        break;
                    }
                    case "Tag": {
                        mediaTemplateObject.setTag(this.getText());
                        break;
                    }
                    case "State": {
                        mediaTemplateObject.setState(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        mediaTemplateObject.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        mediaTemplateObject.setUpdateTime(this.getText());
                        break;
                    }
                    case "BucketId": {
                        mediaTemplateObject.setBucketId(this.getText());
                        break;
                    }
                    case "Category": {
                        mediaTemplateObject.setCategory(this.getText());
                    }
                }
            }
            Object object = mediaTemplateObject.getTransTpl();
            if (this.in("Response", "TemplateList", "TransTpl", "Container")) {
                MediaContainerObject mediaContainerObject = ((MediaTemplateTransTplObject)object).getContainer();
                if ("Format".equalsIgnoreCase(string2)) {
                    mediaContainerObject.setFormat(this.getText());
                }
            } else if (this.in("Response", "TemplateList", "TransTpl", "Video")) {
                MediaVideoObject mediaVideoObject = ((MediaTemplateTransTplObject)object).getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo(mediaVideoObject, string2, this.getText());
            } else if (this.in("Response", "TemplateList", "TransTpl", "TimeInterval")) {
                MediaTimeIntervalObject mediaTimeIntervalObject = ((MediaTemplateTransTplObject)object).getTimeInterval();
                ParserMediaInfoUtils.ParsingMediaTimeInterval(mediaTimeIntervalObject, string2, this.getText());
            } else if (this.in("Response", "TemplateList", "TransTpl", "Audio")) {
                MediaAudioObject mediaAudioObject = ((MediaTemplateTransTplObject)object).getAudio();
                ParserMediaInfoUtils.ParsingMediaAudio(mediaAudioObject, string2, this.getText());
            } else if (this.in("Response", "TemplateList", "TransTpl", "TransConfig")) {
                MediaTransConfigObject mediaTransConfigObject = ((MediaTemplateTransTplObject)object).getTransConfig();
                ParserMediaInfoUtils.ParsingTransConfig(mediaTransConfigObject, string2, this.getText());
            } else if (this.in("Response", "TemplateList", "Snapshot")) {
                MediaSnapshotObject mediaSnapshotObject = mediaTemplateObject.getSnapshot();
                ParserMediaInfoUtils.ParsingSnapshot(mediaSnapshotObject, string2, this.getText());
            } else if (this.in("Response", "TemplateList", "Watermark")) {
                MediaWatermark mediaWatermark = mediaTemplateObject.getWatermark();
                ParserMediaInfoUtils.ParsingWatermark(mediaWatermark, string2, this.getText());
            } else if (this.in("Response", "TemplateList", "Watermark", "Text")) {
                MediaWaterMarkText mediaWaterMarkText = mediaTemplateObject.getWatermark().getText();
                ParserMediaInfoUtils.ParsingWatermarkText(mediaWaterMarkText, string2, this.getText());
            } else if (this.in("Response", "TemplateList", "Watermark", "Image")) {
                MediaWaterMarkImage mediaWaterMarkImage = mediaTemplateObject.getWatermark().getImage();
                ParserMediaInfoUtils.ParsingWatermarkImage(mediaWaterMarkImage, string2, this.getText());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "ConcatFragment")) {
                ParserMediaInfoUtils.ParseConcatFragment(this.getConcatFragment(mediaTemplateObject), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "Audio")) {
                ParserMediaInfoUtils.ParsingMediaAudio(mediaTemplateObject.getConcatTemplate().getAudio(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "Video")) {
                ParserMediaInfoUtils.ParsingMediaVideo(mediaTemplateObject.getConcatTemplate().getVideo(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "Container")) {
                if (string2.equalsIgnoreCase("Format")) {
                    mediaTemplateObject.getConcatTemplate().getContainer().setFormat(this.getText());
                }
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "AudioMix")) {
                ParserMediaInfoUtils.ParseAudioMix(mediaTemplateObject.getConcatTemplate().getAudioMix(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "VideoTargetRec")) {
                ParserMediaInfoUtils.ParsingVideoTargetRec(mediaTemplateObject.getVideoTargetRec(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "TtsTpl")) {
                ParserMediaInfoUtils.ParseTtsTpl(mediaTemplateObject.getTtsTpl(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "Transcode", "Container")) {
                ParserMediaInfoUtils.ParseContainer(mediaTemplateObject.getVideoEnhance().getTrascode().getContainer(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "Transcode", "Video")) {
                ParserMediaInfoUtils.ParsingMediaVideo(mediaTemplateObject.getVideoEnhance().getTrascode().getVideo(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "Transcode", "Audio")) {
                ParserMediaInfoUtils.ParsingMediaAudio(mediaTemplateObject.getVideoEnhance().getTrascode().getAudio(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "SuperResolution")) {
                ParserMediaInfoUtils.ParsingSuperResolution(mediaTemplateObject.getVideoEnhance().getSuperResolution(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "ColorEnhance")) {
                ParserMediaInfoUtils.ParsingColorEnhance(mediaTemplateObject.getVideoEnhance().getColorEnhance(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "MsSharpen")) {
                ParserMediaInfoUtils.ParsingMsSharpen(mediaTemplateObject.getVideoEnhance().getMsSharpen(), string2, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "SDRtoHDR")) {
                ParserMediaInfoUtils.ParsingSDRtoHDR(mediaTemplateObject.getVideoEnhance().getSdrToHDR(), string2, this.getText());
            }
        }

        public MediaConcatFragmentObject getConcatFragment(MediaTemplateObject mediaTemplateObject) {
            List<MediaConcatFragmentObject> list = mediaTemplateObject.getConcatTemplate().getConcatFragmentList();
            if (list != null && !list.isEmpty()) {
                return list.get(list.size() - 1);
            }
            return new MediaConcatFragmentObject();
        }

        public MediaListTemplateResponse getResponse() {
            return this.response;
        }
    }

    public static class SnapshotHandler
    extends AbstractHandler {
        SnapshotResponse response = new SnapshotResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response", "Output")) {
                MediaOutputObject mediaOutputObject = this.response.getOutput();
                if ("Bucket".equalsIgnoreCase(string2)) {
                    mediaOutputObject.setBucket(this.getText());
                } else if ("Object".equalsIgnoreCase(string2)) {
                    mediaOutputObject.setObject(this.getText());
                } else if ("Region".equalsIgnoreCase(string2)) {
                    mediaOutputObject.setRegion(this.getText());
                }
            }
        }

        public SnapshotResponse getResponse() {
            return this.response;
        }
    }

    public static class MediaTemplateHandler
    extends AbstractHandler {
        MediaTemplateResponse response = new MediaTemplateResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            Object object;
            Object object2;
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(string2)) {
                    this.response.setRequestId(this.getText());
                }
            } else if (this.in("Response", "Template")) {
                object2 = this.response.getTemplate();
                switch (string2) {
                    case "TemplateId": {
                        ((MediaTemplateObject)object2).setTemplateId(this.getText());
                        break;
                    }
                    case "Name": {
                        ((MediaTemplateObject)object2).setName(this.getText());
                        break;
                    }
                    case "Tag": {
                        ((MediaTemplateObject)object2).setTag(this.getText());
                        break;
                    }
                    case "State": {
                        ((MediaTemplateObject)object2).setState(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        ((MediaCommonResponse)object2).setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        ((MediaCommonResponse)object2).setUpdateTime(this.getText());
                        break;
                    }
                    case "BucketId": {
                        ((MediaTemplateObject)object2).setBucketId(this.getText());
                        break;
                    }
                    case "Category": {
                        ((MediaTemplateObject)object2).setCategory(this.getText());
                    }
                }
            }
            object2 = this.response.getTemplate().getTransTpl();
            if (this.in("Response", "Template", "TransTpl", "Container")) {
                object = ((MediaTemplateTransTplObject)object2).getContainer();
                if ("Format".equalsIgnoreCase(string2)) {
                    ((MediaContainerObject)object).setFormat(this.getText());
                }
            } else if (this.in("Response", "Template", "TransTpl", "Video")) {
                object = ((MediaTemplateTransTplObject)object2).getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo((MediaVideoObject)object, string2, this.getText());
            } else if (this.in("Response", "Template", "TransTpl", "TimeInterval")) {
                object = ((MediaTemplateTransTplObject)object2).getTimeInterval();
                ParserMediaInfoUtils.ParsingMediaTimeInterval((MediaTimeIntervalObject)object, string2, this.getText());
            } else if (this.in("Response", "Template", "TransTpl", "Audio")) {
                object = ((MediaTemplateTransTplObject)object2).getAudio();
                ParserMediaInfoUtils.ParsingMediaAudio((MediaAudioObject)object, string2, this.getText());
            } else if (this.in("Response", "Template", "TransTpl", "TransConfig")) {
                object = ((MediaTemplateTransTplObject)object2).getTransConfig();
                ParserMediaInfoUtils.ParsingTransConfig((MediaTransConfigObject)object, string2, this.getText());
            } else if (this.in("Response", "Template", "Snapshot")) {
                object = this.response.getTemplate().getSnapshot();
                ParserMediaInfoUtils.ParsingSnapshot((MediaSnapshotObject)object, string2, this.getText());
            } else if (this.in("Response", "Template", "Watermark")) {
                object = this.response.getTemplate().getWatermark();
                ParserMediaInfoUtils.ParsingWatermark((MediaWatermark)object, string2, this.getText());
            } else if (this.in("Response", "Template", "Watermark", "Text")) {
                object = this.response.getTemplate().getWatermark().getText();
                ParserMediaInfoUtils.ParsingWatermarkText((MediaWaterMarkText)object, string2, this.getText());
            } else if (this.in("Response", "Template", "Watermark", "Image")) {
                object = this.response.getTemplate().getWatermark().getImage();
                ParserMediaInfoUtils.ParsingWatermarkImage((MediaWaterMarkImage)object, string2, this.getText());
            } else if (this.in("Response", "Template", "VideoTargetRec")) {
                object = this.response.getTemplate().getVideoTargetRec();
                ParserMediaInfoUtils.ParsingVideoTargetRec((VideoTargetRec)object, string2, this.getText());
            }
        }

        public MediaTemplateResponse getResponse() {
            return this.response;
        }
    }

    public static class MediaQueueResponseHandler
    extends AbstractHandler {
        MediaQueueResponse response = new MediaQueueResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(string2)) {
                    this.response.setRequestId(this.getText());
                }
            } else if (this.in("Response", "Queue")) {
                MediaQueueObject mediaQueueObject = this.response.getQueue();
                switch (string2) {
                    case "QueueId": {
                        mediaQueueObject.setQueueId(this.getText());
                        break;
                    }
                    case "Name": {
                        mediaQueueObject.setName(this.getText());
                        break;
                    }
                    case "State": {
                        mediaQueueObject.setState(this.getText());
                        break;
                    }
                    case "MaxSize": {
                        mediaQueueObject.setMaxSize(this.getText());
                        break;
                    }
                    case "MaxConcurrent": {
                        mediaQueueObject.setMaxConcurrent(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        mediaQueueObject.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        mediaQueueObject.setUpdateTime(this.getText());
                        break;
                    }
                    case "BucketId": {
                        mediaQueueObject.setBucketId(this.getText());
                        break;
                    }
                    case "Category": {
                        mediaQueueObject.setCategory(this.getText());
                    }
                }
            } else if (this.in("Response", "Queue", "NotifyConfig")) {
                MediaNotifyConfig mediaNotifyConfig = this.response.getQueue().getNotifyConfig();
                switch (string2) {
                    case "Url": {
                        mediaNotifyConfig.setUrl(this.getText());
                        break;
                    }
                    case "Event": {
                        mediaNotifyConfig.setEvent(this.getText());
                        break;
                    }
                    case "Type": {
                        mediaNotifyConfig.setType(this.getText());
                        break;
                    }
                    case "State": {
                        mediaNotifyConfig.setState(this.getText());
                    }
                }
            }
        }

        public MediaQueueResponse getResponse() {
            return this.response;
        }
    }

    public static class DescribeMediaJobsHandler
    extends AbstractHandler {
        MediaListJobResponse response = new MediaListJobResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            List<Object> list;
            List<MediaJobObject> list2 = this.response.getJobsDetailList();
            if ("JobsDetail".equalsIgnoreCase(string2)) {
                list = list2;
                list.add(new MediaJobObject());
            }
            if ("ConcatFragment".equals(string2)) {
                list = list2.get(list2.size() - 1).getOperation().getMediaConcatTemplate().getConcatFragmentList();
                list.add((MediaJobObject)((Object)new MediaConcatFragmentObject()));
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            Object object;
            List<MediaJobObject> list = this.response.getJobsDetailList();
            MediaJobObject mediaJobObject = list.isEmpty() ? new MediaJobObject() : list.get(list.size() - 1);
            if (this.in("Response", "JobsDetail")) {
                switch (string2) {
                    case "Code": {
                        mediaJobObject.setCode(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        mediaJobObject.setCreationTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        mediaJobObject.setEndTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        mediaJobObject.setJobId(this.getText());
                        break;
                    }
                    case "Message": {
                        mediaJobObject.setMessage(this.getText());
                        break;
                    }
                    case "QueueId": {
                        mediaJobObject.setQueueId(this.getText());
                        break;
                    }
                    case "State": {
                        mediaJobObject.setState(this.getText());
                        break;
                    }
                    case "Tag": {
                        mediaJobObject.setTag(this.getText());
                        break;
                    }
                    case "BucketName": {
                        mediaJobObject.setBucketName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Input")) {
                mediaJobObject.getInput().setObject(this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation")) {
                object = mediaJobObject.getOperation();
                switch (string2) {
                    case "TemplateId": {
                        ((MediaJobOperation)object).setTemplateId(this.getText());
                        break;
                    }
                    case "WatermarkTemplateId": {
                        ((MediaJobOperation)object).getWatermarkTemplateId().add(this.getText());
                        break;
                    }
                    case "UserData": {
                        ((MediaJobOperation)object).setUserData(this.getText());
                        break;
                    }
                    case "JobLevel": {
                        ((MediaJobOperation)object).setJobLevel(this.getText());
                        break;
                    }
                    case "TemplateName": {
                        ((MediaJobOperation)object).setTemplateName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Format")) {
                object = mediaJobObject.getOperation().getMediaInfo().getFormat();
                ParserMediaInfoUtils.ParsingMediaFormat((MediaFormat)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Audio")) {
                object = mediaJobObject.getOperation().getMediaInfo().getStream().getAudio();
                ParserMediaInfoUtils.ParsingStreamAudio((MediaInfoAudio)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Subtitle")) {
                object = mediaJobObject.getOperation().getMediaInfo().getStream().getSubtitle();
                ParserMediaInfoUtils.ParsingSubtitle((MediaInfoSubtitle)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Video")) {
                object = mediaJobObject.getOperation().getMediaInfo().getStream().getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo((MediaInfoVideo)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "RemoveWatermark")) {
                object = mediaJobObject.getOperation().getRemoveWatermark();
                ParserMediaInfoUtils.ParsingRemoveWatermark((MediaRemoveWaterMark)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Container")) {
                if ("Format".equalsIgnoreCase(string2)) {
                    mediaJobObject.getOperation().getTranscode().getContainer().setFormat(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Video")) {
                object = mediaJobObject.getOperation().getTranscode().getAudio();
                ParserMediaInfoUtils.ParsingStreamAudio((MediaAudioObject)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Audio")) {
                object = mediaJobObject.getOperation().getTranscode().getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo((MediaTranscodeVideoObject)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "TransConfig")) {
                object = mediaJobObject.getOperation().getTranscode().getTransConfig();
                ParserMediaInfoUtils.ParsingTransConfig((MediaTransConfigObject)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "TimeInterval")) {
                object = mediaJobObject.getOperation().getTranscode().getTimeInterval();
                ParserMediaInfoUtils.ParsingMediaTimeInterval((MediaTimeIntervalObject)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Snapshot")) {
                object = mediaJobObject.getOperation().getSnapshot();
                ParserMediaInfoUtils.ParsingSnapshot((MediaSnapshotObject)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Segment")) {
                object = mediaJobObject.getOperation().getSegment();
                ParserMediaInfoUtils.ParsingSegment((MediaSegmentObject)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Snapshot", "SpriteSnapshotConfig")) {
                object = mediaJobObject.getOperation().getSnapshot().getSnapshotConfig();
                ParserMediaInfoUtils.ParsingSnapshotConfig((SpriteSnapshotConfig)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
                object = mediaJobObject.getOperation().getOutput();
                ParserMediaInfoUtils.ParsingOutput((MediaOutputObject)object, string2, this.getText());
            }
            object = mediaJobObject.getOperation().getMediaConcatTemplate();
            if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "ConcatFragment")) {
                List<MediaConcatFragmentObject> list2 = ((MediaConcatTemplateObject)object).getConcatFragmentList();
                MediaConcatFragmentObject mediaConcatFragmentObject = list2.get(list2.size() - 1);
                switch (string2) {
                    case "Mode": {
                        mediaConcatFragmentObject.setMode(this.getText());
                        break;
                    }
                    case "Url": {
                        mediaConcatFragmentObject.setUrl(this.getText());
                        break;
                    }
                    case "StartTime": {
                        mediaConcatFragmentObject.setStartTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        mediaConcatFragmentObject.setEndTime(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Audio")) {
                MediaAudioObject mediaAudioObject = ((MediaConcatTemplateObject)object).getAudio();
                ParserMediaInfoUtils.ParsingMediaAudio(mediaAudioObject, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Video")) {
                MediaVideoObject mediaVideoObject = ((MediaConcatTemplateObject)object).getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo(mediaVideoObject, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Container")) {
                MediaContainerObject mediaContainerObject = ((MediaConcatTemplateObject)object).getContainer();
                if ("Format".equals(string2)) {
                    mediaContainerObject.setFormat(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate")) {
                if ("Index".equals(string2)) {
                    ((MediaConcatTemplateObject)object).setIndex(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DigitalWatermark")) {
                MediaDigitalWatermark mediaDigitalWatermark = mediaJobObject.getOperation().getDigitalWatermark();
                ParserMediaInfoUtils.ParsingDigitalWatermark(mediaDigitalWatermark, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ExtractDigitalWatermark")) {
                ExtractDigitalWatermark extractDigitalWatermark = mediaJobObject.getOperation().getExtractDigitalWatermark();
                ParserMediaInfoUtils.ParsingDigitalWatermark(extractDigitalWatermark, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaResult", "OutputFile")) {
                OutputFile outputFile = mediaJobObject.getOperation().getMediaResult().getOutputFile();
                ParserMediaInfoUtils.ParsingMediaResult(outputFile, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaResult", "OutputFile", "Md5Info")) {
                Md5Info md5Info = mediaJobObject.getOperation().getMediaResult().getOutputFile().getMd5Info();
                ParserMediaInfoUtils.ParsingMd5Info(md5Info, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcess")) {
                MediaPicProcessTemplateObject mediaPicProcessTemplateObject = mediaJobObject.getOperation().getPicProcess();
                if ("IsPicInfo".equalsIgnoreCase(string2)) {
                    mediaPicProcessTemplateObject.setIsPicInfo(this.getText());
                } else if ("ProcessRule".equalsIgnoreCase(string2)) {
                    mediaPicProcessTemplateObject.setProcessRule(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcess")) {
                MediaPicProcessTemplateObject mediaPicProcessTemplateObject = mediaJobObject.getOperation().getPicProcess();
                if ("IsPicInfo".equalsIgnoreCase(string2)) {
                    mediaPicProcessTemplateObject.setIsPicInfo(this.getText());
                } else if ("ProcessRule".equalsIgnoreCase(string2)) {
                    mediaPicProcessTemplateObject.setProcessRule(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcessResult")) {
                if ("ObjectName".equalsIgnoreCase(string2)) {
                    mediaJobObject.getOperation().getPicProcessResult().setObjectName(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcessResult", "OriginalInfo")) {
                if ("Etag".equalsIgnoreCase(string2)) {
                    mediaJobObject.getOperation().getPicProcessResult().getOriginalInfo().setEtag(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcessResult", "OriginalInfo", "ImageInfo")) {
                ImageInfo imageInfo = mediaJobObject.getOperation().getPicProcessResult().getOriginalInfo().getImageInfo();
                ParserMediaInfoUtils.ParsingImageInfo(imageInfo, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcessResult", "ProcessResult")) {
                ProcessResult processResult = mediaJobObject.getOperation().getPicProcessResult().getProcessResult();
                ParserMediaInfoUtils.ParsingProcessResult(processResult, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoTargetRec")) {
                VideoTargetRec videoTargetRec = mediaJobObject.getOperation().getVideoTargetRec();
                ParserMediaInfoUtils.ParsingVideoTargetRec(videoTargetRec, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "TtsConfig")) {
                ParserMediaInfoUtils.ParseTtsConfig(mediaJobObject.getOperation().getTtsConfig(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "TtsTpl")) {
                ParserMediaInfoUtils.ParseTtsTpl(mediaJobObject.getOperation().getTtsTpl(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "Transcode", "Container")) {
                ParserMediaInfoUtils.ParseContainer(mediaJobObject.getOperation().getVideoEnhance().getTrascode().getContainer(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "Transcode", "Video")) {
                ParserMediaInfoUtils.ParsingMediaVideo(mediaJobObject.getOperation().getVideoEnhance().getTrascode().getVideo(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "Transcode", "Audio")) {
                ParserMediaInfoUtils.ParsingMediaAudio(mediaJobObject.getOperation().getVideoEnhance().getTrascode().getAudio(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "SuperResolution")) {
                ParserMediaInfoUtils.ParsingSuperResolution(mediaJobObject.getOperation().getVideoEnhance().getSuperResolution(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "ColorEnhance")) {
                ParserMediaInfoUtils.ParsingColorEnhance(mediaJobObject.getOperation().getVideoEnhance().getColorEnhance(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "MsSharpen")) {
                ParserMediaInfoUtils.ParsingMsSharpen(mediaJobObject.getOperation().getVideoEnhance().getMsSharpen(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "SDRtoHDR")) {
                ParserMediaInfoUtils.ParsingSDRtoHDR(mediaJobObject.getOperation().getVideoEnhance().getSdrToHDR(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "FrameEnhance")) {
                ParserMediaInfoUtils.ParsingFrameEnhance(mediaJobObject.getOperation().getVideoEnhance().getFrameEnhance(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "AudioMixArray")) {
                ParserMediaInfoUtils.ParsingAudioMixArray(mediaJobObject.getOperation().getTranscode().getAudioMixArray(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "AudioMixArray", "EffectConfig")) {
                ParserMediaInfoUtils.ParsingEffectConfig(mediaJobObject.getOperation().getTranscode().getAudioMixArray(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Subtitles", "Subtitle")) {
                ParserMediaInfoUtils.ParsingSubtitles(mediaJobObject.getOperation().getSubtitles(), string2, this.getText());
            }
        }

        public MediaListJobResponse getResponse() {
            return this.response;
        }
    }

    public static class MediaJobCreatHandler
    extends AbstractHandler {
        MediaJobResponse response = new MediaJobResponse();
        List<MediaConcatFragmentObject> concatFragmentList = this.response.getJobsDetail().getOperation().getMediaConcatTemplate().getConcatFragmentList();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("ConcatFragment".equals(string2)) {
                this.concatFragmentList.add(new MediaConcatFragmentObject());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            Object object;
            MediaJobObject mediaJobObject = this.response.getJobsDetail();
            if (this.in("Response", "JobsDetail")) {
                switch (string2) {
                    case "Code": {
                        mediaJobObject.setCode(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        mediaJobObject.setCreationTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        mediaJobObject.setEndTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        mediaJobObject.setJobId(this.getText());
                        break;
                    }
                    case "Message": {
                        mediaJobObject.setMessage(this.getText());
                        break;
                    }
                    case "QueueId": {
                        mediaJobObject.setQueueId(this.getText());
                        break;
                    }
                    case "State": {
                        mediaJobObject.setState(this.getText());
                        break;
                    }
                    case "Tag": {
                        mediaJobObject.setTag(this.getText());
                        break;
                    }
                    case "BucketName": {
                        mediaJobObject.setBucketName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Input")) {
                mediaJobObject.getInput().setObject(this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation")) {
                object = mediaJobObject.getOperation();
                switch (string2) {
                    case "TemplateId": {
                        ((MediaJobOperation)object).setTemplateId(this.getText());
                        break;
                    }
                    case "WatermarkTemplateId": {
                        ((MediaJobOperation)object).getWatermarkTemplateId().add(this.getText());
                        break;
                    }
                    case "UserData": {
                        ((MediaJobOperation)object).setUserData(this.getText());
                        break;
                    }
                    case "JobLevel": {
                        ((MediaJobOperation)object).setJobLevel(this.getText());
                        break;
                    }
                    case "TemplateName": {
                        ((MediaJobOperation)object).setTemplateName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Format")) {
                object = mediaJobObject.getOperation().getMediaInfo().getFormat();
                ParserMediaInfoUtils.ParsingMediaFormat((MediaFormat)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Audio")) {
                object = mediaJobObject.getOperation().getMediaInfo().getStream().getAudio();
                ParserMediaInfoUtils.ParsingStreamAudio((MediaInfoAudio)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Subtitle")) {
                object = mediaJobObject.getOperation().getMediaInfo().getStream().getSubtitle();
                ParserMediaInfoUtils.ParsingSubtitle((MediaInfoSubtitle)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Video")) {
                object = mediaJobObject.getOperation().getMediaInfo().getStream().getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo((MediaInfoVideo)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Watermark")) {
                object = mediaJobObject.getOperation().getWatermark();
                ParserMediaInfoUtils.ParsingWatermark((MediaWatermark)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "RemoveWatermark")) {
                object = mediaJobObject.getOperation().getRemoveWatermark();
                ParserMediaInfoUtils.ParsingRemoveWatermark((MediaRemoveWaterMark)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Watermark", "Text")) {
                object = mediaJobObject.getOperation().getWatermark().getText();
                ParserMediaInfoUtils.ParsingWatermarkText((MediaWaterMarkText)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Watermark", "Image")) {
                object = mediaJobObject.getOperation().getWatermark().getImage();
                ParserMediaInfoUtils.ParsingWatermarkImage((MediaWaterMarkImage)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Container")) {
                if ("Format".equalsIgnoreCase(string2)) {
                    this.response.getJobsDetail().getOperation().getTranscode().getContainer().setFormat(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Video")) {
                object = mediaJobObject.getOperation().getTranscode().getAudio();
                ParserMediaInfoUtils.ParsingStreamAudio((MediaAudioObject)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Audio")) {
                object = mediaJobObject.getOperation().getTranscode().getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo((MediaTranscodeVideoObject)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "TransConfig")) {
                object = mediaJobObject.getOperation().getTranscode().getTransConfig();
                ParserMediaInfoUtils.ParsingTransConfig((MediaTransConfigObject)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "TimeInterval")) {
                object = mediaJobObject.getOperation().getTranscode().getTimeInterval();
                ParserMediaInfoUtils.ParsingMediaTimeInterval((MediaTimeIntervalObject)object, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
                ParserMediaInfoUtils.ParsingOutput(mediaJobObject.getOperation().getOutput(), string2, this.getText());
            }
            object = this.response.getJobsDetail().getOperation().getMediaConcatTemplate();
            if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "ConcatFragment")) {
                MediaConcatFragmentObject mediaConcatFragmentObject = this.concatFragmentList.get(this.concatFragmentList.size() - 1);
                switch (string2) {
                    case "Mode": {
                        mediaConcatFragmentObject.setMode(this.getText());
                        break;
                    }
                    case "Url": {
                        mediaConcatFragmentObject.setUrl(this.getText());
                        break;
                    }
                    case "StartTime": {
                        mediaConcatFragmentObject.setStartTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        mediaConcatFragmentObject.setEndTime(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Audio")) {
                MediaAudioObject mediaAudioObject = ((MediaConcatTemplateObject)object).getAudio();
                ParserMediaInfoUtils.ParsingMediaAudio(mediaAudioObject, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Video")) {
                MediaVideoObject mediaVideoObject = ((MediaConcatTemplateObject)object).getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo(mediaVideoObject, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Container")) {
                MediaContainerObject mediaContainerObject = ((MediaConcatTemplateObject)object).getContainer();
                if ("Format".equals(string2)) {
                    mediaContainerObject.setFormat(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate")) {
                if ("Index".equals(string2)) {
                    ((MediaConcatTemplateObject)object).setIndex(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DigitalWatermark")) {
                MediaDigitalWatermark mediaDigitalWatermark = this.response.getJobsDetail().getOperation().getDigitalWatermark();
                ParserMediaInfoUtils.ParsingDigitalWatermark(mediaDigitalWatermark, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ExtractDigitalWatermark")) {
                ExtractDigitalWatermark extractDigitalWatermark = this.response.getJobsDetail().getOperation().getExtractDigitalWatermark();
                ParserMediaInfoUtils.ParsingDigitalWatermark(extractDigitalWatermark, string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcess")) {
                MediaJobOperation mediaJobOperation = this.response.getJobsDetail().getOperation();
                if ("IsPicInfo".equalsIgnoreCase(string2)) {
                    mediaJobOperation.getPicProcess().setIsPicInfo(this.getText());
                } else if ("ProcessRule".equalsIgnoreCase(string2)) {
                    mediaJobOperation.getPicProcess().setProcessRule(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "VoiceSeparate")) {
                if ("AudioMode".equalsIgnoreCase(string2)) {
                    mediaJobObject.getOperation().getVoiceSeparate().setAudioMode(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "VoiceSeparate", "AudioConfig")) {
                ParserMediaInfoUtils.ParseAudioConfig(mediaJobObject.getOperation().getVoiceSeparate().getAudioConfig(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "TtsConfig")) {
                ParserMediaInfoUtils.ParseTtsConfig(mediaJobObject.getOperation().getTtsConfig(), string2, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "TtsTpl")) {
                ParserMediaInfoUtils.ParseTtsTpl(mediaJobObject.getOperation().getTtsTpl(), string2, this.getText());
            }
        }

        public MediaJobResponse getResponse() {
            return this.response;
        }
    }

    public static class WorkflowExecutionHandler
    extends AbstractHandler {
        private MediaWorkflowExecutionResponse response = new MediaWorkflowExecutionResponse();
        MediaWorkflowExecutionObject workflowObject = this.response.getWorkflowExecution();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("Tasks".equals(string2)) {
                this.workflowObject.getTasks().addLast(new MediaTasks());
            }
            if (this.in("Response", "WorkflowExecution", "Topology", "Nodes")) {
                Map<String, MediaWorkflowNode> map = this.workflowObject.getTopology().getMediaWorkflowNodes();
                map.put(string2, new MediaWorkflowNode());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            Map<String, MediaWorkflowDependency> map;
            if (this.in("Response")) {
                switch (string2) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "WorkflowExecution")) {
                switch (string2) {
                    case "Object": {
                        this.workflowObject.setObject(this.getText());
                        break;
                    }
                    case "WorkflowId": {
                        this.workflowObject.setWorkflowId(this.getText());
                        break;
                    }
                    case "State": {
                        this.workflowObject.setState(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.workflowObject.setCreateTime(this.getText());
                        break;
                    }
                    case "RunId": {
                        this.workflowObject.setRunId(this.getText());
                        break;
                    }
                    case "WorkflowName": {
                        this.workflowObject.setWorkflowName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "WorkflowExecution", "Tasks")) {
                map = this.workflowObject.getTasks().getLast();
                switch (string2) {
                    case "Type": {
                        ((MediaTasks)((Object)map)).setType(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        ((MediaTasks)((Object)map)).setCreateTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        ((MediaTasks)((Object)map)).setEndTime(this.getText());
                        break;
                    }
                    case "State": {
                        ((MediaTasks)((Object)map)).setState(this.getText());
                        break;
                    }
                    case "JobId": {
                        ((MediaTasks)((Object)map)).setJobId(this.getText());
                        break;
                    }
                    case "Name": {
                        ((MediaTasks)((Object)map)).setName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "WorkflowExecution", "Topology", "Dependencies")) {
                map = this.workflowObject.getTopology().getMediaWorkflowDependency();
                MediaWorkflowDependency mediaWorkflowDependency = map.get(string2);
                if (mediaWorkflowDependency == null) {
                    mediaWorkflowDependency = new MediaWorkflowDependency();
                }
                mediaWorkflowDependency.setValue(this.getText());
                map.put(string2, mediaWorkflowDependency);
            }
            map = this.workflowObject.getTopology().getMediaWorkflowNodes();
            for (String string4 : map.keySet()) {
                MediaWorkflowNode mediaWorkflowNode = (MediaWorkflowNode)map.get(string4);
                if (this.in("Response", "WorkflowExecution", "Topology", "Nodes", string4, "Operation")) {
                    if (!"TemplateId".equals(string2)) continue;
                    mediaWorkflowNode.getOperation().setTemplateId(this.getText());
                    continue;
                }
                if (this.in("Response", "WorkflowExecution", "Topology", "Nodes", string4, "Operation", "Output")) {
                    MediaOutputObject mediaOutputObject = mediaWorkflowNode.getOperation().getOutput();
                    switch (string2) {
                        case "Bucket": {
                            mediaOutputObject.setBucket(this.getText());
                            return;
                        }
                        case "Object": {
                            mediaOutputObject.setObject(this.getText());
                            return;
                        }
                        case "Region": {
                            mediaOutputObject.setRegion(this.getText());
                            return;
                        }
                    }
                    return;
                }
                if (this.in("Response", "WorkflowExecution", "Topology", "Nodes", string4)) {
                    if (!"Type".equals(string2)) continue;
                    mediaWorkflowNode.setType(this.getText());
                    continue;
                }
                if (!this.in("Response", "WorkflowExecution", "Topology", "Nodes", string4, "Input")) continue;
                MediaWorkflowInput mediaWorkflowInput = mediaWorkflowNode.getInput();
                switch (string2) {
                    case "ObjectPrefix": {
                        mediaWorkflowInput.setObjectPrefix(this.getText());
                        return;
                    }
                    case "QueueId": {
                        mediaWorkflowInput.setQueueId(this.getText());
                        return;
                    }
                }
                return;
            }
        }

        public MediaWorkflowExecutionResponse getResponse() {
            return this.response;
        }

        public void setResponse(MediaWorkflowExecutionResponse mediaWorkflowExecutionResponse) {
            this.response = mediaWorkflowExecutionResponse;
        }
    }

    public static class WorkflowHandler
    extends AbstractHandler {
        private MediaWorkflowResponse response = new MediaWorkflowResponse();

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            switch (string2) {
                case "Name": {
                    this.response.setName(this.getText());
                    break;
                }
                case "WorkflowId": {
                    this.response.setWorkflowId(this.getText());
                    break;
                }
                case "State": {
                    this.response.setState(this.getText());
                    break;
                }
                case "CreateTime": {
                    this.response.setCreateTime(this.getText());
                    break;
                }
                case "UpdateTime": {
                    this.response.setUpdateTime(this.getText());
                    break;
                }
                case "BucketId": {
                    this.response.setBucketId(this.getText());
                    break;
                }
            }
        }

        public MediaWorkflowResponse getResponse() {
            return this.response;
        }

        public void setResponse(MediaWorkflowResponse mediaWorkflowResponse) {
            this.response = mediaWorkflowResponse;
        }
    }

    public static class WorkflowListHandler
    extends AbstractHandler {
        private MediaWorkflowListResponse response = new MediaWorkflowListResponse();
        MediaWorkflowObject workflowObject;

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("MediaWorkflowList".equals(string2)) {
                this.workflowObject = new MediaWorkflowObject();
            }
            if (this.in("Response", "MediaWorkflowList", "Topology", "Nodes")) {
                Map<String, MediaWorkflowNode> map = this.workflowObject.getTopology().getMediaWorkflowNodes();
                map.put(string2, new MediaWorkflowNode());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            Map<String, MediaWorkflowDependency> map;
            if (this.in("Response")) {
                switch (string2) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                    case "TotalCount": {
                        this.response.setTotalCount(this.getText());
                        break;
                    }
                    case "PageNumber": {
                        this.response.setPageNumber(this.getText());
                        break;
                    }
                    case "PageSize": {
                        this.response.setPageSize(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "MediaWorkflowList")) {
                switch (string2) {
                    case "Name": {
                        this.workflowObject.setName(this.getText());
                        break;
                    }
                    case "WorkflowId": {
                        this.workflowObject.setWorkflowId(this.getText());
                        break;
                    }
                    case "State": {
                        this.workflowObject.setState(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.workflowObject.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        this.workflowObject.setUpdateTime(this.getText());
                        break;
                    }
                    case "BucketId": {
                        this.workflowObject.setBucketId(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "MediaWorkflowList", "Topology", "Dependencies")) {
                map = this.workflowObject.getTopology().getMediaWorkflowDependency();
                MediaWorkflowDependency mediaWorkflowDependency = map.get(string2);
                if (mediaWorkflowDependency == null) {
                    mediaWorkflowDependency = new MediaWorkflowDependency();
                }
                mediaWorkflowDependency.setValue(this.getText());
                map.put(string2, mediaWorkflowDependency);
            }
            map = this.workflowObject.getTopology().getMediaWorkflowNodes();
            for (String string4 : map.keySet()) {
                MediaWorkflowNode mediaWorkflowNode = (MediaWorkflowNode)map.get(string4);
                if (this.in("Response", "MediaWorkflowList", "Topology", "Nodes", string4, "Operation")) {
                    if (!"TemplateId".equals(string2)) continue;
                    mediaWorkflowNode.getOperation().setTemplateId(this.getText());
                    continue;
                }
                if (this.in("Response", "MediaWorkflowList", "Topology", "Nodes", string4, "Operation", "Output")) {
                    MediaOutputObject mediaOutputObject = mediaWorkflowNode.getOperation().getOutput();
                    switch (string2) {
                        case "Bucket": {
                            mediaOutputObject.setBucket(this.getText());
                            return;
                        }
                        case "Object": {
                            mediaOutputObject.setObject(this.getText());
                            return;
                        }
                        case "Region": {
                            mediaOutputObject.setRegion(this.getText());
                            return;
                        }
                    }
                    return;
                }
                if (this.in("Response", "MediaWorkflowList", "Topology", "Nodes", string4)) {
                    if (!"Type".equals(string2)) continue;
                    mediaWorkflowNode.setType(this.getText());
                    continue;
                }
                if (!this.in("Response", "MediaWorkflowList", "Topology", "Nodes", string4, "Input")) continue;
                MediaWorkflowInput mediaWorkflowInput = mediaWorkflowNode.getInput();
                switch (string2) {
                    case "ObjectPrefix": {
                        mediaWorkflowInput.setObjectPrefix(this.getText());
                        return;
                    }
                    case "QueueId": {
                        mediaWorkflowInput.setQueueId(this.getText());
                        return;
                    }
                }
                return;
            }
            if ("MediaWorkflowList".equals(string2)) {
                this.response.getMediaWorkflowList().add(this.workflowObject);
            }
        }

        public MediaWorkflowListResponse getResponse() {
            return this.response;
        }

        public void setResponse(MediaWorkflowListResponse mediaWorkflowListResponse) {
            this.response = mediaWorkflowListResponse;
        }
    }

    public static class ListMediaBucketHandler
    extends AbstractHandler {
        private MediaBucketResponse response = new MediaBucketResponse();
        boolean isNew = true;
        MediaBucketObject bucketObject;

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("MediaBucketList".equals(string2)) {
                this.isNew = true;
            }
            if (this.isNew) {
                this.bucketObject = new MediaBucketObject();
                this.isNew = false;
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response")) {
                switch (string2) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                    case "TotalCount": {
                        this.response.setTotalCount(this.getText());
                        break;
                    }
                    case "PageNumber": {
                        this.response.setPageNumber(this.getText());
                        break;
                    }
                    case "PageSize": {
                        this.response.setPageSize(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "MediaBucketList")) {
                switch (string2) {
                    case "BucketId": {
                        this.bucketObject.setBucketId(this.getText());
                        break;
                    }
                    case "Region": {
                        this.bucketObject.setRegion(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.bucketObject.setCreateTime(this.getText());
                        break;
                    }
                    case "Name": {
                        this.bucketObject.setName(this.getText());
                        break;
                    }
                    case "AliasBucketId": {
                        this.bucketObject.setAliasBucketId(this.getText());
                        break;
                    }
                }
            }
            if ("MediaBucketList".equals(string2) && !this.isNew) {
                this.response.getMediaBucketList().add(this.bucketObject);
                this.bucketObject = null;
            }
        }

        public MediaBucketResponse getResponse() {
            return this.response;
        }
    }

    public static class DocListQueueHandler
    extends AbstractHandler {
        private DocListQueueResponse response = new DocListQueueResponse();
        boolean isNew = true;
        MediaQueueObject queueObject;

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("QueueList".equals(string2)) {
                this.isNew = true;
            }
            if (this.isNew) {
                this.queueObject = new MediaQueueObject();
                this.isNew = false;
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response")) {
                switch (string2) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                    case "TotalCount": {
                        this.response.setTotalCount(this.getText());
                        break;
                    }
                    case "PageNumber": {
                        this.response.setPageNumber(this.getText());
                        break;
                    }
                    case "PageSize": {
                        this.response.setPageSize(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "QueueList")) {
                switch (string2) {
                    case "QueueId": {
                        this.queueObject.setQueueId(this.getText());
                        break;
                    }
                    case "Name": {
                        this.queueObject.setName(this.getText());
                        break;
                    }
                    case "State": {
                        this.queueObject.setState(this.getText());
                        break;
                    }
                    case "MaxSize": {
                        this.queueObject.setMaxSize(this.getText());
                        break;
                    }
                    case "MaxConcurrent": {
                        this.queueObject.setMaxConcurrent(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.queueObject.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        this.queueObject.setUpdateTime(this.getText());
                        break;
                    }
                    case "Category": {
                        this.queueObject.setCategory(this.getText());
                        break;
                    }
                    case "BucketId": {
                        this.queueObject.setBucketId(this.getText());
                        break;
                    }
                    case "BucketName": {
                        this.queueObject.setBucketName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "QueueList", "NotifyConfig")) {
                switch (string2) {
                    case "Url": {
                        this.queueObject.getNotifyConfig().setUrl(this.getText());
                        break;
                    }
                    case "State": {
                        this.queueObject.getNotifyConfig().setState(this.getText());
                        break;
                    }
                    case "Type": {
                        this.queueObject.getNotifyConfig().setType(this.getText());
                        break;
                    }
                    case "Event": {
                        this.queueObject.getNotifyConfig().setEvent(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "NonExistPIDs") && "QueueID".equals(string2)) {
                this.response.getNonExistPIDs().add(this.getText());
            }
            if ("QueueList".equals(string2) && !this.isNew) {
                this.response.getQueueList().add(this.queueObject);
                this.queueObject = null;
            }
        }

        public DocListQueueResponse getResponse() {
            return this.response;
        }

        public void setResponse(DocListQueueResponse docListQueueResponse) {
            this.response = docListQueueResponse;
        }
    }

    public static class ListQueueHandler
    extends AbstractHandler {
        private MediaListQueueResponse response = new MediaListQueueResponse();
        boolean isNew = true;
        MediaQueueObject queueObject;

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if ("QueueList".equals(string2)) {
                this.isNew = true;
            }
            if (this.isNew) {
                this.queueObject = new MediaQueueObject();
                this.isNew = false;
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Response")) {
                switch (string2) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                    case "TotalCount": {
                        this.response.setTotalCount(this.getText());
                        break;
                    }
                    case "PageNumber": {
                        this.response.setPageNumber(this.getText());
                        break;
                    }
                    case "PageSize": {
                        this.response.setPageSize(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "QueueList")) {
                switch (string2) {
                    case "QueueId": {
                        this.queueObject.setQueueId(this.getText());
                        break;
                    }
                    case "Name": {
                        this.queueObject.setName(this.getText());
                        break;
                    }
                    case "State": {
                        this.queueObject.setState(this.getText());
                        break;
                    }
                    case "MaxSize": {
                        this.queueObject.setMaxSize(this.getText());
                        break;
                    }
                    case "MaxConcurrent": {
                        this.queueObject.setMaxConcurrent(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.queueObject.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        this.queueObject.setUpdateTime(this.getText());
                        break;
                    }
                    case "Category": {
                        this.queueObject.setCategory(this.getText());
                        break;
                    }
                    case "BucketId": {
                        this.queueObject.setBucketId(this.getText());
                        break;
                    }
                    case "BucketName": {
                        this.queueObject.setBucketName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "QueueList", "NotifyConfig")) {
                switch (string2) {
                    case "Url": {
                        this.queueObject.getNotifyConfig().setUrl(this.getText());
                        break;
                    }
                    case "State": {
                        this.queueObject.getNotifyConfig().setState(this.getText());
                        break;
                    }
                    case "Type": {
                        this.queueObject.getNotifyConfig().setType(this.getText());
                        break;
                    }
                    case "Event": {
                        this.queueObject.getNotifyConfig().setEvent(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "NonExistPIDs") && "QueueID".equals(string2)) {
                this.response.getNonExistPIDs().add(this.getText());
            }
            if ("QueueList".equals(string2) && !this.isNew) {
                this.response.getQueueList().add(this.queueObject);
                this.queueObject = null;
            }
        }

        public MediaListQueueResponse getResponse() {
            return this.response;
        }

        public void setResponse(MediaListQueueResponse mediaListQueueResponse) {
            this.response = mediaListQueueResponse;
        }
    }

    public static class GetBucketIntelligentTierConfigurationHandler
    extends AbstractHandler {
        private final BucketIntelligentTierConfiguration configuration = new BucketIntelligentTierConfiguration();
        private BucketIntelligentTierConfiguration.Transition transition;

        public BucketIntelligentTierConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("IntelligentTieringConfiguration") && string2.equals("Transition")) {
                this.configuration.setTransition(new BucketIntelligentTierConfiguration.Transition());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("IntelligentTieringConfiguration")) {
                if (string2.equals("Status")) {
                    this.configuration.setStatus(this.getText());
                }
            } else if (this.in("IntelligentTieringConfiguration", "Transition") && string2.equals("Days")) {
                this.configuration.getTransition().setDays(Integer.parseInt(this.getText()));
            }
        }
    }

    public static class GetObjectTaggingHandler
    extends AbstractHandler {
        private GetObjectTaggingResult getObjectTaggingResult;
        private List<Tag> tagSet;
        private String currentTagValue;
        private String currentTagKey;

        public GetObjectTaggingResult getResult() {
            return this.getObjectTaggingResult;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("Tagging") && string2.equals("TagSet")) {
                this.tagSet = new ArrayList<Tag>();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Tagging") && string2.equals("TagSet")) {
                this.getObjectTaggingResult = new GetObjectTaggingResult(this.tagSet);
                this.tagSet = null;
            }
            if (this.in("Tagging", "TagSet")) {
                if (string2.equals("Tag")) {
                    this.tagSet.add(new Tag(this.currentTagKey, this.currentTagValue));
                    this.currentTagKey = null;
                    this.currentTagValue = null;
                }
            } else if (this.in("Tagging", "TagSet", "Tag")) {
                if (string2.equals("Key")) {
                    this.currentTagKey = this.getText();
                } else if (string2.equals("Value")) {
                    this.currentTagValue = this.getText();
                }
            }
        }
    }

    public static class ListBucketInventoryConfigurationsHandler
    extends AbstractHandler {
        public static final String SSE_COS = "SSE-COS";
        private final ListBucketInventoryConfigurationsResult result = new ListBucketInventoryConfigurationsResult();
        private InventoryConfiguration currentConfiguration;
        private List<String> currentOptionalFieldsList;
        private InventoryDestination currentDestination;
        private InventoryFilter currentFilter;
        private InventoryCosBucketDestination currentCosBucketDestination;
        private InventorySchedule currentSchedule;

        public ListBucketInventoryConfigurationsResult getResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListInventoryConfigurationResult")) {
                if (string2.equals("InventoryConfiguration")) {
                    this.currentConfiguration = new InventoryConfiguration();
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration")) {
                if (string2.equals("Destination")) {
                    this.currentDestination = new InventoryDestination();
                } else if (string2.equals("Filter")) {
                    this.currentFilter = new InventoryFilter();
                } else if (string2.equals("Schedule")) {
                    this.currentSchedule = new InventorySchedule();
                } else if (string2.equals("OptionalFields")) {
                    this.currentOptionalFieldsList = new ArrayList<String>();
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Destination") && string2.equals("COSBucketDestination")) {
                this.currentCosBucketDestination = new InventoryCosBucketDestination();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("ListInventoryConfigurationResult")) {
                if (string2.equals("InventoryConfiguration")) {
                    if (this.result.getInventoryConfigurationList() == null) {
                        this.result.setInventoryConfigurationList(new ArrayList<InventoryConfiguration>());
                    }
                    this.result.getInventoryConfigurationList().add(this.currentConfiguration);
                    this.currentConfiguration = null;
                } else if (string2.equals("IsTruncated")) {
                    this.result.setTruncated("true".equals(this.getText()));
                } else if (string2.equals("ContinuationToken")) {
                    this.result.setContinuationToken(this.getText());
                } else if (string2.equals("NextContinuationToken")) {
                    this.result.setNextContinuationToken(this.getText());
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration")) {
                if (string2.equals("Id")) {
                    this.currentConfiguration.setId(this.getText());
                } else if (string2.equals("Destination")) {
                    this.currentConfiguration.setDestination(this.currentDestination);
                    this.currentDestination = null;
                } else if (string2.equals("IsEnabled")) {
                    this.currentConfiguration.setEnabled("true".equals(this.getText()));
                } else if (string2.equals("Filter")) {
                    this.currentConfiguration.setInventoryFilter(this.currentFilter);
                    this.currentFilter = null;
                } else if (string2.equals("IncludedObjectVersions")) {
                    this.currentConfiguration.setIncludedObjectVersions(this.getText());
                } else if (string2.equals("Schedule")) {
                    this.currentConfiguration.setSchedule(this.currentSchedule);
                    this.currentSchedule = null;
                } else if (string2.equals("OptionalFields")) {
                    this.currentConfiguration.setOptionalFields(this.currentOptionalFieldsList);
                    this.currentOptionalFieldsList = null;
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Destination")) {
                if (string2.equals("COSBucketDestination")) {
                    this.currentDestination.setCosBucketDestination(this.currentCosBucketDestination);
                    this.currentCosBucketDestination = null;
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Destination", "COSBucketDestination")) {
                if (string2.equals("AccountId")) {
                    this.currentCosBucketDestination.setAccountId(this.getText());
                } else if (string2.equals("Bucket")) {
                    this.currentCosBucketDestination.setBucketArn(this.getText());
                } else if (string2.equals("Format")) {
                    this.currentCosBucketDestination.setFormat(this.getText());
                } else if (string2.equals("Prefix")) {
                    this.currentCosBucketDestination.setPrefix(this.getText());
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Destination", "COSBucketDestination", "Encryption")) {
                if (string2.equals(SSE_COS)) {
                    this.currentCosBucketDestination.setEncryption(new ServerSideEncryptionCOS());
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Filter")) {
                if (string2.equals("Prefix")) {
                    this.currentFilter.setPredicate(new InventoryPrefixPredicate(this.getText()));
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Schedule")) {
                if (string2.equals("Frequency")) {
                    this.currentSchedule.setFrequency(this.getText());
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "OptionalFields") && string2.equals("Field")) {
                this.currentOptionalFieldsList.add(this.getText());
            }
        }
    }

    public static class BucketTaggingConfigurationHandler
    extends AbstractHandler {
        private final BucketTaggingConfiguration configuration = new BucketTaggingConfiguration();
        private Map<String, String> currentTagSet;
        private String currentTagKey;
        private String currentTagValue;

        public BucketTaggingConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("Tagging") && string2.equals("TagSet")) {
                this.currentTagSet = new LinkedHashMap<String, String>();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("Tagging")) {
                if (string2.equals("TagSet")) {
                    this.configuration.getAllTagSets().add(new TagSet(this.currentTagSet));
                    this.currentTagSet = null;
                }
            } else if (this.in("Tagging", "TagSet")) {
                if (string2.equals("Tag")) {
                    if (this.currentTagKey != null && this.currentTagValue != null) {
                        this.currentTagSet.put(this.currentTagKey, this.currentTagValue);
                    }
                    this.currentTagKey = null;
                    this.currentTagValue = null;
                }
            } else if (this.in("Tagging", "TagSet", "Tag")) {
                if (string2.equals("Key")) {
                    this.currentTagKey = this.getText();
                } else if (string2.equals("Value")) {
                    this.currentTagValue = this.getText();
                }
            }
        }
    }

    public static class GetBucketInventoryConfigurationHandler
    extends AbstractHandler {
        public static final String SSE_COS = "SSE-COS";
        private final GetBucketInventoryConfigurationResult result = new GetBucketInventoryConfigurationResult();
        private final InventoryConfiguration configuration = new InventoryConfiguration();
        private List<String> optionalFields;
        private InventoryDestination inventoryDestination;
        private InventoryFilter filter;
        private InventoryCosBucketDestination cosBucketDestination;
        private InventorySchedule inventorySchedule;

        public GetBucketInventoryConfigurationResult getResult() {
            return this.result.withInventoryConfiguration(this.configuration);
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("InventoryConfiguration")) {
                if (string2.equals("Destination")) {
                    this.inventoryDestination = new InventoryDestination();
                } else if (string2.equals("Filter")) {
                    this.filter = new InventoryFilter();
                } else if (string2.equals("Schedule")) {
                    this.inventorySchedule = new InventorySchedule();
                } else if (string2.equals("OptionalFields")) {
                    this.optionalFields = new ArrayList<String>();
                }
            } else if (this.in("InventoryConfiguration", "Destination") && string2.equals("COSBucketDestination")) {
                this.cosBucketDestination = new InventoryCosBucketDestination();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("InventoryConfiguration")) {
                if (string2.equals("Id")) {
                    this.configuration.setId(this.getText());
                } else if (string2.equals("Destination")) {
                    this.configuration.setDestination(this.inventoryDestination);
                    this.inventoryDestination = null;
                } else if (string2.equals("IsEnabled")) {
                    this.configuration.setEnabled("true".equals(this.getText()));
                } else if (string2.equals("Filter")) {
                    this.configuration.setInventoryFilter(this.filter);
                    this.filter = null;
                } else if (string2.equals("IncludedObjectVersions")) {
                    this.configuration.setIncludedObjectVersions(this.getText());
                } else if (string2.equals("Schedule")) {
                    this.configuration.setSchedule(this.inventorySchedule);
                    this.inventorySchedule = null;
                } else if (string2.equals("OptionalFields")) {
                    this.configuration.setOptionalFields(this.optionalFields);
                    this.optionalFields = null;
                }
            } else if (this.in("InventoryConfiguration", "Destination")) {
                if (string2.equals("COSBucketDestination")) {
                    this.inventoryDestination.setCosBucketDestination(this.cosBucketDestination);
                    this.cosBucketDestination = null;
                }
            } else if (this.in("InventoryConfiguration", "Destination", "COSBucketDestination")) {
                if (string2.equals("AccountId")) {
                    this.cosBucketDestination.setAccountId(this.getText());
                } else if (string2.equals("Bucket")) {
                    this.cosBucketDestination.setBucketArn(this.getText());
                } else if (string2.equals("Format")) {
                    this.cosBucketDestination.setFormat(this.getText());
                } else if (string2.equals("Prefix")) {
                    this.cosBucketDestination.setPrefix(this.getText());
                }
            } else if (this.in("InventoryConfiguration", "Destination", "COSBucketDestination", "Encryption")) {
                if (string2.equals(SSE_COS)) {
                    this.cosBucketDestination.setEncryption(new ServerSideEncryptionCOS());
                }
            } else if (this.in("InventoryConfiguration", "Filter")) {
                if (string2.equals("Prefix")) {
                    this.filter.setPredicate(new InventoryPrefixPredicate(this.getText()));
                }
            } else if (this.in("InventoryConfiguration", "Schedule")) {
                if (string2.equals("Frequency")) {
                    this.inventorySchedule.setFrequency(this.getText());
                }
            } else if (this.in("InventoryConfiguration", "OptionalFields") && string2.equals("Field")) {
                this.optionalFields.add(this.getText());
            }
        }
    }

    public static class BucketLoggingConfigurationHandler
    extends AbstractHandler {
        private final BucketLoggingConfiguration bucketLoggingConfiguration = new BucketLoggingConfiguration();

        public BucketLoggingConfiguration getBucketLoggingConfiguration() {
            return this.bucketLoggingConfiguration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("BucketLoggingStatus", "LoggingEnabled")) {
                if (string2.equals("TargetBucket")) {
                    this.bucketLoggingConfiguration.setDestinationBucketName(this.getText());
                } else if (string2.equals("TargetPrefix")) {
                    this.bucketLoggingConfiguration.setLogFilePrefix(this.getText());
                }
            }
        }
    }

    public static class BucketRefererConfigurationHandler
    extends AbstractHandler {
        private final BucketRefererConfiguration configuration = new BucketRefererConfiguration();

        public BucketRefererConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("RefererConfiguration")) {
                if (string2.equals("Status")) {
                    this.configuration.setStatus(this.getText());
                } else if (string2.equals("RefererType")) {
                    this.configuration.setRefererType(this.getText());
                } else if (string2.equals("EmptyReferConfiguration")) {
                    this.configuration.setEmptyReferConfiguration(this.getText());
                }
            } else if (this.in("RefererConfiguration", "DomainList") && string2.equals("Domain")) {
                this.configuration.addDomain(this.getText());
            }
        }
    }

    public static class BucketDomainCertificateHandler
    extends AbstractHandler {
        private final BucketGetDomainCertificate domainCertificate = new BucketGetDomainCertificate();

        public BucketGetDomainCertificate getBucketDomainCertificate() {
            return this.domainCertificate;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("DomainCertificate") && "Status".equals(string2)) {
                this.domainCertificate.setStatus(this.getText());
            }
        }
    }

    public static class BucketDomainConfigurationHandler
    extends AbstractHandler {
        private final BucketDomainConfiguration configuration = new BucketDomainConfiguration();
        private DomainRule currentRule;
        private String status;
        private String mname;
        private String type;
        private String forcedReplacement;

        public BucketDomainConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("DomainConfiguration") && string2.equals("DomainRule")) {
                this.currentRule = new DomainRule();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("DomainConfiguration")) {
                if (string2.equals("DomainRule")) {
                    this.currentRule.setStatus(this.status);
                    this.currentRule.setName(this.mname);
                    this.currentRule.setType(this.type);
                    this.currentRule.setForcedReplacement(this.forcedReplacement);
                    this.configuration.getDomainRules().add(this.currentRule);
                    this.currentRule = null;
                    this.status = null;
                    this.mname = null;
                    this.type = null;
                    this.forcedReplacement = null;
                }
            } else if (this.in("DomainConfiguration", "DomainRule")) {
                if (string2.equals("Status")) {
                    this.status = this.getText();
                } else if (string2.equals("Name")) {
                    this.mname = this.getText();
                } else if (string2.equals("Type")) {
                    this.type = this.getText();
                } else if (string2.equals("ForcedReplacement")) {
                    this.forcedReplacement = this.getText();
                }
            }
        }
    }

    public static class BucketCrossOriginConfigurationHandler
    extends AbstractHandler {
        private final BucketCrossOriginConfiguration configuration = new BucketCrossOriginConfiguration(new ArrayList<CORSRule>());
        private CORSRule currentRule;
        private List<CORSRule.AllowedMethods> allowedMethods = null;
        private List<String> allowedOrigins = null;
        private List<String> exposedHeaders = null;
        private List<String> allowedHeaders = null;

        public BucketCrossOriginConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("CORSConfiguration")) {
                if (string2.equals("CORSRule")) {
                    this.currentRule = new CORSRule();
                }
            } else if (this.in("CORSConfiguration", "CORSRule")) {
                if (string2.equals("AllowedOrigin")) {
                    if (this.allowedOrigins == null) {
                        this.allowedOrigins = new ArrayList<String>();
                    }
                } else if (string2.equals("AllowedMethod")) {
                    if (this.allowedMethods == null) {
                        this.allowedMethods = new ArrayList<CORSRule.AllowedMethods>();
                    }
                } else if (string2.equals("ExposeHeader")) {
                    if (this.exposedHeaders == null) {
                        this.exposedHeaders = new ArrayList<String>();
                    }
                } else if (string2.equals("AllowedHeader") && this.allowedHeaders == null) {
                    this.allowedHeaders = new LinkedList<String>();
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("CORSConfiguration")) {
                if (string2.equals("CORSRule")) {
                    this.currentRule.setAllowedHeaders(this.allowedHeaders);
                    this.currentRule.setAllowedMethods(this.allowedMethods);
                    this.currentRule.setAllowedOrigins(this.allowedOrigins);
                    this.currentRule.setExposedHeaders(this.exposedHeaders);
                    this.allowedHeaders = null;
                    this.allowedMethods = null;
                    this.allowedOrigins = null;
                    this.exposedHeaders = null;
                    this.configuration.getRules().add(this.currentRule);
                    this.currentRule = null;
                }
            } else if (this.in("CORSConfiguration", "CORSRule")) {
                if (string2.equals("ID")) {
                    this.currentRule.setId(this.getText());
                } else if (string2.equals("AllowedOrigin")) {
                    this.allowedOrigins.add(this.getText());
                } else if (string2.equals("AllowedMethod")) {
                    this.allowedMethods.add(CORSRule.AllowedMethods.fromValue(this.getText()));
                } else if (string2.equals("MaxAgeSeconds")) {
                    this.currentRule.setMaxAgeSeconds(Integer.parseInt(this.getText()));
                } else if (string2.equals("ExposeHeader")) {
                    this.exposedHeaders.add(this.getText());
                } else if (string2.equals("AllowedHeader")) {
                    this.allowedHeaders.add(this.getText());
                }
            }
        }
    }

    public static class BucketLifecycleConfigurationHandler
    extends AbstractHandler {
        private final BucketLifecycleConfiguration configuration = new BucketLifecycleConfiguration(new ArrayList<BucketLifecycleConfiguration.Rule>());
        private BucketLifecycleConfiguration.Rule currentRule;
        private BucketLifecycleConfiguration.Transition currentTransition;
        private BucketLifecycleConfiguration.NoncurrentVersionTransition currentNcvTransition;
        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;
        private LifecycleFilter currentFilter;
        private List<LifecycleFilterPredicate> andOperandsList;
        private String currentTagKey;
        private String currentTagValue;

        public BucketLifecycleConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("LifecycleConfiguration")) {
                if (string2.equals("Rule")) {
                    this.currentRule = new BucketLifecycleConfiguration.Rule();
                }
            } else if (this.in("LifecycleConfiguration", "Rule")) {
                if (string2.equals("Transition")) {
                    this.currentTransition = new BucketLifecycleConfiguration.Transition();
                } else if (string2.equals("NoncurrentVersionTransition")) {
                    this.currentNcvTransition = new BucketLifecycleConfiguration.NoncurrentVersionTransition();
                } else if (string2.equals("AbortIncompleteMultipartUpload")) {
                    this.abortIncompleteMultipartUpload = new AbortIncompleteMultipartUpload();
                } else if (string2.equals("Filter")) {
                    this.currentFilter = new LifecycleFilter();
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Filter") && string2.equals("And")) {
                this.andOperandsList = new ArrayList<LifecycleFilterPredicate>();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("LifecycleConfiguration")) {
                if (string2.equals("Rule")) {
                    this.configuration.getRules().add(this.currentRule);
                    this.currentRule = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule")) {
                if (string2.equals("ID")) {
                    this.currentRule.setId(this.getText());
                } else if (string2.equals("Status")) {
                    this.currentRule.setStatus(this.getText());
                } else if (string2.equals("Transition")) {
                    this.currentRule.addTransition(this.currentTransition);
                    this.currentTransition = null;
                } else if (string2.equals("NoncurrentVersionTransition")) {
                    this.currentRule.addNoncurrentVersionTransition(this.currentNcvTransition);
                    this.currentNcvTransition = null;
                } else if (string2.equals("AbortIncompleteMultipartUpload")) {
                    this.currentRule.setAbortIncompleteMultipartUpload(this.abortIncompleteMultipartUpload);
                    this.abortIncompleteMultipartUpload = null;
                } else if (string2.equals("Filter")) {
                    this.currentRule.setFilter(this.currentFilter);
                    this.currentFilter = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Expiration")) {
                if (string2.equals("Date")) {
                    this.currentRule.setExpirationDate(DateUtils.parseISO8601Date(this.getText()));
                } else if (string2.equals("Days")) {
                    this.currentRule.setExpirationInDays(Integer.parseInt(this.getText()));
                } else if (string2.equals("ExpiredObjectDeleteMarker") && "true".equals(this.getText())) {
                    this.currentRule.setExpiredObjectDeleteMarker(true);
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Transition")) {
                if (string2.equals("StorageClass")) {
                    this.currentTransition.setStorageClass(this.getText());
                } else if (string2.equals("Date")) {
                    this.currentTransition.setDate(DateUtils.parseISO8601Date(this.getText()));
                } else if (string2.equals("Days")) {
                    this.currentTransition.setDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "NoncurrentVersionExpiration")) {
                if (string2.equals("NoncurrentDays")) {
                    this.currentRule.setNoncurrentVersionExpirationInDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "NoncurrentVersionTransition")) {
                if (string2.equals("StorageClass")) {
                    this.currentNcvTransition.setStorageClass(this.getText());
                } else if (string2.equals("NoncurrentDays")) {
                    this.currentNcvTransition.setDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "AbortIncompleteMultipartUpload")) {
                if (string2.equals("DaysAfterInitiation")) {
                    this.abortIncompleteMultipartUpload.setDaysAfterInitiation(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Filter")) {
                if (string2.equals("Prefix")) {
                    this.currentFilter.setPredicate(new LifecyclePrefixPredicate(this.getText()));
                } else if (string2.equals("Tag")) {
                    this.currentFilter.setPredicate(new LifecycleTagPredicate(new Tag(this.currentTagKey, this.currentTagValue)));
                    this.currentTagKey = null;
                    this.currentTagValue = null;
                } else if (string2.equals("And")) {
                    this.currentFilter.setPredicate(new LifecycleAndOperator(this.andOperandsList));
                    this.andOperandsList = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Filter", "Tag")) {
                if (string2.equals("Key")) {
                    this.currentTagKey = this.getText();
                } else if (string2.equals("Value")) {
                    this.currentTagValue = this.getText();
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Filter", "And")) {
                if (string2.equals("Prefix")) {
                    this.andOperandsList.add(new LifecyclePrefixPredicate(this.getText()));
                } else if (string2.equals("Tag")) {
                    this.andOperandsList.add(new LifecycleTagPredicate(new Tag(this.currentTagKey, this.currentTagValue)));
                    this.currentTagKey = null;
                    this.currentTagValue = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Filter", "And", "Tag")) {
                if (string2.equals("Key")) {
                    this.currentTagKey = this.getText();
                } else if (string2.equals("Value")) {
                    this.currentTagValue = this.getText();
                }
            }
        }
    }

    public static class DeleteObjectsHandler
    extends AbstractHandler {
        private final DeleteObjectsResponse response = new DeleteObjectsResponse();
        private DeleteObjectsResult.DeletedObject currentDeletedObject = null;
        private MultiObjectDeleteException.DeleteError currentError = null;

        public DeleteObjectsResponse getDeleteObjectResult() {
            return this.response;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("DeleteResult")) {
                if (string2.equals("Deleted")) {
                    this.currentDeletedObject = new DeleteObjectsResult.DeletedObject();
                } else if (string2.equals("Error")) {
                    this.currentError = new MultiObjectDeleteException.DeleteError();
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("DeleteResult")) {
                if (string2.equals("Deleted")) {
                    this.response.getDeletedObjects().add(this.currentDeletedObject);
                    this.currentDeletedObject = null;
                } else if (string2.equals("Error")) {
                    this.response.getErrors().add(this.currentError);
                    this.currentError = null;
                }
            } else if (this.in("DeleteResult", "Deleted")) {
                if (string2.equals("Key")) {
                    this.currentDeletedObject.setKey(this.getText());
                } else if (string2.equals("VersionId")) {
                    this.currentDeletedObject.setVersionId(this.getText());
                } else if (string2.equals("DeleteMarker")) {
                    this.currentDeletedObject.setDeleteMarker(this.getText().equals("true"));
                } else if (string2.equals("DeleteMarkerVersionId")) {
                    this.currentDeletedObject.setDeleteMarkerVersionId(this.getText());
                }
            } else if (this.in("DeleteResult", "Error")) {
                if (string2.equals("Key")) {
                    this.currentError.setKey(this.getText());
                } else if (string2.equals("VersionId")) {
                    this.currentError.setVersionId(this.getText());
                } else if (string2.equals("Code")) {
                    this.currentError.setCode(this.getText());
                } else if (string2.equals("Message")) {
                    this.currentError.setMessage(this.getText());
                }
            }
        }
    }

    public static class BucketReplicationConfigurationHandler
    extends AbstractHandler {
        private final BucketReplicationConfiguration bucketReplicationConfiguration = new BucketReplicationConfiguration();
        private ReplicationRule currentRule;
        private ReplicationDestinationConfig destinationConfig;
        private static final String REPLICATION_CONFIG = "ReplicationConfiguration";
        private static final String ROLE = "Role";
        private static final String RULE = "Rule";
        private static final String DESTINATION = "Destination";
        private static final String ID = "ID";
        private static final String PREFIX = "Prefix";
        private static final String STATUS = "Status";
        private static final String BUCKET = "Bucket";
        private static final String STORAGECLASS = "StorageClass";

        public BucketReplicationConfiguration getConfiguration() {
            return this.bucketReplicationConfiguration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in(REPLICATION_CONFIG)) {
                if (string2.equals(RULE)) {
                    this.currentRule = new ReplicationRule();
                }
            } else if (this.in(REPLICATION_CONFIG, RULE) && string2.equals(DESTINATION)) {
                this.destinationConfig = new ReplicationDestinationConfig();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in(REPLICATION_CONFIG)) {
                if (string2.equals(RULE)) {
                    this.bucketReplicationConfiguration.addRule(this.currentRule);
                    this.currentRule = null;
                    this.destinationConfig = null;
                } else if (string2.equals(ROLE)) {
                    this.bucketReplicationConfiguration.setRoleName(this.getText());
                }
            } else if (this.in(REPLICATION_CONFIG, RULE)) {
                if (string2.equals(ID)) {
                    this.currentRule.setID(this.getText());
                } else if (string2.equals(PREFIX)) {
                    this.currentRule.setPrefix(this.getText());
                } else if (string2.equals(STATUS)) {
                    this.currentRule.setStatus(this.getText());
                } else if (string2.equals(DESTINATION)) {
                    this.currentRule.setDestinationConfig(this.destinationConfig);
                }
            } else if (this.in(REPLICATION_CONFIG, RULE, DESTINATION)) {
                if (string2.equals(BUCKET)) {
                    this.destinationConfig.setBucketQCS(this.getText());
                } else if (string2.equals(STORAGECLASS)) {
                    this.destinationConfig.setStorageClass(this.getText());
                }
            }
        }
    }

    public static class BucketWebsiteConfigurationHandler
    extends AbstractHandler {
        private final BucketWebsiteConfiguration configuration = new BucketWebsiteConfiguration(null);
        private RoutingRuleCondition currentCondition = null;
        private RedirectRule currentRedirectRule = null;
        private RoutingRule currentRoutingRule = null;

        public BucketWebsiteConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("WebsiteConfiguration")) {
                if (string2.equals("RedirectAllRequestsTo")) {
                    this.currentRedirectRule = new RedirectRule();
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules")) {
                if (string2.equals("RoutingRule")) {
                    this.currentRoutingRule = new RoutingRule();
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule")) {
                if (string2.equals("Condition")) {
                    this.currentCondition = new RoutingRuleCondition();
                } else if (string2.equals("Redirect")) {
                    this.currentRedirectRule = new RedirectRule();
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("WebsiteConfiguration")) {
                if (string2.equals("RedirectAllRequestsTo")) {
                    this.configuration.setRedirectAllRequestsTo(this.currentRedirectRule);
                    this.currentRedirectRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "IndexDocument")) {
                if (string2.equals("Suffix")) {
                    this.configuration.setIndexDocumentSuffix(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "ErrorDocument")) {
                if (string2.equals("Key")) {
                    this.configuration.setErrorDocument(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules")) {
                if (string2.equals("RoutingRule")) {
                    this.configuration.getRoutingRules().add(this.currentRoutingRule);
                    this.currentRoutingRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule")) {
                if (string2.equals("Condition")) {
                    this.currentRoutingRule.setCondition(this.currentCondition);
                    this.currentCondition = null;
                } else if (string2.equals("Redirect")) {
                    this.currentRoutingRule.setRedirect(this.currentRedirectRule);
                    this.currentRedirectRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule", "Condition")) {
                if (string2.equals("KeyPrefixEquals")) {
                    this.currentCondition.setKeyPrefixEquals(this.getText());
                } else if (string2.equals("HttpErrorCodeReturnedEquals")) {
                    this.currentCondition.setHttpErrorCodeReturnedEquals(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "RedirectAllRequestsTo") || this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule", "Redirect")) {
                if (string2.equals("Protocol")) {
                    this.currentRedirectRule.setProtocol(this.getText());
                } else if (string2.equals("HostName")) {
                    this.currentRedirectRule.setHostName(this.getText());
                } else if (string2.equals("ReplaceKeyPrefixWith")) {
                    this.currentRedirectRule.setReplaceKeyPrefixWith(this.getText());
                } else if (string2.equals("ReplaceKeyWith")) {
                    this.currentRedirectRule.setReplaceKeyWith(this.getText());
                } else if (string2.equals("HttpRedirectCode")) {
                    this.currentRedirectRule.setHttpRedirectCode(this.getText());
                }
            }
        }
    }

    public static class ListPartsHandler
    extends AbstractHandler {
        private final PartListing result = new PartListing();
        private PartSummary currentPart;
        private Owner currentOwner;

        public PartListing getListPartsResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListPartsResult")) {
                if (string2.equals("Part")) {
                    this.currentPart = new PartSummary();
                } else if (string2.equals("Owner") || string2.equals("Initiator")) {
                    this.currentOwner = new Owner();
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("ListPartsResult")) {
                if (string2.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (string2.equals("Key")) {
                    this.result.setKey(this.getText());
                } else if (string2.equals("UploadId")) {
                    this.result.setUploadId(this.getText());
                } else if (string2.equals("Owner")) {
                    this.result.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (string2.equals("Initiator")) {
                    this.result.setInitiator(this.currentOwner);
                    this.currentOwner = null;
                } else if (string2.equals("StorageClass")) {
                    this.result.setStorageClass(this.getText());
                } else if (string2.equals("PartNumberMarker")) {
                    this.result.setPartNumberMarker(this.parseInteger(this.getText()));
                } else if (string2.equals("NextPartNumberMarker")) {
                    this.result.setNextPartNumberMarker(this.parseInteger(this.getText()));
                } else if (string2.equals("MaxParts")) {
                    this.result.setMaxParts(this.parseInteger(this.getText()));
                } else if (string2.equals("EncodingType")) {
                    this.result.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.getText()));
                } else if (string2.equals("Part")) {
                    this.result.getParts().add(this.currentPart);
                    this.currentPart = null;
                }
            } else if (this.in("ListPartsResult", "Part")) {
                if (string2.equals("PartNumber")) {
                    this.currentPart.setPartNumber(Integer.parseInt(this.getText()));
                } else if (string2.equals("LastModified")) {
                    this.currentPart.setLastModified(DateUtils.parseISO8601Date(this.getText()));
                } else if (string2.equals("ETag")) {
                    this.currentPart.setETag(StringUtils.removeQuotes(this.getText()));
                } else if (string2.equals("Size")) {
                    this.currentPart.setSize(Long.parseLong(this.getText()));
                }
            } else if (this.in("ListPartsResult", "Owner") || this.in("ListPartsResult", "Initiator")) {
                if (string2.equals("ID")) {
                    this.currentOwner.setId(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                }
            }
        }

        private Integer parseInteger(String string) {
            string = XmlResponsesSaxParser.checkForEmptyString(this.getText());
            if (string == null) {
                return null;
            }
            return Integer.parseInt(string);
        }
    }

    public static class ListMultipartUploadsHandler
    extends AbstractHandler {
        private final MultipartUploadListing result = new MultipartUploadListing();
        private MultipartUpload currentMultipartUpload;
        private Owner currentOwner;

        public MultipartUploadListing getListMultipartUploadsResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListMultipartUploadsResult")) {
                if (string2.equals("Upload")) {
                    this.currentMultipartUpload = new MultipartUpload();
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload") && (string2.equals("Owner") || string2.equals("Initiator"))) {
                this.currentOwner = new Owner();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("ListMultipartUploadsResult")) {
                if (string2.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (string2.equals("KeyMarker")) {
                    this.result.setKeyMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("Delimiter")) {
                    this.result.setDelimiter(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("Prefix")) {
                    this.result.setPrefix(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("UploadIdMarker")) {
                    this.result.setUploadIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("NextKeyMarker")) {
                    this.result.setNextKeyMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("NextUploadIdMarker")) {
                    this.result.setNextUploadIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("MaxUploads")) {
                    this.result.setMaxUploads(Integer.parseInt(this.getText()));
                } else if (string2.equals("EncodingType")) {
                    this.result.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.getText()));
                } else if (string2.equals("Upload")) {
                    this.result.getMultipartUploads().add(this.currentMultipartUpload);
                    this.currentMultipartUpload = null;
                }
            } else if (this.in("ListMultipartUploadsResult", "CommonPrefixes")) {
                if (string2.equals("Prefix")) {
                    this.result.getCommonPrefixes().add(this.getText());
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload")) {
                if (string2.equals("Key")) {
                    this.currentMultipartUpload.setKey(this.getText());
                } else if (string2.equals("UploadId")) {
                    this.currentMultipartUpload.setUploadId(this.getText());
                } else if (string2.equals("Owner")) {
                    this.currentMultipartUpload.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (string2.equals("Initiator")) {
                    this.currentMultipartUpload.setInitiator(this.currentOwner);
                    this.currentOwner = null;
                } else if (string2.equals("Initiated")) {
                    this.currentMultipartUpload.setInitiated(DateUtils.parseISO8601Date(this.getText()));
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload", "Owner") || this.in("ListMultipartUploadsResult", "Upload", "Initiator")) {
                if (string2.equals("ID")) {
                    this.currentOwner.setId(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                }
            }
        }
    }

    public static class InitiateMultipartUploadHandler
    extends AbstractHandler {
        private final InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();

        public InitiateMultipartUploadResult getInitiateMultipartUploadResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("InitiateMultipartUploadResult")) {
                if (string2.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (string2.equals("Key")) {
                    this.result.setKey(this.getText());
                } else if (string2.equals("UploadId")) {
                    this.result.setUploadId(this.getText());
                }
            }
        }
    }

    public static class CompleteMultipartUploadHandler
    extends AbstractSSEHandler
    implements ObjectExpirationResult,
    VIDResult {
        private CompleteMultipartUploadResult result;
        private CIUploadResult ciUploadResult = new CIUploadResult();
        private OriginalInfo originalInfo;
        private CIObject ciObject;
        private QRcodeInfo qRcodeInfo;
        private CosServiceException cse;
        private String traceId;
        private String requestId;
        private String errorCode;

        @Override
        public Date getExpirationTime() {
            return this.result == null ? null : this.result.getExpirationTime();
        }

        @Override
        public void setExpirationTime(Date date) {
            if (this.result != null) {
                this.result.setExpirationTime(date);
            }
        }

        @Override
        public String getExpirationTimeRuleId() {
            return this.result == null ? null : this.result.getExpirationTimeRuleId();
        }

        @Override
        public void setExpirationTimeRuleId(String string) {
            if (this.result != null) {
                this.result.setExpirationTimeRuleId(string);
            }
        }

        @Override
        public String getRequestId() {
            return this.result == null ? null : this.result.getRequestId();
        }

        @Override
        public void setRequestId(String string) {
            if (this.result != null) {
                this.result.setRequestId(string);
            }
        }

        @Override
        public String getDateStr() {
            return this.result == null ? null : this.result.getDateStr();
        }

        @Override
        public void setDateStr(String string) {
            if (this.result != null) {
                this.result.setDateStr(string);
            }
        }

        public CompleteMultipartUploadResult getCompleteMultipartUploadResult() {
            return this.result;
        }

        public CosServiceException getCOSException() {
            return this.cse;
        }

        public CIUploadResult getCiUploadResult() {
            return this.ciUploadResult;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.atTopLevel()) {
                if (string2.equals("CompleteMultipartUploadResult")) {
                    this.result = new CompleteMultipartUploadResult();
                    this.originalInfo = new OriginalInfo();
                    this.ciUploadResult.setOriginalInfo(this.originalInfo);
                }
            } else if (this.in("CompleteMultipartUploadResult")) {
                if (string2.equals("ImageInfo")) {
                    this.ciUploadResult.getOriginalInfo().setImageInfo(new ImageInfo());
                } else if (string2.equals("ProcessResults")) {
                    this.ciUploadResult.setProcessResults(new ProcessResults());
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults")) {
                if (string2.equals("Object")) {
                    this.ciObject = new CIObject();
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults", "Object")) {
                if (string2.equals("QRcodeInfo")) {
                    this.qRcodeInfo = new QRcodeInfo();
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults", "Object", "QRcodeInfo") && string2.equals("CodeLocation")) {
                this.qRcodeInfo.setCodeLocation(new CodeLocation());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.atTopLevel()) {
                if (string2.equals("Error") && this.cse != null) {
                    this.cse.setErrorCode(this.errorCode);
                    this.cse.setRequestId(this.requestId);
                    this.cse.setTraceId(this.traceId);
                    this.cse.setStatusCode(200);
                }
            } else if (this.in("Error")) {
                if (string2.equals("Code")) {
                    this.errorCode = this.getText();
                } else if (string2.equals("Message")) {
                    this.cse = new CosServiceException(this.getText());
                } else if (string2.equals("RequestId")) {
                    this.requestId = this.getText();
                } else if (string2.equals("HostId")) {
                    this.traceId = this.getText();
                }
            } else if (this.in("CompleteMultipartUploadResult")) {
                if (string2.equals("Location")) {
                    this.result.setLocation(this.getText());
                    this.originalInfo.setLocation(this.getText());
                } else if (string2.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (string2.equals("Key")) {
                    this.result.setKey(this.getText());
                    this.originalInfo.setKey(this.getText());
                } else if (string2.equals("ETag")) {
                    this.result.setETag(StringUtils.removeQuotes(this.getText()));
                    this.originalInfo.setEtag(StringUtils.removeQuotes(this.getText()));
                }
            } else if (this.in("CompleteMultipartUploadResult", "ImageInfo")) {
                ImageInfo imageInfo = this.ciUploadResult.getOriginalInfo().getImageInfo();
                if (string2.equals("Format")) {
                    imageInfo.setFormat(this.getText());
                } else if (string2.equals("Width")) {
                    imageInfo.setWidth(Integer.parseInt(this.getText()));
                } else if (string2.equals("Height")) {
                    imageInfo.setHeight(Integer.parseInt(this.getText()));
                } else if (string2.equals("Quality")) {
                    imageInfo.setQuality(Integer.parseInt(this.getText()));
                } else if (string2.equals("Ave")) {
                    imageInfo.setAve(this.getText());
                } else if (string2.equals("Orientation")) {
                    imageInfo.setOrientation(Integer.parseInt(this.getText()));
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults")) {
                if (string2.equals("Object")) {
                    if (this.ciUploadResult.getProcessResults().getObjectList() == null) {
                        this.ciUploadResult.getProcessResults().setObjectList(new LinkedList<CIObject>());
                    }
                    this.ciUploadResult.getProcessResults().getObjectList().add(this.ciObject);
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults", "Object")) {
                if (string2.equals("Key")) {
                    this.ciObject.setKey(this.getText());
                } else if (string2.equals("Location")) {
                    this.ciObject.setLocation(this.getText());
                } else if (string2.equals("Format")) {
                    this.ciObject.setFormat(this.getText());
                } else if (string2.equals("Width")) {
                    this.ciObject.setWidth(Integer.parseInt(this.getText()));
                } else if (string2.equals("Height")) {
                    this.ciObject.setHeight(Integer.parseInt(this.getText()));
                } else if (string2.equals("Size")) {
                    this.ciObject.setSize(Integer.parseInt(this.getText()));
                } else if (string2.equals("Quality")) {
                    this.ciObject.setQuality(Integer.parseInt(this.getText()));
                } else if (string2.equals("ETag")) {
                    this.ciObject.setEtag(StringUtils.removeQuotes(this.getText()));
                } else if (string2.equals("CodeStatus")) {
                    this.ciObject.setCodeStatus(Integer.parseInt(this.getText()));
                } else if (string2.equals("QRcodeInfo")) {
                    if (this.ciObject.getQRcodeInfoList() == null) {
                        this.ciObject.setQRcodeInfoList(new LinkedList<QRcodeInfo>());
                    }
                    this.ciObject.getQRcodeInfoList().add(this.qRcodeInfo);
                } else if (string2.equals("WatermarkStatus")) {
                    this.ciObject.setWatermarkStatus(Integer.parseInt(this.getText()));
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults", "Object", "QRcodeInfo")) {
                if (string2.equals("CodeUrl")) {
                    this.qRcodeInfo.setCodeUrl(this.getText());
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults", "Object", "QRcodeInfo", "CodeLocation")) {
                CodeLocation codeLocation = this.qRcodeInfo.getCodeLocation();
                if (codeLocation.getPoints() == null) {
                    codeLocation.setPoints(new LinkedList<String>());
                }
                if (string2.equals("Point")) {
                    codeLocation.getPoints().add(this.getText());
                }
            }
        }

        @Override
        protected ServerSideEncryptionResult sseResult() {
            return this.result;
        }
    }

    public static class BucketVersioningConfigurationHandler
    extends AbstractHandler {
        private final BucketVersioningConfiguration configuration = new BucketVersioningConfiguration();

        public BucketVersioningConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("VersioningConfiguration") && string2.equals("Status")) {
                this.configuration.setStatus(this.getText());
            }
        }
    }

    public static class ListVersionsHandler
    extends AbstractHandler {
        private final VersionListing versionListing = new VersionListing();
        private final boolean shouldSDKDecodeResponse;
        private COSVersionSummary currentVersionSummary;
        private Owner currentOwner;

        public ListVersionsHandler(boolean bl) {
            this.shouldSDKDecodeResponse = bl;
        }

        public VersionListing getListing() {
            return this.versionListing;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListVersionsResult")) {
                if (string2.equals("Version")) {
                    this.currentVersionSummary = new COSVersionSummary();
                    this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                } else if (string2.equals("DeleteMarker")) {
                    this.currentVersionSummary = new COSVersionSummary();
                    this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                    this.currentVersionSummary.setIsDeleteMarker(true);
                }
            } else if ((this.in("ListVersionsResult", "Version") || this.in("ListVersionsResult", "DeleteMarker")) && string2.equals("Owner")) {
                this.currentOwner = new Owner();
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("ListVersionsResult")) {
                if (string2.equals("Name")) {
                    this.versionListing.setBucketName(this.getText());
                } else if (string2.equals("Prefix")) {
                    this.versionListing.setPrefix(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                } else if (string2.equals("KeyMarker")) {
                    this.versionListing.setKeyMarker(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                } else if (string2.equals("VersionIdMarker")) {
                    this.versionListing.setVersionIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("MaxKeys")) {
                    this.versionListing.setMaxKeys(Integer.parseInt(this.getText()));
                } else if (string2.equals("Delimiter")) {
                    this.versionListing.setDelimiter(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                } else if (string2.equals("EncodingType")) {
                    this.versionListing.setEncodingType(this.shouldSDKDecodeResponse ? null : XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (string2.equals("NextKeyMarker")) {
                    this.versionListing.setNextKeyMarker(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                } else if (string2.equals("NextVersionIdMarker")) {
                    this.versionListing.setNextVersionIdMarker(this.getText());
                } else if (string2.equals("IsTruncated")) {
                    this.versionListing.setTruncated("true".equals(this.getText()));
                } else if (string2.equals("Version") || string2.equals("DeleteMarker")) {
                    this.versionListing.getVersionSummaries().add(this.currentVersionSummary);
                    this.currentVersionSummary = null;
                }
            } else if (this.in("ListVersionsResult", "CommonPrefixes")) {
                if (string2.equals("Prefix")) {
                    String string4 = XmlResponsesSaxParser.checkForEmptyString(this.getText());
                    this.versionListing.getCommonPrefixes().add(this.shouldSDKDecodeResponse ? UrlEncoderUtils.urlDecode(string4) : string4);
                }
            } else if (this.in("ListVersionsResult", "Version") || this.in("ListVersionsResult", "DeleteMarker")) {
                if (string2.equals("Key")) {
                    this.currentVersionSummary.setKey(XmlResponsesSaxParser.decodeIfSpecified(this.getText(), this.shouldSDKDecodeResponse));
                } else if (string2.equals("VersionId")) {
                    this.currentVersionSummary.setVersionId(this.getText());
                } else if (string2.equals("IsLatest")) {
                    this.currentVersionSummary.setIsLatest("true".equals(this.getText()));
                } else if (string2.equals("LastModified")) {
                    this.currentVersionSummary.setLastModified(DateUtils.parseISO8601Date(this.getText()));
                } else if (string2.equals("ETag")) {
                    this.currentVersionSummary.setETag(StringUtils.removeQuotes(this.getText()));
                } else if (string2.equals("Size")) {
                    this.currentVersionSummary.setSize(Long.parseLong(this.getText()));
                } else if (string2.equals("Owner")) {
                    this.currentVersionSummary.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (string2.equals("StorageClass")) {
                    this.currentVersionSummary.setStorageClass(this.getText());
                }
            } else if (this.in("ListVersionsResult", "Version", "Owner") || this.in("ListVersionsResult", "DeleteMarker", "Owner")) {
                if (string2.equals("ID")) {
                    this.currentOwner.setId(this.getText());
                } else if (string2.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(this.getText());
                }
            }
        }
    }

    public static class CopyObjectResultHandler
    extends AbstractSSEHandler
    implements ObjectExpirationResult,
    VIDResult {
        private final CopyObjectResult result = new CopyObjectResult();
        private String errorCode = null;
        private String errorMessage = null;
        private String errorRequestId = null;
        private String errorHostId = null;
        private String crc64Ecma;
        private boolean receivedErrorResponse = false;

        @Override
        public void setDateStr(String string) {
            this.result.setDateStr(string);
        }

        @Override
        public String getDateStr() {
            return this.result.getDateStr();
        }

        @Override
        public void setRequestId(String string) {
            this.result.setRequestId(string);
        }

        @Override
        public String getRequestId() {
            return this.result.getRequestId();
        }

        @Override
        protected ServerSideEncryptionResult sseResult() {
            return this.result;
        }

        public Date getLastModified() {
            return this.result.getLastModifiedDate();
        }

        public String getVersionId() {
            return this.result.getVersionId();
        }

        public void setVersionId(String string) {
            this.result.setVersionId(string);
        }

        public String getCrc64Ecma() {
            return this.result.getCrc64Ecma();
        }

        public void setCrc64Ecma(String string) {
            this.result.setCrc64Ecma(string);
        }

        @Override
        public Date getExpirationTime() {
            return this.result.getExpirationTime();
        }

        @Override
        public void setExpirationTime(Date date) {
            this.result.setExpirationTime(date);
        }

        @Override
        public String getExpirationTimeRuleId() {
            return this.result.getExpirationTimeRuleId();
        }

        @Override
        public void setExpirationTimeRuleId(String string) {
            this.result.setExpirationTimeRuleId(string);
        }

        public String getETag() {
            return this.result.getETag();
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorHostId() {
            return this.errorHostId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getErrorRequestId() {
            return this.errorRequestId;
        }

        public boolean isErrorResponse() {
            return this.receivedErrorResponse;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.atTopLevel()) {
                if (string2.equals("CopyObjectResult") || string2.equals("CopyPartResult")) {
                    this.receivedErrorResponse = false;
                } else if (string2.equals("Error")) {
                    this.receivedErrorResponse = true;
                }
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("CopyObjectResult") || this.in("CopyPartResult")) {
                if (!string2.equals("LastModified")) {
                    if (string2.equals("ETag")) {
                        this.result.setETag(StringUtils.removeQuotes(this.getText()));
                    } else if (string2.equals("VersionId")) {
                        this.result.setVersionId(this.getText());
                    } else if (string2.equals("CRC64")) {
                        this.result.setCrc64Ecma(this.getText());
                    }
                }
            } else if (this.in("Error")) {
                if (string2.equals("Code")) {
                    this.errorCode = this.getText();
                } else if (string2.equals("Message")) {
                    this.errorMessage = this.getText();
                } else if (string2.equals("RequestId")) {
                    this.errorRequestId = this.getText();
                } else if (string2.equals("HostId")) {
                    this.errorHostId = this.getText();
                }
            }
        }
    }

    public static class BucketLocationHandler
    extends AbstractHandler {
        private String location = null;

        public String getLocation() {
            return this.location;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.atTopLevel() && string2.equals("LocationConstraint")) {
                String string4 = this.getText();
                this.location = string4.length() == 0 ? null : string4;
            }
        }
    }

    public static class AccessControlListHandler
    extends AbstractHandler {
        private final AccessControlList accessControlList = new AccessControlList();
        private Grantee currentGrantee = null;
        private Permission currentPermission = null;

        public AccessControlList getAccessControlList() {
            return this.accessControlList;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            String string4;
            if (this.in("AccessControlPolicy")) {
                if (string2.equals("Owner")) {
                    this.accessControlList.setOwner(new Owner());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant") && string2.equals("Grantee") && !"Group".equals(string4 = XmlResponsesSaxParser.findAttributeValue("xsi:type", attributes)) && "CanonicalUser".equals(string4)) {
                this.currentGrantee = new UinGrantee(null);
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("AccessControlPolicy", "Owner")) {
                if (string2.equals("ID")) {
                    this.accessControlList.getOwner().setId(this.getText());
                } else if (string2.equals("DisplayName")) {
                    this.accessControlList.getOwner().setDisplayName(this.getText());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList")) {
                if (string2.equals("Grant")) {
                    this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
                    this.currentGrantee = null;
                    this.currentPermission = null;
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant")) {
                if (string2.equals("Permission")) {
                    this.currentPermission = Permission.parsePermission(this.getText());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant", "Grantee")) {
                if (string2.equals("ID")) {
                    this.currentGrantee.setIdentifier(this.getText());
                } else if (string2.equals("URI")) {
                    this.currentGrantee = GroupGrantee.parseGroupGrantee(this.getText());
                } else if (string2.equals("DisplayName")) {
                    ((UinGrantee)this.currentGrantee).setDisplayName(this.getText());
                }
            }
        }
    }

    public static class ImagePersistenceHandler
    extends AbstractHandler {
        private final CIUploadResult ciUploadResult = new CIUploadResult();
        private CIObject ciObject;
        private QRcodeInfo qRcodeInfo;

        public CIUploadResult getCiUploadResult() {
            return this.ciUploadResult;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("UploadResult")) {
                if (string2.equals("OriginalInfo")) {
                    this.ciUploadResult.setOriginalInfo(new OriginalInfo());
                } else if (string2.equals("ProcessResults")) {
                    this.ciUploadResult.setProcessResults(new ProcessResults());
                }
            } else if (this.in("UploadResult", "OriginalInfo")) {
                if (string2.equals("ImageInfo")) {
                    this.ciUploadResult.getOriginalInfo().setImageInfo(new ImageInfo());
                }
            } else if (this.in("UploadResult", "ProcessResults")) {
                if (string2.equals("Object")) {
                    this.ciObject = new CIObject();
                }
            } else if (this.in("UploadResult", "ProcessResults", "Object")) {
                if (string2.equals("QRcodeInfo")) {
                    this.qRcodeInfo = new QRcodeInfo();
                }
            } else if (this.in("UploadResult", "ProcessResults", "Object", "QRcodeInfo") && string2.equals("CodeLocation")) {
                this.qRcodeInfo.setCodeLocation(new CodeLocation());
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("UploadResult", "OriginalInfo")) {
                OriginalInfo originalInfo = this.ciUploadResult.getOriginalInfo();
                if (string2.equals("Key")) {
                    originalInfo.setKey(this.getText());
                } else if (string2.equals("Location")) {
                    originalInfo.setLocation(this.getText());
                } else if (string2.equals("ETag")) {
                    originalInfo.setEtag(StringUtils.removeQuotes(this.getText()));
                }
            } else if (this.in("UploadResult", "OriginalInfo", "ImageInfo")) {
                ImageInfo imageInfo = this.ciUploadResult.getOriginalInfo().getImageInfo();
                if (string2.equals("Format")) {
                    imageInfo.setFormat(this.getText());
                } else if (string2.equals("Width")) {
                    imageInfo.setWidth(Integer.parseInt(this.getText()));
                } else if (string2.equals("Height")) {
                    imageInfo.setHeight(Integer.parseInt(this.getText()));
                } else if (string2.equals("Quality")) {
                    imageInfo.setQuality(Integer.parseInt(this.getText()));
                } else if (string2.equals("Ave")) {
                    imageInfo.setAve(this.getText());
                } else if (string2.equals("Orientation")) {
                    imageInfo.setOrientation(Integer.parseInt(this.getText()));
                }
            } else if (this.in("UploadResult", "ProcessResults")) {
                if (string2.equals("Object")) {
                    if (this.ciUploadResult.getProcessResults().getObjectList() == null) {
                        this.ciUploadResult.getProcessResults().setObjectList(new LinkedList<CIObject>());
                    }
                    this.ciUploadResult.getProcessResults().getObjectList().add(this.ciObject);
                }
            } else if (this.in("UploadResult", "ProcessResults", "Object")) {
                if (string2.equals("Key")) {
                    this.ciObject.setKey(this.getText());
                } else if (string2.equals("Location")) {
                    this.ciObject.setLocation(this.getText());
                } else if (string2.equals("Format")) {
                    this.ciObject.setFormat(this.getText());
                } else if (string2.equals("Width")) {
                    this.ciObject.setWidth(Integer.parseInt(this.getText()));
                } else if (string2.equals("Height")) {
                    this.ciObject.setHeight(Integer.parseInt(this.getText()));
                } else if (string2.equals("Size")) {
                    this.ciObject.setSize(Integer.parseInt(this.getText()));
                } else if (string2.equals("Quality")) {
                    this.ciObject.setQuality(Integer.parseInt(this.getText()));
                } else if (string2.equals("ETag")) {
                    this.ciObject.setEtag(StringUtils.removeQuotes(this.getText()));
                } else if (string2.equals("CodeStatus")) {
                    this.ciObject.setCodeStatus(Integer.parseInt(this.getText()));
                } else if (string2.equals("QRcodeInfo")) {
                    if (this.ciObject.getQRcodeInfoList() == null) {
                        this.ciObject.setQRcodeInfoList(new LinkedList<QRcodeInfo>());
                    }
                    this.ciObject.getQRcodeInfoList().add(this.qRcodeInfo);
                } else if (string2.equals("WatermarkStatus")) {
                    this.ciObject.setWatermarkStatus(Integer.parseInt(this.getText()));
                }
            } else if (this.in("UploadResult", "ProcessResults", "Object", "QRcodeInfo")) {
                if (string2.equals("CodeUrl")) {
                    this.qRcodeInfo.setCodeUrl(this.getText());
                }
            } else if (this.in("UploadResult", "ProcessResults", "Object", "QRcodeInfo", "CodeLocation")) {
                CodeLocation codeLocation = this.qRcodeInfo.getCodeLocation();
                if (codeLocation.getPoints() == null) {
                    codeLocation.setPoints(new LinkedList<String>());
                }
                if (string2.equals("Point")) {
                    codeLocation.getPoints().add(this.getText());
                }
            }
        }
    }

    public static class ListAllMyBucketsHandler
    extends AbstractHandler {
        private final List<Bucket> buckets = new ArrayList<Bucket>();
        private Owner bucketsOwner = null;
        private Bucket currentBucket = null;

        public List<Bucket> getBuckets() {
            return this.buckets;
        }

        public Owner getOwner() {
            return this.bucketsOwner;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListAllMyBucketsResult")) {
                if (string2.equals("Owner")) {
                    this.bucketsOwner = new Owner();
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets") && string2.equals("Bucket")) {
                this.currentBucket = new Bucket();
                this.currentBucket.setOwner(this.bucketsOwner);
            }
        }

        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.in("ListAllMyBucketsResult", "Owner")) {
                if (string2.equals("ID")) {
                    this.bucketsOwner.setId(this.getText());
                } else if (string2.equals("DisplayName")) {
                    this.bucketsOwner.setDisplayName(this.getText());
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets")) {
                if (string2.equals("Bucket")) {
                    this.buckets.add(this.currentBucket);
                    this.currentBucket = null;
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets", "Bucket")) {
                if (string2.equals("Name")) {
                    this.currentBucket.setName(this.getText());
                } else if (string2.equals("CreationDate")) {
                    Date date = DateUtils.parseISO8601Date(this.getText());
                    this.currentBucket.setCreationDate(date);
                } else if (string2.equals("CreateDate")) {
                    Date date = DateUtils.parseISO8601Date(this.getText());
                    this.currentBucket.setCreationDate(date);
                } else if (string2.equals("Location")) {
                    this.currentBucket.setLocation(this.getText());
                } else if (string2.equals("BucketType")) {
                    this.currentBucket.setBucketType(this.getText());
                } else if (string2.equals("Type")) {
                    this.currentBucket.setType(this.getText());
                }
            }
        }
    }

    public static class ListBucketHandler
    extends AbstractHandler {
        private final ObjectListing objectListing = new ObjectListing();
        private final boolean shouldSDKDecodeResponse;
        private COSObjectSummary currentObject = null;
        private Owner currentOwner = null;
        private String lastKey = null;

        public ListBucketHandler(boolean bl) {
            this.shouldSDKDecodeResponse = bl;
        }

        public ObjectListing getObjectListing() {
            return this.objectListing;
        }

        @Override
        protected void doStartElement(String string, String string2, String string3, Attributes attributes) {
            if (this.in("ListBucketResult")) {
                if (string2.equals("Contents")) {
                    this.currentObject = new COSObjectSummary();
                    this.currentObject.setBucketName(this.objectListing.getBucketName());
                }
            } else if (this.in("ListBucketResult", "Contents") && string2.equals("Owner")) {
                this.currentOwner = new Owner();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void doEndElement(String string, String string2, String string3) {
            if (this.atTopLevel()) {
                if (!string2.equals("ListBucketResult") || !this.objectListing.isTruncated() || this.objectListing.getNextMarker() != null) return;
                String string4 = null;
                if (!this.objectListing.getObjectSummaries().isEmpty()) {
                    string4 = this.objectListing.getObjectSummaries().get(this.objectListing.getObjectSummaries().size() - 1).getKey();
                } else if (!this.objectListing.getCommonPrefixes().isEmpty()) {
                    string4 = this.objectListing.getCommonPrefixes().get(this.objectListing.getCommonPrefixes().size() - 1);
                } else {
                    log.error("COS response indicates truncated results, but contains no object summaries or common prefixes.");
                }
                this.objectListing.setNextMarker(string4);
                return;
            } else if (this.in("ListBucketResult")) {
                if (string2.equals("Name")) {
                    this.objectListing.setBucketName(this.getText());
                    if (!log.isDebugEnabled()) return;
                    log.debug("Examining listing for bucket: " + this.objectListing.getBucketName());
                    return;
                } else if (string2.equals("Prefix")) {
                    this.objectListing.setPrefix(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                    return;
                } else if (string2.equals("Marker")) {
                    this.objectListing.setMarker(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                    return;
                } else if (string2.equals("NextMarker")) {
                    this.objectListing.setNextMarker(XmlResponsesSaxParser.decodeIfSpecified(this.getText(), this.shouldSDKDecodeResponse));
                    return;
                } else if (string2.equals("MaxKeys")) {
                    this.objectListing.setMaxKeys(XmlResponsesSaxParser.parseInt(this.getText()));
                    return;
                } else if (string2.equals("Delimiter")) {
                    this.objectListing.setDelimiter(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                    return;
                } else if (string2.equals("EncodingType")) {
                    this.objectListing.setEncodingType(this.shouldSDKDecodeResponse ? null : XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                    return;
                } else if (string2.equals("IsTruncated")) {
                    String string5 = this.getText();
                    if (string5.startsWith("false")) {
                        this.objectListing.setTruncated(false);
                        return;
                    } else {
                        if (!string5.startsWith("true")) throw new IllegalStateException("Invalid value for IsTruncated field: " + string5);
                        this.objectListing.setTruncated(true);
                    }
                    return;
                } else {
                    if (!string2.equals("Contents")) return;
                    this.objectListing.getObjectSummaries().add(this.currentObject);
                    this.currentObject = null;
                }
                return;
            } else if (this.in("ListBucketResult", "Contents")) {
                if (string2.equals("Key")) {
                    this.lastKey = this.getText();
                    this.currentObject.setKey(XmlResponsesSaxParser.decodeIfSpecified(this.lastKey, this.shouldSDKDecodeResponse));
                    return;
                } else if (string2.equals("LastModified")) {
                    this.currentObject.setLastModified(DateUtils.parseISO8601Date(this.getText()));
                    return;
                } else if (string2.equals("ETag")) {
                    this.currentObject.setETag(StringUtils.removeQuotes(this.getText()));
                    return;
                } else if (string2.equals("Size")) {
                    this.currentObject.setSize(XmlResponsesSaxParser.parseLong(this.getText()));
                    return;
                } else if (string2.equals("StorageClass")) {
                    this.currentObject.setStorageClass(this.getText());
                    return;
                } else {
                    if (!string2.equals("Owner")) return;
                    this.currentObject.setOwner(this.currentOwner);
                    this.currentOwner = null;
                }
                return;
            } else if (this.in("ListBucketResult", "Contents", "Owner")) {
                if (string2.equals("ID")) {
                    this.currentOwner.setId(this.getText());
                    return;
                } else {
                    if (!string2.equals("DisplayName")) return;
                    this.currentOwner.setDisplayName(this.getText());
                }
                return;
            } else {
                if (!this.in("ListBucketResult", "CommonPrefixes") || !string2.equals("Prefix")) return;
                this.objectListing.getCommonPrefixes().add(XmlResponsesSaxParser.decodeIfSpecified(this.getText(), this.shouldSDKDecodeResponse));
            }
        }
    }
}

