/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.internal.InputSubstream;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerUtils;
import java.io.File;

public class UploadPartRequestFactory {
    private final String bucketName;
    private final String key;
    private final String uploadId;
    private final long optimalPartSize;
    private final File file;
    private final PutObjectRequest origReq;
    private int partNumber = 1;
    private long offset = 0L;
    private long remainingBytes;
    private SSECustomerKey sseCustomerKey;
    private final int totalNumberOfParts;
    private int trafficLimit = 0;
    private ReleasableInputStream wrappedStream;

    public UploadPartRequestFactory(PutObjectRequest putObjectRequest, String string, long l) {
        this.origReq = putObjectRequest;
        this.uploadId = string;
        this.optimalPartSize = l;
        this.bucketName = putObjectRequest.getBucketName();
        this.key = putObjectRequest.getKey();
        this.file = TransferManagerUtils.getRequestFile(putObjectRequest);
        this.remainingBytes = TransferManagerUtils.getContentLength(putObjectRequest);
        this.sseCustomerKey = putObjectRequest.getSSECustomerKey();
        this.totalNumberOfParts = (int)Math.ceil((double)this.remainingBytes / (double)this.optimalPartSize);
        if (putObjectRequest.getInputStream() != null) {
            this.wrappedStream = ReleasableInputStream.wrap(putObjectRequest.getInputStream());
        }
        this.trafficLimit = putObjectRequest.getTrafficLimit();
    }

    public synchronized boolean hasMoreRequests() {
        return this.remainingBytes > 0L;
    }

    public synchronized UploadPartRequest getNextUploadPartRequest() {
        long l = Math.min(this.optimalPartSize, this.remainingBytes);
        boolean bl = this.remainingBytes - l <= 0L;
        UploadPartRequest uploadPartRequest = null;
        uploadPartRequest = this.wrappedStream != null ? new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withInputStream(new InputSubstream(this.wrappedStream, 0L, l, bl)).withPartNumber(this.partNumber++).withPartSize(l).withTrafficLimit(this.trafficLimit) : new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withFile(this.file).withFileOffset(this.offset).withPartNumber(this.partNumber++).withPartSize(l).withTrafficLimit(this.trafficLimit);
        TransferManager.appendMultipartUserAgent(uploadPartRequest);
        if (this.sseCustomerKey != null) {
            uploadPartRequest.setSSECustomerKey(this.sseCustomerKey);
        }
        TransferManagerUtils.populateEndpointAddr(this.origReq, uploadPartRequest);
        this.offset += l;
        this.remainingBytes -= l;
        uploadPartRequest.setLastPart(bl);
        uploadPartRequest.withGeneralProgressListener(this.origReq.getGeneralProgressListener());
        uploadPartRequest.getRequestClientOptions().setReadLimit(this.origReq.getReadLimit());
        return uploadPartRequest;
    }

    public int getTotalNumberOfParts() {
        return this.totalNumberOfParts;
    }
}

