/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.AbortedException;
import com.qcloud.cos.internal.Releasable;
import com.qcloud.cos.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;

public abstract class SdkInputStream
extends InputStream
implements Releasable {
    protected abstract InputStream getWrappedInputStream();

    protected static boolean shouldAbort() {
        return Thread.interrupted();
    }

    protected final void abortIfNeeded() {
        if (SdkInputStream.shouldAbort()) {
            try {
                this.abort();
            }
            catch (IOException iOException) {
                LogFactory.getLog(this.getClass()).debug("FYI", iOException);
            }
            throw new AbortedException();
        }
    }

    protected void abort() throws IOException {
    }

    @Override
    public void release() {
        IOUtils.closeQuietly(this, null);
        InputStream inputStream2 = this.getWrappedInputStream();
        if (inputStream2 instanceof Releasable) {
            Releasable releasable = (Releasable)((Object)inputStream2);
            releasable.release();
        }
    }
}

