/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.AbortedException;
import com.qcloud.cos.internal.Releasable;
import com.qcloud.cos.internal.SdkIOUtils;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SdkFilterInputStream
extends FilterInputStream
implements Releasable {
    private volatile boolean aborted = false;

    protected SdkFilterInputStream(InputStream inputStream2) {
        super(inputStream2);
    }

    protected final void abortIfNeeded() {
        if (Thread.interrupted()) {
            this.abort();
            throw new AbortedException();
        }
    }

    public void abort() {
        if (this.aborted) {
            return;
        }
        this.aborted = true;
        if (this.in instanceof SdkFilterInputStream) {
            ((SdkFilterInputStream)this.in).abort();
        }
    }

    protected boolean isAborted() {
        return this.aborted;
    }

    @Override
    public int read() throws IOException {
        this.abortIfNeeded();
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.abortIfNeeded();
        return this.in.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        this.abortIfNeeded();
        return this.in.skip(l);
    }

    @Override
    public int available() throws IOException {
        this.abortIfNeeded();
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.abortIfNeeded();
    }

    @Override
    public synchronized void mark(int n) {
        this.abortIfNeeded();
        this.in.mark(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported();
    }

    @Override
    public void release() {
        SdkIOUtils.closeQuietly(this);
        if (this.in instanceof Releasable) {
            Releasable releasable = (Releasable)((Object)this.in);
            releasable.release();
        }
    }
}

