/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.FileLockException;
import com.qcloud.cos.utils.IOUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FileLocks {

    private static final boolean EXTERNAL_LOCK = false;
    private static final Logger log = LoggerFactory.getLogger(FileLocks.class);
    private static final Map<File, RandomAccessFile> lockedFiles = new TreeMap<File, RandomAccessFile>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lock(File file) {
        boolean bl;
        Map<File, RandomAccessFile> map = lockedFiles;
        synchronized (map) {
            if (lockedFiles.containsKey(file)) {
                return false;
            }
        }
        map = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel fileChannel = randomAccessFile.getChannel();
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(randomAccessFile, log);
            throw new FileLockException(exception);
        }
        Map<File, RandomAccessFile> map2 = lockedFiles;
        synchronized (map2) {
            RandomAccessFile randomAccessFile2 = lockedFiles.put(file, randomAccessFile);
            if (randomAccessFile2 == null) {
                bl = true;
            } else {
                bl = false;
                lockedFiles.put(file, randomAccessFile2);
            }
        }
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug("Locked file " + file + " with " + map);
            }
        } else {
            IOUtils.closeQuietly(randomAccessFile, log);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileLocked(File file) {
        Map<File, RandomAccessFile> map = lockedFiles;
        synchronized (map) {
            return lockedFiles.containsKey(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unlock(File file) {
        Map<File, RandomAccessFile> map = lockedFiles;
        synchronized (map) {
            RandomAccessFile randomAccessFile = lockedFiles.get(file);
            if (randomAccessFile == null) {
                return false;
            }
            IOUtils.closeQuietly(randomAccessFile, log);
            lockedFiles.remove(file);
        }
        if (log.isDebugEnabled()) {
            log.debug("Unlocked file " + file);
        }
        return true;
    }
}

