/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.ObjectExpirationHeaderHandler;
import com.qcloud.cos.internal.ObjectRestoreHeaderHandler;
import com.qcloud.cos.internal.ResponseMetadata;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.utils.DateUtils;
import com.qcloud.cos.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCosResponseHandler<T>
implements HttpResponseHandler<CosServiceResponse<T>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCosResponseHandler.class);
    private static final Set<String> ignoredHeaders = new HashSet<String>();

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    protected CosServiceResponse<T> parseResponseMetadata(CosHttpResponse cosHttpResponse) {
        CosServiceResponse cosServiceResponse = new CosServiceResponse();
        String string = cosHttpResponse.getHeaders().get("x-cos-request-id");
        String string2 = cosHttpResponse.getHeaders().get("x-cos-trace-id");
        String string3 = cosHttpResponse.getHeaders().get("x-ci-request-id");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("x-cos-request-id", string);
        hashMap.put("x-cos-trace-id", string2);
        hashMap.put("x-ci-request-id", string3);
        cosServiceResponse.setResponseMetadata(new ResponseMetadata(hashMap));
        return cosServiceResponse;
    }

    protected void populateObjectMetadata(CosHttpResponse cosHttpResponse, ObjectMetadata objectMetadata) {
        for (Map.Entry<String, String> entry : cosHttpResponse.getHeaders().entrySet()) {
            String string = entry.getKey();
            if (StringUtils.beginsWithIgnoreCase(string, "x-cos-meta-")) {
                string = string.substring("x-cos-meta-".length());
                objectMetadata.addUserMetadata(string, entry.getValue());
                continue;
            }
            if (ignoredHeaders.contains(string)) continue;
            if (string.equalsIgnoreCase("Last-Modified")) {
                try {
                    objectMetadata.setHeader(string, DateUtils.parseRFC822Date(entry.getValue()));
                }
                catch (Exception exception) {
                    log.warn("Unable to parse last modified date: " + entry.getValue(), exception);
                }
                continue;
            }
            if (string.equalsIgnoreCase("Content-Length")) {
                try {
                    objectMetadata.setHeader(string, Long.parseLong(entry.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    log.warn("Unable to parse content length: " + entry.getValue(), numberFormatException);
                }
                continue;
            }
            if (string.equalsIgnoreCase("x-cos-delete-marker")) {
                objectMetadata.setDeleteMarker(Boolean.parseBoolean(entry.getValue()));
                continue;
            }
            if (string.equalsIgnoreCase("ETag")) {
                objectMetadata.setETag(StringUtils.removeQuotes(entry.getValue()));
                continue;
            }
            if (string.equalsIgnoreCase("Expires")) {
                try {
                    objectMetadata.setHttpExpiresDate(DateUtils.parseRFC822Date(entry.getValue()));
                }
                catch (Exception exception) {
                    log.warn("Unable to parse http expiration date: " + entry.getValue(), exception);
                }
                continue;
            }
            if (string.equalsIgnoreCase("x-cos-expiration")) {
                new ObjectExpirationHeaderHandler<ObjectMetadata>().handle(objectMetadata, cosHttpResponse);
                continue;
            }
            if (string.equalsIgnoreCase("x-cos-restore")) {
                new ObjectRestoreHeaderHandler<ObjectMetadata>().handle(objectMetadata, cosHttpResponse);
                continue;
            }
            if (string.equalsIgnoreCase("x-cos-file-mode-dir")) {
                objectMetadata.setFileModeDir(true);
                continue;
            }
            objectMetadata.setHeader(string, entry.getValue());
        }
    }

    static {
        ignoredHeaders.add("Server");
        ignoredHeaders.add("x-cos-trace-id");
    }
}

