/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdleConnectionMonitorThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(IdleConnectionMonitorThread.class);
    private final HttpClientConnectionManager connMgr;
    private volatile boolean shutdown;
    private int idleAliveMS;
    private static final int MONITOR_INTERVAL_MS = 2000;

    public IdleConnectionMonitorThread(HttpClientConnectionManager httpClientConnectionManager) {
        this.connMgr = httpClientConnectionManager;
        this.shutdown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    this.wait(2000L);
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(this.idleAliveMS, TimeUnit.MILLISECONDS);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            log.error("interrupt exception occured:", interruptedException);
            return;
        }
        finally {
            this.connMgr.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        IdleConnectionMonitorThread idleConnectionMonitorThread = this;
        synchronized (idleConnectionMonitorThread) {
            this.notifyAll();
        }
    }

    public void setIdleAliveMS(int n) {
        this.idleAliveMS = n;
    }
}

