/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.event;

import com.qcloud.cos.event.DeliveryMode;
import com.qcloud.cos.event.ProgressEvent;
import com.qcloud.cos.exception.CosClientException;

public interface ProgressListener {
    public static final ProgressListener NOOP = new ProgressListener(){

        @Override
        public void progressChanged(ProgressEvent progressEvent) {
        }
    };

    public void progressChanged(ProgressEvent var1);

    public static class ExceptionReporter
    implements DeliveryMode,
    ProgressListener {
        private final ProgressListener listener;
        private final boolean syncCallSafe;
        private volatile Throwable cause;

        public ExceptionReporter(ProgressListener progressListener) {
            if (progressListener == null) {
                throw new IllegalArgumentException();
            }
            this.listener = progressListener;
            if (progressListener instanceof DeliveryMode) {
                DeliveryMode deliveryMode = (DeliveryMode)((Object)progressListener);
                this.syncCallSafe = deliveryMode.isSyncCallSafe();
            } else {
                this.syncCallSafe = false;
            }
        }

        @Override
        public void progressChanged(ProgressEvent progressEvent) {
            if (this.cause != null) {
                return;
            }
            try {
                this.listener.progressChanged(progressEvent);
            }
            catch (Throwable throwable) {
                this.cause = throwable;
            }
        }

        public void throwExceptionIfAny() {
            if (this.cause != null) {
                throw new CosClientException(this.cause);
            }
        }

        public Throwable getCause() {
            return this.cause;
        }

        public static ExceptionReporter wrap(ProgressListener progressListener) {
            return new ExceptionReporter(progressListener);
        }

        @Override
        public boolean isSyncCallSafe() {
            return this.syncCallSafe;
        }
    }
}

