/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.event;

import com.qcloud.cos.event.COSProgressListener;
import com.qcloud.cos.event.DeliveryMode;
import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.transfer.PersistableTransfer;
import java.util.concurrent.Future;
import org.slf4j.LoggerFactory;

public class COSProgressPublisher
extends SDKProgressPublisher {
    public static Future<?> publishTransferPersistable(ProgressListener progressListener, PersistableTransfer persistableTransfer) {
        if (persistableTransfer == null || !(progressListener instanceof COSProgressListener)) {
            return null;
        }
        COSProgressListener cOSProgressListener = (COSProgressListener)progressListener;
        return COSProgressPublisher.deliverEvent(cOSProgressListener, persistableTransfer);
    }

    private static Future<?> deliverEvent(final COSProgressListener cOSProgressListener, final PersistableTransfer persistableTransfer) {
        DeliveryMode deliveryMode;
        if (cOSProgressListener instanceof DeliveryMode && (deliveryMode = (DeliveryMode)((Object)cOSProgressListener)).isSyncCallSafe()) {
            return COSProgressPublisher.quietlyCallListener(cOSProgressListener, persistableTransfer);
        }
        return COSProgressPublisher.setLatestFutureTask(COSProgressPublisher.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                cOSProgressListener.onPersistableTransfer(persistableTransfer);
            }
        }));
    }

    private static Future<?> quietlyCallListener(COSProgressListener cOSProgressListener, PersistableTransfer persistableTransfer) {
        try {
            cOSProgressListener.onPersistableTransfer(persistableTransfer);
        }
        catch (Throwable throwable) {
            LoggerFactory.getLogger(COSProgressPublisher.class).debug("Failure from the event listener", throwable);
        }
        return null;
    }
}

