/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.AuditingResultUtil;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.auditing.AuditingInfo;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingResponse;
import java.util.List;

public class VideoAuditingJobDemo {
    public static void main(String[] stringArray) throws InterruptedException {
        COSClient cOSClient = ClientUtils.getTestClient();
        VideoAuditingJobDemo.describeAuditingJob(cOSClient);
    }

    public static void createVideoAuditingJob(COSClient cOSClient) {
        VideoAuditingRequest videoAuditingRequest = new VideoAuditingRequest();
        videoAuditingRequest.setBucketName("demo-123456789");
        videoAuditingRequest.getInput().setObject("1.mp4");
        videoAuditingRequest.getConf().setDetectType("all");
        videoAuditingRequest.getConf().getSnapshot().setCount("10");
        videoAuditingRequest.getConf().getSnapshot().setMode("Interval");
        videoAuditingRequest.getConf().getSnapshot().setTimeInterval("10");
        VideoAuditingResponse videoAuditingResponse = cOSClient.createVideoAuditingJob(videoAuditingRequest);
        System.out.println(videoAuditingResponse);
    }

    public static void describeAuditingJob(COSClient cOSClient) throws InterruptedException {
        VideoAuditingResponse videoAuditingResponse;
        String string;
        VideoAuditingRequest videoAuditingRequest = new VideoAuditingRequest();
        videoAuditingRequest.setBucketName("demo-123456789");
        videoAuditingRequest.setJobId("av2628fdd21c4d11ecb3fa5254009*****");
        while (true) {
            if ("Success".equalsIgnoreCase(string = (videoAuditingResponse = cOSClient.describeAuditingJob(videoAuditingRequest)).getJobsDetail().getState()) || "Failed".equalsIgnoreCase(string)) break;
            Thread.sleep(100L);
        }
        System.out.println(videoAuditingResponse.getRequestId());
        System.out.println(string);
        System.out.println(videoAuditingResponse.getJobsDetail());
        List<AuditingInfo> list = AuditingResultUtil.getAuditingInfoList(videoAuditingResponse.getJobsDetail());
        System.out.println(list);
    }
}

