/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.AuditingResultUtil;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.auditing.AuditingInfo;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingInputObject;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.BatchImageJobDetail;
import com.qcloud.cos.model.ciModel.auditing.DescribeImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingResponse;
import com.qcloud.cos.transfer.ImageAuditingImpl;
import com.qcloud.cos.transfer.MultipleImageAuditingImpl;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.utils.Jackson;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ImageAuditingDemo {
    public static void main(String[] stringArray) throws InterruptedException {
        COSClient cOSClient = ClientUtils.getTestClient();
        ImageAuditingDemo.imageAuditing(cOSClient);
    }

    public static void imageAuditing(COSClient cOSClient) {
        ImageAuditingRequest imageAuditingRequest = new ImageAuditingRequest();
        imageAuditingRequest.setBucketName("demobucket-1234567890");
        imageAuditingRequest.setObjectKey("1.png");
        imageAuditingRequest.setLargeImageDetect("1");
        imageAuditingRequest.setBizType("a34415d405a001ef15f4855f46e*****");
        ImageAuditingResponse imageAuditingResponse = cOSClient.imageAuditing(imageAuditingRequest);
        System.out.println(Jackson.toJsonString(imageAuditingResponse));
        List<AuditingInfo> list = AuditingResultUtil.getImageInfoList(imageAuditingResponse);
        System.out.println(imageAuditingResponse);
    }

    public static void batchImageAuditing(COSClient cOSClient) {
        BatchImageAuditingRequest batchImageAuditingRequest = new BatchImageAuditingRequest();
        batchImageAuditingRequest.setBucketName("demo-123456789");
        List<BatchImageAuditingInputObject> list = batchImageAuditingRequest.getInputList();
        BatchImageAuditingInputObject batchImageAuditingInputObject = new BatchImageAuditingInputObject();
        batchImageAuditingInputObject.setObject("1.jpg");
        batchImageAuditingInputObject.setDataId("DataId");
        list.add(batchImageAuditingInputObject);
        batchImageAuditingInputObject = new BatchImageAuditingInputObject();
        batchImageAuditingInputObject.setUrl("https://demo-123456789.cos.ap-chongqing.myqcloud.com/1.png");
        batchImageAuditingInputObject.setDataId("DataId");
        list.add(batchImageAuditingInputObject);
        batchImageAuditingRequest.getConf().setDetectType("all");
        BatchImageAuditingResponse batchImageAuditingResponse = cOSClient.batchImageAuditing(batchImageAuditingRequest);
        List<BatchImageJobDetail> list2 = batchImageAuditingResponse.getJobList();
        for (BatchImageJobDetail batchImageJobDetail : list2) {
            List<AuditingInfo> list3 = AuditingResultUtil.getBatchImageInfoList(batchImageJobDetail);
            System.out.println(list3);
        }
    }

    public static void batchPostImageAuditing(COSClient cOSClient) throws InterruptedException {
        ArrayList<ImageAuditingRequest> arrayList = new ArrayList<ImageAuditingRequest>();
        ImageAuditingRequest imageAuditingRequest = new ImageAuditingRequest();
        imageAuditingRequest.setBucketName("demo-1234567890");
        imageAuditingRequest.setObjectKey("1.png");
        arrayList.add(imageAuditingRequest);
        imageAuditingRequest = new ImageAuditingRequest();
        imageAuditingRequest.setBucketName("demo-1234567890");
        imageAuditingRequest.setObjectKey("1.jpg");
        arrayList.add(imageAuditingRequest);
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        MultipleImageAuditingImpl multipleImageAuditingImpl = transferManager.batchPostImageAuditing(arrayList);
        multipleImageAuditingImpl.waitForCompletion();
        List<ImageAuditingImpl> list = multipleImageAuditingImpl.getImageAuditingList();
        for (ImageAuditingImpl imageAuditingImpl : list) {
            System.out.println((Object)imageAuditingImpl.getState());
            System.out.println(imageAuditingImpl.getResponse());
            System.out.println(imageAuditingImpl.getErrMsg());
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void describeAuditingImageJob(COSClient cOSClient) {
        DescribeImageAuditingRequest describeImageAuditingRequest = new DescribeImageAuditingRequest();
        describeImageAuditingRequest.setBucketName("demobucket-1234567890");
        describeImageAuditingRequest.setJobId("si45a4f827badf11ecb72c525400bc****");
        ImageAuditingResponse imageAuditingResponse = cOSClient.describeAuditingImageJob(describeImageAuditingRequest);
        System.out.println(Jackson.toJsonString(imageAuditingResponse));
    }
}

