/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.FileCompressConfig;
import com.qcloud.cos.model.ciModel.job.FileHashCodeConfig;
import com.qcloud.cos.model.ciModel.job.FileProcessJobResponse;
import com.qcloud.cos.model.ciModel.job.FileProcessJobType;
import com.qcloud.cos.model.ciModel.job.FileProcessRequest;
import com.qcloud.cos.model.ciModel.job.FileUnCompressConfig;
import com.qcloud.cos.utils.Jackson;
import java.util.List;

public class FileProcessJobDemo {
    public static void main(String[] stringArray) {
        COSClient cOSClient = ClientUtils.getTestClient();
        FileProcessJobDemo.describeFileProcessJob(cOSClient);
    }

    public static void createFileCompressJob(COSClient cOSClient) {
        FileProcessRequest fileProcessRequest = new FileProcessRequest();
        fileProcessRequest.setBucketName("demo-1234567890");
        fileProcessRequest.setTag(FileProcessJobType.FileCompress);
        FileCompressConfig fileCompressConfig = fileProcessRequest.getOperation().getFileCompressConfig();
        fileCompressConfig.setFormat("zip");
        fileCompressConfig.setFlatten("0");
        List<String> list = fileCompressConfig.getKey();
        list.add("mark/pic-1.jpg");
        list.add("mark/pic-1.pdf");
        fileProcessRequest.setQueueId("p1ff062b35a494cf0ac4b572df22a5650");
        MediaOutputObject mediaOutputObject = fileProcessRequest.getOperation().getOutput();
        mediaOutputObject.setBucket("demo-1234567890");
        mediaOutputObject.setRegion("ap-shanghai");
        mediaOutputObject.setObject("output/demo.zip");
        FileProcessJobResponse fileProcessJobResponse = cOSClient.createFileProcessJob(fileProcessRequest);
        System.out.println(fileProcessJobResponse.getJobDetail().getJobId());
    }

    public static void createFileUncompressJob(COSClient cOSClient) {
        FileProcessRequest fileProcessRequest = new FileProcessRequest();
        fileProcessRequest.setBucketName("demo-1234567890");
        fileProcessRequest.setTag(FileProcessJobType.FileUncompress);
        fileProcessRequest.getInput().setObject("output/demo.zip");
        FileUnCompressConfig fileUnCompressConfig = fileProcessRequest.getOperation().getFileUnCompressConfig();
        fileUnCompressConfig.setPrefix("output/");
        fileUnCompressConfig.setPrefixReplaced("1");
        fileProcessRequest.setQueueId("p1ff062b35a494cf0ac4b572df22a5650");
        MediaOutputObject mediaOutputObject = fileProcessRequest.getOperation().getOutput();
        mediaOutputObject.setBucket("demo-1234567890");
        mediaOutputObject.setRegion("ap-shanghai");
        FileProcessJobResponse fileProcessJobResponse = cOSClient.createFileProcessJob(fileProcessRequest);
        System.out.println(fileProcessJobResponse.getJobDetail().getJobId());
    }

    public static void createFileHashCodeJob(COSClient cOSClient) {
        FileProcessRequest fileProcessRequest = new FileProcessRequest();
        fileProcessRequest.setBucketName("demo-1234567890");
        fileProcessRequest.setTag(FileProcessJobType.FileHashCode);
        fileProcessRequest.getInput().setObject("input/1.mp4");
        FileHashCodeConfig fileHashCodeConfig = fileProcessRequest.getOperation().getFileHashCodeConfig();
        fileHashCodeConfig.setType("MD5");
        fileHashCodeConfig.setAddToHeader("true");
        fileProcessRequest.setQueueId("p1ff062b35a494cf0ac4b572df22a5650");
        FileProcessJobResponse fileProcessJobResponse = cOSClient.createFileProcessJob(fileProcessRequest);
        System.out.println(fileProcessJobResponse.getJobDetail().getJobId());
    }

    public static void describeFileProcessJob(COSClient cOSClient) {
        FileProcessRequest fileProcessRequest = new FileProcessRequest();
        fileProcessRequest.setBucketName("demo-1234567890");
        fileProcessRequest.setJobId("fda7eb1607b8411ed8c182156726*****");
        FileProcessJobResponse fileProcessJobResponse = cOSClient.describeFileProcessJob(fileProcessRequest);
        System.out.println(Jackson.toJsonString(fileProcessJobResponse));
    }
}

