/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.internal.CIServiceRequest;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.DocHtmlRequest;
import com.qcloud.cos.model.ciModel.job.DocJobDetail;
import com.qcloud.cos.model.ciModel.job.DocJobListRequest;
import com.qcloud.cos.model.ciModel.job.DocJobListResponse;
import com.qcloud.cos.model.ciModel.job.DocJobObject;
import com.qcloud.cos.model.ciModel.job.DocJobRequest;
import com.qcloud.cos.model.ciModel.job.DocJobResponse;
import com.qcloud.cos.model.ciModel.job.DocProcessObject;
import com.qcloud.cos.model.ciModel.queue.DocListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.DocQueueRequest;
import com.qcloud.cos.model.ciModel.queue.MediaQueueObject;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;

public class DocJobDemo {
    public static void main(String[] stringArray) throws MalformedURLException, URISyntaxException, InterruptedException {
        COSClient cOSClient = ClientUtils.getTestClient();
        DocJobDemo.createDocJobs(cOSClient);
    }

    public static void createDocJobs(COSClient cOSClient) {
        DocJobRequest docJobRequest = new DocJobRequest();
        docJobRequest.setBucketName("examplebucket-1250000000");
        DocJobObject docJobObject = docJobRequest.getDocJobObject();
        docJobObject.setTag("DocProcess");
        docJobObject.getInput().setObject("demo.docx");
        docJobObject.setQueueId("pc02270c617ae4b6d9b0a52cb1c*****");
        DocProcessObject docProcessObject = docJobObject.getOperation().getDocProcessObject();
        docProcessObject.setQuality("100");
        docProcessObject.setZoom("100");
        docProcessObject.setStartPage("1");
        docProcessObject.setEndPage("3");
        docProcessObject.setTgtType("png");
        docProcessObject.setDocPassword("123");
        MediaOutputObject mediaOutputObject = docJobObject.getOperation().getOutput();
        mediaOutputObject.setRegion("ap-chongqing");
        mediaOutputObject.setBucket("examplebucket-1250000000");
        mediaOutputObject.setObject("mark/pic-${Page}.jpg");
        DocJobResponse docJobResponse = cOSClient.createDocProcessJobs(docJobRequest);
        System.out.println(docJobResponse);
    }

    public static void describeDocProcessJob(COSClient cOSClient) {
        DocJobRequest docJobRequest = new DocJobRequest();
        docJobRequest.setBucketName("examplebucket-1250000000");
        docJobRequest.setJobId("d75b6ea083df711eb8d09476dfb8*****");
        DocJobResponse docJobResponse = cOSClient.describeDocProcessJob(docJobRequest);
        System.out.println(docJobResponse);
    }

    public static void describeDocProcessJobs(COSClient cOSClient) {
        DocJobListRequest docJobListRequest = new DocJobListRequest();
        docJobListRequest.setBucketName("examplebucket-1250000000");
        docJobListRequest.setQueueId("pc02270c617ae4b6d9b0a52cb1c*****");
        docJobListRequest.setTag("DocProcess");
        docJobListRequest.setStartCreationTime("2020-12-10T16:20:07+0800");
        DocJobListResponse docJobListResponse = cOSClient.describeDocProcessJobs(docJobListRequest);
        for (DocJobDetail docJobDetail : docJobListResponse.getDocJobDetailList()) {
            System.out.println(docJobDetail);
        }
    }

    public static void generateDocPreviewUrl(COSClient cOSClient) throws URISyntaxException {
        DocHtmlRequest docHtmlRequest = new DocHtmlRequest();
        docHtmlRequest.setBucketName("demo-123456789");
        docHtmlRequest.setDstType(DocHtmlRequest.DocType.html);
        docHtmlRequest.setObjectKey("1.pptx");
        String string = cOSClient.GenerateDocPreviewUrl(docHtmlRequest);
        System.out.println(string);
    }

    public static void processDocJob(COSClient cOSClient) throws InterruptedException {
        DocJobResponse docJobResponse;
        String string = "demo-123456789";
        DocQueueRequest docQueueRequest = new DocQueueRequest();
        docQueueRequest.setBucketName(string);
        DocListQueueResponse docListQueueResponse = cOSClient.describeDocProcessQueues(docQueueRequest);
        List<MediaQueueObject> list = docListQueueResponse.getQueueList();
        String string2 = "";
        if (list.size() == 0) {
            System.out.println("\u83b7\u53d6\u961f\u5217\u5931\u8d25");
            return;
        }
        CIServiceRequest cIServiceRequest = list.get(0);
        string2 = ((MediaQueueObject)cIServiceRequest).getQueueId();
        cIServiceRequest = new DocJobRequest();
        ((DocJobRequest)cIServiceRequest).setBucketName(string);
        DocJobObject docJobObject = ((DocJobRequest)cIServiceRequest).getDocJobObject();
        docJobObject.setTag("DocProcess");
        docJobObject.getInput().setObject("1.pdf");
        docJobObject.setQueueId(string2);
        DocProcessObject docProcessObject = docJobObject.getOperation().getDocProcessObject();
        docProcessObject.setQuality("100");
        docProcessObject.setZoom("100");
        docProcessObject.setEndPage("-1");
        docProcessObject.setTgtType("jpg");
        MediaOutputObject mediaOutputObject = docJobObject.getOperation().getOutput();
        mediaOutputObject.setRegion(cOSClient.getClientConfig().getRegion().getRegionName());
        mediaOutputObject.setBucket(string);
        mediaOutputObject.setObject("demo/pic-${Number}.jpg");
        DocJobResponse docJobResponse2 = cOSClient.createDocProcessJobs((DocJobRequest)cIServiceRequest);
        DocJobRequest docJobRequest = new DocJobRequest();
        docJobRequest.setBucketName(string);
        String string3 = docJobResponse2.getJobsDetail().getJobId();
        docJobRequest.setJobId(string3);
        while (true) {
            String string4;
            if ("Success".equalsIgnoreCase(string4 = (docJobResponse = cOSClient.describeDocProcessJob(docJobRequest)).getJobsDetail().getState()) || "Failed".equalsIgnoreCase(string4)) break;
            Thread.sleep(500L);
        }
        System.out.println(docJobResponse);
    }
}

