/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.DeleteBucketInventoryConfigurationRequest;
import com.qcloud.cos.model.GetBucketInventoryConfigurationResult;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsRequest;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsResult;
import com.qcloud.cos.model.SetBucketInventoryConfigurationRequest;
import com.qcloud.cos.model.inventory.InventoryConfiguration;
import com.qcloud.cos.model.inventory.InventoryCosBucketDestination;
import com.qcloud.cos.model.inventory.InventoryDestination;
import com.qcloud.cos.model.inventory.InventoryFilter;
import com.qcloud.cos.model.inventory.InventoryFormat;
import com.qcloud.cos.model.inventory.InventoryFrequency;
import com.qcloud.cos.model.inventory.InventoryIncludedObjectVersions;
import com.qcloud.cos.model.inventory.InventoryOptionalField;
import com.qcloud.cos.model.inventory.InventoryPrefixPredicate;
import com.qcloud.cos.model.inventory.InventorySchedule;
import com.qcloud.cos.model.inventory.ServerSideEncryptionCOS;
import com.qcloud.cos.region.Region;
import java.util.LinkedList;

public class BucketInventoryDemo {
    public static void SetGetDeleteBucketInventoryDemo() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        InventoryConfiguration inventoryConfiguration = new InventoryConfiguration();
        InventoryCosBucketDestination inventoryCosBucketDestination = new InventoryCosBucketDestination();
        inventoryCosBucketDestination.setAccountId("2779643970");
        inventoryCosBucketDestination.setBucketArn("qcs::cos:ap-guangzhou::mybucket-1251668577");
        inventoryCosBucketDestination.setEncryption(new ServerSideEncryptionCOS());
        inventoryCosBucketDestination.setFormat(InventoryFormat.CSV);
        inventoryCosBucketDestination.setPrefix("inventory-output");
        InventoryDestination inventoryDestination = new InventoryDestination();
        inventoryDestination.setCosBucketDestination(inventoryCosBucketDestination);
        inventoryConfiguration.setDestination(inventoryDestination);
        inventoryConfiguration.setEnabled(true);
        inventoryConfiguration.setId("1");
        InventorySchedule inventorySchedule = new InventorySchedule();
        inventorySchedule.setFrequency(InventoryFrequency.Daily);
        inventoryConfiguration.setSchedule(inventorySchedule);
        InventoryPrefixPredicate inventoryPrefixPredicate = new InventoryPrefixPredicate("test/");
        inventoryConfiguration.setInventoryFilter(new InventoryFilter(inventoryPrefixPredicate));
        inventoryConfiguration.setIncludedObjectVersions(InventoryIncludedObjectVersions.All);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(InventoryOptionalField.Size.toString());
        linkedList.add(InventoryOptionalField.LastModifiedDate.toString());
        inventoryConfiguration.setOptionalFields(linkedList);
        SetBucketInventoryConfigurationRequest setBucketInventoryConfigurationRequest = new SetBucketInventoryConfigurationRequest();
        setBucketInventoryConfigurationRequest.setBucketName(string);
        setBucketInventoryConfigurationRequest.setInventoryConfiguration(inventoryConfiguration);
        cOSClient.setBucketInventoryConfiguration(setBucketInventoryConfigurationRequest);
        inventoryConfiguration.setId("2");
        inventorySchedule.setFrequency(InventoryFrequency.Weekly);
        cOSClient.setBucketInventoryConfiguration(setBucketInventoryConfigurationRequest);
        GetBucketInventoryConfigurationResult getBucketInventoryConfigurationResult = cOSClient.getBucketInventoryConfiguration(string, "1");
        ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest = new ListBucketInventoryConfigurationsRequest();
        listBucketInventoryConfigurationsRequest.setBucketName(string);
        ListBucketInventoryConfigurationsResult listBucketInventoryConfigurationsResult = cOSClient.listBucketInventoryConfigurations(listBucketInventoryConfigurationsRequest);
        DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest = new DeleteBucketInventoryConfigurationRequest();
        deleteBucketInventoryConfigurationRequest.setBucketName(string);
        deleteBucketInventoryConfigurationRequest.setId("1");
        cOSClient.deleteBucketInventoryConfiguration(deleteBucketInventoryConfigurationRequest);
    }

    public static void main(String[] stringArray) {
        BucketInventoryDemo.SetGetDeleteBucketInventoryDemo();
    }
}

