/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.qcloud.cos.auth.ConnectionUtils;
import com.qcloud.cos.auth.CredentialsEndpointRetryParameters;
import com.qcloud.cos.auth.CredentialsEndpointRetryPolicy;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.utils.IOUtils;
import com.qcloud.cos.utils.Jackson;
import com.qcloud.cos.utils.VersionInfoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceCredentialsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceCredentialsUtils.class);
    private static InstanceCredentialsUtils instance = new InstanceCredentialsUtils(ConnectionUtils.getInstance());
    private static final String USER_AGENT = VersionInfoUtils.getUserAgent();
    private final ConnectionUtils connectionUtils;

    private InstanceCredentialsUtils(ConnectionUtils connectionUtils) {
        this.connectionUtils = connectionUtils;
    }

    public static InstanceCredentialsUtils getInstance() {
        return instance;
    }

    public String readResource(URI uRI) throws IOException {
        return this.readResource(uRI, CredentialsEndpointRetryPolicy.NO_RETRY_POLICY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readResource(URI uRI, CredentialsEndpointRetryPolicy credentialsEndpointRetryPolicy, Map<String, String> map) throws IOException {
        int n = 0;
        InputStream inputStream2 = null;
        Map<String, String> map2 = this.addDefaultHeader(map);
        while (true) {
            block15: {
                String string;
                int n2;
                HttpURLConnection httpURLConnection;
                block14: {
                    httpURLConnection = this.connectionUtils.connectToEndpoint(uRI, map2);
                    n2 = httpURLConnection.getResponseCode();
                    if (n2 != 200) break block14;
                    inputStream2 = httpURLConnection.getInputStream();
                    string = IOUtils.toString(inputStream2);
                    IOUtils.closeQuietly(inputStream2, LOG);
                    return string;
                }
                try {
                    Object object;
                    if (n2 == 404) {
                        string = "The requested metadata is not found at " + httpURLConnection.getURL();
                        LOG.error(string);
                        throw new CosClientException(string);
                    }
                    LOG.error("The response status code is:" + n2);
                    inputStream2 = httpURLConnection.getErrorStream();
                    string = null;
                    String string2 = null;
                    if (null != inputStream2) {
                        object = IOUtils.toString(inputStream2);
                        LOG.error("errorResponse:" + (String)object);
                        try {
                            JsonNode jsonNode = Jackson.jsonNodeOf((String)object);
                            JsonNode jsonNode2 = jsonNode.get("code");
                            JsonNode jsonNode3 = jsonNode.get("message");
                            if (null != jsonNode2) {
                                string2 = jsonNode2.asText();
                            }
                            if (null != jsonNode3) {
                                string = jsonNode3.asText();
                            }
                        }
                        catch (Exception exception) {
                            LOG.error("Unable to parse errorResponse:" + (String)object, exception);
                        }
                    }
                    if (credentialsEndpointRetryPolicy.shouldRetry(n++, CredentialsEndpointRetryParameters.builder().withStatusCode(n2).build())) break block15;
                    object = new CosServiceException(httpURLConnection.getResponseMessage());
                    if (null != string) {
                        ((CosServiceException)object).setErrorMessage(string);
                    }
                    if (null != string2) {
                        ((CosServiceException)object).setErrorCode(string2);
                    }
                    throw object;
                }
                catch (IOException iOException) {
                    block16: {
                        try {
                            LOG.error("An IOException occurred, service endpoint:" + uRI + ", exception:", iOException);
                            if (credentialsEndpointRetryPolicy.shouldRetry(n++, CredentialsEndpointRetryParameters.builder().withException(iOException).build())) break block16;
                            throw iOException;
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(inputStream2, LOG);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly(inputStream2, LOG);
                    continue;
                }
            }
            IOUtils.closeQuietly(inputStream2, LOG);
            continue;
            break;
        }
    }

    private Map<String, String> addDefaultHeader(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (map != null) {
            hashMap.putAll(map);
        }
        this.putIfAbsent(hashMap, "User-Agent", USER_AGENT);
        this.putIfAbsent(hashMap, "Accept", "*/*");
        this.putIfAbsent(hashMap, "Connection", "keep-alive");
        return hashMap;
    }

    private <K, V> void putIfAbsent(Map<K, V> map, K k, V v) {
        if (map.get(k) == null) {
            map.put(k, v);
        }
    }
}

