/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.COSEncryption;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.internal.COSDirect;
import com.qcloud.cos.internal.crypto.COSCryptoModule;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoModuleDispatcher;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.qcloud.cos.internal.crypto.TencentCloudKMSClient;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectId;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.DeleteObjectRequest;
import com.qcloud.cos.model.EncryptedInitiateMultipartUploadRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.InstructionFileId;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutInstructionFileRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import java.io.File;

public class COSEncryptionClient
extends COSClient
implements COSEncryption {
    private final COSCryptoModule crypto;
    private final boolean isKMSClientInternal;
    private final QCLOUDKMS kms;

    public COSEncryptionClient(COSCredentialsProvider cOSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfig clientConfig, CryptoConfiguration cryptoConfiguration) {
        this(null, cOSCredentialsProvider, encryptionMaterialsProvider, clientConfig, cryptoConfiguration);
    }

    public COSEncryptionClient(QCLOUDKMS qCLOUDKMS, COSCredentialsProvider cOSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfig clientConfig, CryptoConfiguration cryptoConfiguration) {
        super(cOSCredentialsProvider.getCredentials(), clientConfig);
        this.assertParameterNotNull(encryptionMaterialsProvider, "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(cryptoConfiguration, "CryptoConfiguration parameter must not be null.");
        this.isKMSClientInternal = qCLOUDKMS == null;
        this.kms = this.isKMSClientInternal ? this.newTencentCloudKMSClient(cOSCredentialsProvider, clientConfig, cryptoConfiguration) : qCLOUDKMS;
        this.crypto = new CryptoModuleDispatcher(this.kms, new COSDirectImpl(), cOSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
    }

    private TencentCloudKMSClient newTencentCloudKMSClient(COSCredentialsProvider cOSCredentialsProvider, ClientConfig clientConfig, CryptoConfiguration cryptoConfiguration) {
        String string = cryptoConfiguration.getKmsRegion();
        if (string == null) {
            string = clientConfig.getRegion().getRegionName();
        }
        TencentCloudKMSClient tencentCloudKMSClient = new TencentCloudKMSClient(cOSCredentialsProvider, string);
        return tencentCloudKMSClient;
    }

    private void assertParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) {
        return this.crypto.putObjectSecurely(putObjectRequest.clone());
    }

    @Override
    public COSObject getObject(GetObjectRequest getObjectRequest) {
        return this.crypto.getObjectSecurely(getObjectRequest);
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) {
        return this.crypto.getObjectSecurely(getObjectRequest, file);
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) {
        super.deleteObject(deleteObjectRequest);
        InstructionFileId instructionFileId = new COSObjectId(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey()).instructionFileId();
        DeleteObjectRequest deleteObjectRequest2 = (DeleteObjectRequest)deleteObjectRequest.clone();
        deleteObjectRequest2.withBucketName(instructionFileId.getBucket()).withKey(instructionFileId.getKey());
        super.deleteObject(deleteObjectRequest2);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        return this.crypto.completeMultipartUploadSecurely(completeMultipartUploadRequest);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        boolean bl = true;
        if (initiateMultipartUploadRequest instanceof EncryptedInitiateMultipartUploadRequest) {
            EncryptedInitiateMultipartUploadRequest encryptedInitiateMultipartUploadRequest = (EncryptedInitiateMultipartUploadRequest)initiateMultipartUploadRequest;
            bl = encryptedInitiateMultipartUploadRequest.isCreateEncryptionMaterial();
        }
        return bl ? this.crypto.initiateMultipartUploadSecurely(initiateMultipartUploadRequest) : super.initiateMultipartUpload(initiateMultipartUploadRequest);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws CosClientException, CosServiceException {
        return this.crypto.uploadPartSecurely(uploadPartRequest);
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        return this.crypto.copyPartSecurely(copyPartRequest);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        this.crypto.abortMultipartUploadSecurely(abortMultipartUploadRequest);
    }

    public PutObjectResult putInstructionFile(PutInstructionFileRequest putInstructionFileRequest) {
        return this.crypto.putInstructionFileSecurely(putInstructionFileRequest);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.isKMSClientInternal) {
            this.kms.shutdown();
        }
    }

    private final class COSDirectImpl
    extends COSDirect {
        private COSDirectImpl() {
        }

        @Override
        public PutObjectResult putObject(PutObjectRequest putObjectRequest) {
            return COSEncryptionClient.super.putObject(putObjectRequest);
        }

        @Override
        public COSObject getObject(GetObjectRequest getObjectRequest) {
            return COSEncryptionClient.super.getObject(getObjectRequest);
        }

        @Override
        public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) {
            return COSEncryptionClient.super.getObject(getObjectRequest, file);
        }

        @Override
        public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
            return COSEncryptionClient.super.completeMultipartUpload(completeMultipartUploadRequest);
        }

        @Override
        public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
            return COSEncryptionClient.super.initiateMultipartUpload(initiateMultipartUploadRequest);
        }

        @Override
        public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws CosClientException, CosServiceException {
            return COSEncryptionClient.super.uploadPart(uploadPartRequest);
        }

        @Override
        public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
            return COSEncryptionClient.super.copyPart(copyPartRequest);
        }

        @Override
        public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
            COSEncryptionClient.super.abortMultipartUpload(abortMultipartUploadRequest);
        }
    }
}

