/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.qcloud.cos.COS;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.auth.COSSessionCredentials;
import com.qcloud.cos.auth.COSSigner;
import com.qcloud.cos.auth.COSStaticCredentialsProvider;
import com.qcloud.cos.endpoint.CIPicRegionEndpointBuilder;
import com.qcloud.cos.endpoint.CIRegionEndpointBuilder;
import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.endpoint.RegionEndpointBuilder;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.MultiObjectDeleteException;
import com.qcloud.cos.exception.Throwables;
import com.qcloud.cos.http.CosHttpClient;
import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.http.DefaultCosHttpClient;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.internal.BucketNameUtils;
import com.qcloud.cos.internal.CIGetSnapshotResponseHandler;
import com.qcloud.cos.internal.CIPicServiceRequest;
import com.qcloud.cos.internal.CIServiceRequest;
import com.qcloud.cos.internal.CIWorkflowServiceRequest;
import com.qcloud.cos.internal.COSDefaultAclHeaderHandler;
import com.qcloud.cos.internal.COSObjectResponseHandler;
import com.qcloud.cos.internal.COSStringResponseHandler;
import com.qcloud.cos.internal.COSVersionHeaderHandler;
import com.qcloud.cos.internal.COSXmlResponseHandler;
import com.qcloud.cos.internal.CosMetadataResponseHandler;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.DeleteObjectTaggingHeaderHandler;
import com.qcloud.cos.internal.DeleteObjectsResponse;
import com.qcloud.cos.internal.DigestValidationInputStream;
import com.qcloud.cos.internal.GetObjectTaggingResponseHeaderHandler;
import com.qcloud.cos.internal.HeaderHandler;
import com.qcloud.cos.internal.InputSubstream;
import com.qcloud.cos.internal.LengthCheckInputStream;
import com.qcloud.cos.internal.MD5DigestCalculatingInputStream;
import com.qcloud.cos.internal.MultiObjectDeleteXmlFactory;
import com.qcloud.cos.internal.ObjectExpirationHeaderHandler;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.internal.RequestXmlFactory;
import com.qcloud.cos.internal.ResettableInputStream;
import com.qcloud.cos.internal.ResponseHeaderHandlerChain;
import com.qcloud.cos.internal.SSEResultBase;
import com.qcloud.cos.internal.ServerSideEncryptionHeaderHandler;
import com.qcloud.cos.internal.ServiceClientHolderInputStream;
import com.qcloud.cos.internal.SetObjectTaggingResponseHeaderHandler;
import com.qcloud.cos.internal.SkipMd5CheckStrategy;
import com.qcloud.cos.internal.Unmarshaller;
import com.qcloud.cos.internal.Unmarshallers;
import com.qcloud.cos.internal.VIDResultHandler;
import com.qcloud.cos.internal.VoidCosResponseHandler;
import com.qcloud.cos.internal.XmlResponsesSaxParser;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.AclXmlFactory;
import com.qcloud.cos.model.AppendObjectRequest;
import com.qcloud.cos.model.AppendObjectResult;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.BucketConfigurationXmlFactory;
import com.qcloud.cos.model.BucketCrossOriginConfiguration;
import com.qcloud.cos.model.BucketDomainConfiguration;
import com.qcloud.cos.model.BucketIntelligentTierConfiguration;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.BucketLoggingConfiguration;
import com.qcloud.cos.model.BucketPolicy;
import com.qcloud.cos.model.BucketRefererConfiguration;
import com.qcloud.cos.model.BucketReplicationConfiguration;
import com.qcloud.cos.model.BucketTaggingConfiguration;
import com.qcloud.cos.model.BucketVersioningConfiguration;
import com.qcloud.cos.model.BucketWebsiteConfiguration;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.CosDataSource;
import com.qcloud.cos.model.CreateBucketRequest;
import com.qcloud.cos.model.DecompressionRequest;
import com.qcloud.cos.model.DecompressionResult;
import com.qcloud.cos.model.DeleteBucketCrossOriginConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketDomainConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketInventoryConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketInventoryConfigurationResult;
import com.qcloud.cos.model.DeleteBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketPolicyRequest;
import com.qcloud.cos.model.DeleteBucketReplicationConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketRequest;
import com.qcloud.cos.model.DeleteBucketTaggingConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketWebsiteConfigurationRequest;
import com.qcloud.cos.model.DeleteObjectRequest;
import com.qcloud.cos.model.DeleteObjectTaggingRequest;
import com.qcloud.cos.model.DeleteObjectTaggingResult;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.DeleteObjectsResult;
import com.qcloud.cos.model.DeleteVersionRequest;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.qcloud.cos.model.GenericBucketRequest;
import com.qcloud.cos.model.GetBucketAclRequest;
import com.qcloud.cos.model.GetBucketCrossOriginConfigurationRequest;
import com.qcloud.cos.model.GetBucketDomainConfigurationRequest;
import com.qcloud.cos.model.GetBucketIntelligentTierConfigurationRequest;
import com.qcloud.cos.model.GetBucketInventoryConfigurationRequest;
import com.qcloud.cos.model.GetBucketInventoryConfigurationResult;
import com.qcloud.cos.model.GetBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.GetBucketLocationRequest;
import com.qcloud.cos.model.GetBucketLoggingConfigurationRequest;
import com.qcloud.cos.model.GetBucketPolicyRequest;
import com.qcloud.cos.model.GetBucketRefererConfigurationRequest;
import com.qcloud.cos.model.GetBucketReplicationConfigurationRequest;
import com.qcloud.cos.model.GetBucketTaggingConfigurationRequest;
import com.qcloud.cos.model.GetBucketVersioningConfigurationRequest;
import com.qcloud.cos.model.GetBucketWebsiteConfigurationRequest;
import com.qcloud.cos.model.GetObjectAclRequest;
import com.qcloud.cos.model.GetObjectMetadataRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.GetObjectTaggingRequest;
import com.qcloud.cos.model.GetObjectTaggingResult;
import com.qcloud.cos.model.GetSymlinkRequest;
import com.qcloud.cos.model.GetSymlinkResult;
import com.qcloud.cos.model.GetSymlinkResultHandler;
import com.qcloud.cos.model.Grant;
import com.qcloud.cos.model.Grantee;
import com.qcloud.cos.model.HeadBucketRequest;
import com.qcloud.cos.model.HeadBucketResult;
import com.qcloud.cos.model.HeadBucketResultHandler;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsRequest;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsResult;
import com.qcloud.cos.model.ListBucketsRequest;
import com.qcloud.cos.model.ListJobsResult;
import com.qcloud.cos.model.ListMultipartUploadsRequest;
import com.qcloud.cos.model.ListNextBatchOfObjectsRequest;
import com.qcloud.cos.model.ListNextBatchOfVersionsRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ListPartsRequest;
import com.qcloud.cos.model.ListVersionsRequest;
import com.qcloud.cos.model.MultipartUploadListing;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.Permission;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.PutSymlinkRequest;
import com.qcloud.cos.model.PutSymlinkResult;
import com.qcloud.cos.model.PutSymlinkResultHandler;
import com.qcloud.cos.model.RenameRequest;
import com.qcloud.cos.model.ResponseHeaderOverrides;
import com.qcloud.cos.model.RestoreObjectRequest;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.SelectObjectContentEventStream;
import com.qcloud.cos.model.SelectObjectContentRequest;
import com.qcloud.cos.model.SelectObjectContentResult;
import com.qcloud.cos.model.SetBucketAclRequest;
import com.qcloud.cos.model.SetBucketCrossOriginConfigurationRequest;
import com.qcloud.cos.model.SetBucketDomainConfigurationRequest;
import com.qcloud.cos.model.SetBucketIntelligentTierConfigurationRequest;
import com.qcloud.cos.model.SetBucketInventoryConfigurationRequest;
import com.qcloud.cos.model.SetBucketInventoryConfigurationResult;
import com.qcloud.cos.model.SetBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.SetBucketLoggingConfigurationRequest;
import com.qcloud.cos.model.SetBucketPolicyRequest;
import com.qcloud.cos.model.SetBucketRefererConfigurationRequest;
import com.qcloud.cos.model.SetBucketReplicationConfigurationRequest;
import com.qcloud.cos.model.SetBucketTaggingConfigurationRequest;
import com.qcloud.cos.model.SetBucketVersioningConfigurationRequest;
import com.qcloud.cos.model.SetBucketWebsiteConfigurationRequest;
import com.qcloud.cos.model.SetObjectAclRequest;
import com.qcloud.cos.model.SetObjectTaggingRequest;
import com.qcloud.cos.model.SetObjectTaggingResult;
import com.qcloud.cos.model.UploadMode;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.model.VersionListing;
import com.qcloud.cos.model.bucketcertificate.BucketDomainCertificateRequest;
import com.qcloud.cos.model.bucketcertificate.BucketGetDomainCertificate;
import com.qcloud.cos.model.bucketcertificate.BucketPutDomainCertificate;
import com.qcloud.cos.model.bucketcertificate.SetBucketDomainCertificateRequest;
import com.qcloud.cos.model.ciModel.auditing.AudioAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.AudioAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.DescribeImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.ReportBadCaseRequest;
import com.qcloud.cos.model.ciModel.auditing.TextAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.TextAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingResponse;
import com.qcloud.cos.model.ciModel.bucket.DocBucketRequest;
import com.qcloud.cos.model.ciModel.bucket.DocBucketResponse;
import com.qcloud.cos.model.ciModel.bucket.MediaBucketRequest;
import com.qcloud.cos.model.ciModel.bucket.MediaBucketResponse;
import com.qcloud.cos.model.ciModel.common.CImageProcessRequest;
import com.qcloud.cos.model.ciModel.common.ImageProcessRequest;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.image.GenerateQrcodeRequest;
import com.qcloud.cos.model.ciModel.image.ImageLabelRequest;
import com.qcloud.cos.model.ciModel.image.ImageLabelResponse;
import com.qcloud.cos.model.ciModel.image.ImageLabelV2Request;
import com.qcloud.cos.model.ciModel.image.ImageLabelV2Response;
import com.qcloud.cos.model.ciModel.image.ImageSearchRequest;
import com.qcloud.cos.model.ciModel.image.ImageSearchResponse;
import com.qcloud.cos.model.ciModel.image.ImageStyleRequest;
import com.qcloud.cos.model.ciModel.image.ImageStyleResponse;
import com.qcloud.cos.model.ciModel.image.OpenImageSearchRequest;
import com.qcloud.cos.model.ciModel.job.BatchJobRequest;
import com.qcloud.cos.model.ciModel.job.BatchJobResponse;
import com.qcloud.cos.model.ciModel.job.DocHtmlRequest;
import com.qcloud.cos.model.ciModel.job.DocJobListRequest;
import com.qcloud.cos.model.ciModel.job.DocJobListResponse;
import com.qcloud.cos.model.ciModel.job.DocJobRequest;
import com.qcloud.cos.model.ciModel.job.DocJobResponse;
import com.qcloud.cos.model.ciModel.job.FileProcessJobResponse;
import com.qcloud.cos.model.ciModel.job.FileProcessRequest;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoRequest;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoResponse;
import com.qcloud.cos.model.ciModel.persistence.CIUploadResult;
import com.qcloud.cos.model.ciModel.persistence.DetectCarRequest;
import com.qcloud.cos.model.ciModel.persistence.DetectCarResponse;
import com.qcloud.cos.model.ciModel.queue.DocListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.DocQueueRequest;
import com.qcloud.cos.model.ciModel.queue.MediaListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.MediaQueueRequest;
import com.qcloud.cos.model.ciModel.queue.MediaQueueResponse;
import com.qcloud.cos.model.ciModel.snapshot.CosSnapshotRequest;
import com.qcloud.cos.model.ciModel.snapshot.PrivateM3U8Request;
import com.qcloud.cos.model.ciModel.snapshot.PrivateM3U8Response;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotRequest;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotResponse;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.model.ciModel.utils.CICheckUtils;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionsResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowListRequest;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowListResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowRequest;
import com.qcloud.cos.model.ciModel.xml.CIAuditingXmlFactory;
import com.qcloud.cos.model.ciModel.xml.CIFileProcessXmlFactory;
import com.qcloud.cos.model.ciModel.xml.CIMediaXmlFactory;
import com.qcloud.cos.model.ciModel.xml.CImageXmlFactory;
import com.qcloud.cos.model.fetch.GetAsyncFetchTaskRequest;
import com.qcloud.cos.model.fetch.GetAsyncFetchTaskResult;
import com.qcloud.cos.model.fetch.GetAsyncFetchTaskResultHandler;
import com.qcloud.cos.model.fetch.PutAsyncFetchTaskRequest;
import com.qcloud.cos.model.fetch.PutAsyncFetchTaskResult;
import com.qcloud.cos.model.fetch.PutAsyncFetchTaskResultHandler;
import com.qcloud.cos.model.fetch.PutAsyncFetchTaskSerializer;
import com.qcloud.cos.model.inventory.InventoryConfiguration;
import com.qcloud.cos.model.transform.ObjectTaggingXmlFactory;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.utils.Base64;
import com.qcloud.cos.utils.BinaryUtils;
import com.qcloud.cos.utils.DateUtils;
import com.qcloud.cos.utils.Jackson;
import com.qcloud.cos.utils.Md5Utils;
import com.qcloud.cos.utils.ServiceUtils;
import com.qcloud.cos.utils.StringUtils;
import com.qcloud.cos.utils.UrlEncoderUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.DecoderException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSClient
implements COS {
    private static final Logger log = LoggerFactory.getLogger(COSClient.class);
    private final SkipMd5CheckStrategy skipMd5CheckStrategy = SkipMd5CheckStrategy.INSTANCE;
    private final VoidCosResponseHandler voidCosResponseHandler = new VoidCosResponseHandler();
    private volatile COSCredentialsProvider credProvider;
    protected ClientConfig clientConfig;
    private CosHttpClient cosHttpClient;

    public COSClient(COSCredentials cOSCredentials, ClientConfig clientConfig) {
        this(new COSStaticCredentialsProvider(cOSCredentials), clientConfig);
    }

    public COSClient(COSCredentialsProvider cOSCredentialsProvider, ClientConfig clientConfig) {
        this.credProvider = cOSCredentialsProvider;
        this.clientConfig = clientConfig;
        this.cosHttpClient = new DefaultCosHttpClient(clientConfig);
    }

    public void shutdown() {
        this.cosHttpClient.shutdown();
    }

    public void setCOSCredentials(COSCredentials cOSCredentials) {
        this.rejectNull(cOSCredentials, "cred must not be null");
        this.credProvider = new COSStaticCredentialsProvider(cOSCredentials);
    }

    public void setCOSCredentialsProvider(COSCredentialsProvider cOSCredentialsProvider) {
        this.rejectNull(cOSCredentialsProvider, "credProvider must not be null");
        this.credProvider = cOSCredentialsProvider;
    }

    @Override
    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    private COSCredentials fetchCredential() throws CosClientException {
        if (this.credProvider == null) {
            throw new CosClientException("credentials Provider is null, you must set legal Credentials info when init cosClient.");
        }
        COSCredentials cOSCredentials = this.credProvider.getCredentials();
        if (cOSCredentials == null) {
            throw new CosClientException("credentials from Provider is null. please check your credentials provider");
        }
        return cOSCredentials;
    }

    private void rejectNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    private void rejectEmpty(String string, String string2) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException(string2);
        }
    }

    private void rejectEmpty(Map map, String string) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException(string);
        }
    }

    private void rejectStartWith(String string, String string2, String string3) {
        if (string != null && !string.isEmpty() && string2 != null && !string.startsWith(string2)) {
            throw new IllegalArgumentException(string3);
        }
    }

    protected <X extends CosServiceRequest> CosHttpRequest<X> createRequest(String string, String string2, X x, HttpMethodName httpMethodName) {
        CosHttpRequest<X> cosHttpRequest = new CosHttpRequest<X>(x);
        cosHttpRequest.setHttpMethod(httpMethodName);
        cosHttpRequest.addHeader("User-Agent", this.clientConfig.getUserAgent());
        if (x instanceof ListBucketsRequest) {
            this.buildUrlAndHost(cosHttpRequest, string, string2, true);
        } else {
            this.rejectNull(this.clientConfig.getRegion(), "region is missing, you must set region when init clientConfig for the api.");
            this.buildUrlAndHost(cosHttpRequest, string, string2, false);
        }
        cosHttpRequest.setProgressListener(x.getGeneralProgressListener());
        return cosHttpRequest;
    }

    private void addAclHeaders(CosHttpRequest<? extends CosServiceRequest> cosHttpRequest, AccessControlList accessControlList) {
        List<Grant> list = accessControlList.getGrantsAsList();
        HashMap hashMap = new HashMap();
        for (Grant grant : list) {
            if (!hashMap.containsKey((Object)grant.getPermission())) {
                hashMap.put(grant.getPermission(), new LinkedList());
            }
            ((Collection)hashMap.get((Object)grant.getPermission())).add(grant.getGrantee());
        }
        for (Permission permission : Permission.values()) {
            if (!hashMap.containsKey((Object)permission)) continue;
            Collection collection = (Collection)hashMap.get((Object)permission);
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (Grantee grantee : collection) {
                if (!bl) {
                    bl = true;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(grantee.getTypeIdentifier()).append("=").append("\"").append(grantee.getIdentifier()).append("\"");
            }
            cosHttpRequest.addHeader(permission.getHeaderName(), stringBuilder.toString());
        }
    }

    protected static void populateRequestMetadata(CosHttpRequest<?> cosHttpRequest, ObjectMetadata objectMetadata) {
        Object object;
        Object object2;
        Map<String, Object> map = objectMetadata.getRawMetadata();
        if (map != null) {
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                cosHttpRequest.addHeader((String)object.getKey(), object.getValue().toString());
            }
        }
        if ((object2 = objectMetadata.getHttpExpiresDate()) != null) {
            cosHttpRequest.addHeader("Expires", DateUtils.formatRFC822Date((Date)object2));
        }
        if ((object = objectMetadata.getUserMetadata()) != null) {
            for (Map.Entry entry : object.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (string != null) {
                    string = string.trim();
                }
                if (string2 != null) {
                    string2 = string2.trim();
                }
                cosHttpRequest.addHeader("x-cos-meta-" + string, string2);
            }
        }
    }

    private void populateRequestWithCopyObjectParameters(CosHttpRequest<? extends CosServiceRequest> cosHttpRequest, CopyObjectRequest copyObjectRequest) {
        Region region = copyObjectRequest.getSourceBucketRegion();
        EndpointBuilder endpointBuilder = null;
        endpointBuilder = region == null ? this.clientConfig.getEndpointBuilder() : new RegionEndpointBuilder(region);
        if (copyObjectRequest.getSourceEndpointBuilder() != null) {
            endpointBuilder = copyObjectRequest.getSourceEndpointBuilder();
        }
        String string = this.formatKey(copyObjectRequest.getSourceKey());
        String string2 = this.formatBucket(copyObjectRequest.getSourceBucketName(), copyObjectRequest.getSourceAppid() != null ? copyObjectRequest.getSourceAppid() : this.fetchCredential().getCOSAppId());
        String string3 = String.format("%s%s", endpointBuilder.buildGeneralApiEndpoint(string2), UrlEncoderUtils.encodeEscapeDelimiter(string));
        if (copyObjectRequest.getSourceVersionId() != null) {
            string3 = string3 + "?versionId=" + copyObjectRequest.getSourceVersionId();
        }
        cosHttpRequest.addHeader("x-cos-copy-source", string3);
        COSClient.addDateHeader(cosHttpRequest, "x-cos-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        COSClient.addDateHeader(cosHttpRequest, "x-cos-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        COSClient.addStringListHeader(cosHttpRequest, "x-cos-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        COSClient.addStringListHeader(cosHttpRequest, "x-cos-copy-source-if-none-match", copyObjectRequest.getNonmatchingETagConstraints());
        if (copyObjectRequest.getAccessControlList() != null) {
            this.addAclHeaders(cosHttpRequest, copyObjectRequest.getAccessControlList());
        } else if (copyObjectRequest.getCannedAccessControlList() != null) {
            cosHttpRequest.addHeader("x-cos-acl", copyObjectRequest.getCannedAccessControlList().toString());
        }
        if (copyObjectRequest.getStorageClass() != null) {
            cosHttpRequest.addHeader("x-cos-storage-class", copyObjectRequest.getStorageClass());
        }
        if (copyObjectRequest.getRedirectLocation() != null) {
            cosHttpRequest.addHeader("x-cos-website-redirect-location", copyObjectRequest.getRedirectLocation());
        }
        ObjectMetadata objectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (copyObjectRequest.getMetadataDirective() != null) {
            cosHttpRequest.addHeader("x-cos-metadata-directive", copyObjectRequest.getMetadataDirective());
        } else if (objectMetadata != null) {
            cosHttpRequest.addHeader("x-cos-metadata-directive", "REPLACE");
        }
        if (objectMetadata != null) {
            COSClient.populateRequestMetadata(cosHttpRequest, objectMetadata);
        }
        COSClient.populateSSE_C(cosHttpRequest, copyObjectRequest.getDestinationSSECustomerKey());
        COSClient.populateSourceSSE_C(cosHttpRequest, copyObjectRequest.getSourceSSECustomerKey());
        COSClient.populateSSE_KMS(cosHttpRequest, copyObjectRequest.getSSECOSKeyManagementParams());
    }

    private void populateRequestWithCopyPartParameters(CosHttpRequest<? extends CosServiceRequest> cosHttpRequest, CopyPartRequest copyPartRequest) {
        Region region = copyPartRequest.getSourceBucketRegion();
        EndpointBuilder endpointBuilder = null;
        endpointBuilder = region == null ? this.clientConfig.getEndpointBuilder() : new RegionEndpointBuilder(region);
        if (copyPartRequest.getSourceEndpointBuilder() != null) {
            endpointBuilder = copyPartRequest.getSourceEndpointBuilder();
        }
        String string = this.formatKey(copyPartRequest.getSourceKey());
        String string2 = this.formatBucket(copyPartRequest.getSourceBucketName(), copyPartRequest.getSourceAppid() != null ? copyPartRequest.getSourceAppid() : this.fetchCredential().getCOSAppId());
        String string3 = String.format("%s%s", endpointBuilder.buildGeneralApiEndpoint(string2), UrlEncoderUtils.encodeEscapeDelimiter(string));
        if (copyPartRequest.getSourceVersionId() != null) {
            string3 = string3 + "?versionId=" + copyPartRequest.getSourceVersionId();
        }
        cosHttpRequest.addHeader("x-cos-copy-source", string3);
        COSClient.addDateHeader(cosHttpRequest, "x-cos-copy-source-if-modified-since", copyPartRequest.getModifiedSinceConstraint());
        COSClient.addDateHeader(cosHttpRequest, "x-cos-copy-source-if-unmodified-since", copyPartRequest.getUnmodifiedSinceConstraint());
        COSClient.addStringListHeader(cosHttpRequest, "x-cos-copy-source-if-match", copyPartRequest.getMatchingETagConstraints());
        COSClient.addStringListHeader(cosHttpRequest, "x-cos-copy-source-if-none-match", copyPartRequest.getNonmatchingETagConstraints());
        if (copyPartRequest.getFirstByte() != null && copyPartRequest.getLastByte() != null) {
            String string4 = "bytes=" + copyPartRequest.getFirstByte() + "-" + copyPartRequest.getLastByte();
            cosHttpRequest.addHeader("x-cos-copy-source-range", string4);
        }
        COSClient.populateSSE_C(cosHttpRequest, copyPartRequest.getDestinationSSECustomerKey());
        COSClient.populateSourceSSE_C(cosHttpRequest, copyPartRequest.getSourceSSECustomerKey());
    }

    private String formatKey(String string) {
        if (string == null) {
            return "/";
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return string;
    }

    private String leftStripPathDelimiter(String string) {
        if (string == null) {
            return string;
        }
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private String formatBucket(String string, String string2) throws CosClientException {
        BucketNameUtils.validateBucketName(string);
        if (string2 == null) {
            if (!string.trim().isEmpty()) {
                return string;
            }
            throw new CosClientException("please make sure bucket name must contain legal appid when appid is missing. example: music-1251122334");
        }
        String string3 = "-" + string2;
        if (string.endsWith(string3)) {
            return string;
        }
        return string + string3;
    }

    private <X extends CosServiceRequest> void buildUrlAndHost(CosHttpRequest<X> cosHttpRequest, String string, String string2, boolean bl) throws CosClientException {
        String string3;
        boolean bl2 = cosHttpRequest.getOriginalRequest() instanceof CIServiceRequest;
        string2 = this.formatKey(string2);
        cosHttpRequest.setResourcePath(string2);
        String string4 = "";
        String string5 = "";
        if (bl) {
            string4 = this.clientConfig.getEndpointBuilder().buildGetServiceApiEndpoint();
            string5 = this.clientConfig.getEndpointResolver().resolveGetServiceApiEndpoint(string4);
        } else {
            string = this.formatBucket(string, this.fetchCredential().getCOSAppId());
            string4 = cosHttpRequest.getOriginalRequest() instanceof CIPicServiceRequest ? new CIPicRegionEndpointBuilder(this.clientConfig.getRegion()).buildGeneralApiEndpoint(string) : (bl2 ? new CIRegionEndpointBuilder(this.clientConfig.getRegion()).buildGeneralApiEndpoint(string) : this.clientConfig.getEndpointBuilder().buildGeneralApiEndpoint(string));
            string5 = this.clientConfig.getEndpointResolver().resolveGeneralApiEndpoint(string4);
        }
        if (string4 == null) {
            throw new CosClientException("endpoint is null, please check your endpoint builder");
        }
        if (string5 == null) {
            throw new CosClientException("endpointAddr is null, please check your endpoint resolver");
        }
        if (this.clientConfig.getIsDistinguishHost()) {
            string3 = String.format("%s.%s.myqcloud.com", string, Region.formatRegion(this.clientConfig.getRegion()));
            cosHttpRequest.addHeader("Host", string3);
        } else {
            cosHttpRequest.addHeader("Host", string4);
        }
        if (bl2 && !this.clientConfig.getCiSpecialRequest()) {
            cosHttpRequest.setProtocol(HttpProtocol.https);
        } else {
            cosHttpRequest.setProtocol(this.clientConfig.getHttpProtocol());
        }
        string3 = ((CosServiceRequest)cosHttpRequest.getOriginalRequest()).getFixedEndpointAddr();
        if (string3 != null) {
            cosHttpRequest.setEndpoint(string3);
        } else {
            cosHttpRequest.setEndpoint(string5);
        }
        cosHttpRequest.setResourcePath(string2);
    }

    private <X, Y extends CosServiceRequest> X invoke(CosHttpRequest<Y> cosHttpRequest, Unmarshaller<X, InputStream> unmarshaller) throws CosClientException, CosServiceException {
        return this.invoke(cosHttpRequest, new COSXmlResponseHandler<X>(unmarshaller));
    }

    private <X, Y extends CosServiceRequest> X invoke(CosHttpRequest<Y> cosHttpRequest, HttpResponseHandler<CosServiceResponse<X>> httpResponseHandler) throws CosClientException, CosServiceException {
        COSSigner cOSSigner = this.clientConfig.getCosSigner();
        Y y = cosHttpRequest.getOriginalRequest();
        COSCredentials cOSCredentials = y != null && ((CosServiceRequest)y).getCosCredentials() != null ? ((CosServiceRequest)y).getCosCredentials() : this.fetchCredential();
        Date date = new Date(System.currentTimeMillis() + this.clientConfig.getSignExpired() * 1000L);
        boolean bl = y instanceof CIWorkflowServiceRequest;
        cOSSigner.setCIWorkflowRequest(bl);
        cOSSigner.sign(cosHttpRequest, cOSCredentials, date);
        return this.cosHttpClient.exeute(cosHttpRequest, httpResponseHandler);
    }

    private static PutObjectResult createPutObjectResult(ObjectMetadata objectMetadata) {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.setRequestId((String)objectMetadata.getRawMetadataValue("x-cos-request-id"));
        putObjectResult.setDateStr((String)objectMetadata.getRawMetadataValue("Date"));
        putObjectResult.setVersionId(objectMetadata.getVersionId());
        putObjectResult.setETag(objectMetadata.getETag());
        putObjectResult.setExpirationTime(objectMetadata.getExpirationTime());
        putObjectResult.setSSEAlgorithm(objectMetadata.getSSEAlgorithm());
        putObjectResult.setSSECustomerAlgorithm(objectMetadata.getSSECustomerAlgorithm());
        putObjectResult.setSSECustomerKeyMd5(objectMetadata.getSSECustomerKeyMd5());
        putObjectResult.setCrc64Ecma(objectMetadata.getCrc64Ecma());
        putObjectResult.setMetadata(objectMetadata);
        putObjectResult.setCiUploadResult(objectMetadata.getCiUploadResult());
        return putObjectResult;
    }

    private static AppendObjectResult createAppendObjectResult(ObjectMetadata objectMetadata) {
        AppendObjectResult appendObjectResult = new AppendObjectResult();
        appendObjectResult.setNextAppendPosition(Long.valueOf((String)objectMetadata.getRawMetadataValue("x-cos-next-append-position")));
        appendObjectResult.setMetadata(objectMetadata);
        return appendObjectResult;
    }

    private static void addParameterIfNotNull(CosHttpRequest<?> cosHttpRequest, String string, String string2) {
        if (string2 != null) {
            cosHttpRequest.addParameter(string, string2);
        }
    }

    private static void addHeaderIfNotNull(CosHttpRequest<?> cosHttpRequest, String string, String string2) {
        if (string2 != null) {
            cosHttpRequest.addHeader(string, string2);
        }
    }

    private static void addDateHeader(CosHttpRequest<?> cosHttpRequest, String string, Date date) {
        if (date != null) {
            cosHttpRequest.addHeader(string, DateUtils.formatRFC822Date(date));
        }
    }

    private static void addStringListHeader(CosHttpRequest<?> cosHttpRequest, String string, List<String> list) {
        if (list != null && !list.isEmpty()) {
            cosHttpRequest.addHeader(string, StringUtils.join(list));
        }
    }

    private void setZeroContentLength(CosHttpRequest<?> cosHttpRequest) {
        cosHttpRequest.addHeader("Content-Length", String.valueOf(0));
    }

    private boolean shouldRetryCompleteMultipartUpload(CosServiceRequest cosServiceRequest, CosClientException cosClientException, int n) {
        return false;
    }

    private static void addResponseHeaderParameters(CosHttpRequest<?> cosHttpRequest, ResponseHeaderOverrides responseHeaderOverrides) {
        if (responseHeaderOverrides != null) {
            if (responseHeaderOverrides.getCacheControl() != null) {
                cosHttpRequest.addParameter("response-cache-control", responseHeaderOverrides.getCacheControl());
            }
            if (responseHeaderOverrides.getContentDisposition() != null) {
                cosHttpRequest.addParameter("response-content-disposition", responseHeaderOverrides.getContentDisposition());
            }
            if (responseHeaderOverrides.getContentEncoding() != null) {
                cosHttpRequest.addParameter("response-content-encoding", responseHeaderOverrides.getContentEncoding());
            }
            if (responseHeaderOverrides.getContentLanguage() != null) {
                cosHttpRequest.addParameter("response-content-language", responseHeaderOverrides.getContentLanguage());
            }
            if (responseHeaderOverrides.getContentType() != null) {
                cosHttpRequest.addParameter("response-content-type", responseHeaderOverrides.getContentType());
            }
            if (responseHeaderOverrides.getExpires() != null) {
                cosHttpRequest.addParameter("response-expires", responseHeaderOverrides.getExpires());
            }
        }
    }

    private static void populateSSE_C(CosHttpRequest<?> cosHttpRequest, SSECustomerKey sSECustomerKey) {
        if (sSECustomerKey == null) {
            return;
        }
        COSClient.addHeaderIfNotNull(cosHttpRequest, "x-cos-server-side-encryption-customer-algorithm", sSECustomerKey.getAlgorithm());
        COSClient.addHeaderIfNotNull(cosHttpRequest, "x-cos-server-side-encryption-customer-key", sSECustomerKey.getKey());
        COSClient.addHeaderIfNotNull(cosHttpRequest, "x-cos-server-side-encryption-customer-key-MD5", sSECustomerKey.getMd5());
        if (sSECustomerKey.getKey() != null && sSECustomerKey.getMd5() == null) {
            String string = sSECustomerKey.getKey();
            byte[] byArray = Base64.decode(string);
            cosHttpRequest.addHeader("x-cos-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64(byArray));
        }
    }

    private static void populateTrafficLimit(CosHttpRequest<?> cosHttpRequest, int n) {
        if (n > 0) {
            cosHttpRequest.addHeader("x-cos-traffic-limit", String.valueOf(n));
        }
    }

    private static void populateSourceSSE_C(CosHttpRequest<?> cosHttpRequest, SSECustomerKey sSECustomerKey) {
        if (sSECustomerKey == null) {
            return;
        }
        COSClient.addHeaderIfNotNull(cosHttpRequest, "x-cos-copy-source-server-side-encryption-customer-algorithm", sSECustomerKey.getAlgorithm());
        COSClient.addHeaderIfNotNull(cosHttpRequest, "x-cos-copy-source-server-side-encryption-customer-key", sSECustomerKey.getKey());
        COSClient.addHeaderIfNotNull(cosHttpRequest, "x-cos-copy-source-server-side-encryption-customer-key-MD5", sSECustomerKey.getMd5());
        if (sSECustomerKey.getKey() != null && sSECustomerKey.getMd5() == null) {
            String string = sSECustomerKey.getKey();
            byte[] byArray = Base64.decode(string);
            cosHttpRequest.addHeader("x-cos-copy-source-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64(byArray));
        }
    }

    private static void populateSSE_KMS(CosHttpRequest<?> cosHttpRequest, SSECOSKeyManagementParams sSECOSKeyManagementParams) {
        if (sSECOSKeyManagementParams != null) {
            COSClient.addHeaderIfNotNull(cosHttpRequest, "x-cos-server-side-encryption", sSECOSKeyManagementParams.getEncryption());
            COSClient.addHeaderIfNotNull(cosHttpRequest, "x-cos-server-side-encryption-cos-kms-key-id", sSECOSKeyManagementParams.getCOSKmsKeyId());
            COSClient.addHeaderIfNotNull(cosHttpRequest, "x-cos-server-side-encryption-context", sSECOSKeyManagementParams.getEncryptionContext());
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws CosClientException, CosServiceException {
        ObjectMetadata objectMetadata = this.uploadObjectInternal(UploadMode.PUT_OBJECT, putObjectRequest);
        PutObjectResult putObjectResult = COSClient.createPutObjectResult(objectMetadata);
        putObjectResult.setContentMd5(objectMetadata.getETag());
        return putObjectResult;
    }

    @Override
    public AppendObjectResult appendObject(AppendObjectRequest appendObjectRequest) throws CosServiceException, CosClientException {
        this.rejectNull(appendObjectRequest, "The append object request must be specified");
        this.rejectNull(appendObjectRequest.getPosition(), "The position parameter must be specified");
        ObjectMetadata objectMetadata = this.uploadObjectInternal(UploadMode.APPEND_OBJECT, appendObjectRequest);
        return COSClient.createAppendObjectResult(objectMetadata);
    }

    @Override
    public void rename(RenameRequest renameRequest) throws CosServiceException, CosClientException {
        this.rejectNull(renameRequest, "The request must not be null");
        this.rejectNull(renameRequest.getBucketName(), "The bucket name parameter must be specified when rename");
        this.rejectNull(renameRequest.getSrcObject(), "The src object parameter must be specified when rename");
        this.rejectNull(renameRequest.getDstObject(), "The dst object parameter must be specified when rename");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when rename");
        this.rejectEmpty(renameRequest.getSrcObject(), "The length of the src key must be greater than 0");
        this.rejectEmpty(renameRequest.getDstObject(), "The length of the dst key must be greater than 0");
        CosHttpRequest<RenameRequest> cosHttpRequest = this.createRequest(renameRequest.getBucketName(), renameRequest.getDstObject(), renameRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("rename", null);
        cosHttpRequest.addHeader("x-cos-rename-source", renameRequest.getSrcObject());
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <UploadObjectRequest extends PutObjectRequest> ObjectMetadata uploadObjectInternal(UploadMode uploadMode, UploadObjectRequest UploadObjectRequest2) throws CosClientException, CosServiceException {
        ObjectMetadata objectMetadata;
        Object object;
        Object object2;
        Object object3;
        this.rejectNull(UploadObjectRequest2, "The PutObjectRequest parameter must be specified when uploading an object");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when uploading an object");
        File file = UploadObjectRequest2.getFile();
        InputStream inputStream2 = UploadObjectRequest2.getInputStream();
        String string = UploadObjectRequest2.getBucketName();
        String string2 = UploadObjectRequest2.getKey();
        ObjectMetadata objectMetadata2 = UploadObjectRequest2.getMetadata();
        InputStream inputStream3 = inputStream2;
        if (objectMetadata2 == null) {
            objectMetadata2 = new ObjectMetadata();
        }
        this.rejectNull(string, "The bucket name parameter must be specified when uploading an object");
        this.rejectNull(string2, "The key parameter must be specified when uploading an object");
        if (file == null) {
            if (inputStream3 != null) {
                inputStream3 = ReleasableInputStream.wrap(inputStream3);
            }
        } else {
            boolean bl;
            objectMetadata2.setContentLength(file.length());
            long l = 0x140000000L;
            if (file.length() > 0x140000000L) {
                throw new CosClientException("max size 5GB is allowed by putObject Method, your filesize is " + file.length() + ", please use transferManager to upload big file!");
            }
            boolean bl2 = bl = objectMetadata2.getContentMD5() == null;
            if (bl && !this.skipMd5CheckStrategy.skipServerSideValidation(UploadObjectRequest2)) {
                try {
                    object3 = Md5Utils.md5AsBase64(file);
                    objectMetadata2.setContentMD5((String)object3);
                }
                catch (Exception exception) {
                    throw new CosClientException("Unable to calculate MD5 hash: " + exception.getMessage(), exception);
                }
            }
            inputStream3 = ResettableInputStream.newResettableInputStream(file, "Unable to find file to upload");
        }
        MD5DigestCalculatingInputStream mD5DigestCalculatingInputStream = null;
        try {
            object2 = null;
            if (uploadMode.equals((Object)UploadMode.PUT_OBJECT)) {
                object2 = this.createRequest(string, string2, UploadObjectRequest2, HttpMethodName.PUT);
            } else if (uploadMode.equals((Object)UploadMode.APPEND_OBJECT)) {
                object2 = this.createRequest(string, string2, UploadObjectRequest2, HttpMethodName.POST);
                object3 = (AppendObjectRequest)UploadObjectRequest2;
                object = String.valueOf(((AppendObjectRequest)object3).getPosition());
                ((CosHttpRequest)object2).addParameter("append", null);
                ((CosHttpRequest)object2).addParameter("position", (String)object);
            }
            if (UploadObjectRequest2.getAccessControlList() != null) {
                this.addAclHeaders((CosHttpRequest<? extends CosServiceRequest>)object2, UploadObjectRequest2.getAccessControlList());
            } else if (UploadObjectRequest2.getCannedAcl() != null) {
                ((CosHttpRequest)object2).addHeader("x-cos-acl", UploadObjectRequest2.getCannedAcl().toString());
            }
            if (UploadObjectRequest2.getStorageClass() != null) {
                ((CosHttpRequest)object2).addHeader("x-cos-storage-class", UploadObjectRequest2.getStorageClass());
            }
            if (UploadObjectRequest2.getRedirectLocation() != null) {
                ((CosHttpRequest)object2).addHeader("x-cos-website-redirect-location", UploadObjectRequest2.getRedirectLocation());
                if (inputStream3 == null) {
                    inputStream3 = new ByteArrayInputStream(new byte[0]);
                }
            }
            COSClient.populateSSE_C(object2, UploadObjectRequest2.getSSECustomerKey());
            COSClient.populateSSE_KMS(object2, UploadObjectRequest2.getSSECOSKeyManagementParams());
            COSClient.populateTrafficLimit(object2, UploadObjectRequest2.getTrafficLimit());
            object3 = (Long)objectMetadata2.getRawMetadataValue("Content-Length");
            if (object3 == null) {
                log.warn("No content length specified for stream data.  Stream contents will be buffered in memory and could result in out of memory errors.");
            } else {
                long l = (Long)object3;
                long l2 = 0x140000000L;
                if (l > 0x140000000L) {
                    throw new CosClientException("max size 5GB is allowed by putObject Method, your filesize is " + l + ", please use transferManager to upload big file!");
                }
                if (l >= 0L) {
                    LengthCheckInputStream lengthCheckInputStream = new LengthCheckInputStream(inputStream3, l, false);
                    inputStream3 = lengthCheckInputStream;
                }
            }
            if (objectMetadata2.getContentMD5() == null && !this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(UploadObjectRequest2)) {
                mD5DigestCalculatingInputStream = new MD5DigestCalculatingInputStream(inputStream3);
                inputStream3 = mD5DigestCalculatingInputStream;
            }
            COSClient.populateRequestMetadata(object2, objectMetadata2);
            ((CosHttpRequest)object2).setContent(inputStream3);
            try {
                if (UploadObjectRequest2.getPicOperations() != null) {
                    ((CosHttpRequest)object2).addHeader("Pic-Operations", Jackson.toJsonString(UploadObjectRequest2.getPicOperations()));
                    objectMetadata = (ObjectMetadata)this.invoke((CosHttpRequest)object2, (HttpResponseHandler)new ResponseHeaderHandlerChain<ObjectMetadata>(new Unmarshallers.ImagePersistenceUnmarshaller(), new CosMetadataResponseHandler()));
                } else {
                    objectMetadata = this.invoke((CosHttpRequest)object2, new CosMetadataResponseHandler());
                }
            }
            catch (Throwable throwable) {
                throw Throwables.failure(throwable);
            }
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(UploadObjectRequest2, file, inputStream2, inputStream3, log);
        }
        object2 = objectMetadata2.getContentMD5();
        if (mD5DigestCalculatingInputStream != null) {
            object2 = Base64.encodeAsString(mD5DigestCalculatingInputStream.getMd5Digest());
        }
        object3 = objectMetadata.getETag();
        if (object2 != null && uploadMode.equals((Object)UploadMode.PUT_OBJECT) && !this.skipMd5CheckStrategy.skipClientSideValidationPerPutResponse(objectMetadata) && !CICheckUtils.isCoverImageRequest(UploadObjectRequest2)) {
            object = BinaryUtils.fromBase64((String)object2);
            byte[] byArray = null;
            try {
                byArray = BinaryUtils.fromHex((String)object3);
            }
            catch (DecoderException decoderException) {
                throw new CosClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + (String)object2 + " in base 64) didn't match hash (etag: " + (String)object3 + " in hex) calculated by COS .  You may need to delete the data stored in COS . (metadata.contentMD5: " + objectMetadata2.getContentMD5() + ", bucketName: " + string + ", key: " + string2 + ")");
            }
            if (!Arrays.equals((byte[])object, byArray)) {
                throw new CosClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + (String)object2 + " in base 64) didn't match hash (etag: " + (String)object3 + " in hex) calculated by COS .  You may need to delete the data stored in COS . (metadata.contentMD5: " + objectMetadata2.getContentMD5() + ", bucketName: " + string + ", key: " + string2 + ")");
            }
        }
        return objectMetadata;
    }

    @Override
    public PutObjectResult putObject(String string, String string2, File file) throws CosClientException, CosServiceException {
        return this.putObject(new PutObjectRequest(string, string2, file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String string, String string2, InputStream inputStream2, ObjectMetadata objectMetadata) throws CosClientException, CosServiceException {
        return this.putObject(new PutObjectRequest(string, string2, inputStream2, objectMetadata));
    }

    @Override
    public PutObjectResult putObject(String string, String string2, String string3) throws CosClientException, CosServiceException {
        this.rejectNull(string, "The bucket name parameter must be specified when uploading an object");
        this.rejectNull(string2, "The key parameter must be specified when uploading an object");
        this.rejectNull(string3, "The content with utf-8 encoding must be specified when uploading an object");
        byte[] byArray = string3.getBytes(StringUtils.UTF8);
        String string4 = Md5Utils.md5AsBase64(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType("text/plain");
        objectMetadata.setContentLength(byArray.length);
        objectMetadata.setContentMD5(string4);
        return this.putObject(new PutObjectRequest(string, string2, byteArrayInputStream, objectMetadata));
    }

    @Override
    public COSObject getObject(String string, String string2) throws CosClientException, CosServiceException {
        return this.getObject(new GetObjectRequest(string, string2));
    }

    @Override
    public COSObject getObject(GetObjectRequest getObjectRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectRequest, "The GetObjectRequest parameter must be specified when requesting an object");
        this.rejectNull(getObjectRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object");
        this.rejectNull(getObjectRequest.getKey(), "The key parameter must be specified when requesting an object");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting an object");
        CosHttpRequest<GetObjectRequest> cosHttpRequest = this.createRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "versionId", getObjectRequest.getVersionId());
        long[] lArray = getObjectRequest.getRange();
        if (lArray != null) {
            cosHttpRequest.addHeader("Range", "bytes=" + Long.toString(lArray[0]) + "-" + Long.toString(lArray[1]));
        }
        COSClient.addResponseHeaderParameters(cosHttpRequest, getObjectRequest.getResponseHeaders());
        COSClient.addDateHeader(cosHttpRequest, "If-Modified-Since", getObjectRequest.getModifiedSinceConstraint());
        COSClient.addDateHeader(cosHttpRequest, "If-Unmodified-Since", getObjectRequest.getUnmodifiedSinceConstraint());
        COSClient.addStringListHeader(cosHttpRequest, "If-Match", getObjectRequest.getMatchingETagConstraints());
        COSClient.addStringListHeader(cosHttpRequest, "If-None-Match", getObjectRequest.getNonmatchingETagConstraints());
        COSClient.populateSSE_C(cosHttpRequest, getObjectRequest.getSSECustomerKey());
        COSClient.populateTrafficLimit(cosHttpRequest, getObjectRequest.getTrafficLimit());
        try {
            COSObject cOSObject = this.invoke(cosHttpRequest, new COSObjectResponseHandler());
            cOSObject.setBucketName(getObjectRequest.getBucketName());
            cOSObject.setKey(getObjectRequest.getKey());
            FilterInputStream filterInputStream = cOSObject.getObjectContent();
            HttpRequestBase httpRequestBase = cOSObject.getObjectContent().getHttpRequest();
            filterInputStream = new ServiceClientHolderInputStream(filterInputStream, this);
            if (!this.skipMd5CheckStrategy.skipClientSideValidation(getObjectRequest, cOSObject.getObjectMetadata())) {
                try {
                    byte[] byArray = BinaryUtils.fromHex(cOSObject.getObjectMetadata().getETag());
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    filterInputStream = new DigestValidationInputStream(filterInputStream, messageDigest, byArray);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    log.warn("No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", noSuchAlgorithmException);
                }
                catch (DecoderException decoderException) {
                    log.warn("BinaryUtils.fromHex error. Unable to calculate checksum and verify data integrity. etag:" + cOSObject.getObjectMetadata().getETag(), decoderException);
                }
            } else {
                filterInputStream = new LengthCheckInputStream(filterInputStream, cOSObject.getObjectMetadata().getContentLength(), true);
            }
            cOSObject.setObjectContent(new COSObjectInputStream(filterInputStream, httpRequestBase));
            return cOSObject;
        }
        catch (CosServiceException cosServiceException) {
            if (cosServiceException.getStatusCode() == 412 || cosServiceException.getStatusCode() == 304) {
                return null;
            }
            throw cosServiceException;
        }
    }

    @Override
    public ObjectMetadata getObject(final GetObjectRequest getObjectRequest, File file) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectRequest, "The GetObjectRequest parameter must be specified when requesting an object");
        this.rejectNull(file, "The destination file parameter must be specified when downloading an object directly to a file");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when downloading an object directly to a file");
        COSObject cOSObject = ServiceUtils.retryableDownloadCOSObjectToFile(file, new ServiceUtils.RetryableCOSDownloadTask(){

            @Override
            public boolean needIntegrityCheck() {
                return !COSClient.this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(getObjectRequest);
            }

            @Override
            public COSObject getCOSObjectStream() {
                return COSClient.this.getObject(getObjectRequest);
            }
        }, false);
        if (cOSObject == null) {
            return null;
        }
        return cOSObject.getObjectMetadata();
    }

    @Override
    public PutSymlinkResult putSymlink(PutSymlinkRequest putSymlinkRequest) {
        this.rejectNull(putSymlinkRequest, "The request must not be null.");
        this.rejectNull(putSymlinkRequest.getBucketName(), "The bucket name parameter must be specified when create symlink.");
        this.rejectNull(putSymlinkRequest.getSymlink(), "The symlink name must be specified when create symlink");
        this.rejectNull(putSymlinkRequest.getTarget(), "The target object must be specified when create symlink");
        CosHttpRequest<PutSymlinkRequest> cosHttpRequest = this.createRequest(putSymlinkRequest.getBucketName(), putSymlinkRequest.getSymlink(), putSymlinkRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("symlink", null);
        cosHttpRequest.addHeader("x-cos-symlink-target", putSymlinkRequest.getTarget());
        return this.invoke(cosHttpRequest, new PutSymlinkResultHandler());
    }

    @Override
    public GetSymlinkResult getSymlink(GetSymlinkRequest getSymlinkRequest) {
        this.rejectNull(getSymlinkRequest, "The request must not be null.");
        this.rejectNull(getSymlinkRequest.getBucketName(), "The bucket name parameter must be specified when getting symlink.");
        this.rejectNull(getSymlinkRequest.getSymlink(), "The requested symbolic link must be specified.");
        CosHttpRequest<GetSymlinkRequest> cosHttpRequest = this.createRequest(getSymlinkRequest.getBucketName(), getSymlinkRequest.getSymlink(), getSymlinkRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("symlink", null);
        COSClient.addParameterIfNotNull(cosHttpRequest, "versionId", getSymlinkRequest.getVersionId());
        return this.invoke(cosHttpRequest, new GetSymlinkResultHandler());
    }

    @Override
    public boolean doesObjectExist(String string, String string2) throws CosClientException, CosServiceException {
        try {
            this.getObjectMetadata(string, string2);
            return true;
        }
        catch (CosServiceException cosServiceException) {
            if (cosServiceException.getStatusCode() == 404) {
                return false;
            }
            throw cosServiceException;
        }
    }

    @Override
    public ObjectMetadata getObjectMetadata(String string, String string2) throws CosClientException, CosServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(string, string2));
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectMetadataRequest, "The GetObjectMetadataRequest parameter must be specified when requesting an object's metadata");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting an object's metadata");
        String string = getObjectMetadataRequest.getBucketName();
        String string2 = getObjectMetadataRequest.getKey();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting an object's metadata");
        this.rejectNull(string2, "The key parameter must be specified when requesting an object's metadata");
        CosHttpRequest<GetObjectMetadataRequest> cosHttpRequest = this.createRequest(string, string2, getObjectMetadataRequest, HttpMethodName.HEAD);
        COSClient.addParameterIfNotNull(cosHttpRequest, "versionId", getObjectMetadataRequest.getVersionId());
        COSClient.populateSSE_C(cosHttpRequest, getObjectMetadataRequest.getSSECustomerKey());
        return this.invoke(cosHttpRequest, new CosMetadataResponseHandler());
    }

    @Override
    public void deleteObject(String string, String string2) throws CosClientException, CosServiceException {
        this.deleteObject(new DeleteObjectRequest(string, string2));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteObjectRequest, "The delete object request must be specified when deleting an object");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting an object");
        this.rejectNull(deleteObjectRequest.getBucketName(), "The bucket name must be specified when deleting an object");
        this.rejectNull(deleteObjectRequest.getKey(), "The key must be specified when deleting an object");
        this.rejectEmpty(deleteObjectRequest.getKey(), "The length of the key must be greater than 0");
        CosHttpRequest<DeleteObjectRequest> cosHttpRequest = this.createRequest(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey(), deleteObjectRequest, HttpMethodName.DELETE);
        if (deleteObjectRequest.isRecursive()) {
            cosHttpRequest.addParameter("recursive", null);
        }
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws MultiObjectDeleteException, CosClientException, CosServiceException {
        Object object;
        Object object2;
        this.rejectNull(deleteObjectsRequest, "The DeleteObjectsRequest parameter must be specified when deleting objects");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting objects");
        CosHttpRequest<DeleteObjectsRequest> cosHttpRequest = this.createRequest(deleteObjectsRequest.getBucketName(), null, deleteObjectsRequest, HttpMethodName.POST);
        cosHttpRequest.addParameter("delete", null);
        byte[] byArray = new MultiObjectDeleteXmlFactory().convertToXmlByteArray(deleteObjectsRequest);
        cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        try {
            object2 = Md5Utils.computeMD5Hash(byArray);
            object = BinaryUtils.toBase64((byte[])object2);
            cosHttpRequest.addHeader("Content-MD5", (String)object);
        }
        catch (Exception exception) {
            throw new CosClientException("Couldn't compute md5 sum", exception);
        }
        object2 = new ResponseHeaderHandlerChain<DeleteObjectsResponse>(new Unmarshallers.DeleteObjectsResultUnmarshaller(), new HeaderHandler[0]);
        object = (DeleteObjectsResponse)this.invoke((CosHttpRequest)cosHttpRequest, (HttpResponseHandler)object2);
        if (!((DeleteObjectsResponse)object).getErrors().isEmpty()) {
            Map<String, String> map = ((COSXmlResponseHandler)object2).getResponseHeaders();
            MultiObjectDeleteException multiObjectDeleteException = new MultiObjectDeleteException(((DeleteObjectsResponse)object).getErrors(), ((DeleteObjectsResponse)object).getDeletedObjects());
            multiObjectDeleteException.setStatusCode(200);
            multiObjectDeleteException.setRequestId(map.get("x-cos-request-id"));
            throw multiObjectDeleteException;
        }
        DeleteObjectsResult deleteObjectsResult = new DeleteObjectsResult(((DeleteObjectsResponse)object).getDeletedObjects());
        return deleteObjectsResult;
    }

    @Override
    public void deleteVersion(String string, String string2, String string3) throws CosClientException, CosServiceException {
        this.deleteVersion(new DeleteVersionRequest(string, string2, string3));
    }

    @Override
    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteVersionRequest, "The DeleteVersionRequest parameter must be specified when deleting a version");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting a version");
        String string = deleteVersionRequest.getBucketName();
        String string2 = deleteVersionRequest.getKey();
        String string3 = deleteVersionRequest.getVersionId();
        this.rejectNull(string, "The bucket name must be specified when deleting a version");
        this.rejectNull(string2, "The key must be specified when deleting a version");
        this.rejectNull(string3, "The version ID must be specified when deleting a version");
        CosHttpRequest<DeleteVersionRequest> cosHttpRequest = this.createRequest(string, string2, deleteVersionRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("versionId", string3);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public Bucket createBucket(String string) throws CosClientException, CosServiceException {
        return this.createBucket(new CreateBucketRequest(string));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws CosClientException, CosServiceException {
        this.rejectNull(createBucketRequest, "The CreateBucketRequest parameter must be specified when creating a bucket");
        String string = createBucketRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when creating a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when creating a bucket");
        string = string.trim();
        BucketNameUtils.validateBucketName(string);
        CosHttpRequest<CreateBucketRequest> cosHttpRequest = this.createRequest(string, "/", createBucketRequest, HttpMethodName.PUT);
        if (createBucketRequest.getAccessControlList() != null) {
            this.addAclHeaders(cosHttpRequest, createBucketRequest.getAccessControlList());
        } else if (createBucketRequest.getCannedAcl() != null) {
            cosHttpRequest.addHeader("x-cos-acl", createBucketRequest.getCannedAcl().toString());
        }
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return new Bucket(string);
    }

    @Override
    public void deleteBucket(String string) throws CosClientException, CosServiceException {
        this.deleteBucket(new DeleteBucketRequest(string));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketRequest, "The DeleteBucketRequest parameter must be specified when deleting a bucket");
        String string = deleteBucketRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting a bucket");
        CosHttpRequest<DeleteBucketRequest> cosHttpRequest = this.createRequest(string, "/", deleteBucketRequest, HttpMethodName.DELETE);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public boolean doesBucketExist(String string) throws CosClientException, CosServiceException {
        try {
            this.headBucket(new HeadBucketRequest(string));
            return true;
        }
        catch (CosServiceException cosServiceException) {
            if (cosServiceException.getStatusCode() == 404) {
                return false;
            }
            throw cosServiceException;
        }
    }

    @Override
    public HeadBucketResult headBucket(HeadBucketRequest headBucketRequest) throws CosClientException, CosServiceException {
        this.rejectNull(headBucketRequest, "The HeadBucketRequest parameter must be specified when head a bucket");
        String string = headBucketRequest.getBucketName();
        this.rejectNull(string, "The bucketName parameter must be specified.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when querying a bucket");
        CosHttpRequest<HeadBucketRequest> cosHttpRequest = this.createRequest(string, null, headBucketRequest, HttpMethodName.HEAD);
        return this.invoke(cosHttpRequest, new HeadBucketResultHandler());
    }

    @Override
    public List<Bucket> listBuckets() throws CosClientException, CosServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listBucketsRequest, "The request object parameter listBucketsRequest must be specified.");
        CosHttpRequest<ListBucketsRequest> cosHttpRequest = this.createRequest(null, null, listBucketsRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.ListBucketsUnmarshaller());
    }

    @Override
    public String getBucketLocation(String string) throws CosClientException, CosServiceException {
        return this.getBucketLocation(new GetBucketLocationRequest(string));
    }

    @Override
    public String getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketLocationRequest, "The request parameter must be specified when requesting a bucket's location");
        String string = getBucketLocationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting a bucket's location");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting a bucket's location");
        CosHttpRequest<GetBucketLocationRequest> cosHttpRequest = this.createRequest(string, null, getBucketLocationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("location", null);
        return this.invoke(cosHttpRequest, new Unmarshallers.BucketLocationUnmarshaller());
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws CosClientException, CosServiceException {
        this.rejectNull(initiateMultipartUploadRequest, "The request parameter must be specified when initiating a multipart upload");
        this.rejectNull(initiateMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when initiating a multipart upload");
        this.rejectNull(initiateMultipartUploadRequest.getKey(), "The key parameter must be specified when initiating a multipart upload");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when initiating a multipart upload");
        CosHttpRequest<InitiateMultipartUploadRequest> cosHttpRequest = this.createRequest(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), initiateMultipartUploadRequest, HttpMethodName.POST);
        cosHttpRequest.addParameter("uploads", null);
        if (initiateMultipartUploadRequest.getStorageClass() != null) {
            cosHttpRequest.addHeader("x-cos-storage-class", initiateMultipartUploadRequest.getStorageClass().toString());
        }
        if (initiateMultipartUploadRequest.getRedirectLocation() != null) {
            cosHttpRequest.addHeader("x-cos-website-redirect-location", initiateMultipartUploadRequest.getRedirectLocation());
        }
        if (initiateMultipartUploadRequest.getAccessControlList() != null) {
            this.addAclHeaders(cosHttpRequest, initiateMultipartUploadRequest.getAccessControlList());
        } else if (initiateMultipartUploadRequest.getCannedACL() != null) {
            cosHttpRequest.addHeader("x-cos-acl", initiateMultipartUploadRequest.getCannedACL().toString());
        }
        if (initiateMultipartUploadRequest.objectMetadata != null) {
            COSClient.populateRequestMetadata(cosHttpRequest, initiateMultipartUploadRequest.objectMetadata);
        }
        COSClient.populateSSE_C(cosHttpRequest, initiateMultipartUploadRequest.getSSECustomerKey());
        COSClient.populateSSE_KMS(cosHttpRequest, initiateMultipartUploadRequest.getSSECOSKeyManagementParams());
        cosHttpRequest.addHeader("Content-Length", String.valueOf(0));
        ResponseHeaderHandlerChain<InitiateMultipartUploadResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<InitiateMultipartUploadResult>(new Unmarshallers.InitiateMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler());
        return (InitiateMultipartUploadResult)this.invoke(cosHttpRequest, responseHeaderHandlerChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws CosClientException, CosServiceException {
        this.rejectNull(uploadPartRequest, "The request parameter must be specified when uploading a part");
        File file = uploadPartRequest.getFile();
        InputStream inputStream2 = uploadPartRequest.getInputStream();
        String string = uploadPartRequest.getBucketName();
        String string2 = uploadPartRequest.getKey();
        String string3 = uploadPartRequest.getUploadId();
        int n = uploadPartRequest.getPartNumber();
        long l = uploadPartRequest.getPartSize();
        this.rejectNull(string, "The bucket name parameter must be specified when uploading a part");
        this.rejectNull(string2, "The key parameter must be specified when uploading a part");
        this.rejectNull(string3, "The upload ID parameter must be specified when uploading a part");
        this.rejectNull(n, "The part number parameter must be specified when uploading a part");
        this.rejectNull(l, "The part size parameter must be specified when uploading a part");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when uploading a part");
        CosHttpRequest<UploadPartRequest> cosHttpRequest = this.createRequest(string, string2, uploadPartRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("uploadId", string3);
        cosHttpRequest.addParameter("partNumber", Integer.toString(n));
        ObjectMetadata objectMetadata = uploadPartRequest.getObjectMetadata();
        if (objectMetadata != null) {
            COSClient.populateRequestMetadata(cosHttpRequest, objectMetadata);
        }
        COSClient.addHeaderIfNotNull(cosHttpRequest, "Content-MD5", uploadPartRequest.getMd5Digest());
        cosHttpRequest.addHeader("Content-Length", Long.toString(l));
        COSClient.populateSSE_C(cosHttpRequest, uploadPartRequest.getSSECustomerKey());
        COSClient.populateTrafficLimit(cosHttpRequest, uploadPartRequest.getTrafficLimit());
        InputStream inputStream3 = inputStream2;
        try {
            if (file == null) {
                if (inputStream2 == null) {
                    throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
                }
                inputStream3 = ReleasableInputStream.wrap(inputStream3);
            } else {
                try {
                    inputStream3 = new ResettableInputStream(file);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Failed to open file " + file, iOException);
                }
            }
            inputStream3 = new InputSubstream(inputStream3, uploadPartRequest.getFileOffset(), l, uploadPartRequest.isLastPart());
            MD5DigestCalculatingInputStream mD5DigestCalculatingInputStream = null;
            if (uploadPartRequest.getMd5Digest() == null && !this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(uploadPartRequest)) {
                mD5DigestCalculatingInputStream = new MD5DigestCalculatingInputStream(inputStream3);
                inputStream3 = mD5DigestCalculatingInputStream;
            }
            UploadPartResult uploadPartResult = this.doUploadPart(string, string2, string3, n, l, cosHttpRequest, inputStream3, mD5DigestCalculatingInputStream);
            return uploadPartResult;
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(uploadPartRequest, file, inputStream2, inputStream3, log);
        }
    }

    private UploadPartResult doUploadPart(String string, String string2, String string3, int n, long l, CosHttpRequest<UploadPartRequest> cosHttpRequest, InputStream inputStream2, MD5DigestCalculatingInputStream mD5DigestCalculatingInputStream) {
        try {
            byte[] byArray;
            Object object;
            cosHttpRequest.setContent(inputStream2);
            ObjectMetadata objectMetadata = this.invoke(cosHttpRequest, new CosMetadataResponseHandler());
            String string4 = objectMetadata.getETag();
            if (mD5DigestCalculatingInputStream != null && !this.skipMd5CheckStrategy.skipClientSideValidationPerUploadPartResponse(objectMetadata) && !Arrays.equals((byte[])(object = (Object)mD5DigestCalculatingInputStream.getMd5Digest()), byArray = BinaryUtils.fromHex(string4))) {
                String string5 = "bucketName: " + string + ", key: " + string2 + ", uploadId: " + string3 + ", partNumber: " + n + ", partSize: " + l;
                throw new CosClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + BinaryUtils.toHex((byte[])object) + " in hex) didn't match hash (etag: " + string4 + " in hex) calculated by Qcloud COS.  You may need to delete the data stored in Qcloud COS. (" + string5 + ")");
            }
            object = new UploadPartResult();
            ((UploadPartResult)object).setETag(string4);
            ((UploadPartResult)object).setPartNumber(n);
            ((SSEResultBase)object).setSSEAlgorithm(objectMetadata.getSSEAlgorithm());
            ((SSEResultBase)object).setSSECustomerAlgorithm(objectMetadata.getSSECustomerAlgorithm());
            ((SSEResultBase)object).setSSECustomerKeyMd5(objectMetadata.getSSECustomerKeyMd5());
            ((UploadPartResult)object).setCrc64Ecma(objectMetadata.getCrc64Ecma());
            return object;
        }
        catch (Throwable throwable) {
            throw Throwables.failure(throwable);
        }
    }

    @Override
    public PartListing listParts(ListPartsRequest listPartsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listPartsRequest, "The request parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getBucketName(), "The bucket name parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getKey(), "The key parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getUploadId(), "The upload ID parameter must be specified when listing parts");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing parts");
        CosHttpRequest<ListPartsRequest> cosHttpRequest = this.createRequest(listPartsRequest.getBucketName(), listPartsRequest.getKey(), listPartsRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("uploadId", listPartsRequest.getUploadId());
        if (listPartsRequest.getMaxParts() != null) {
            cosHttpRequest.addParameter("max-parts", listPartsRequest.getMaxParts().toString());
        }
        if (listPartsRequest.getPartNumberMarker() != null) {
            cosHttpRequest.addParameter("part-number-marker", listPartsRequest.getPartNumberMarker().toString());
        }
        if (listPartsRequest.getEncodingType() != null) {
            cosHttpRequest.addParameter("encoding-type", listPartsRequest.getEncodingType());
        }
        return this.invoke(cosHttpRequest, new Unmarshallers.ListPartsResultUnmarshaller());
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws CosClientException, CosServiceException {
        this.rejectNull(abortMultipartUploadRequest, "The request parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getKey(), "The key parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getUploadId(), "The upload ID parameter must be specified when aborting a multipart upload");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when aborting a multipart uploads");
        String string = abortMultipartUploadRequest.getBucketName();
        String string2 = abortMultipartUploadRequest.getKey();
        CosHttpRequest<AbortMultipartUploadRequest> cosHttpRequest = this.createRequest(string, string2, abortMultipartUploadRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("uploadId", abortMultipartUploadRequest.getUploadId());
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws CosClientException, CosServiceException {
        XmlResponsesSaxParser.CompleteMultipartUploadHandler completeMultipartUploadHandler;
        this.rejectNull(completeMultipartUploadRequest, "The request parameter must be specified when completing a multipart upload");
        String string = completeMultipartUploadRequest.getBucketName();
        String string2 = completeMultipartUploadRequest.getKey();
        String string3 = completeMultipartUploadRequest.getUploadId();
        this.rejectNull(string, "The bucket name parameter must be specified when completing a multipart upload");
        this.rejectNull(string2, "The key parameter must be specified when completing a multipart upload");
        this.rejectNull(string3, "The upload ID parameter must be specified when completing a multipart upload");
        this.rejectNull(completeMultipartUploadRequest.getPartETags(), "The part ETags parameter must be specified when completing a multipart upload");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when completing a multipart uploads");
        int n = 0;
        do {
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler> responseHeaderHandlerChain;
            CosHttpRequest<CompleteMultipartUploadRequest> cosHttpRequest = this.createRequest(string, string2, completeMultipartUploadRequest, HttpMethodName.POST);
            cosHttpRequest.addParameter("uploadId", string3);
            byte[] byArray = RequestXmlFactory.convertToXmlByteArray(completeMultipartUploadRequest.getPartETags());
            cosHttpRequest.addHeader("Content-Type", "application/xml");
            cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
            ObjectMetadata objectMetadata = completeMultipartUploadRequest.getObjectMetadata();
            if (objectMetadata != null) {
                COSClient.populateRequestMetadata(cosHttpRequest, objectMetadata);
            }
            cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
            if (completeMultipartUploadRequest.getPicOperations() != null) {
                cosHttpRequest.addHeader("Pic-Operations", Jackson.toJsonString(completeMultipartUploadRequest.getPicOperations()));
            }
            if ((completeMultipartUploadHandler = (XmlResponsesSaxParser.CompleteMultipartUploadHandler)this.invoke(cosHttpRequest, responseHeaderHandlerChain = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler>(new Unmarshallers.CompleteMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new ObjectExpirationHeaderHandler(), new VIDResultHandler()))).getCompleteMultipartUploadResult() == null) continue;
            Map<String, String> map = responseHeaderHandlerChain.getResponseHeaders();
            String string4 = map.get("x-cos-version-id");
            String string5 = map.get("x-cos-hash-crc64ecma");
            completeMultipartUploadHandler.getCompleteMultipartUploadResult().setVersionId(string4);
            completeMultipartUploadHandler.getCompleteMultipartUploadResult().setCrc64Ecma(string5);
            if (completeMultipartUploadRequest.getPicOperations() != null) {
                completeMultipartUploadHandler.getCompleteMultipartUploadResult().setCiUploadResult(completeMultipartUploadHandler.getCiUploadResult());
            }
            return completeMultipartUploadHandler.getCompleteMultipartUploadResult();
        } while (this.shouldRetryCompleteMultipartUpload(completeMultipartUploadRequest, completeMultipartUploadHandler.getCOSException(), n++));
        throw completeMultipartUploadHandler.getCOSException();
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listMultipartUploadsRequest, "The request parameter must be specified when listing multipart uploads");
        this.rejectNull(listMultipartUploadsRequest.getBucketName(), "The bucket name parameter must be specified when listing multipart uploads");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing multipart uploads");
        CosHttpRequest<ListMultipartUploadsRequest> cosHttpRequest = this.createRequest(listMultipartUploadsRequest.getBucketName(), null, listMultipartUploadsRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("uploads", null);
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            cosHttpRequest.addParameter("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if (listMultipartUploadsRequest.getMaxUploads() != null) {
            cosHttpRequest.addParameter("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            cosHttpRequest.addParameter("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            cosHttpRequest.addParameter("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            cosHttpRequest.addParameter("prefix", listMultipartUploadsRequest.getPrefix());
        }
        if (listMultipartUploadsRequest.getEncodingType() != null) {
            cosHttpRequest.addParameter("encoding-type", listMultipartUploadsRequest.getEncodingType());
        }
        return this.invoke(cosHttpRequest, new Unmarshallers.ListMultipartUploadsResultUnmarshaller());
    }

    @Override
    public ObjectListing listObjects(String string) throws CosClientException, CosServiceException {
        return this.listObjects(new ListObjectsRequest(string, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String string, String string2) throws CosClientException, CosServiceException {
        return this.listObjects(new ListObjectsRequest(string, string2, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listObjectsRequest, "The ListObjectsRequest parameter must be specified when listing objects in a bucket");
        this.rejectNull(listObjectsRequest.getBucketName(), "The bucket name parameter must be specified when listing objects in a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing objects in a bucket");
        boolean bl = listObjectsRequest.getEncodingType() == null;
        CosHttpRequest<ListObjectsRequest> cosHttpRequest = this.createRequest(listObjectsRequest.getBucketName(), "/", listObjectsRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "prefix", this.leftStripPathDelimiter(listObjectsRequest.getPrefix()));
        COSClient.addParameterIfNotNull(cosHttpRequest, "marker", listObjectsRequest.getMarker());
        COSClient.addParameterIfNotNull(cosHttpRequest, "delimiter", listObjectsRequest.getDelimiter());
        cosHttpRequest.addParameter("encoding-type", bl ? "url" : listObjectsRequest.getEncodingType());
        if (listObjectsRequest.getMaxKeys() != null && listObjectsRequest.getMaxKeys() >= 0) {
            cosHttpRequest.addParameter("max-keys", listObjectsRequest.getMaxKeys().toString());
        }
        COSXmlResponseHandler<ObjectListing> cOSXmlResponseHandler = new COSXmlResponseHandler<ObjectListing>(new Unmarshallers.ListObjectsUnmarshaller(bl));
        return (ObjectListing)this.invoke(cosHttpRequest, cOSXmlResponseHandler);
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ObjectListing objectListing) throws CosClientException, CosServiceException {
        return this.listNextBatchOfObjects(new ListNextBatchOfObjectsRequest(objectListing));
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listNextBatchOfObjectsRequest, "The request object parameter must be specified when listing the next batch of objects in a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing the next batch of objects  in a bucket");
        ObjectListing objectListing = listNextBatchOfObjectsRequest.getPreviousObjectListing();
        if (!objectListing.isTruncated()) {
            ObjectListing objectListing2 = new ObjectListing();
            objectListing2.setBucketName(objectListing.getBucketName());
            objectListing2.setDelimiter(objectListing.getDelimiter());
            objectListing2.setMarker(objectListing.getNextMarker());
            objectListing2.setMaxKeys(objectListing.getMaxKeys());
            objectListing2.setPrefix(objectListing.getPrefix());
            objectListing2.setEncodingType(objectListing.getEncodingType());
            objectListing2.setTruncated(false);
            return objectListing2;
        }
        return this.listObjects(listNextBatchOfObjectsRequest.toListObjectsRequest());
    }

    @Override
    public VersionListing listVersions(String string, String string2) throws CosClientException, CosServiceException {
        return this.listVersions(new ListVersionsRequest(string, string2, null, null, null, null));
    }

    @Override
    public VersionListing listVersions(String string, String string2, String string3, String string4, String string5, Integer n) throws CosClientException, CosServiceException {
        ListVersionsRequest listVersionsRequest = new ListVersionsRequest().withBucketName(string).withPrefix(string2).withDelimiter(string5).withKeyMarker(string3).withVersionIdMarker(string4).withMaxResults(n);
        return this.listVersions(listVersionsRequest);
    }

    @Override
    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listVersionsRequest, "The ListVersionsRequest parameter must be specified when listing versions in a bucket");
        this.rejectNull(listVersionsRequest.getBucketName(), "The bucket name parameter must be specified when listing versions in a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing versions in a bucket");
        boolean bl = listVersionsRequest.getEncodingType() == null;
        CosHttpRequest<ListVersionsRequest> cosHttpRequest = this.createRequest(listVersionsRequest.getBucketName(), null, listVersionsRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("versions", null);
        COSClient.addParameterIfNotNull(cosHttpRequest, "prefix", listVersionsRequest.getPrefix());
        COSClient.addParameterIfNotNull(cosHttpRequest, "key-marker", listVersionsRequest.getKeyMarker());
        COSClient.addParameterIfNotNull(cosHttpRequest, "version-id-marker", listVersionsRequest.getVersionIdMarker());
        COSClient.addParameterIfNotNull(cosHttpRequest, "delimiter", listVersionsRequest.getDelimiter());
        cosHttpRequest.addParameter("encoding-type", bl ? "url" : listVersionsRequest.getEncodingType());
        if (listVersionsRequest.getMaxResults() != null && listVersionsRequest.getMaxResults() >= 0) {
            cosHttpRequest.addParameter("max-keys", listVersionsRequest.getMaxResults().toString());
        }
        return this.invoke(cosHttpRequest, new Unmarshallers.VersionListUnmarshaller(bl));
    }

    @Override
    public VersionListing listNextBatchOfVersions(VersionListing versionListing) throws CosClientException, CosServiceException {
        return this.listNextBatchOfVersions(new ListNextBatchOfVersionsRequest(versionListing));
    }

    @Override
    public VersionListing listNextBatchOfVersions(ListNextBatchOfVersionsRequest listNextBatchOfVersionsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listNextBatchOfVersionsRequest, "The request object parameter must be specified when listing the next batch of versions in a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing the next batch of versions in a bucket");
        VersionListing versionListing = listNextBatchOfVersionsRequest.getPreviousVersionListing();
        if (!versionListing.isTruncated()) {
            VersionListing versionListing2 = new VersionListing();
            versionListing2.setBucketName(versionListing.getBucketName());
            versionListing2.setDelimiter(versionListing.getDelimiter());
            versionListing2.setKeyMarker(versionListing.getNextKeyMarker());
            versionListing2.setVersionIdMarker(versionListing.getNextVersionIdMarker());
            versionListing2.setMaxKeys(versionListing.getMaxKeys());
            versionListing2.setPrefix(versionListing.getPrefix());
            versionListing2.setEncodingType(versionListing.getEncodingType());
            versionListing2.setTruncated(false);
            return versionListing2;
        }
        return this.listVersions(listNextBatchOfVersionsRequest.toListVersionsRequest());
    }

    @Override
    public CopyObjectResult copyObject(String string, String string2, String string3, String string4) throws CosClientException, CosServiceException {
        return this.copyObject(new CopyObjectRequest(string, string2, string3, string4));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws CosClientException, CosServiceException {
        Object object;
        this.rejectNull(copyObjectRequest, "The CopyObjectRequest parameter must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when copying an object");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when copying an object");
        String string = copyObjectRequest.getDestinationKey();
        String string2 = copyObjectRequest.getDestinationBucketName();
        CosHttpRequest<CopyObjectRequest> cosHttpRequest = this.createRequest(string2, string, copyObjectRequest, HttpMethodName.PUT);
        this.populateRequestWithCopyObjectParameters(cosHttpRequest, copyObjectRequest);
        this.setZeroContentLength(cosHttpRequest);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            object = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new ObjectExpirationHeaderHandler(), new VIDResultHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke((CosHttpRequest)cosHttpRequest, (HttpResponseHandler)object);
        }
        catch (CosServiceException cosServiceException) {
            if (cosServiceException.getStatusCode() == 412) {
                return null;
            }
            throw cosServiceException;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            object = copyObjectResultHandler.getErrorCode();
            String string3 = copyObjectResultHandler.getErrorMessage();
            String string4 = copyObjectResultHandler.getErrorRequestId();
            CosServiceException cosServiceException = new CosServiceException(string3);
            cosServiceException.setErrorCode((String)object);
            cosServiceException.setRequestId(string4);
            cosServiceException.setStatusCode(200);
            throw cosServiceException;
        }
        object = new CopyObjectResult();
        ((CopyObjectResult)object).setETag(copyObjectResultHandler.getETag());
        ((CopyObjectResult)object).setLastModifiedDate(copyObjectResultHandler.getLastModified());
        ((CopyObjectResult)object).setVersionId(copyObjectResultHandler.getVersionId());
        ((SSEResultBase)object).setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        ((SSEResultBase)object).setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        ((SSEResultBase)object).setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        ((CopyObjectResult)object).setExpirationTime(copyObjectResultHandler.getExpirationTime());
        ((CopyObjectResult)object).setExpirationTimeRuleId(copyObjectResultHandler.getExpirationTimeRuleId());
        ((CopyObjectResult)object).setDateStr(copyObjectResultHandler.getDateStr());
        ((CopyObjectResult)object).setCrc64Ecma(copyObjectResultHandler.getCrc64Ecma());
        ((CopyObjectResult)object).setRequestId(copyObjectResultHandler.getRequestId());
        return object;
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) throws CosClientException, CosServiceException {
        Object object;
        this.rejectNull(copyPartRequest, "The CopyPartRequest parameter must be specified when copying a part");
        this.rejectNull(copyPartRequest.getSourceBucketName(), "The source bucket name must be specified when copying a part");
        this.rejectNull(copyPartRequest.getSourceKey(), "The source object key must be specified when copying a part");
        this.rejectNull(copyPartRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying a part");
        this.rejectNull(copyPartRequest.getUploadId(), "The upload id must be specified when copying a part");
        this.rejectNull(copyPartRequest.getDestinationKey(), "The destination object key must be specified when copying a part");
        this.rejectNull(copyPartRequest.getPartNumber(), "The part number must be specified when copying a part");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when copying a part");
        String string = copyPartRequest.getDestinationKey();
        String string2 = copyPartRequest.getDestinationBucketName();
        CosHttpRequest<CopyPartRequest> cosHttpRequest = this.createRequest(string2, string, copyPartRequest, HttpMethodName.PUT);
        this.populateRequestWithCopyPartParameters(cosHttpRequest, copyPartRequest);
        cosHttpRequest.addParameter("uploadId", copyPartRequest.getUploadId());
        cosHttpRequest.addParameter("partNumber", Integer.toString(copyPartRequest.getPartNumber()));
        this.setZeroContentLength(cosHttpRequest);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            object = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new COSVersionHeaderHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke((CosHttpRequest)cosHttpRequest, (HttpResponseHandler)object);
        }
        catch (CosServiceException cosServiceException) {
            if (cosServiceException.getStatusCode() == 412) {
                return null;
            }
            throw cosServiceException;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            object = copyObjectResultHandler.getErrorCode();
            String string3 = copyObjectResultHandler.getErrorMessage();
            String string4 = copyObjectResultHandler.getErrorRequestId();
            CosServiceException cosServiceException = new CosServiceException(string3);
            cosServiceException.setErrorCode((String)object);
            cosServiceException.setErrorType(CosServiceException.ErrorType.Service);
            cosServiceException.setRequestId(string4);
            cosServiceException.setStatusCode(200);
            throw cosServiceException;
        }
        object = new CopyPartResult();
        ((CopyPartResult)object).setETag(copyObjectResultHandler.getETag());
        ((CopyPartResult)object).setPartNumber(copyPartRequest.getPartNumber());
        ((CopyPartResult)object).setLastModifiedDate(copyObjectResultHandler.getLastModified());
        ((CopyPartResult)object).setVersionId(copyObjectResultHandler.getVersionId());
        ((SSEResultBase)object).setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        ((SSEResultBase)object).setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        ((SSEResultBase)object).setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        ((CopyPartResult)object).setCrc64Ecma(copyObjectResultHandler.getCrc64Ecma());
        return object;
    }

    @Override
    public void setBucketLifecycleConfiguration(String string, BucketLifecycleConfiguration bucketLifecycleConfiguration) throws CosClientException, CosServiceException {
        this.setBucketLifecycleConfiguration(new SetBucketLifecycleConfigurationRequest(string, bucketLifecycleConfiguration));
    }

    @Override
    public void setBucketLifecycleConfiguration(SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketLifecycleConfigurationRequest, "The set bucket lifecycle configuration request object must be specified.");
        String string = setBucketLifecycleConfigurationRequest.getBucketName();
        BucketLifecycleConfiguration bucketLifecycleConfiguration = setBucketLifecycleConfigurationRequest.getLifecycleConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting bucket lifecycle configuration.");
        this.rejectNull(bucketLifecycleConfiguration, "The lifecycle configuration parameter must be specified when setting bucket lifecycle configuration.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting bucket lifecycle configuration");
        CosHttpRequest<SetBucketLifecycleConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketLifecycleConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("lifecycle", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketLifecycleConfiguration);
        cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        try {
            byte[] byArray2 = Md5Utils.computeMD5Hash(byArray);
            String string2 = BinaryUtils.toBase64(byArray2);
            cosHttpRequest.addHeader("Content-MD5", string2);
        }
        catch (Exception exception) {
            throw new CosClientException("Couldn't compute md5 sum", exception);
        }
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String string) throws CosClientException, CosServiceException {
        return this.getBucketLifecycleConfiguration(new GetBucketLifecycleConfigurationRequest(string));
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        this.rejectNull(getBucketLifecycleConfigurationRequest, "The request object pamameter getBucketLifecycleConfigurationRequest must be specified.");
        String string = getBucketLifecycleConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specifed when retrieving the bucket lifecycle configuration.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when retrieving lifecycle configuration");
        CosHttpRequest<GetBucketLifecycleConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketLifecycleConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("lifecycle", null);
        try {
            return this.invoke(cosHttpRequest, new Unmarshallers.BucketLifecycleConfigurationUnmarshaller());
        }
        catch (CosServiceException cosServiceException) {
            switch (cosServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cosServiceException;
        }
    }

    @Override
    public void deleteBucketLifecycleConfiguration(String string) throws CosClientException, CosServiceException {
        this.deleteBucketLifecycleConfiguration(new DeleteBucketLifecycleConfigurationRequest(string));
    }

    @Override
    public void deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketLifecycleConfigurationRequest, "The delete bucket lifecycle configuration request object must be specified.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting lifecycle configuration");
        String string = deleteBucketLifecycleConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting bucket lifecycle configuration.");
        CosHttpRequest<DeleteBucketLifecycleConfigurationRequest> cosHttpRequest = this.createRequest(string, null, deleteBucketLifecycleConfigurationRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("lifecycle", null);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketVersioningConfigurationRequest, "The SetBucketVersioningConfigurationRequest object must be specified when setting versioning configuration");
        String string = setBucketVersioningConfigurationRequest.getBucketName();
        BucketVersioningConfiguration bucketVersioningConfiguration = setBucketVersioningConfigurationRequest.getVersioningConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting versioning configuration");
        this.rejectNull(bucketVersioningConfiguration, "The bucket versioning parameter must be specified when setting versioning configuration");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting versioning configuration");
        CosHttpRequest<SetBucketVersioningConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketVersioningConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("versioning", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketVersioningConfiguration);
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(String string) throws CosClientException, CosServiceException {
        return this.getBucketVersioningConfiguration(new GetBucketVersioningConfigurationRequest(string));
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(GetBucketVersioningConfigurationRequest getBucketVersioningConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketVersioningConfigurationRequest, "The request object parameter getBucketVersioningConfigurationRequest must be specified.");
        String string = getBucketVersioningConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when querying versioning configuration");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when querying versioning configuration");
        CosHttpRequest<GetBucketVersioningConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketVersioningConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("versioning", null);
        return this.invoke(cosHttpRequest, new Unmarshallers.BucketVersioningConfigurationUnmarshaller());
    }

    @Override
    public void setObjectAcl(String string, String string2, AccessControlList accessControlList) throws CosClientException, CosServiceException {
        this.setObjectAcl(new SetObjectAclRequest(string, string2, accessControlList));
    }

    @Override
    public void setObjectAcl(String string, String string2, CannedAccessControlList cannedAccessControlList) throws CosClientException, CosServiceException {
        this.setObjectAcl(new SetObjectAclRequest(string, string2, cannedAccessControlList));
    }

    @Override
    public void setObjectAcl(SetObjectAclRequest setObjectAclRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setObjectAclRequest, "The request must not be null.");
        this.rejectNull(setObjectAclRequest.getBucketName(), "The bucket name parameter must be specified when setting an object's ACL");
        this.rejectNull(setObjectAclRequest.getKey(), "The key parameter must be specified when setting an object's ACL");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting an object acl");
        if (setObjectAclRequest.getAcl() != null && setObjectAclRequest.getCannedAcl() != null) {
            throw new IllegalArgumentException("Only one of the ACL and CannedACL parameters can be specified, not both.");
        }
        if (setObjectAclRequest.getAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), null, setObjectAclRequest.getAcl(), (CosServiceRequest)setObjectAclRequest);
        } else if (setObjectAclRequest.getCannedAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), setObjectAclRequest.getVersionId(), setObjectAclRequest.getCannedAcl(), (CosServiceRequest)setObjectAclRequest);
        } else {
            throw new IllegalArgumentException("At least one of the ACL and CannedACL parameters should be specified");
        }
    }

    @Override
    public AccessControlList getObjectAcl(String string, String string2) throws CosClientException, CosServiceException {
        return this.getObjectAcl(new GetObjectAclRequest(string, string2));
    }

    @Override
    public AccessControlList getObjectAcl(GetObjectAclRequest getObjectAclRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectAclRequest, "The request parameter must be specified when requesting an object's ACL");
        this.rejectNull(getObjectAclRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object's ACL");
        this.rejectNull(getObjectAclRequest.getKey(), "The key parameter must be specified when requesting an object's ACL");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting an object acl");
        return this.getAcl(getObjectAclRequest.getBucketName(), getObjectAclRequest.getKey(), getObjectAclRequest.getVersionId(), getObjectAclRequest);
    }

    @Override
    public void setBucketAcl(String string, AccessControlList accessControlList) throws CosClientException, CosServiceException {
        this.setBucketAcl(new SetBucketAclRequest(string, accessControlList));
    }

    @Override
    public void setBucketAcl(String string, CannedAccessControlList cannedAccessControlList) throws CosClientException, CosServiceException {
        this.setBucketAcl(new SetBucketAclRequest(string, cannedAccessControlList));
    }

    @Override
    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketAclRequest, "The SetBucketAclRequest parameter must be specified when setting a bucket's ACL");
        String string = setBucketAclRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when setting a bucket's ACL");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting a bucket acl");
        AccessControlList accessControlList = setBucketAclRequest.getAcl();
        CannedAccessControlList cannedAccessControlList = setBucketAclRequest.getCannedAcl();
        if (accessControlList == null && cannedAccessControlList == null) {
            throw new IllegalArgumentException("The ACL parameter must be specified when setting a bucket's ACL");
        }
        if (accessControlList != null && cannedAccessControlList != null) {
            throw new IllegalArgumentException("Only one of the acl and cannedAcl parameter can be specified, not both.");
        }
        if (accessControlList != null) {
            this.setAcl(string, null, null, accessControlList, (CosServiceRequest)setBucketAclRequest);
        } else {
            this.setAcl(string, null, null, cannedAccessControlList, (CosServiceRequest)setBucketAclRequest);
        }
    }

    @Override
    public AccessControlList getBucketAcl(String string) throws CosClientException, CosServiceException {
        return this.getBucketAcl(new GetBucketAclRequest(string));
    }

    @Override
    public AccessControlList getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketAclRequest, "The bucket name parameter must be specified when requesting a bucket's ACL");
        String string = getBucketAclRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting a bucket's ACL");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting a bucket acl");
        return this.getAcl(string, null, null, getBucketAclRequest);
    }

    private AccessControlList getAcl(String string, String string2, String string3, CosServiceRequest cosServiceRequest) {
        if (cosServiceRequest == null) {
            cosServiceRequest = new GenericBucketRequest(string);
        }
        CosHttpRequest<CosServiceRequest> cosHttpRequest = this.createRequest(string, string2, cosServiceRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("acl", null);
        if (string3 != null) {
            cosHttpRequest.addParameter("versionId", string3);
        }
        ResponseHeaderHandlerChain<AccessControlList> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<AccessControlList>(new Unmarshallers.AccessControlListUnmarshaller(), new COSDefaultAclHeaderHandler());
        return (AccessControlList)this.invoke(cosHttpRequest, responseHeaderHandlerChain);
    }

    private void setAcl(String string, String string2, String string3, AccessControlList accessControlList, CosServiceRequest cosServiceRequest) {
        if (cosServiceRequest == null) {
            cosServiceRequest = new GenericBucketRequest(string);
        }
        CosHttpRequest<CosServiceRequest> cosHttpRequest = this.createRequest(string, string2, cosServiceRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("acl", null);
        if (string3 != null) {
            cosHttpRequest.addParameter("versionId", string3);
        }
        byte[] byArray = new AclXmlFactory().convertToXmlByteArray(accessControlList);
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    private void setAcl(String string, String string2, String string3, CannedAccessControlList cannedAccessControlList, CosServiceRequest cosServiceRequest) throws CosClientException, CosServiceException {
        if (cosServiceRequest == null) {
            cosServiceRequest = new GenericBucketRequest(string);
        }
        CosHttpRequest<CosServiceRequest> cosHttpRequest = this.createRequest(string, string2, cosServiceRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("acl", null);
        cosHttpRequest.addHeader("x-cos-acl", cannedAccessControlList.toString());
        if (string3 != null) {
            cosHttpRequest.addParameter("versionId", string3);
        }
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(String string) throws CosClientException, CosServiceException {
        return this.getBucketCrossOriginConfiguration(new GetBucketCrossOriginConfigurationRequest(string));
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(GetBucketCrossOriginConfigurationRequest getBucketCrossOriginConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketCrossOriginConfigurationRequest, "The request object parameter getBucketCrossOriginConfigurationRequest must be specified.");
        String string = getBucketCrossOriginConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when retrieving the bucket cross origin configuration.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when retrieving the bucket cross origin configuration");
        CosHttpRequest<GetBucketCrossOriginConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketCrossOriginConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("cors", null);
        try {
            return this.invoke(cosHttpRequest, new Unmarshallers.BucketCrossOriginConfigurationUnmarshaller());
        }
        catch (CosServiceException cosServiceException) {
            switch (cosServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cosServiceException;
        }
    }

    @Override
    public void setBucketCrossOriginConfiguration(String string, BucketCrossOriginConfiguration bucketCrossOriginConfiguration) throws CosClientException, CosServiceException {
        this.setBucketCrossOriginConfiguration(new SetBucketCrossOriginConfigurationRequest(string, bucketCrossOriginConfiguration));
    }

    @Override
    public void setBucketCrossOriginConfiguration(SetBucketCrossOriginConfigurationRequest setBucketCrossOriginConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketCrossOriginConfigurationRequest, "The set bucket cross origin configuration request object must be specified.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting bucket cross origin configuration");
        String string = setBucketCrossOriginConfigurationRequest.getBucketName();
        BucketCrossOriginConfiguration bucketCrossOriginConfiguration = setBucketCrossOriginConfigurationRequest.getCrossOriginConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting bucket cross origin configuration.");
        this.rejectNull(bucketCrossOriginConfiguration, "The cross origin configuration parameter must be specified when setting bucket cross origin configuration.");
        CosHttpRequest<SetBucketCrossOriginConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketCrossOriginConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("cors", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketCrossOriginConfiguration);
        cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        try {
            byte[] byArray2 = Md5Utils.computeMD5Hash(byArray);
            String string2 = BinaryUtils.toBase64(byArray2);
            cosHttpRequest.addHeader("Content-MD5", string2);
        }
        catch (Exception exception) {
            throw new CosClientException("Couldn't compute md5 sum", exception);
        }
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(String string) throws CosClientException, CosServiceException {
        this.deleteBucketCrossOriginConfiguration(new DeleteBucketCrossOriginConfigurationRequest(string));
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(DeleteBucketCrossOriginConfigurationRequest deleteBucketCrossOriginConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketCrossOriginConfigurationRequest, "The delete bucket cross origin configuration request object must be specified.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting bucket cross origin configuration");
        String string = deleteBucketCrossOriginConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting bucket cross origin configuration.");
        CosHttpRequest<DeleteBucketCrossOriginConfigurationRequest> cosHttpRequest = this.createRequest(string, null, deleteBucketCrossOriginConfigurationRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("cors", null);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketReplicationConfiguration(String string, BucketReplicationConfiguration bucketReplicationConfiguration) throws CosClientException, CosServiceException {
        this.setBucketReplicationConfiguration(new SetBucketReplicationConfigurationRequest(string, bucketReplicationConfiguration));
    }

    @Override
    public void setBucketReplicationConfiguration(SetBucketReplicationConfigurationRequest setBucketReplicationConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketReplicationConfigurationRequest, "The set bucket replication configuration request object must be specified.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting bucket replication configuration");
        String string = setBucketReplicationConfigurationRequest.getBucketName();
        BucketReplicationConfiguration bucketReplicationConfiguration = setBucketReplicationConfigurationRequest.getReplicationConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting replication configuration.");
        this.rejectNull(bucketReplicationConfiguration, "The replication configuration parameter must be specified when setting replication configuration.");
        CosHttpRequest<SetBucketReplicationConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketReplicationConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("replication", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketReplicationConfiguration);
        cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        try {
            cosHttpRequest.addHeader("Content-MD5", BinaryUtils.toBase64(Md5Utils.computeMD5Hash(byArray)));
        }
        catch (Exception exception) {
            throw new CosClientException("Not able to compute MD5 of the replication rule configuration. Exception Message : " + exception.getMessage(), exception);
        }
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public BucketReplicationConfiguration getBucketReplicationConfiguration(String string) throws CosClientException, CosServiceException {
        return this.getBucketReplicationConfiguration(new GetBucketReplicationConfigurationRequest(string));
    }

    @Override
    public BucketReplicationConfiguration getBucketReplicationConfiguration(GetBucketReplicationConfigurationRequest getBucketReplicationConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketReplicationConfigurationRequest, "The bucket request parameter must be specified when retrieving replication configuration");
        String string = getBucketReplicationConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket request must specify a bucket name when retrieving replication configuration");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when retrieving replication configuration");
        CosHttpRequest<GetBucketReplicationConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketReplicationConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("replication", null);
        return this.invoke(cosHttpRequest, new Unmarshallers.BucketReplicationConfigurationUnmarshaller());
    }

    @Override
    public void deleteBucketReplicationConfiguration(String string) throws CosClientException, CosServiceException {
        this.deleteBucketReplicationConfiguration(new DeleteBucketReplicationConfigurationRequest(string));
    }

    @Override
    public void deleteBucketReplicationConfiguration(DeleteBucketReplicationConfigurationRequest deleteBucketReplicationConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketReplicationConfigurationRequest, "The DeleteBucketReplicationConfigurationRequest parameter must be specified when deleting replication configuration");
        String string = deleteBucketReplicationConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting replication configuration");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting replication configuration");
        CosHttpRequest<DeleteBucketReplicationConfigurationRequest> cosHttpRequest = this.createRequest(string, null, deleteBucketReplicationConfigurationRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("replication", null);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public URL generatePresignedUrl(String string, String string2, Date date) throws CosClientException {
        return this.generatePresignedUrl(string, string2, date, HttpMethodName.GET);
    }

    @Override
    public URL generatePresignedUrl(String string, String string2, Date date, HttpMethodName httpMethodName) throws CosClientException {
        return this.generatePresignedUrl(string, string2, date, httpMethodName, new HashMap<String, String>(), new HashMap<String, String>(), false, true);
    }

    @Override
    public URL generatePresignedUrl(String string, String string2, Date date, HttpMethodName httpMethodName, Map<String, String> map, Map<String, String> map2) throws CosClientException {
        return this.generatePresignedUrl(string, string2, date, httpMethodName, map, map2, false, true);
    }

    @Override
    public URL generatePresignedUrl(String string, String string2, Date date, HttpMethodName httpMethodName, Map<String, String> map, Map<String, String> map2, Boolean bl, Boolean bl2) throws CosClientException {
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(string, string2, httpMethodName);
        generatePresignedUrlRequest.setExpiration(date);
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            generatePresignedUrlRequest.addRequestParameter(entry.getKey(), entry.getValue());
        }
        if (bl2.booleanValue()) {
            generatePresignedUrlRequest.putCustomRequestHeader("Host", this.clientConfig.getEndpointBuilder().buildGeneralApiEndpoint(string));
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            generatePresignedUrlRequest.putCustomRequestHeader(entry.getKey(), entry.getValue());
        }
        generatePresignedUrlRequest.setSignPrefixMode(bl);
        return this.generatePresignedUrl(generatePresignedUrlRequest, bl2);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest) throws CosClientException {
        return this.generatePresignedUrl(generatePresignedUrlRequest, true);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest, Boolean bl) throws CosClientException {
        String[] stringArray;
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when generating a pre-signed URL");
        this.rejectNull(generatePresignedUrlRequest, "The request parameter must be specified when generating a pre-signed URL");
        generatePresignedUrlRequest.rejectIllegalArguments();
        String string = generatePresignedUrlRequest.getBucketName();
        String string2 = generatePresignedUrlRequest.getKey();
        if (generatePresignedUrlRequest.getExpiration() == null) {
            generatePresignedUrlRequest.setExpiration(new Date(System.currentTimeMillis() + this.clientConfig.getSignExpired() * 1000L));
        }
        HttpMethodName httpMethodName = generatePresignedUrlRequest.getMethod();
        CosHttpRequest<GeneratePresignedUrlRequest> cosHttpRequest = this.createRequest(string, string2, generatePresignedUrlRequest, httpMethodName);
        COSClient.addParameterIfNotNull(cosHttpRequest, "versionId", generatePresignedUrlRequest.getVersionId());
        for (Map.Entry<String, String> object22 : generatePresignedUrlRequest.getRequestParameters().entrySet()) {
            cosHttpRequest.addParameter(object22.getKey(), object22.getValue());
        }
        COSClient.addHeaderIfNotNull(cosHttpRequest, "Content-Type", generatePresignedUrlRequest.getContentType());
        COSClient.addHeaderIfNotNull(cosHttpRequest, "Content-MD5", generatePresignedUrlRequest.getContentMd5());
        Map<String, String> map = generatePresignedUrlRequest.getCustomRequestHeaders();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                cosHttpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        COSClient.addResponseHeaderParameters(cosHttpRequest, generatePresignedUrlRequest.getResponseHeaders());
        COSSigner cOSSigner = new COSSigner();
        COSCredentials cOSCredentials = this.fetchCredential();
        String string3 = cOSSigner.buildAuthorizationStr(cosHttpRequest.getHttpMethod(), cosHttpRequest.getResourcePath(), cosHttpRequest.getHeaders(), cosHttpRequest.getParameters(), cOSCredentials, generatePresignedUrlRequest.getExpiration(), bl);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.clientConfig.getHttpProtocol().toString()).append("://");
        stringBuilder.append(this.clientConfig.getEndpointBuilder().buildGeneralApiEndpoint(this.formatBucket(string, cOSCredentials.getCOSAppId())));
        stringBuilder.append(UrlEncoderUtils.encodeUrlPath(this.formatKey(string2)));
        boolean bl2 = false;
        if (string3 != null) {
            if (generatePresignedUrlRequest.isSignPrefixMode()) {
                stringBuilder.append("?sign=").append(UrlEncoderUtils.encode(string3));
            } else {
                String[] stringArray2 = string3.split("&");
                String[] stringArray3 = new String[stringArray2.length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray = stringArray2[i].split("=", 2);
                    if (stringArray.length == 2) {
                        stringArray3[i] = StringUtils.join("=", UrlEncoderUtils.encode(stringArray[0]), UrlEncoderUtils.encode(stringArray[1]));
                        continue;
                    }
                    if (stringArray.length != 1) continue;
                    stringArray3[i] = StringUtils.join("=", UrlEncoderUtils.encode(stringArray[0]));
                }
                string3 = StringUtils.join("&", stringArray3);
                stringBuilder.append("?").append(string3);
            }
            if (cOSCredentials instanceof COSSessionCredentials) {
                stringBuilder.append("&").append("x-cos-security-token").append("=").append(UrlEncoderUtils.encode(((COSSessionCredentials)cOSCredentials).getSessionToken()));
            }
            bl2 = true;
        }
        for (Map.Entry entry : cosHttpRequest.getParameters().entrySet()) {
            String string4 = (String)entry.getKey();
            stringArray = (String[])entry.getValue();
            if (!bl2) {
                stringBuilder.append("?");
                bl2 = true;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(UrlEncoderUtils.encode(string4));
            if (stringArray == null) continue;
            stringBuilder.append("=").append(UrlEncoderUtils.encode((String)stringArray));
        }
        try {
            return new URL(stringBuilder.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new CosClientException(malformedURLException.toString());
        }
    }

    @Override
    public void restoreObject(String string, String string2, int n) throws CosClientException, CosServiceException {
        this.restoreObject(new RestoreObjectRequest(string, string2, n));
    }

    @Override
    public void restoreObject(RestoreObjectRequest restoreObjectRequest) throws CosClientException, CosServiceException {
        this.rejectNull(restoreObjectRequest, "The RestoreObjectRequest parameter must be specified when restore a object.");
        String string = restoreObjectRequest.getBucketName();
        String string2 = restoreObjectRequest.getKey();
        String string3 = restoreObjectRequest.getVersionId();
        int n = restoreObjectRequest.getExpirationInDays();
        this.rejectNull(string, "The bucket name parameter must be specified when copying a cas object");
        this.rejectNull(string2, "The key parameter must be specified when copying a cas object");
        if (n == -1) {
            throw new IllegalArgumentException("The expiration in days parameter must be specified when copying a cas object");
        }
        CosHttpRequest<RestoreObjectRequest> cosHttpRequest = this.createRequest(string, string2, restoreObjectRequest, HttpMethodName.POST);
        cosHttpRequest.addParameter("restore", null);
        COSClient.addParameterIfNotNull(cosHttpRequest, "versionId", string3);
        byte[] byArray = RequestXmlFactory.convertToXmlByteArray(restoreObjectRequest);
        cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        try {
            byte[] byArray2 = Md5Utils.computeMD5Hash(byArray);
            String string4 = BinaryUtils.toBase64(byArray2);
            cosHttpRequest.addHeader("Content-MD5", string4);
        }
        catch (Exception exception) {
            throw new CosClientException("Couldn't compute md5 sum", exception);
        }
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public void updateObjectMetaData(String string, String string2, ObjectMetadata objectMetadata) throws CosClientException, CosServiceException {
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(string, string2, string, string2);
        copyObjectRequest.setNewObjectMetadata(objectMetadata);
        this.copyObject(copyObjectRequest);
    }

    @Override
    public void setBucketPolicy(String string, String string2) throws CosClientException, CosServiceException {
        this.setBucketPolicy(new SetBucketPolicyRequest(string, string2));
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String string) throws CosClientException, CosServiceException {
        return this.getBucketLoggingConfiguration(new GetBucketLoggingConfigurationRequest(string));
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(GetBucketLoggingConfigurationRequest getBucketLoggingConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketLoggingConfigurationRequest, "The request object parameter getBucketLoggingConfigurationRequest must be specifed.");
        String string = getBucketLoggingConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting a bucket's logging status");
        CosHttpRequest<GetBucketLoggingConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketLoggingConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("logging", null);
        return this.invoke(cosHttpRequest, new Unmarshallers.BucketLoggingConfigurationnmarshaller());
    }

    @Override
    public void setBucketLoggingConfiguration(SetBucketLoggingConfigurationRequest setBucketLoggingConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketLoggingConfigurationRequest, "The set bucket logging configuration request object must be specified when enabling server access logging");
        String string = setBucketLoggingConfigurationRequest.getBucketName();
        BucketLoggingConfiguration bucketLoggingConfiguration = setBucketLoggingConfigurationRequest.getLoggingConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when enabling server access logging");
        this.rejectNull(bucketLoggingConfiguration, "The logging configuration parameter must be specified when enabling server access logging");
        CosHttpRequest<SetBucketLoggingConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketLoggingConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("logging", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketLoggingConfiguration);
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketPolicy(SetBucketPolicyRequest setBucketPolicyRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketPolicyRequest, "The request object must be specified when setting a bucket policy");
        String string = setBucketPolicyRequest.getBucketName();
        String string2 = setBucketPolicyRequest.getPolicyText();
        this.rejectNull(string, "The bucket name must be specified when setting a bucket policy");
        this.rejectNull(string2, "The policy text must be specified when setting a bucket policy");
        CosHttpRequest<SetBucketPolicyRequest> cosHttpRequest = this.createRequest(string, null, setBucketPolicyRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("policy", null);
        cosHttpRequest.setContent(new ByteArrayInputStream(string2.getBytes(StringUtils.UTF8)));
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public BucketPolicy getBucketPolicy(String string) throws CosClientException, CosServiceException {
        return this.getBucketPolicy(new GetBucketPolicyRequest(string));
    }

    @Override
    public BucketPolicy getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketPolicyRequest, "The request object must be specified when getting a bucket policy");
        String string = getBucketPolicyRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when getting a bucket policy");
        CosHttpRequest<GetBucketPolicyRequest> cosHttpRequest = this.createRequest(string, null, getBucketPolicyRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("policy", null);
        BucketPolicy bucketPolicy = new BucketPolicy();
        try {
            String string2 = this.invoke(cosHttpRequest, new COSStringResponseHandler());
            bucketPolicy.setPolicyText(string2);
            return bucketPolicy;
        }
        catch (CosServiceException cosServiceException) {
            if (cosServiceException.getErrorCode().equals("NoSuchBucketPolicy")) {
                return bucketPolicy;
            }
            throw cosServiceException;
        }
    }

    @Override
    public void deleteBucketPolicy(String string) throws CosClientException, CosServiceException {
        this.deleteBucketPolicy(new DeleteBucketPolicyRequest(string));
    }

    @Override
    public void deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketPolicyRequest, "The request object must be specified when deleting a bucket policy");
        String string = deleteBucketPolicyRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when deleting a bucket policy");
        CosHttpRequest<DeleteBucketPolicyRequest> cosHttpRequest = this.createRequest(string, null, deleteBucketPolicyRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("policy", null);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String string) throws CosClientException, CosServiceException {
        return this.getBucketWebsiteConfiguration(new GetBucketWebsiteConfigurationRequest(string));
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(GetBucketWebsiteConfigurationRequest getBucketWebsiteConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketWebsiteConfigurationRequest, "The request object parameter getBucketWebsiteConfigurationRequest must be specified.");
        String string = getBucketWebsiteConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting a bucket's website configuration");
        CosHttpRequest<GetBucketWebsiteConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketWebsiteConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("website", null);
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        try {
            return this.invoke(cosHttpRequest, new Unmarshallers.BucketWebsiteConfigurationUnmarshaller());
        }
        catch (CosServiceException cosServiceException) {
            if (cosServiceException.getStatusCode() == 404) {
                return null;
            }
            throw cosServiceException;
        }
    }

    @Override
    public void setBucketWebsiteConfiguration(String string, BucketWebsiteConfiguration bucketWebsiteConfiguration) throws CosClientException, CosServiceException {
        this.setBucketWebsiteConfiguration(new SetBucketWebsiteConfigurationRequest(string, bucketWebsiteConfiguration));
    }

    @Override
    public void setBucketWebsiteConfiguration(SetBucketWebsiteConfigurationRequest setBucketWebsiteConfigurationRequest) throws CosClientException, CosServiceException {
        String string = setBucketWebsiteConfigurationRequest.getBucketName();
        BucketWebsiteConfiguration bucketWebsiteConfiguration = setBucketWebsiteConfigurationRequest.getConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting a bucket's website configuration");
        this.rejectNull(bucketWebsiteConfiguration, "The bucket website configuration parameter must be specified when setting a bucket's website configuration");
        if (bucketWebsiteConfiguration.getRedirectAllRequestsTo() == null) {
            this.rejectNull(bucketWebsiteConfiguration.getIndexDocumentSuffix(), "The bucket website configuration parameter must specify the index document suffix when setting a bucket's website configuration");
        }
        CosHttpRequest<SetBucketWebsiteConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketWebsiteConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("website", null);
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketWebsiteConfiguration);
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public void deleteBucketWebsiteConfiguration(String string) throws CosClientException, CosServiceException {
        this.deleteBucketWebsiteConfiguration(new DeleteBucketWebsiteConfigurationRequest(string));
    }

    @Override
    public void deleteBucketWebsiteConfiguration(DeleteBucketWebsiteConfigurationRequest deleteBucketWebsiteConfigurationRequest) throws CosClientException, CosServiceException {
        String string = deleteBucketWebsiteConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting a bucket's website configuration");
        CosHttpRequest<DeleteBucketWebsiteConfigurationRequest> cosHttpRequest = this.createRequest(string, null, deleteBucketWebsiteConfigurationRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("website", null);
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public void deleteBucketDomainConfiguration(String string) throws CosClientException, CosServiceException {
        this.deleteBucketDomainConfiguration(new DeleteBucketDomainConfigurationRequest(string));
    }

    @Override
    public void deleteBucketDomainConfiguration(DeleteBucketDomainConfigurationRequest deleteBucketDomainConfigurationRequest) {
        String string = deleteBucketDomainConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting a bucket's domain configuration");
        CosHttpRequest<DeleteBucketDomainConfigurationRequest> cosHttpRequest = this.createRequest(string, null, deleteBucketDomainConfigurationRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("domain", null);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketDomainConfiguration(String string, BucketDomainConfiguration bucketDomainConfiguration) throws CosClientException, CosServiceException {
        this.setBucketDomainConfiguration(new SetBucketDomainConfigurationRequest(string, bucketDomainConfiguration));
    }

    @Override
    public void setBucketDomainConfiguration(SetBucketDomainConfigurationRequest setBucketDomainConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketDomainConfigurationRequest, "The request object parameter setBucketDomainConfigurationRequest must be specified.");
        String string = setBucketDomainConfigurationRequest.getBucketName();
        BucketDomainConfiguration bucketDomainConfiguration = setBucketDomainConfigurationRequest.getConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting a bucket's domain configuration");
        this.rejectNull(bucketDomainConfiguration, "The bucket domain configuration parameter must be specified when setting a bucket's domain configuration");
        this.rejectNull(bucketDomainConfiguration.getDomainRules(), "The bucket domain rules must specify the index document suffix when setting a bucket's domain configuration");
        CosHttpRequest<SetBucketDomainConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketDomainConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("domain", null);
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketDomainConfiguration);
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public BucketDomainConfiguration getBucketDomainConfiguration(String string) throws CosClientException, CosServiceException {
        return this.getBucketDomainConfiguration(new GetBucketDomainConfigurationRequest(string));
    }

    @Override
    public BucketDomainConfiguration getBucketDomainConfiguration(GetBucketDomainConfigurationRequest getBucketDomainConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketDomainConfigurationRequest, "The request object parameter getBucketDomainConfigurationRequest must be specified.");
        String string = getBucketDomainConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when retrieving the bucket domain configuration.");
        CosHttpRequest<GetBucketDomainConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketDomainConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("domain", null);
        try {
            return this.invoke(cosHttpRequest, new Unmarshallers.BucketDomainConfigurationUnmarshaller());
        }
        catch (CosServiceException cosServiceException) {
            switch (cosServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cosServiceException;
        }
    }

    @Override
    public void setBucketDomainCertificate(String string, BucketPutDomainCertificate bucketPutDomainCertificate) throws CosClientException, CosServiceException {
        this.setBucketDomainCertificate(new SetBucketDomainCertificateRequest(string, bucketPutDomainCertificate));
    }

    @Override
    public void setBucketDomainCertificate(SetBucketDomainCertificateRequest setBucketDomainCertificateRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketDomainCertificateRequest, "The request object parameter setBucketDomainCertificateRequest must be specified.");
        String string = setBucketDomainCertificateRequest.getBucketName();
        BucketPutDomainCertificate bucketPutDomainCertificate = setBucketDomainCertificateRequest.getBucketPutDomainCertificate();
        this.rejectNull(string, "The bucket name parameter must be specified when setting a bucket's domain certificate");
        this.rejectNull(bucketPutDomainCertificate, "The bucket domain certificate parameter must be specified when setting a bucket's domain certificate");
        this.rejectNull(bucketPutDomainCertificate.getBucketDomainCertificateInfo(), "The bucket domain certificate parameter must be specified when setting a bucket's domain certificate");
        this.rejectNull(bucketPutDomainCertificate.getDomainList(), "The bucket domain lists must specify the index document suffix when setting a bucket's domain certificate");
        CosHttpRequest<SetBucketDomainCertificateRequest> cosHttpRequest = this.createRequest(string, null, setBucketDomainCertificateRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("domaincertificate", null);
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketPutDomainCertificate);
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public BucketGetDomainCertificate getBucketDomainCertificate(String string, String string2) throws CosClientException, CosServiceException {
        BucketDomainCertificateRequest bucketDomainCertificateRequest = new BucketDomainCertificateRequest(string);
        bucketDomainCertificateRequest.setDomainName(string2);
        return this.getBucketDomainCertificate(bucketDomainCertificateRequest);
    }

    @Override
    public BucketGetDomainCertificate getBucketDomainCertificate(BucketDomainCertificateRequest bucketDomainCertificateRequest) throws CosClientException, CosServiceException {
        this.rejectNull(bucketDomainCertificateRequest, "The request object parameter getBucketDomainCertificateRequest must be specified.");
        String string = bucketDomainCertificateRequest.getBucketName();
        String string2 = bucketDomainCertificateRequest.getDomainName();
        this.rejectNull(string, "The bucket name must be specified when retrieving the bucket domain Certificate.");
        this.rejectNull(string2, "The domain name must be specified when retrieving the bucket domain Certificate.");
        CosHttpRequest<BucketDomainCertificateRequest> cosHttpRequest = this.createRequest(string, null, bucketDomainCertificateRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("domaincertificate", null);
        cosHttpRequest.addParameter("domainname", string2);
        try {
            return this.invoke(cosHttpRequest, new Unmarshallers.BucketDomainCertificateUnmarshaller());
        }
        catch (CosServiceException cosServiceException) {
            switch (cosServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cosServiceException;
        }
    }

    @Override
    public void deleteBucketDomainCertificate(String string, String string2) throws CosClientException, CosServiceException {
        BucketDomainCertificateRequest bucketDomainCertificateRequest = new BucketDomainCertificateRequest(string);
        bucketDomainCertificateRequest.setDomainName(string2);
        this.deleteBucketDomainCertificate(bucketDomainCertificateRequest);
    }

    @Override
    public void deleteBucketDomainCertificate(BucketDomainCertificateRequest bucketDomainCertificateRequest) throws CosClientException, CosServiceException {
        this.rejectNull(bucketDomainCertificateRequest, "The request object parameter deleteBucketDomainCertificateRequest must be specified.");
        String string = bucketDomainCertificateRequest.getBucketName();
        String string2 = bucketDomainCertificateRequest.getDomainName();
        this.rejectNull(string, "The bucket name must be specified when removing the bucket domain Certificate.");
        this.rejectNull(string2, "The domain name must be specified when removing the bucket domain Certificate.");
        CosHttpRequest<BucketDomainCertificateRequest> cosHttpRequest = this.createRequest(string, null, bucketDomainCertificateRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("domaincertificate", null);
        cosHttpRequest.addParameter("domainname", string2);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketRefererConfiguration(String string, BucketRefererConfiguration bucketRefererConfiguration) throws CosClientException, CosServiceException {
        this.setBucketRefererConfiguration(new SetBucketRefererConfigurationRequest(string, bucketRefererConfiguration));
    }

    @Override
    public void setBucketRefererConfiguration(SetBucketRefererConfigurationRequest setBucketRefererConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketRefererConfigurationRequest, "The request object parameter setBucketRefererConfigurationRequest must be specified.");
        String string = setBucketRefererConfigurationRequest.getBucketName();
        BucketRefererConfiguration bucketRefererConfiguration = setBucketRefererConfigurationRequest.getConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting a bucket's referer configuration");
        this.rejectNull(bucketRefererConfiguration, "The bucket domain configuration parameter must be specified when setting a bucket's referer configuration");
        CosHttpRequest<SetBucketRefererConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketRefererConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("referer", null);
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketRefererConfiguration);
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        try {
            byte[] byArray2 = Md5Utils.computeMD5Hash(byArray);
            String string2 = BinaryUtils.toBase64(byArray2);
            cosHttpRequest.addHeader("Content-MD5", string2);
        }
        catch (Exception exception) {
            throw new CosClientException("Couldn't compute md5 sum", exception);
        }
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public BucketRefererConfiguration getBucketRefererConfiguration(String string) throws CosClientException, CosServiceException {
        return this.getBucketRefererConfiguration(new GetBucketRefererConfigurationRequest(string));
    }

    @Override
    public BucketRefererConfiguration getBucketRefererConfiguration(GetBucketRefererConfigurationRequest getBucketRefererConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketRefererConfigurationRequest, "The request object parameter getBucketRefererConfigurationRequest must be specified.");
        String string = getBucketRefererConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when retrieving the bucket domain configuration.");
        CosHttpRequest<GetBucketRefererConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketRefererConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("referer", null);
        try {
            return this.invoke(cosHttpRequest, new Unmarshallers.BucketRefererConfigurationUnmarshaller());
        }
        catch (CosServiceException cosServiceException) {
            switch (cosServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cosServiceException;
        }
    }

    @Override
    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(String string, String string2) throws CosClientException, CosServiceException {
        return this.deleteBucketInventoryConfiguration(new DeleteBucketInventoryConfigurationRequest(string, string2));
    }

    @Override
    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketInventoryConfigurationRequest, "The request cannot be null");
        this.rejectNull(deleteBucketInventoryConfigurationRequest.getBucketName(), "The bucketName cannot be null");
        this.rejectNull(deleteBucketInventoryConfigurationRequest.getId(), "The id cannot be null");
        String string = deleteBucketInventoryConfigurationRequest.getBucketName();
        String string2 = deleteBucketInventoryConfigurationRequest.getId();
        CosHttpRequest<DeleteBucketInventoryConfigurationRequest> cosHttpRequest = this.createRequest(string, null, deleteBucketInventoryConfigurationRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("inventory", null);
        cosHttpRequest.addParameter("id", string2);
        return this.invoke(cosHttpRequest, new Unmarshallers.DeleteBucketInventoryConfigurationUnmarshaller());
    }

    @Override
    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(String string, String string2) throws CosClientException, CosServiceException {
        return this.getBucketInventoryConfiguration(new GetBucketInventoryConfigurationRequest(string, string2));
    }

    @Override
    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketInventoryConfigurationRequest, "The request cannot be null");
        this.rejectNull(getBucketInventoryConfigurationRequest.getBucketName(), "The bucketName cannot be null");
        this.rejectNull(getBucketInventoryConfigurationRequest.getId(), "The id cannot be null");
        String string = getBucketInventoryConfigurationRequest.getBucketName();
        String string2 = getBucketInventoryConfigurationRequest.getId();
        CosHttpRequest<GetBucketInventoryConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketInventoryConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("inventory", null);
        cosHttpRequest.addParameter("id", string2);
        return this.invoke(cosHttpRequest, new Unmarshallers.GetBucketInventoryConfigurationUnmarshaller());
    }

    @Override
    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(String string, InventoryConfiguration inventoryConfiguration) throws CosClientException, CosServiceException {
        return this.setBucketInventoryConfiguration(new SetBucketInventoryConfigurationRequest(string, inventoryConfiguration));
    }

    @Override
    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(SetBucketInventoryConfigurationRequest setBucketInventoryConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketInventoryConfigurationRequest, "The request cannot be null");
        this.rejectNull(setBucketInventoryConfigurationRequest.getBucketName(), "The bucketName cannot be null");
        this.rejectNull(setBucketInventoryConfigurationRequest.getInventoryConfiguration(), "The inventoryConfiguration cannot be null");
        this.rejectNull(setBucketInventoryConfigurationRequest.getInventoryConfiguration().getId(), "The inventoryConfiguration.id cannot be null");
        String string = setBucketInventoryConfigurationRequest.getBucketName();
        InventoryConfiguration inventoryConfiguration = setBucketInventoryConfigurationRequest.getInventoryConfiguration();
        String string2 = inventoryConfiguration.getId();
        CosHttpRequest<SetBucketInventoryConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketInventoryConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("inventory", null);
        cosHttpRequest.addParameter("id", string2);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(inventoryConfiguration);
        cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        return this.invoke(cosHttpRequest, new Unmarshallers.SetBucketInventoryConfigurationUnmarshaller());
    }

    @Override
    public ListBucketInventoryConfigurationsResult listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listBucketInventoryConfigurationsRequest, "The request cannot be null");
        this.rejectNull(listBucketInventoryConfigurationsRequest.getBucketName(), "The bucketName cannot be null");
        String string = listBucketInventoryConfigurationsRequest.getBucketName();
        CosHttpRequest<ListBucketInventoryConfigurationsRequest> cosHttpRequest = this.createRequest(string, null, listBucketInventoryConfigurationsRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("inventory", null);
        COSClient.addParameterIfNotNull(cosHttpRequest, "continuation-token", listBucketInventoryConfigurationsRequest.getContinuationToken());
        return this.invoke(cosHttpRequest, new Unmarshallers.ListBucketInventoryConfigurationsUnmarshaller());
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(String string) {
        return this.getBucketTaggingConfiguration(new GetBucketTaggingConfigurationRequest(string));
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(GetBucketTaggingConfigurationRequest getBucketTaggingConfigurationRequest) {
        this.rejectNull(getBucketTaggingConfigurationRequest, "The request object parameter getBucketTaggingConfigurationRequest must be specifed.");
        String string = getBucketTaggingConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when retrieving the bucket tagging configuration.");
        CosHttpRequest<GetBucketTaggingConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketTaggingConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("tagging", null);
        try {
            return this.invoke(cosHttpRequest, new Unmarshallers.BucketTaggingConfigurationUnmarshaller());
        }
        catch (CosServiceException cosServiceException) {
            switch (cosServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cosServiceException;
        }
    }

    @Override
    public void setBucketTaggingConfiguration(String string, BucketTaggingConfiguration bucketTaggingConfiguration) {
        this.setBucketTaggingConfiguration(new SetBucketTaggingConfigurationRequest(string, bucketTaggingConfiguration));
    }

    @Override
    public void setBucketTaggingConfiguration(SetBucketTaggingConfigurationRequest setBucketTaggingConfigurationRequest) {
        this.rejectNull(setBucketTaggingConfigurationRequest, "The set bucket tagging configuration request object must be specified.");
        String string = setBucketTaggingConfigurationRequest.getBucketName();
        BucketTaggingConfiguration bucketTaggingConfiguration = setBucketTaggingConfigurationRequest.getTaggingConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting bucket tagging configuration.");
        this.rejectNull(bucketTaggingConfiguration, "The tagging configuration parameter must be specified when setting bucket tagging configuration.");
        CosHttpRequest<SetBucketTaggingConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketTaggingConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("tagging", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketTaggingConfiguration);
        cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        try {
            byte[] byArray2 = Md5Utils.computeMD5Hash(byArray);
            String string2 = BinaryUtils.toBase64(byArray2);
            cosHttpRequest.addHeader("Content-MD5", string2);
        }
        catch (Exception exception) {
            throw new CosClientException("Couldn't compute md5 sum", exception);
        }
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public void deleteBucketTaggingConfiguration(String string) {
        this.deleteBucketTaggingConfiguration(new DeleteBucketTaggingConfigurationRequest(string));
    }

    @Override
    public void deleteBucketTaggingConfiguration(DeleteBucketTaggingConfigurationRequest deleteBucketTaggingConfigurationRequest) {
        this.rejectNull(deleteBucketTaggingConfigurationRequest, "The delete bucket tagging configuration request object must be specified.");
        String string = deleteBucketTaggingConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting bucket tagging configuration.");
        CosHttpRequest<DeleteBucketTaggingConfigurationRequest> cosHttpRequest = this.createRequest(string, null, deleteBucketTaggingConfigurationRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("tagging", null);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    private void setContent(CosHttpRequest<?> cosHttpRequest, byte[] byArray, String string, boolean bl) {
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        cosHttpRequest.addHeader("Content-Length", Integer.toString(byArray.length));
        cosHttpRequest.addHeader("Content-Type", string);
        if (bl) {
            try {
                byte[] byArray2 = Md5Utils.computeMD5Hash(byArray);
                String string2 = BinaryUtils.toBase64(byArray2);
                cosHttpRequest.addHeader("Content-MD5", string2);
            }
            catch (Exception exception) {
                throw new CosClientException("Couldn't compute md5 sum", exception);
            }
        }
    }

    @Override
    public SelectObjectContentResult selectObjectContent(SelectObjectContentRequest selectObjectContentRequest) throws CosClientException, CosServiceException {
        this.rejectNull(selectObjectContentRequest, "The request parameter must be specified");
        this.rejectNull(selectObjectContentRequest.getBucketName(), "The bucket name parameter must be specified when selecting object content.");
        this.rejectNull(selectObjectContentRequest.getKey(), "The key parameter must be specified when selecting object content.");
        CosHttpRequest<SelectObjectContentRequest> cosHttpRequest = this.createRequest(selectObjectContentRequest.getBucketName(), selectObjectContentRequest.getKey(), selectObjectContentRequest, HttpMethodName.POST);
        cosHttpRequest.addParameter("select", null);
        cosHttpRequest.addParameter("select-type", "2");
        COSClient.populateSSE_C(cosHttpRequest, selectObjectContentRequest.getSSECustomerKey());
        this.setContent(cosHttpRequest, RequestXmlFactory.convertToXmlByteArray(selectObjectContentRequest), ContentType.APPLICATION_XML.toString(), true);
        COSObject cOSObject = this.invoke(cosHttpRequest, new COSObjectResponseHandler());
        ServiceClientHolderInputStream serviceClientHolderInputStream = new ServiceClientHolderInputStream(cOSObject.getObjectContent(), this);
        return new SelectObjectContentResult().withPayload(new SelectObjectContentEventStream(serviceClientHolderInputStream));
    }

    @Override
    public GetObjectTaggingResult getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest) {
        this.rejectNull(getObjectTaggingRequest, "The request parameter must be specified when getting the object tags");
        this.rejectNull(getObjectTaggingRequest.getBucketName(), "The request bucketName must be specified when getting the object tags");
        this.rejectNull(getObjectTaggingRequest.getKey(), "The request key must be specified when getting the object tags");
        CosHttpRequest<GetObjectTaggingRequest> cosHttpRequest = this.createRequest(getObjectTaggingRequest.getBucketName(), getObjectTaggingRequest.getKey(), getObjectTaggingRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("tagging", null);
        COSClient.addParameterIfNotNull(cosHttpRequest, "versionId", getObjectTaggingRequest.getVersionId());
        ResponseHeaderHandlerChain<GetObjectTaggingResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<GetObjectTaggingResult>(new Unmarshallers.GetObjectTaggingResponseUnmarshaller(), new GetObjectTaggingResponseHeaderHandler());
        return (GetObjectTaggingResult)this.invoke(cosHttpRequest, responseHeaderHandlerChain);
    }

    @Override
    public SetObjectTaggingResult setObjectTagging(SetObjectTaggingRequest setObjectTaggingRequest) {
        this.rejectNull(setObjectTaggingRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(setObjectTaggingRequest.getBucketName(), "The request bucketName must be specified setting the object tags");
        this.rejectNull(setObjectTaggingRequest.getKey(), "The request key must be specified setting the object tags");
        this.rejectNull(setObjectTaggingRequest.getTagging(), "The request tagging must be specified setting the object tags");
        CosHttpRequest<SetObjectTaggingRequest> cosHttpRequest = this.createRequest(setObjectTaggingRequest.getBucketName(), setObjectTaggingRequest.getKey(), setObjectTaggingRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("tagging", null);
        COSClient.addParameterIfNotNull(cosHttpRequest, "versionId", setObjectTaggingRequest.getVersionId());
        byte[] byArray = new ObjectTaggingXmlFactory().convertToXmlByteArray(setObjectTaggingRequest.getTagging());
        this.setContent(cosHttpRequest, byArray, "application/xml", true);
        ResponseHeaderHandlerChain<SetObjectTaggingResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<SetObjectTaggingResult>(new Unmarshallers.SetObjectTaggingResponseUnmarshaller(), new SetObjectTaggingResponseHeaderHandler());
        return (SetObjectTaggingResult)this.invoke(cosHttpRequest, responseHeaderHandlerChain);
    }

    @Override
    public DeleteObjectTaggingResult deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest) {
        this.rejectNull(deleteObjectTaggingRequest, "The request parameter must be specified when delete the object tags");
        this.rejectNull(deleteObjectTaggingRequest.getBucketName(), "The request bucketName must be specified setting the object tags");
        this.rejectNull(deleteObjectTaggingRequest.getKey(), "The request key must be specified setting the object tags");
        CosHttpRequest<DeleteObjectTaggingRequest> cosHttpRequest = this.createRequest(deleteObjectTaggingRequest.getBucketName(), deleteObjectTaggingRequest.getKey(), deleteObjectTaggingRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("tagging", null);
        COSClient.addParameterIfNotNull(cosHttpRequest, "versionId", deleteObjectTaggingRequest.getVersionId());
        ResponseHeaderHandlerChain<DeleteObjectTaggingResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<DeleteObjectTaggingResult>(new Unmarshallers.DeleteObjectTaggingResponseUnmarshaller(), new DeleteObjectTaggingHeaderHandler());
        return (DeleteObjectTaggingResult)this.invoke(cosHttpRequest, responseHeaderHandlerChain);
    }

    @Override
    public BucketIntelligentTierConfiguration getBucketIntelligentTierConfiguration(GetBucketIntelligentTierConfigurationRequest getBucketIntelligentTierConfigurationRequest) {
        this.rejectNull(getBucketIntelligentTierConfigurationRequest, "The request cannot be null");
        this.rejectNull(getBucketIntelligentTierConfigurationRequest.getBucketName(), "The bucketName cannot be null");
        String string = getBucketIntelligentTierConfigurationRequest.getBucketName();
        CosHttpRequest<GetBucketIntelligentTierConfigurationRequest> cosHttpRequest = this.createRequest(string, null, getBucketIntelligentTierConfigurationRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("intelligenttiering", null);
        return this.invoke(cosHttpRequest, new Unmarshallers.GetBucketIntelligentTierConfigurationsUnmarshaller());
    }

    @Override
    public BucketIntelligentTierConfiguration getBucketIntelligentTierConfiguration(String string) {
        return this.getBucketIntelligentTierConfiguration(new GetBucketIntelligentTierConfigurationRequest(string));
    }

    @Override
    public void setBucketIntelligentTieringConfiguration(SetBucketIntelligentTierConfigurationRequest setBucketIntelligentTierConfigurationRequest) {
        this.rejectNull(setBucketIntelligentTierConfigurationRequest, "The request cannot be null");
        this.rejectNull(setBucketIntelligentTierConfigurationRequest.getBucketName(), "The bucketName cannot be null");
        BucketIntelligentTierConfiguration bucketIntelligentTierConfiguration = setBucketIntelligentTierConfigurationRequest.getBucketIntelligentTierConfiguration();
        this.rejectNull(bucketIntelligentTierConfiguration, "Bucket intelligent tier configuration cannot be null");
        String string = setBucketIntelligentTierConfigurationRequest.getBucketName();
        CosHttpRequest<SetBucketIntelligentTierConfigurationRequest> cosHttpRequest = this.createRequest(string, null, setBucketIntelligentTierConfigurationRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("intelligenttiering", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketIntelligentTierConfiguration);
        cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
    }

    @Override
    public MediaJobResponse createMediaJobs(MediaJobsRequest mediaJobsRequest) {
        this.checkCIRequestCommon(mediaJobsRequest);
        this.rejectNull(mediaJobsRequest.getTag(), "The tag parameter must be specified setting the object tags");
        this.rejectNull(mediaJobsRequest.getQueueId(), "The queueId parameter must be specified setting the object tags");
        this.rejectStartWith(mediaJobsRequest.getCallBack(), "http", "The CallBack parameter mush start with http or https");
        CosHttpRequest<MediaJobsRequest> cosHttpRequest = this.createRequest(mediaJobsRequest.getBucketName(), "/jobs", mediaJobsRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIMediaXmlFactory.convertToXmlByteArray(mediaJobsRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.JobCreatUnmarshaller());
    }

    @Override
    public Boolean cancelMediaJob(MediaJobsRequest mediaJobsRequest) {
        this.checkCIRequestCommon(mediaJobsRequest);
        this.rejectNull(mediaJobsRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<MediaJobsRequest> cosHttpRequest = this.createRequest(mediaJobsRequest.getBucketName(), "/jobs/" + mediaJobsRequest.getJobId(), mediaJobsRequest, HttpMethodName.PUT);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public MediaJobResponse describeMediaJob(MediaJobsRequest mediaJobsRequest) {
        this.checkCIRequestCommon(mediaJobsRequest);
        this.rejectNull(mediaJobsRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<MediaJobsRequest> cosHttpRequest = this.createRequest(mediaJobsRequest.getBucketName(), "/jobs/" + mediaJobsRequest.getJobId(), mediaJobsRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.JobUnmarshaller());
    }

    @Override
    public MediaListJobResponse describeMediaJobs(MediaJobsRequest mediaJobsRequest) {
        this.checkCIRequestCommon(mediaJobsRequest);
        this.rejectNull(mediaJobsRequest.getQueueId(), "The queueId parameter must be specified setting the object tags");
        this.rejectNull(mediaJobsRequest.getTag(), "The tag parameter must be specified setting the object tags");
        CosHttpRequest<MediaJobsRequest> cosHttpRequest = this.createRequest(mediaJobsRequest.getBucketName(), "/jobs", mediaJobsRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "queueId", mediaJobsRequest.getQueueId());
        COSClient.addParameterIfNotNull(cosHttpRequest, "tag", mediaJobsRequest.getTag());
        COSClient.addParameterIfNotNull(cosHttpRequest, "orderByTime", mediaJobsRequest.getOrderByTime());
        COSClient.addParameterIfNotNull(cosHttpRequest, "nextToken", mediaJobsRequest.getNextToken());
        COSClient.addParameterIfNotNull(cosHttpRequest, "size", mediaJobsRequest.getSize().toString());
        COSClient.addParameterIfNotNull(cosHttpRequest, "states", mediaJobsRequest.getStates());
        COSClient.addParameterIfNotNull(cosHttpRequest, "startCreationTime", mediaJobsRequest.getStartCreationTime());
        COSClient.addParameterIfNotNull(cosHttpRequest, "endCreationTime", mediaJobsRequest.getEndCreationTime());
        MediaListJobResponse mediaListJobResponse = this.invoke(cosHttpRequest, new Unmarshallers.ListJobUnmarshaller());
        this.checkMediaListJobResponse(mediaListJobResponse);
        return mediaListJobResponse;
    }

    @Override
    public MediaListQueueResponse describeMediaQueues(MediaQueueRequest mediaQueueRequest) {
        this.checkCIRequestCommon(mediaQueueRequest);
        CosHttpRequest<MediaQueueRequest> cosHttpRequest = this.createRequest(mediaQueueRequest.getBucketName(), "/queue", mediaQueueRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "queueIds", mediaQueueRequest.getQueueId());
        COSClient.addParameterIfNotNull(cosHttpRequest, "state", mediaQueueRequest.getState());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageNumber", mediaQueueRequest.getPageNumber());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageSize", mediaQueueRequest.getPageSize());
        return this.invoke(cosHttpRequest, new Unmarshallers.ListQueueUnmarshaller());
    }

    @Override
    public MediaQueueResponse updateMediaQueue(MediaQueueRequest mediaQueueRequest) {
        this.checkCIRequestCommon(mediaQueueRequest);
        this.rejectNull(mediaQueueRequest.getQueueId(), "The queueId parameter must be specified setting the object tags");
        this.rejectNull(mediaQueueRequest.getName(), "The name parameter must be specified setting the object tags");
        this.rejectNull(mediaQueueRequest.getState(), "The state parameter must be specified setting the object tags");
        CosHttpRequest<MediaQueueRequest> cosHttpRequest = this.createRequest(mediaQueueRequest.getBucketName(), "/queue/" + mediaQueueRequest.getQueueId(), mediaQueueRequest, HttpMethodName.PUT);
        this.setContent(cosHttpRequest, RequestXmlFactory.convertToXmlByteArray(mediaQueueRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.QueueUnmarshaller());
    }

    @Override
    public MediaBucketResponse describeMediaBuckets(MediaBucketRequest mediaBucketRequest) {
        this.checkCIRequestCommon(mediaBucketRequest);
        CosHttpRequest<MediaBucketRequest> cosHttpRequest = this.createRequest(mediaBucketRequest.getBucketName(), "/mediabucket", mediaBucketRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "regions", mediaBucketRequest.getRegions());
        COSClient.addParameterIfNotNull(cosHttpRequest, "bucketNames", mediaBucketRequest.getBucketNames());
        COSClient.addParameterIfNotNull(cosHttpRequest, "bucketName", mediaBucketRequest.getBucketName());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageNumber", mediaBucketRequest.getPageNumber());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageSize", mediaBucketRequest.getPageSize());
        return this.invoke(cosHttpRequest, new Unmarshallers.ListBucketUnmarshaller());
    }

    @Override
    public MediaTemplateResponse createMediaTemplate(MediaTemplateRequest mediaTemplateRequest) {
        this.rejectNull(mediaTemplateRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(mediaTemplateRequest.getTag(), "The tag parameter must be specified setting the object tags");
        this.rejectNull(mediaTemplateRequest.getName(), "The name parameter must be specified setting the object tags");
        CosHttpRequest<MediaTemplateRequest> cosHttpRequest = this.createRequest(mediaTemplateRequest.getBucketName(), "/template", mediaTemplateRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIMediaXmlFactory.convertToXmlByteArray(mediaTemplateRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.TemplateUnmarshaller());
    }

    @Override
    public Boolean deleteMediaTemplate(MediaTemplateRequest mediaTemplateRequest) {
        this.checkCIRequestCommon(mediaTemplateRequest);
        this.rejectNull(mediaTemplateRequest.getTemplateId(), "The templateId parameter must be specified setting the object tags");
        CosHttpRequest<MediaTemplateRequest> cosHttpRequest = this.createRequest(mediaTemplateRequest.getBucketName(), "/template/" + mediaTemplateRequest.getTemplateId(), mediaTemplateRequest, HttpMethodName.DELETE);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public MediaListTemplateResponse describeMediaTemplates(MediaTemplateRequest mediaTemplateRequest) {
        this.checkCIRequestCommon(mediaTemplateRequest);
        CosHttpRequest<MediaTemplateRequest> cosHttpRequest = this.createRequest(mediaTemplateRequest.getBucketName(), "/template", mediaTemplateRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "tag", mediaTemplateRequest.getTag());
        COSClient.addParameterIfNotNull(cosHttpRequest, "category", mediaTemplateRequest.getCategory());
        COSClient.addParameterIfNotNull(cosHttpRequest, "ids", mediaTemplateRequest.getIds());
        COSClient.addParameterIfNotNull(cosHttpRequest, "name", mediaTemplateRequest.getName());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageNumber", mediaTemplateRequest.getPageNumber());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageSize", mediaTemplateRequest.getPageSize());
        return this.invoke(cosHttpRequest, new Unmarshallers.ListTemplateUnmarshaller());
    }

    @Override
    public Boolean updateMediaTemplate(MediaTemplateRequest mediaTemplateRequest) {
        this.checkCIRequestCommon(mediaTemplateRequest);
        this.rejectNull(mediaTemplateRequest.getTag(), "The tag parameter must be specified setting the object tags");
        this.rejectNull(mediaTemplateRequest.getName(), "The name parameter must be specified setting the object tags");
        CosHttpRequest<MediaTemplateRequest> cosHttpRequest = this.createRequest(mediaTemplateRequest.getBucketName(), "/template/" + mediaTemplateRequest.getTemplateId(), mediaTemplateRequest, HttpMethodName.PUT);
        this.setContent(cosHttpRequest, RequestXmlFactory.convertToXmlByteArray(mediaTemplateRequest), "application/xml", false);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public SnapshotResponse generateSnapshot(SnapshotRequest snapshotRequest) {
        this.checkCIRequestCommon(snapshotRequest);
        this.rejectNull(snapshotRequest.getTime(), "The time parameter must be specified setting the object tags");
        this.rejectNull(snapshotRequest.getInput().getObject(), "The input.object parameter must be specified setting the object tags");
        CosHttpRequest<SnapshotRequest> cosHttpRequest = this.createRequest(snapshotRequest.getBucketName(), "/snapshot", snapshotRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, RequestXmlFactory.convertToXmlByteArray(snapshotRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.SnapshotUnmarshaller());
    }

    @Override
    public MediaInfoResponse generateMediainfo(MediaInfoRequest mediaInfoRequest) {
        this.checkCIRequestCommon(mediaInfoRequest);
        this.rejectNull(mediaInfoRequest.getInput().getObject(), "The input.object parameter must be specified setting the object tags");
        CosHttpRequest<MediaInfoRequest> cosHttpRequest = this.createRequest(mediaInfoRequest.getBucketName(), "/mediainfo", mediaInfoRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, RequestXmlFactory.convertToXmlByteArray(mediaInfoRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.MediaInfoUnmarshaller());
    }

    @Override
    public Boolean deleteWorkflow(MediaWorkflowListRequest mediaWorkflowListRequest) {
        this.checkCIRequestCommon(mediaWorkflowListRequest);
        this.rejectNull(mediaWorkflowListRequest.getWorkflowId(), "The request parameter must be specified when delete the object tags");
        CosHttpRequest<MediaWorkflowListRequest> cosHttpRequest = this.createRequest(mediaWorkflowListRequest.getBucketName(), "/workflow/" + mediaWorkflowListRequest.getWorkflowId(), mediaWorkflowListRequest, HttpMethodName.DELETE);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public MediaWorkflowListResponse describeWorkflow(MediaWorkflowListRequest mediaWorkflowListRequest) {
        this.checkCIRequestCommon(mediaWorkflowListRequest);
        CosHttpRequest<MediaWorkflowListRequest> cosHttpRequest = this.createRequest(mediaWorkflowListRequest.getBucketName(), "/workflow", mediaWorkflowListRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "ids", mediaWorkflowListRequest.getIds());
        COSClient.addParameterIfNotNull(cosHttpRequest, "name", mediaWorkflowListRequest.getName());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageNumber", mediaWorkflowListRequest.getPageNumber());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageSize", mediaWorkflowListRequest.getPageSize());
        return this.invoke(cosHttpRequest, new Unmarshallers.WorkflowListUnmarshaller());
    }

    @Override
    public MediaWorkflowExecutionResponse describeWorkflowExecution(MediaWorkflowListRequest mediaWorkflowListRequest) {
        this.checkCIRequestCommon(mediaWorkflowListRequest);
        CosHttpRequest<MediaWorkflowListRequest> cosHttpRequest = this.createRequest(mediaWorkflowListRequest.getBucketName(), "/workflowexecution/" + mediaWorkflowListRequest.getRunId(), mediaWorkflowListRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.WorkflowExecutionUnmarshaller());
    }

    @Override
    public MediaWorkflowExecutionsResponse describeWorkflowExecutions(MediaWorkflowListRequest mediaWorkflowListRequest) {
        this.checkCIRequestCommon(mediaWorkflowListRequest);
        CosHttpRequest<MediaWorkflowListRequest> cosHttpRequest = this.createRequest(mediaWorkflowListRequest.getBucketName(), "/workflowexecution", mediaWorkflowListRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "workflowId", mediaWorkflowListRequest.getWorkflowId());
        COSClient.addParameterIfNotNull(cosHttpRequest, "name", mediaWorkflowListRequest.getName());
        COSClient.addParameterIfNotNull(cosHttpRequest, "orderByTime", mediaWorkflowListRequest.getOrderByTime());
        COSClient.addParameterIfNotNull(cosHttpRequest, "size", mediaWorkflowListRequest.getSize());
        COSClient.addParameterIfNotNull(cosHttpRequest, "states", mediaWorkflowListRequest.getStates());
        COSClient.addParameterIfNotNull(cosHttpRequest, "startCreationTime", mediaWorkflowListRequest.getStartCreationTime());
        COSClient.addParameterIfNotNull(cosHttpRequest, "endCreationTime", mediaWorkflowListRequest.getEndCreationTime());
        COSClient.addParameterIfNotNull(cosHttpRequest, "nextToken", mediaWorkflowListRequest.getNextToken());
        return this.invoke(cosHttpRequest, new Unmarshallers.WorkflowExecutionsUnmarshaller());
    }

    @Override
    public DocJobResponse createDocProcessJobs(DocJobRequest docJobRequest) {
        this.checkCIRequestCommon(docJobRequest);
        CosHttpRequest<DocJobRequest> cosHttpRequest = this.createRequest(docJobRequest.getBucketName(), "/doc_jobs", docJobRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, RequestXmlFactory.convertToXmlByteArray(docJobRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.DocProcessJobUnmarshaller());
    }

    @Override
    public DocJobResponse describeDocProcessJob(DocJobRequest docJobRequest) {
        this.checkCIRequestCommon(docJobRequest);
        CosHttpRequest<DocJobRequest> cosHttpRequest = this.createRequest(docJobRequest.getBucketName(), "/doc_jobs/" + docJobRequest.getJobId(), docJobRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.DescribeDocJobUnmarshaller());
    }

    @Override
    public DocJobListResponse describeDocProcessJobs(DocJobListRequest docJobListRequest) {
        this.checkCIRequestCommon(docJobListRequest);
        CosHttpRequest<DocJobListRequest> cosHttpRequest = this.createRequest(docJobListRequest.getBucketName(), "/doc_jobs", docJobListRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "queueId", docJobListRequest.getQueueId());
        COSClient.addParameterIfNotNull(cosHttpRequest, "tag", docJobListRequest.getTag());
        COSClient.addParameterIfNotNull(cosHttpRequest, "orderByTime", docJobListRequest.getOrderByTime());
        COSClient.addParameterIfNotNull(cosHttpRequest, "nextToken", docJobListRequest.getNextToken());
        COSClient.addParameterIfNotNull(cosHttpRequest, "size", docJobListRequest.getSize().toString());
        COSClient.addParameterIfNotNull(cosHttpRequest, "states", docJobListRequest.getStates());
        COSClient.addParameterIfNotNull(cosHttpRequest, "startCreationTime", docJobListRequest.getStartCreationTime());
        COSClient.addParameterIfNotNull(cosHttpRequest, "endCreationTime", docJobListRequest.getEndCreationTime());
        return this.invoke(cosHttpRequest, new Unmarshallers.DescribeDocJobsUnmarshaller());
    }

    @Override
    public DocListQueueResponse describeDocProcessQueues(DocQueueRequest docQueueRequest) {
        this.checkCIRequestCommon(docQueueRequest);
        CosHttpRequest<DocQueueRequest> cosHttpRequest = this.createRequest(docQueueRequest.getBucketName(), "/docqueue", docQueueRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "queueIds", docQueueRequest.getQueueId());
        COSClient.addParameterIfNotNull(cosHttpRequest, "state", docQueueRequest.getState());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageNumber", docQueueRequest.getPageNumber());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageSize", docQueueRequest.getPageSize());
        return this.invoke(cosHttpRequest, new Unmarshallers.DocListQueueUnmarshaller());
    }

    @Override
    public boolean updateDocProcessQueue(DocQueueRequest docQueueRequest) {
        this.checkCIRequestCommon(docQueueRequest);
        this.rejectNull(docQueueRequest.getQueueId(), "The queueId parameter must be specified setting the object tags");
        this.rejectNull(docQueueRequest.getName(), "The name parameter must be specified setting the object tags");
        this.rejectNull(docQueueRequest.getState(), "The state parameter must be specified setting the object tags");
        CosHttpRequest<DocQueueRequest> cosHttpRequest = this.createRequest(docQueueRequest.getBucketName(), "/docqueue/" + docQueueRequest.getQueueId(), docQueueRequest, HttpMethodName.PUT);
        this.setContent(cosHttpRequest, RequestXmlFactory.convertToXmlByteArray(docQueueRequest), "application/xml", false);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public DocBucketResponse describeDocProcessBuckets(DocBucketRequest docBucketRequest) {
        this.checkCIRequestCommon(docBucketRequest);
        CosHttpRequest<DocBucketRequest> cosHttpRequest = this.createRequest(docBucketRequest.getBucketName(), "/docbucket", docBucketRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "regions", docBucketRequest.getRegions());
        COSClient.addParameterIfNotNull(cosHttpRequest, "bucketNames", docBucketRequest.getBucketNames());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageNumber", docBucketRequest.getPageNumber());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageSize", docBucketRequest.getPageSize());
        return this.invoke(cosHttpRequest, new Unmarshallers.DocListBucketUnmarshaller());
    }

    @Override
    public CIUploadResult processImage(ImageProcessRequest imageProcessRequest) {
        this.rejectNull(imageProcessRequest, "The ImageProcessRequest parameter must be specified when requesting an object's metadata");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting an object's metadata");
        String string = imageProcessRequest.getBucketName();
        String string2 = imageProcessRequest.getKey();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting an object's metadata");
        this.rejectNull(string2, "The key parameter must be specified when requesting an object's metadata");
        CosHttpRequest<ImageProcessRequest> cosHttpRequest = this.createRequest(string, string2, imageProcessRequest, HttpMethodName.POST);
        cosHttpRequest.addParameter("image_process", null);
        cosHttpRequest.addHeader("Pic-Operations", Jackson.toJsonString(imageProcessRequest.getPicOperations()));
        ObjectMetadata objectMetadata = (ObjectMetadata)this.invoke(cosHttpRequest, new ResponseHeaderHandlerChain<ObjectMetadata>(new Unmarshallers.ImagePersistenceUnmarshaller(), new CosMetadataResponseHandler()));
        return objectMetadata.getCiUploadResult();
    }

    @Override
    public ImageAuditingResponse imageAuditing(ImageAuditingRequest imageAuditingRequest) {
        this.rejectNull(imageAuditingRequest, "The imageAuditingRequest parameter must be specified setting the object tags");
        this.rejectNull(imageAuditingRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageAuditingRequest> cosHttpRequest = this.createRequest(imageAuditingRequest.getBucketName(), imageAuditingRequest.getObjectKey(), imageAuditingRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("ci-process", "sensitive-content-recognition");
        String string = imageAuditingRequest.getDetectType();
        if (!"all".equalsIgnoreCase(string)) {
            COSClient.addParameterIfNotNull(cosHttpRequest, "detect-type", string);
        }
        COSClient.addParameterIfNotNull(cosHttpRequest, "interval", Integer.toString(imageAuditingRequest.getInterval()));
        COSClient.addParameterIfNotNull(cosHttpRequest, "max-frames", Integer.toString(imageAuditingRequest.getMaxFrames()));
        COSClient.addParameterIfNotNull(cosHttpRequest, "biz-type", imageAuditingRequest.getBizType());
        COSClient.addParameterIfNotNull(cosHttpRequest, "detect-url", imageAuditingRequest.getDetectUrl());
        COSClient.addParameterIfNotNull(cosHttpRequest, "large-image-detect", imageAuditingRequest.getLargeImageDetect());
        COSClient.addParameterIfNotNull(cosHttpRequest, "dataid", imageAuditingRequest.getDataId());
        COSClient.addParameterIfNotNull(cosHttpRequest, "async", imageAuditingRequest.getAsync());
        COSClient.addParameterIfNotNull(cosHttpRequest, "callback", imageAuditingRequest.getCallback());
        return this.invoke(cosHttpRequest, new Unmarshallers.ImageAuditingUnmarshaller());
    }

    @Override
    public VideoAuditingResponse createVideoAuditingJob(VideoAuditingRequest videoAuditingRequest) {
        this.checkCIRequestCommon(videoAuditingRequest);
        this.rejectStartWith(videoAuditingRequest.getConf().getCallback(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<VideoAuditingRequest> cosHttpRequest = this.createRequest(videoAuditingRequest.getBucketName(), "/video/auditing", videoAuditingRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIAuditingXmlFactory.convertToXmlByteArray(videoAuditingRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.VideoAuditingUnmarshaller());
    }

    @Override
    public VideoAuditingResponse describeAuditingJob(VideoAuditingRequest videoAuditingRequest) {
        this.checkCIRequestCommon(videoAuditingRequest);
        this.rejectNull(videoAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<VideoAuditingRequest> cosHttpRequest = this.createRequest(videoAuditingRequest.getBucketName(), "/video/auditing/" + videoAuditingRequest.getJobId(), videoAuditingRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.VideoAuditingJobUnmarshaller());
    }

    @Override
    public AudioAuditingResponse createAudioAuditingJobs(AudioAuditingRequest audioAuditingRequest) {
        this.checkCIRequestCommon(audioAuditingRequest);
        this.rejectStartWith(audioAuditingRequest.getConf().getCallback(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<AudioAuditingRequest> cosHttpRequest = this.createRequest(audioAuditingRequest.getBucketName(), "/audio/auditing", audioAuditingRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIAuditingXmlFactory.convertToXmlByteArray(audioAuditingRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.AudioAuditingUnmarshaller());
    }

    @Override
    public AudioAuditingResponse describeAudioAuditingJob(AudioAuditingRequest audioAuditingRequest) {
        this.checkCIRequestCommon(audioAuditingRequest);
        this.rejectNull(audioAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<AudioAuditingRequest> cosHttpRequest = this.createRequest(audioAuditingRequest.getBucketName(), "/audio/auditing/" + audioAuditingRequest.getJobId(), audioAuditingRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.AudioAuditingJobUnmarshaller());
    }

    @Override
    public ImageLabelResponse getImageLabel(ImageLabelRequest imageLabelRequest) {
        this.rejectNull(imageLabelRequest, "The imageLabelRequest parameter must be specified setting the object tags");
        this.rejectNull(imageLabelRequest.getBucketName(), "The imageLabelRequest.bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageLabelRequest> cosHttpRequest = this.createRequest(imageLabelRequest.getBucketName(), imageLabelRequest.getObjectKey(), imageLabelRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("ci-process", "detect-label");
        COSClient.addParameterIfNotNull(cosHttpRequest, "detect-url", imageLabelRequest.getDetectUrl());
        return this.invoke(cosHttpRequest, new Unmarshallers.ImageLabelUnmarshaller());
    }

    @Override
    public ImageLabelV2Response getImageLabelV2(ImageLabelV2Request imageLabelV2Request) {
        this.rejectNull(imageLabelV2Request, "The imageAuditingRequest parameter must be specified setting the object tags");
        this.rejectNull(imageLabelV2Request.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageLabelV2Request> cosHttpRequest = this.createRequest(imageLabelV2Request.getBucketName(), imageLabelV2Request.getObjectKey(), imageLabelV2Request, HttpMethodName.GET);
        cosHttpRequest.addParameter("ci-process", "content-analysis");
        COSClient.addParameterIfNotNull(cosHttpRequest, "scenes", imageLabelV2Request.getScenes());
        System.out.println(cosHttpRequest.getEndpoint());
        return this.invoke(cosHttpRequest, new Unmarshallers.ImageLabelV2Unmarshaller());
    }

    @Override
    public TextAuditingResponse createAuditingTextJobs(TextAuditingRequest textAuditingRequest) {
        this.checkCIRequestCommon(textAuditingRequest);
        this.rejectStartWith(textAuditingRequest.getConf().getCallback(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<TextAuditingRequest> cosHttpRequest = this.createRequest(textAuditingRequest.getBucketName(), "/text/auditing", textAuditingRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIAuditingXmlFactory.convertToXmlByteArray(textAuditingRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.TextAuditingJobUnmarshaller());
    }

    @Override
    public TextAuditingResponse describeAuditingTextJob(TextAuditingRequest textAuditingRequest) {
        this.checkCIRequestCommon(textAuditingRequest);
        this.rejectNull(textAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<TextAuditingRequest> cosHttpRequest = this.createRequest(textAuditingRequest.getBucketName(), "/text/auditing/" + textAuditingRequest.getJobId(), textAuditingRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.TextAuditingDescribeJobUnmarshaller());
    }

    @Override
    public DocumentAuditingResponse createAuditingDocumentJobs(DocumentAuditingRequest documentAuditingRequest) {
        this.checkCIRequestCommon(documentAuditingRequest);
        this.rejectStartWith(documentAuditingRequest.getConf().getCallback(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<DocumentAuditingRequest> cosHttpRequest = this.createRequest(documentAuditingRequest.getBucketName(), "/document/auditing", documentAuditingRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIAuditingXmlFactory.convertToXmlByteArray(documentAuditingRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.DocumentAuditingJobUnmarshaller());
    }

    @Override
    public DocumentAuditingResponse describeAuditingDocumentJob(DocumentAuditingRequest documentAuditingRequest) {
        this.checkCIRequestCommon(documentAuditingRequest);
        this.rejectNull(documentAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<DocumentAuditingRequest> cosHttpRequest = this.createRequest(documentAuditingRequest.getBucketName(), "/document/auditing/" + documentAuditingRequest.getJobId(), documentAuditingRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.DocumentAuditingDescribeJobUnmarshaller());
    }

    @Override
    public BatchImageAuditingResponse batchImageAuditing(BatchImageAuditingRequest batchImageAuditingRequest) {
        this.checkCIRequestCommon(batchImageAuditingRequest);
        this.rejectStartWith(batchImageAuditingRequest.getConf().getCallback(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<BatchImageAuditingRequest> cosHttpRequest = this.createRequest(batchImageAuditingRequest.getBucketName(), "/image/auditing", batchImageAuditingRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIAuditingXmlFactory.convertToXmlByteArray(batchImageAuditingRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.BatchImageAuditingJobUnmarshaller());
    }

    @Override
    public Boolean createDocProcessBucket(DocBucketRequest docBucketRequest) {
        this.checkCIRequestCommon(docBucketRequest);
        CosHttpRequest<DocBucketRequest> cosHttpRequest = this.createRequest(docBucketRequest.getBucketName(), "/docbucket", docBucketRequest, HttpMethodName.POST);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public String GenerateDocPreviewUrl(DocHtmlRequest docHtmlRequest) throws URISyntaxException {
        this.rejectNull(docHtmlRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(docHtmlRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        this.rejectNull(docHtmlRequest.getObjectKey(), "The objectKey parameter must be specified setting the object tags");
        CosHttpRequest<DocHtmlRequest> cosHttpRequest = this.createRequest(docHtmlRequest.getBucketName(), docHtmlRequest.getObjectKey(), docHtmlRequest, HttpMethodName.GET);
        return this.buildDocPreview(cosHttpRequest);
    }

    @Override
    public WebpageAuditingResponse createWebpageAuditingJob(WebpageAuditingRequest webpageAuditingRequest) {
        this.checkCIRequestCommon(webpageAuditingRequest);
        this.rejectStartWith(webpageAuditingRequest.getInput().getUrl(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<WebpageAuditingRequest> cosHttpRequest = this.createRequest(webpageAuditingRequest.getBucketName(), "/webpage/auditing", webpageAuditingRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIAuditingXmlFactory.convertToXmlByteArray(webpageAuditingRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.WebpageAuditingJobUnmarshaller());
    }

    @Override
    public WebpageAuditingResponse describeWebpageAuditingJob(WebpageAuditingRequest webpageAuditingRequest) {
        this.checkCIRequestCommon(webpageAuditingRequest);
        this.rejectNull(webpageAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<WebpageAuditingRequest> cosHttpRequest = this.createRequest(webpageAuditingRequest.getBucketName(), "/webpage/auditing/" + webpageAuditingRequest.getJobId(), webpageAuditingRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.WebpageAuditingDescribeJobUnmarshaller());
    }

    @Override
    public String reportBadCase(ReportBadCaseRequest reportBadCaseRequest) {
        this.checkCIRequestCommon(reportBadCaseRequest);
        CosHttpRequest<ReportBadCaseRequest> cosHttpRequest = this.createRequest(reportBadCaseRequest.getBucketName(), "/report/badcase", reportBadCaseRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIAuditingXmlFactory.convertToXmlByteArray(reportBadCaseRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.ReportBadCaseUnmarshaller());
    }

    private String buildDocPreview(CosHttpRequest<DocHtmlRequest> cosHttpRequest) throws URISyntaxException {
        String string = cosHttpRequest.getProtocol().toString() + "://" + cosHttpRequest.getEndpoint() + cosHttpRequest.getResourcePath();
        URIBuilder uRIBuilder = new URIBuilder(string);
        COSSigner cOSSigner = this.clientConfig.getCosSigner();
        Date date = new Date(System.currentTimeMillis() + this.clientConfig.getSignExpired() * 1000L);
        String string2 = cOSSigner.buildAuthorizationStr(cosHttpRequest.getHttpMethod(), cosHttpRequest.getResourcePath(), cosHttpRequest.getHeaders(), cosHttpRequest.getParameters(), this.fetchCredential(), date, true);
        DocHtmlRequest docHtmlRequest = cosHttpRequest.getOriginalRequest();
        uRIBuilder.addParameter("ci-process", "doc-preview");
        uRIBuilder.addParameter("dstType", docHtmlRequest.getDstType().toString());
        uRIBuilder.addParameter("srcType", docHtmlRequest.getSrcType());
        uRIBuilder.addParameter("page", docHtmlRequest.getPage());
        uRIBuilder.addParameter("ImageParams", docHtmlRequest.getImageParams());
        uRIBuilder.addParameter("sheet", docHtmlRequest.getSheet());
        uRIBuilder.addParameter("password", docHtmlRequest.getPassword());
        uRIBuilder.addParameter("comment", docHtmlRequest.getComment());
        uRIBuilder.addParameter("excelPaperDirection", docHtmlRequest.getExcelPaperDirection());
        uRIBuilder.addParameter("excelPaperSize", docHtmlRequest.getExcelPaperSize());
        uRIBuilder.addParameter("quality", docHtmlRequest.getQuality());
        uRIBuilder.addParameter("scale", docHtmlRequest.getScale());
        uRIBuilder.addParameter("imageDpi", docHtmlRequest.getImageDpi());
        return uRIBuilder.build().toString() + "&" + string2;
    }

    private void checkAuditingRequest(ImageAuditingRequest imageAuditingRequest) {
        this.rejectNull(imageAuditingRequest.getDetectType(), "The detectType parameter must be specified setting the object tags");
        this.rejectNull(imageAuditingRequest.getObjectKey(), "The objectKey parameter must be specified setting the object tags");
    }

    private void checkWorkflowParameter(MediaWorkflowRequest mediaWorkflowRequest) {
        this.rejectNull(mediaWorkflowRequest.getName(), "The name parameter must be specified setting the object tags");
        this.rejectNull(mediaWorkflowRequest.getTopology(), "The topology parameter must be specified setting the object tags");
        this.rejectEmpty(mediaWorkflowRequest.getTopology().getMediaWorkflowNodes(), "The Nodes parameter must be specified setting the object tags");
        this.rejectEmpty(mediaWorkflowRequest.getTopology().getMediaWorkflowDependency(), "The Dependency parameter must be specified setting the object tags");
    }

    private void checkCIRequestCommon(CIServiceRequest cIServiceRequest) {
        this.rejectNull(cIServiceRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(cIServiceRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
    }

    private void checkRequestOutput(MediaOutputObject mediaOutputObject) {
        this.rejectNull(mediaOutputObject.getBucket(), "The output.bucket parameter must be specified setting the object tags");
        this.rejectNull(mediaOutputObject.getRegion(), "The output.region parameter must be specified setting the object tags");
        this.rejectNull(mediaOutputObject.getObject(), "The output.object parameter must be specified setting the object tags");
    }

    private void checkMediaListJobResponse(MediaListJobResponse mediaListJobResponse) {
        MediaJobObject mediaJobObject;
        List<MediaJobObject> list = mediaListJobResponse.getJobsDetailList();
        if (list.size() == 1 && (mediaJobObject = list.get(0)).getQueueId() == null && mediaJobObject.getJobId() == null && mediaJobObject.getCode() == null) {
            list.clear();
        }
    }

    public URL getObjectUrl(String string, String string2) {
        return this.getObjectUrl(new GetObjectRequest(string, string2));
    }

    public URL getObjectUrl(String string, String string2, String string3) {
        return this.getObjectUrl(new GetObjectRequest(string, string2, string3));
    }

    public URL getObjectUrl(GetObjectRequest getObjectRequest) {
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when generating a pre-signed URL");
        this.rejectNull(getObjectRequest, "The request parameter must be specified when generating a pre-signed URL");
        String string = getObjectRequest.getBucketName();
        String string2 = getObjectRequest.getKey();
        CosHttpRequest<GetObjectRequest> cosHttpRequest = this.createRequest(string, string2, getObjectRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "versionId", getObjectRequest.getVersionId());
        COSCredentials cOSCredentials = this.fetchCredential();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.clientConfig.getHttpProtocol().toString()).append("://");
        stringBuilder.append(this.clientConfig.getEndpointBuilder().buildGeneralApiEndpoint(this.formatBucket(string, cOSCredentials.getCOSAppId())));
        stringBuilder.append(UrlEncoderUtils.encodeUrlPath(this.formatKey(string2)));
        boolean bl = false;
        for (Map.Entry<String, String> entry : cosHttpRequest.getParameters().entrySet()) {
            String string3 = entry.getKey();
            String string4 = entry.getValue();
            if (!bl) {
                stringBuilder.append("?");
                bl = true;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(UrlEncoderUtils.encode(string3));
            if (string4 == null) continue;
            stringBuilder.append("=").append(UrlEncoderUtils.encode(string4));
        }
        try {
            return new URL(stringBuilder.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new CosClientException(malformedURLException.toString());
        }
    }

    @Override
    public PutAsyncFetchTaskResult putAsyncFetchTask(PutAsyncFetchTaskRequest putAsyncFetchTaskRequest) {
        CosHttpRequest<PutAsyncFetchTaskRequest> cosHttpRequest = this.createRequest(putAsyncFetchTaskRequest.getBucketName(), String.format("/%s/", putAsyncFetchTaskRequest.getBucketName()), putAsyncFetchTaskRequest, HttpMethodName.POST);
        PutAsyncFetchTaskSerializer putAsyncFetchTaskSerializer = new PutAsyncFetchTaskSerializer(PutAsyncFetchTaskRequest.class);
        SimpleModule simpleModule = new SimpleModule("PutAsyncFetchTaskSerializer", new Version(1, 0, 0, null, null, null));
        simpleModule.addSerializer(PutAsyncFetchTaskRequest.class, putAsyncFetchTaskSerializer);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(simpleModule);
        String string = null;
        try {
            string = objectMapper.writeValueAsString(putAsyncFetchTaskRequest);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setContent(cosHttpRequest, string.getBytes(), "application/json", false);
        return this.invoke(cosHttpRequest, new PutAsyncFetchTaskResultHandler());
    }

    @Override
    public GetAsyncFetchTaskResult getAsyncFetchTask(GetAsyncFetchTaskRequest getAsyncFetchTaskRequest) {
        CosHttpRequest<GetAsyncFetchTaskRequest> cosHttpRequest = this.createRequest(getAsyncFetchTaskRequest.getBucketName(), String.format("/%s/%s", getAsyncFetchTaskRequest.getBucketName(), getAsyncFetchTaskRequest.getTaskId()), getAsyncFetchTaskRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new GetAsyncFetchTaskResultHandler());
    }

    @Override
    public ImageAuditingResponse describeAuditingImageJob(DescribeImageAuditingRequest describeImageAuditingRequest) {
        this.rejectNull(describeImageAuditingRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        this.rejectNull(describeImageAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<DescribeImageAuditingRequest> cosHttpRequest = this.createRequest(describeImageAuditingRequest.getBucketName(), "/image/auditing/" + describeImageAuditingRequest.getJobId(), describeImageAuditingRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.ImageAuditingDescribeJobUnmarshaller());
    }

    @Override
    public PrivateM3U8Response getPrivateM3U8(PrivateM3U8Request privateM3U8Request) {
        this.rejectNull(privateM3U8Request.getExpires(), "The expires parameter must be specified setting the object tags , must satisfy the interval [3600, 43200]");
        this.rejectNull(privateM3U8Request.getBucketName(), "The privateM3U8Request.bucketName parameter must be specified setting the object tags");
        CosHttpRequest<PrivateM3U8Request> cosHttpRequest = this.createRequest(privateM3U8Request.getBucketName(), privateM3U8Request.getObject(), privateM3U8Request, HttpMethodName.GET);
        cosHttpRequest.addParameter("ci-process", "pm3u8");
        cosHttpRequest.addParameter("expires", privateM3U8Request.getExpires());
        return this.invoke(cosHttpRequest, new Unmarshallers.PrivateM3U8Unmarshaller());
    }

    @Override
    public DetectCarResponse detectCar(DetectCarRequest detectCarRequest) {
        this.rejectNull(detectCarRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<DetectCarRequest> cosHttpRequest = this.createRequest(detectCarRequest.getBucketName(), detectCarRequest.getObjectKey(), detectCarRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("ci-process", "DetectCar");
        COSClient.addParameterIfNotNull(cosHttpRequest, "detect-url", detectCarRequest.getDetectUrl());
        return this.invoke(cosHttpRequest, new Unmarshallers.DetectCarUnmarshaller());
    }

    @Override
    public boolean openImageSearch(OpenImageSearchRequest openImageSearchRequest) {
        this.rejectNull(openImageSearchRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(openImageSearchRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<OpenImageSearchRequest> cosHttpRequest = this.createRequest(openImageSearchRequest.getBucketName(), "/ImageSearchBucket", openImageSearchRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CImageXmlFactory.convertToXmlByteArray(openImageSearchRequest), "application/xml", false);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public boolean addGalleryImages(ImageSearchRequest imageSearchRequest) {
        this.rejectNull(imageSearchRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageSearchRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageSearchRequest> cosHttpRequest = this.createRequest(imageSearchRequest.getBucketName(), imageSearchRequest.getObjectKey(), imageSearchRequest, HttpMethodName.POST);
        cosHttpRequest.addParameter("ci-process", "ImageSearch");
        cosHttpRequest.addParameter("action", "AddImage");
        this.setContent(cosHttpRequest, CImageXmlFactory.convertToXmlByteArray(imageSearchRequest), "application/xml", false);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public boolean deleteGalleryImages(ImageSearchRequest imageSearchRequest) {
        this.rejectNull(imageSearchRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageSearchRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageSearchRequest> cosHttpRequest = this.createRequest(imageSearchRequest.getBucketName(), imageSearchRequest.getObjectKey(), imageSearchRequest, HttpMethodName.POST);
        cosHttpRequest.addParameter("ci-process", "ImageSearch");
        cosHttpRequest.addParameter("action", "DeleteImage");
        this.setContent(cosHttpRequest, CImageXmlFactory.convertToXmlByteArray(imageSearchRequest), "application/xml", false);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public ImageSearchResponse searchGalleryImages(ImageSearchRequest imageSearchRequest) {
        this.rejectNull(imageSearchRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageSearchRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageSearchRequest> cosHttpRequest = this.createRequest(imageSearchRequest.getBucketName(), imageSearchRequest.getObjectKey(), imageSearchRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("ci-process", "ImageSearch");
        cosHttpRequest.addParameter("action", "SearchImage");
        COSClient.addParameterIfNotNull(cosHttpRequest, "MatchThreshold", imageSearchRequest.getMatchThreshold());
        COSClient.addParameterIfNotNull(cosHttpRequest, "Offset", imageSearchRequest.getOffset());
        COSClient.addParameterIfNotNull(cosHttpRequest, "Limit", imageSearchRequest.getLimit());
        COSClient.addParameterIfNotNull(cosHttpRequest, "Filter", imageSearchRequest.getFilter());
        return this.invoke(cosHttpRequest, new Unmarshallers.SearchImagesUnmarshaller());
    }

    @Override
    public MediaWorkflowListResponse triggerWorkflowList(MediaWorkflowListRequest mediaWorkflowListRequest) {
        this.rejectNull(mediaWorkflowListRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(mediaWorkflowListRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<MediaWorkflowListRequest> cosHttpRequest = this.createRequest(mediaWorkflowListRequest.getBucketName(), "triggerworkflow", mediaWorkflowListRequest, HttpMethodName.POST);
        COSClient.addParameterIfNotNull(cosHttpRequest, "workflowId", mediaWorkflowListRequest.getWorkflowId());
        COSClient.addParameterIfNotNull(cosHttpRequest, "object", mediaWorkflowListRequest.getObject());
        COSClient.addParameterIfNotNull(cosHttpRequest, "name", mediaWorkflowListRequest.getName());
        return this.invoke(cosHttpRequest, new Unmarshallers.triggerWorkflowListUnmarshaller());
    }

    @Override
    public InputStream getSnapshot(CosSnapshotRequest cosSnapshotRequest) {
        this.rejectNull(cosSnapshotRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(cosSnapshotRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        this.rejectNull(cosSnapshotRequest.getObjectKey(), "The objectKey parameter must be specified setting the object tags");
        CosHttpRequest<CosSnapshotRequest> cosHttpRequest = this.createRequest(cosSnapshotRequest.getBucketName(), cosSnapshotRequest.getObjectKey(), cosSnapshotRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "ci-process", "snapshot");
        COSClient.addParameterIfNotNull(cosHttpRequest, "time", cosSnapshotRequest.getTime());
        COSClient.addParameterIfNotNull(cosHttpRequest, "width", cosSnapshotRequest.getWidth());
        COSClient.addParameterIfNotNull(cosHttpRequest, "height", cosSnapshotRequest.getHeight());
        COSClient.addParameterIfNotNull(cosHttpRequest, "format", cosSnapshotRequest.getFormat());
        COSClient.addParameterIfNotNull(cosHttpRequest, "rotate", cosSnapshotRequest.getRotate());
        COSClient.addParameterIfNotNull(cosHttpRequest, "mode", cosSnapshotRequest.getMode());
        return this.invoke(cosHttpRequest, new CIGetSnapshotResponseHandler());
    }

    @Override
    public String generateQrcode(GenerateQrcodeRequest generateQrcodeRequest) {
        this.rejectNull(generateQrcodeRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(generateQrcodeRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<GenerateQrcodeRequest> cosHttpRequest = this.createRequest(generateQrcodeRequest.getBucketName(), "/", generateQrcodeRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "ci-process", "qrcode-generate");
        COSClient.addParameterIfNotNull(cosHttpRequest, "qrcode-content", generateQrcodeRequest.getQrcodeContent());
        COSClient.addParameterIfNotNull(cosHttpRequest, "mode", generateQrcodeRequest.getMode());
        COSClient.addParameterIfNotNull(cosHttpRequest, "width", generateQrcodeRequest.getWidth());
        return this.invoke(cosHttpRequest, new Unmarshallers.GenerateQrcodeUnmarshaller());
    }

    @Override
    public Boolean addImageStyle(ImageStyleRequest imageStyleRequest) {
        this.rejectNull(imageStyleRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageStyleRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageStyleRequest> cosHttpRequest = this.createRequest(imageStyleRequest.getBucketName(), "/", imageStyleRequest, HttpMethodName.PUT);
        cosHttpRequest.addParameter("style", "");
        this.setContent(cosHttpRequest, CImageXmlFactory.addStyleConvertToXmlByteArray(imageStyleRequest), "application/xml", false);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public ImageStyleResponse getImageStyle(ImageStyleRequest imageStyleRequest) {
        this.rejectNull(imageStyleRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageStyleRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageStyleRequest> cosHttpRequest = this.createRequest(imageStyleRequest.getBucketName(), "/", imageStyleRequest, HttpMethodName.GET);
        cosHttpRequest.addParameter("style", "");
        this.setContent(cosHttpRequest, CImageXmlFactory.getStyleConvertToXmlByteArray(imageStyleRequest), "application/xml", false);
        this.invoke(cosHttpRequest, new Unmarshallers.getImageStyleUnmarshaller());
        return null;
    }

    @Override
    public Boolean deleteImageStyle(ImageStyleRequest imageStyleRequest) {
        this.rejectNull(imageStyleRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageStyleRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageStyleRequest> cosHttpRequest = this.createRequest(imageStyleRequest.getBucketName(), "/", imageStyleRequest, HttpMethodName.DELETE);
        cosHttpRequest.addParameter("style", "");
        this.setContent(cosHttpRequest, CImageXmlFactory.deleteStyleConvertToXmlByteArray(imageStyleRequest), "application/xml", false);
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public String getObjectDecompressionStatus(String string, String string2) {
        this.rejectNull(string, "The bucketName parameter must be specified getting object decompression status");
        this.rejectNull(string2, "The objectKey parameter must be specified getting object decompression status");
        CosHttpRequest<CosServiceRequest> cosHttpRequest = this.createRequest(string, string2, new CosServiceRequest(), HttpMethodName.GET);
        cosHttpRequest.addParameter("decompression", null);
        cosHttpRequest.addParameter("jobId", string2);
        return this.invoke(cosHttpRequest, new COSStringResponseHandler());
    }

    @Override
    public DecompressionResult postObjectDecompression(DecompressionRequest decompressionRequest) {
        this.rejectNull(decompressionRequest.getSourceBucketName(), "The sourceBucketName parameter must be specified post object decompression");
        this.rejectNull(decompressionRequest, "The decompressionRequest parameter must be specified post object decompression");
        this.rejectNull(decompressionRequest.getTargetBucketName(), "The decompressionRequest parameter must be specified post object decompression");
        this.rejectNull(decompressionRequest.getResourcesPrefix(), "The decompressionRequest parameter must be specified post object decompression");
        if (decompressionRequest.getPrefixReplaced()) {
            this.rejectNull(decompressionRequest.getTargetKeyPrefix(), "The targetKeyPrefix parameter must be specified post object decompression when prefixReplaced is true");
        }
        CosHttpRequest<DecompressionRequest> cosHttpRequest = this.createRequest(decompressionRequest.getSourceBucketName(), decompressionRequest.getObjectKey(), decompressionRequest, HttpMethodName.POST);
        cosHttpRequest.addParameter("decompression", null);
        byte[] byArray = DecompressionRequest.convertToByteArray(decompressionRequest);
        cosHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        cosHttpRequest.addHeader("Content-Type", "application/xml");
        cosHttpRequest.setContent(new ByteArrayInputStream(byArray));
        return (DecompressionResult)this.invoke(cosHttpRequest, new COSXmlResponseHandler<DecompressionResult>(new Unmarshallers.DecompressionResultUnmarshaller()));
    }

    @Override
    public DecompressionResult getObjectDecompressionStatus(String string, String string2, String string3) {
        this.rejectNull(string, "The bucketName parameter must be specified getting object decompression status");
        this.rejectNull(string2, "The objectKey parameter must be specified getting object decompression status");
        CosHttpRequest<CosServiceRequest> cosHttpRequest = this.createRequest(string, string2, new CosServiceRequest(), HttpMethodName.GET);
        if (string3 != null) {
            cosHttpRequest.addParameter("jobId", string3);
        }
        cosHttpRequest.addParameter("decompression", null);
        return (DecompressionResult)this.invoke(cosHttpRequest, new COSXmlResponseHandler<DecompressionResult>(new Unmarshallers.DecompressionResultUnmarshaller()));
    }

    @Override
    public ListJobsResult listObjectDecompressionJobs(String string, String string2, String string3, String string4, String string5) {
        this.rejectNull(string, "The bucketName parameter must be specified list object decompression status");
        CosHttpRequest<CosServiceRequest> cosHttpRequest = this.createRequest(string, "/", new CosServiceRequest(), HttpMethodName.GET);
        cosHttpRequest.addParameter("decompression", null);
        if (string2 != null) {
            cosHttpRequest.addParameter("jobStatus", string2);
        }
        if (string3 != null) {
            cosHttpRequest.addParameter("sortBy", string3);
        }
        if (string4 != null) {
            cosHttpRequest.addParameter("maxResults", string4);
        }
        if (string5 != null) {
            cosHttpRequest.addParameter("nextToken", string5);
        }
        return (ListJobsResult)this.invoke(cosHttpRequest, new COSXmlResponseHandler<ListJobsResult>(new Unmarshallers.ListJobsResultUnmarshaller()));
    }

    @Override
    public MediaJobResponse createPicProcessJob(MediaJobsRequest mediaJobsRequest) {
        this.checkCIRequestCommon(mediaJobsRequest);
        this.rejectNull(mediaJobsRequest.getTag(), "The tag parameter must be specified setting the object tags");
        this.rejectNull(mediaJobsRequest.getQueueId(), "The queueId parameter must be specified setting the object tags");
        this.rejectNull(mediaJobsRequest.getInput().getObject(), "The input parameter must be specified setting the object tags");
        this.rejectStartWith(mediaJobsRequest.getCallBack(), "http", "The CallBack parameter mush start with http or https");
        CosHttpRequest<MediaJobsRequest> cosHttpRequest = this.createRequest(mediaJobsRequest.getBucketName(), "/pic_jobs", mediaJobsRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIMediaXmlFactory.convertToXmlByteArray(mediaJobsRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.JobCreatUnmarshaller());
    }

    @Override
    public MediaListQueueResponse describePicProcessQueues(MediaQueueRequest mediaQueueRequest) {
        this.checkCIRequestCommon(mediaQueueRequest);
        CosHttpRequest<MediaQueueRequest> cosHttpRequest = this.createRequest(mediaQueueRequest.getBucketName(), "/picqueue", mediaQueueRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(cosHttpRequest, "queueIds", mediaQueueRequest.getQueueId());
        COSClient.addParameterIfNotNull(cosHttpRequest, "state", mediaQueueRequest.getState());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageNumber", mediaQueueRequest.getPageNumber());
        COSClient.addParameterIfNotNull(cosHttpRequest, "pageSize", mediaQueueRequest.getPageSize());
        return this.invoke(cosHttpRequest, new Unmarshallers.ListQueueUnmarshaller());
    }

    @Override
    public boolean processImage2(CImageProcessRequest cImageProcessRequest) {
        this.rejectNull(cImageProcessRequest, "The ImageProcessRequest parameter must be specified when requesting an object's metadata");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting an object's metadata");
        String string = cImageProcessRequest.getBucketName();
        String string2 = cImageProcessRequest.getKey();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting an object's metadata");
        this.rejectNull(string2, "The key parameter must be specified when requesting an object's metadata");
        CosHttpRequest<CImageProcessRequest> cosHttpRequest = this.createRequest(string, string2, cImageProcessRequest, HttpMethodName.POST);
        if (cImageProcessRequest.getPicOperations() != null) {
            cosHttpRequest.addHeader("Pic-Operations", Jackson.toJsonString(cImageProcessRequest.getPicOperations()));
        }
        this.invoke(cosHttpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public FileProcessJobResponse createFileProcessJob(FileProcessRequest fileProcessRequest) {
        this.checkCIRequestCommon(fileProcessRequest);
        this.rejectNull((Object)fileProcessRequest.getTag(), "The tag parameter must be specified setting the object tags");
        this.rejectNull(fileProcessRequest.getQueueId(), "The queueId parameter must be specified setting the object tags");
        this.rejectStartWith(fileProcessRequest.getCallBack(), "http", "The CallBack parameter mush start with http or https");
        CosHttpRequest<FileProcessRequest> cosHttpRequest = this.createRequest(fileProcessRequest.getBucketName(), "/file_jobs", fileProcessRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIFileProcessXmlFactory.convertToXmlByteArray(fileProcessRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.FileProcessUnmarshaller());
    }

    @Override
    public FileProcessJobResponse describeFileProcessJob(FileProcessRequest fileProcessRequest) {
        this.checkCIRequestCommon(fileProcessRequest);
        CosHttpRequest<FileProcessRequest> cosHttpRequest = this.createRequest(fileProcessRequest.getBucketName(), "/file_jobs/" + fileProcessRequest.getJobId(), fileProcessRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.FileProcessUnmarshaller());
    }

    @Override
    public BatchJobResponse createInventoryTriggerJob(BatchJobRequest batchJobRequest) {
        CosHttpRequest<BatchJobRequest> cosHttpRequest = this.createRequest(batchJobRequest.getBucketName(), "/inventorytriggerjob", batchJobRequest, HttpMethodName.POST);
        this.setContent(cosHttpRequest, CIMediaXmlFactory.convertToXmlByteArray(batchJobRequest), "application/xml", false);
        return this.invoke(cosHttpRequest, new Unmarshallers.BatchJobUnmarshaller());
    }

    @Override
    public BatchJobResponse describeInventoryTriggerJob(BatchJobRequest batchJobRequest) {
        this.checkCIRequestCommon(batchJobRequest);
        CosHttpRequest<BatchJobRequest> cosHttpRequest = this.createRequest(batchJobRequest.getBucketName(), "/inventorytriggerjob/" + batchJobRequest.getJobId(), batchJobRequest, HttpMethodName.GET);
        return this.invoke(cosHttpRequest, new Unmarshallers.BatchJobUnmarshaller());
    }
}

