/*
 * Decompiled with CFR 0.152.
 */
package com.google.thirdparty.publicsuffix;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Queues;
import com.google.thirdparty.publicsuffix.PublicSuffixType;
import java.util.Deque;

@GwtCompatible
final class TrieParser {
    private static final Joiner DIRECT_JOINER = Joiner.on("");

    TrieParser() {
    }

    static ImmutableMap<String, PublicSuffixType> parseTrie(CharSequence ... charSequenceArray) {
        String string = DIRECT_JOINER.join(charSequenceArray);
        return TrieParser.parseFullString(string);
    }

    @VisibleForTesting
    static ImmutableMap<String, PublicSuffixType> parseFullString(String string) {
        ImmutableMap.Builder<String, PublicSuffixType> builder = ImmutableMap.builder();
        int n = string.length();
        for (int i = 0; i < n; i += TrieParser.doParseTrieToBuilder(Queues.newArrayDeque(), string, i, builder)) {
        }
        return builder.buildOrThrow();
    }

    private static int doParseTrieToBuilder(Deque<CharSequence> deque, CharSequence charSequence, int n, ImmutableMap.Builder<String, PublicSuffixType> builder) {
        String string;
        int n2;
        int n3 = charSequence.length();
        char c = '\u0000';
        for (n2 = n; n2 < n3 && (c = charSequence.charAt(n2)) != '&' && c != '?' && c != '!' && c != ':' && c != ','; ++n2) {
        }
        deque.push(TrieParser.reverse(charSequence.subSequence(n, n2)));
        if ((c == '!' || c == '?' || c == ':' || c == ',') && (string = DIRECT_JOINER.join(deque)).length() > 0) {
            builder.put(string, PublicSuffixType.fromCode(c));
        }
        ++n2;
        if (c != '?' && c != ',') {
            while (n2 < n3) {
                if (charSequence.charAt(n2 += TrieParser.doParseTrieToBuilder(deque, charSequence, n2, builder)) != '?' && charSequence.charAt(n2) != ',') continue;
                ++n2;
                break;
            }
        }
        deque.pop();
        return n2 - n;
    }

    private static CharSequence reverse(CharSequence charSequence) {
        return new StringBuilder(charSequence).reverse();
    }
}

