/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public class ListenableFutureTask<V>
extends FutureTask<V>
implements ListenableFuture<V> {
    private final ExecutionList executionList = new ExecutionList();

    public static <V> ListenableFutureTask<V> create(Callable<V> callable) {
        return new ListenableFutureTask<V>(callable);
    }

    public static <V> ListenableFutureTask<V> create(Runnable runnable2, @ParametricNullness V v) {
        return new ListenableFutureTask<V>(runnable2, v);
    }

    ListenableFutureTask(Callable<V> callable) {
        super(callable);
    }

    ListenableFutureTask(Runnable runnable2, @ParametricNullness V v) {
        super(runnable2, v);
    }

    @Override
    public void addListener(Runnable runnable2, Executor executor) {
        this.executionList.add(runnable2, executor);
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public V get(long l, TimeUnit timeUnit) throws TimeoutException, InterruptedException, ExecutionException {
        long l2 = timeUnit.toNanos(l);
        if (l2 <= 2147483647999999999L) {
            return super.get(l, timeUnit);
        }
        return super.get(Math.min(l2, 2147483647999999999L), TimeUnit.NANOSECONDS);
    }

    @Override
    protected void done() {
        this.executionList.execute();
    }
}

