/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.NullnessCasts;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.Platform;
import com.google.j2objc.annotations.ReflectionSupport;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
@ReflectionSupport(value=ReflectionSupport.Level.FULL)
abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE;
    private static final Runnable PARKED;
    private static final int MAX_BUSY_WAIT_SPINS = 1000;

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Thread thread2 = Thread.currentThread();
        if (!this.compareAndSet(null, thread2)) {
            return;
        }
        boolean bl = !this.isDone();
        Object t2 = null;
        Throwable throwable = null;
        try {
            if (bl) {
                t2 = this.runInterruptibly();
            }
        }
        catch (Throwable throwable2) {
            Platform.restoreInterruptIfIsInterruptedException(throwable2);
            throwable = throwable2;
        }
        finally {
            if (!this.compareAndSet(thread2, DONE)) {
                this.waitForInterrupt(thread2);
            }
            if (bl) {
                if (throwable == null) {
                    this.afterRanInterruptiblySuccess(NullnessCasts.uncheckedCastNullableTToT(t2));
                } else {
                    this.afterRanInterruptiblyFailure(throwable);
                }
            }
        }
    }

    private void waitForInterrupt(Thread thread2) {
        boolean bl = false;
        int n = 0;
        Runnable runnable2 = (Runnable)this.get();
        Blocker blocker = null;
        while (runnable2 instanceof Blocker || runnable2 == PARKED) {
            if (runnable2 instanceof Blocker) {
                blocker = (Blocker)runnable2;
            }
            if (++n > 1000) {
                if (runnable2 == PARKED || this.compareAndSet(runnable2, PARKED)) {
                    bl = Thread.interrupted() || bl;
                    LockSupport.park(blocker);
                }
            } else {
                Thread.yield();
            }
            runnable2 = (Runnable)this.get();
        }
        if (bl) {
            thread2.interrupt();
        }
    }

    abstract boolean isDone();

    @ParametricNullness
    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptiblySuccess(@ParametricNullness T var1);

    abstract void afterRanInterruptiblyFailure(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void interruptTask() {
        Runnable runnable2 = (Runnable)this.get();
        if (runnable2 instanceof Thread) {
            Blocker blocker = new Blocker(this);
            blocker.setOwner(Thread.currentThread());
            if (this.compareAndSet(runnable2, blocker)) {
                try {
                    ((Thread)runnable2).interrupt();
                }
                finally {
                    Runnable runnable3 = this.getAndSet(DONE);
                    if (runnable3 == PARKED) {
                        LockSupport.unpark((Thread)runnable2);
                    }
                }
            }
        }
    }

    @Override
    public final String toString() {
        Runnable runnable2 = (Runnable)this.get();
        String string = runnable2 == DONE ? "running=[DONE]" : (runnable2 instanceof Blocker ? "running=[INTERRUPTED]" : (runnable2 instanceof Thread ? "running=[RUNNING ON " + ((Thread)runnable2).getName() + "]" : "running=[NOT STARTED YET]"));
        return string + ", " + this.toPendingString();
    }

    abstract String toPendingString();

    static {
        Class<LockSupport> clazz = LockSupport.class;
        DONE = new DoNothingRunnable();
        PARKED = new DoNothingRunnable();
    }

    @VisibleForTesting
    static final class Blocker
    extends AbstractOwnableSynchronizer
    implements Runnable {
        private final InterruptibleTask<?> task;

        private Blocker(InterruptibleTask<?> interruptibleTask) {
            this.task = interruptibleTask;
        }

        @Override
        public void run() {
        }

        private void setOwner(Thread thread2) {
            super.setExclusiveOwnerThread(thread2);
        }

        @CheckForNull
        @VisibleForTesting
        Thread getOwner() {
            return super.getExclusiveOwnerThread();
        }

        public String toString() {
            return this.task.toString();
        }
    }

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

