/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.util.concurrent.AggregateFutureState;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.LazyLogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AggregateFuture<InputT, OutputT>
extends AggregateFutureState<OutputT> {
    private static final LazyLogger logger = new LazyLogger(AggregateFuture.class);
    @CheckForNull
    @LazyInit
    private ImmutableCollection<? extends ListenableFuture<? extends InputT>> futures;
    private final boolean allMustSucceed;
    private final boolean collectsValues;

    AggregateFuture(ImmutableCollection<? extends ListenableFuture<? extends InputT>> immutableCollection, boolean bl, boolean bl2) {
        super(immutableCollection.size());
        this.futures = Preconditions.checkNotNull(immutableCollection);
        this.allMustSucceed = bl;
        this.collectsValues = bl2;
    }

    @Override
    protected final void afterDone() {
        super.afterDone();
        ImmutableCollection<ListenableFuture<InputT>> immutableCollection = this.futures;
        this.releaseResources(ReleaseResourcesReason.OUTPUT_FUTURE_DONE);
        if (this.isCancelled() & immutableCollection != null) {
            boolean bl = this.wasInterrupted();
            for (Future future : immutableCollection) {
                future.cancel(bl);
            }
        }
    }

    @Override
    @CheckForNull
    protected final String pendingToString() {
        ImmutableCollection<? extends ListenableFuture<? extends InputT>> immutableCollection = this.futures;
        if (immutableCollection != null) {
            return "futures=" + immutableCollection;
        }
        return super.pendingToString();
    }

    final void init() {
        Objects.requireNonNull(this.futures);
        if (this.futures.isEmpty()) {
            this.handleAllCompleted();
            return;
        }
        if (this.allMustSucceed) {
            int n = 0;
            for (ListenableFuture listenableFuture : this.futures) {
                int n2 = n++;
                listenableFuture.addListener(() -> {
                    try {
                        if (listenableFuture.isCancelled()) {
                            this.futures = null;
                            this.cancel(false);
                        } else {
                            this.collectValueFromNonCancelledFuture(n2, listenableFuture);
                        }
                    }
                    finally {
                        this.decrementCountAndMaybeComplete(null);
                    }
                }, MoreExecutors.directExecutor());
            }
        } else {
            ImmutableCollection<ListenableFuture<InputT>> immutableCollection = this.collectsValues ? this.futures : null;
            Runnable runnable2 = () -> this.decrementCountAndMaybeComplete(immutableCollection);
            for (ListenableFuture listenableFuture : this.futures) {
                listenableFuture.addListener(runnable2, MoreExecutors.directExecutor());
            }
        }
    }

    private void handleException(Throwable throwable) {
        boolean bl;
        boolean bl2;
        Preconditions.checkNotNull(throwable);
        if (this.allMustSucceed && !(bl2 = this.setException(throwable)) && (bl = AggregateFuture.addCausalChain(this.getOrInitSeenExceptions(), throwable))) {
            AggregateFuture.log(throwable);
            return;
        }
        if (throwable instanceof Error) {
            AggregateFuture.log(throwable);
        }
    }

    private static void log(Throwable throwable) {
        String string = throwable instanceof Error ? "Input Future failed with Error" : "Got more than one input Future failure. Logging failures after the first";
        logger.get().log(Level.SEVERE, string, throwable);
    }

    @Override
    final void addInitialException(Set<Throwable> set) {
        Preconditions.checkNotNull(set);
        if (!this.isCancelled()) {
            boolean bl = AggregateFuture.addCausalChain(set, Objects.requireNonNull(this.tryInternalFastPathGetFailure()));
        }
    }

    private void collectValueFromNonCancelledFuture(int n, Future<? extends InputT> future) {
        try {
            this.collectOneValue(n, Futures.getDone(future));
        }
        catch (ExecutionException executionException) {
            this.handleException(executionException.getCause());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void decrementCountAndMaybeComplete(@CheckForNull ImmutableCollection<? extends Future<? extends InputT>> immutableCollection) {
        int n = this.decrementRemainingAndGet();
        Preconditions.checkState(n >= 0, "Less than 0 remaining futures");
        if (n == 0) {
            this.processCompleted(immutableCollection);
        }
    }

    private void processCompleted(@CheckForNull ImmutableCollection<? extends Future<? extends InputT>> immutableCollection) {
        if (immutableCollection != null) {
            int n = 0;
            for (Future future : immutableCollection) {
                if (!future.isCancelled()) {
                    this.collectValueFromNonCancelledFuture(n, future);
                }
                ++n;
            }
        }
        this.clearSeenExceptions();
        this.handleAllCompleted();
        this.releaseResources(ReleaseResourcesReason.ALL_INPUT_FUTURES_PROCESSED);
    }

    @ForOverride
    @OverridingMethodsMustInvokeSuper
    void releaseResources(ReleaseResourcesReason releaseResourcesReason) {
        Preconditions.checkNotNull(releaseResourcesReason);
        this.futures = null;
    }

    abstract void collectOneValue(int var1, @ParametricNullness InputT var2);

    abstract void handleAllCompleted();

    private static boolean addCausalChain(Set<Throwable> set, Throwable throwable) {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            boolean bl = set.add(throwable2);
            if (bl) continue;
            return false;
        }
        return true;
    }

    static enum ReleaseResourcesReason {
        OUTPUT_FUTURE_DONE,
        ALL_INPUT_FUTURES_PROCESSED;

    }
}

