/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.net.ElementTypesAreNonnullByDefault;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.InetAddress;
import java.text.ParseException;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class HostSpecifier {
    private final String canonicalForm;

    private HostSpecifier(String string) {
        this.canonicalForm = string;
    }

    public static HostSpecifier fromValid(String string) {
        HostAndPort hostAndPort = HostAndPort.fromString(string);
        Preconditions.checkArgument(!hostAndPort.hasPort());
        String string2 = hostAndPort.getHost();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddresses.forString(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (inetAddress != null) {
            return new HostSpecifier(InetAddresses.toUriString(inetAddress));
        }
        InternetDomainName internetDomainName = InternetDomainName.from(string2);
        if (internetDomainName.hasPublicSuffix()) {
            return new HostSpecifier(internetDomainName.toString());
        }
        throw new IllegalArgumentException("Domain name does not have a recognized public suffix: " + string2);
    }

    @CanIgnoreReturnValue
    public static HostSpecifier from(String string) throws ParseException {
        try {
            return HostSpecifier.fromValid(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ParseException parseException = new ParseException("Invalid host specifier: " + string, 0);
            parseException.initCause(illegalArgumentException);
            throw parseException;
        }
    }

    public static boolean isValid(String string) {
        try {
            HostSpecifier hostSpecifier = HostSpecifier.fromValid(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public boolean equals(@CheckForNull Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HostSpecifier) {
            HostSpecifier hostSpecifier = (HostSpecifier)object;
            return this.canonicalForm.equals(hostSpecifier.canonicalForm);
        }
        return false;
    }

    public int hashCode() {
        return this.canonicalForm.hashCode();
    }

    public String toString() {
        return this.canonicalForm;
    }
}

