/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.math.RoundingMode;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class MathPreconditions {
    @CanIgnoreReturnValue
    static int checkPositive(String string, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(string + " (" + n + ") must be > 0");
        }
        return n;
    }

    @CanIgnoreReturnValue
    static long checkPositive(String string, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(string + " (" + l + ") must be > 0");
        }
        return l;
    }

    @CanIgnoreReturnValue
    static BigInteger checkPositive(String string, BigInteger bigInteger) {
        if (bigInteger.signum() <= 0) {
            throw new IllegalArgumentException(string + " (" + bigInteger + ") must be > 0");
        }
        return bigInteger;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException(string + " (" + n + ") must be >= 0");
        }
        return n;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(String string, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(string + " (" + l + ") must be >= 0");
        }
        return l;
    }

    @CanIgnoreReturnValue
    static BigInteger checkNonNegative(String string, BigInteger bigInteger) {
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException(string + " (" + bigInteger + ") must be >= 0");
        }
        return bigInteger;
    }

    @CanIgnoreReturnValue
    static double checkNonNegative(String string, double d) {
        if (!(d >= 0.0)) {
            throw new IllegalArgumentException(string + " (" + d + ") must be >= 0");
        }
        return d;
    }

    static void checkRoundingUnnecessary(boolean bl) {
        if (!bl) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRangeForRoundingInputs(boolean bl, double d, RoundingMode roundingMode) {
        if (!bl) {
            throw new ArithmeticException("rounded value is out of range for input " + d + " and rounding mode " + (Object)((Object)roundingMode));
        }
    }

    static void checkNoOverflow(boolean bl, String string, int n, int n2) {
        if (!bl) {
            throw new ArithmeticException("overflow: " + string + "(" + n + ", " + n2 + ")");
        }
    }

    static void checkNoOverflow(boolean bl, String string, long l, long l2) {
        if (!bl) {
            throw new ArithmeticException("overflow: " + string + "(" + l + ", " + l2 + ")");
        }
    }

    private MathPreconditions() {
    }
}

