/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
final class MultiInputStream
extends InputStream {
    private Iterator<? extends ByteSource> it;
    @CheckForNull
    private InputStream in;

    public MultiInputStream(Iterator<? extends ByteSource> iterator2) throws IOException {
        this.it = Preconditions.checkNotNull(iterator2);
        this.advance();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    private void advance() throws IOException {
        this.close();
        if (this.it.hasNext()) {
            this.in = this.it.next().openStream();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        while (this.in != null) {
            int n = this.in.read();
            if (n != -1) {
                return n;
            }
            this.advance();
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        Preconditions.checkNotNull(byArray);
        while (this.in != null) {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 != -1) {
                return n3;
            }
            this.advance();
        }
        return -1;
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.in == null || l <= 0L) {
            return 0L;
        }
        long l2 = this.in.skip(l);
        if (l2 != 0L) {
            return l2;
        }
        if (this.read() == -1) {
            return 0L;
        }
        return 1L + this.in.skip(l - 1L);
    }
}

