/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public abstract class CharSink {
    protected CharSink() {
    }

    public abstract Writer openStream() throws IOException;

    public Writer openBufferedStream() throws IOException {
        Writer writer = this.openStream();
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public void write(CharSequence charSequence) throws IOException {
        Preconditions.checkNotNull(charSequence);
        try (Closer closer = Closer.create();){
            Writer writer = closer.register(this.openStream());
            writer.append(charSequence);
            writer.flush();
        }
    }

    public void writeLines(Iterable<? extends CharSequence> iterable) throws IOException {
        this.writeLines(iterable, System.getProperty("line.separator"));
    }

    public void writeLines(Iterable<? extends CharSequence> iterable, String string) throws IOException {
        this.writeLines(iterable.iterator(), string);
    }

    public void writeLines(Stream<? extends CharSequence> stream) throws IOException {
        this.writeLines(stream, System.getProperty("line.separator"));
    }

    public void writeLines(Stream<? extends CharSequence> stream, String string) throws IOException {
        this.writeLines(stream.iterator(), string);
    }

    private void writeLines(Iterator<? extends CharSequence> iterator2, String string) throws IOException {
        Preconditions.checkNotNull(string);
        try (Writer writer = this.openBufferedStream();){
            while (iterator2.hasNext()) {
                writer.append(iterator2.next()).append(string);
            }
        }
    }

    @CanIgnoreReturnValue
    public long writeFrom(Readable readable) throws IOException {
        Preconditions.checkNotNull(readable);
        try (Closer closer = Closer.create();){
            Writer writer = closer.register(this.openStream());
            long l = CharStreams.copy(readable, writer);
            writer.flush();
            long l2 = l;
            return l2;
        }
    }
}

