/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.LittleEndianByteArray;

@ElementTypesAreNonnullByDefault
final class Fingerprint2011
extends AbstractNonStreamingHashFunction {
    static final HashFunction FINGERPRINT_2011 = new Fingerprint2011();
    private static final long K0 = -6505348102511208375L;
    private static final long K1 = -8261664234251669945L;
    private static final long K2 = -4288712594273399085L;
    private static final long K3 = -4132994306676758123L;

    Fingerprint2011() {
    }

    @Override
    public HashCode hashBytes(byte[] byArray, int n, int n2) {
        Preconditions.checkPositionIndexes(n, n + n2, byArray.length);
        return HashCode.fromLong(Fingerprint2011.fingerprint(byArray, n, n2));
    }

    @Override
    public int bits() {
        return 64;
    }

    public String toString() {
        return "Hashing.fingerprint2011()";
    }

    @VisibleForTesting
    static long fingerprint(byte[] byArray, int n, int n2) {
        long l = n2 <= 32 ? Fingerprint2011.murmurHash64WithSeed(byArray, n, n2, -1397348546323613475L) : (n2 <= 64 ? Fingerprint2011.hashLength33To64(byArray, n, n2) : Fingerprint2011.fullFingerprint(byArray, n, n2));
        long l2 = n2 >= 8 ? LittleEndianByteArray.load64(byArray, n) : -6505348102511208375L;
        long l3 = n2 >= 9 ? LittleEndianByteArray.load64(byArray, n + n2 - 8) : -6505348102511208375L;
        l = Fingerprint2011.hash128to64(l + l3, l2);
        return l == 0L || l == 1L ? l + -2L : l;
    }

    private static long shiftMix(long l) {
        return l ^ l >>> 47;
    }

    @VisibleForTesting
    static long hash128to64(long l, long l2) {
        long l3 = (l2 ^ l) * -4132994306676758123L;
        l3 ^= l3 >>> 47;
        long l4 = (l ^ l3) * -4132994306676758123L;
        l4 ^= l4 >>> 47;
        return l4 *= -4132994306676758123L;
    }

    private static void weakHashLength32WithSeeds(byte[] byArray, int n, long l, long l2, long[] lArray) {
        long l3 = LittleEndianByteArray.load64(byArray, n);
        long l4 = LittleEndianByteArray.load64(byArray, n + 8);
        long l5 = LittleEndianByteArray.load64(byArray, n + 16);
        long l6 = LittleEndianByteArray.load64(byArray, n + 24);
        l2 = Long.rotateRight(l2 + (l += l3) + l6, 51);
        long l7 = l;
        l += l4;
        lArray[0] = l + l6;
        lArray[1] = (l2 += Long.rotateRight(l += l5, 23)) + l7;
    }

    private static long fullFingerprint(byte[] byArray, int n, int n2) {
        long l = LittleEndianByteArray.load64(byArray, n);
        long l2 = LittleEndianByteArray.load64(byArray, n + n2 - 16) ^ 0x8D58AC26AFE12E47L;
        long l3 = LittleEndianByteArray.load64(byArray, n + n2 - 56) ^ 0xA5B85C5E198ED849L;
        long[] lArray = new long[2];
        long[] lArray2 = new long[2];
        Fingerprint2011.weakHashLength32WithSeeds(byArray, n + n2 - 64, n2, l2, lArray);
        Fingerprint2011.weakHashLength32WithSeeds(byArray, n + n2 - 32, (long)n2 * -8261664234251669945L, -6505348102511208375L, lArray2);
        l = Long.rotateRight((l3 += Fingerprint2011.shiftMix(lArray[1]) * -8261664234251669945L) + l, 39) * -8261664234251669945L;
        l2 = Long.rotateRight(l2, 33) * -8261664234251669945L;
        n2 = n2 - 1 & 0xFFFFFFC0;
        do {
            l = Long.rotateRight(l + l2 + lArray[0] + LittleEndianByteArray.load64(byArray, n + 16), 37) * -8261664234251669945L;
            l2 = Long.rotateRight(l2 + lArray[1] + LittleEndianByteArray.load64(byArray, n + 48), 42) * -8261664234251669945L;
            l3 = Long.rotateRight(l3 ^ lArray2[0], 33);
            Fingerprint2011.weakHashLength32WithSeeds(byArray, n, lArray[1] * -8261664234251669945L, (l ^= lArray2[1]) + lArray2[0], lArray);
            Fingerprint2011.weakHashLength32WithSeeds(byArray, n + 32, l3 + lArray2[1], l2 ^= lArray[0], lArray2);
            long l4 = l3;
            l3 = l;
            l = l4;
            n += 64;
        } while ((n2 -= 64) != 0);
        return Fingerprint2011.hash128to64(Fingerprint2011.hash128to64(lArray[0], lArray2[0]) + Fingerprint2011.shiftMix(l2) * -8261664234251669945L + l3, Fingerprint2011.hash128to64(lArray[1], lArray2[1]) + l);
    }

    private static long hashLength33To64(byte[] byArray, int n, int n2) {
        long l = LittleEndianByteArray.load64(byArray, n + 24);
        long l2 = LittleEndianByteArray.load64(byArray, n) + ((long)n2 + LittleEndianByteArray.load64(byArray, n + n2 - 16)) * -6505348102511208375L;
        long l3 = Long.rotateRight(l2 + l, 52);
        long l4 = Long.rotateRight(l2, 37);
        long l5 = (l2 += LittleEndianByteArray.load64(byArray, n + 16)) + l;
        long l6 = l3 + Long.rotateRight(l2, 31) + (l4 += Long.rotateRight(l2 += LittleEndianByteArray.load64(byArray, n + 8), 7));
        l2 = LittleEndianByteArray.load64(byArray, n + 16) + LittleEndianByteArray.load64(byArray, n + n2 - 32);
        l = LittleEndianByteArray.load64(byArray, n + n2 - 8);
        l3 = Long.rotateRight(l2 + l, 52);
        l4 = Long.rotateRight(l2, 37);
        long l7 = (l2 += LittleEndianByteArray.load64(byArray, n + n2 - 16)) + l;
        long l8 = l3 + Long.rotateRight(l2, 31) + (l4 += Long.rotateRight(l2 += LittleEndianByteArray.load64(byArray, n + n2 - 24), 7));
        long l9 = Fingerprint2011.shiftMix((l5 + l8) * -4288712594273399085L + (l7 + l6) * -6505348102511208375L);
        return Fingerprint2011.shiftMix(l9 * -6505348102511208375L + l6) * -4288712594273399085L;
    }

    @VisibleForTesting
    static long murmurHash64WithSeed(byte[] byArray, int n, int n2, long l) {
        long l2 = -4132994306676758123L;
        int n3 = 7;
        int n4 = n2 & ~n3;
        int n5 = n2 & n3;
        long l3 = l ^ (long)n2 * l2;
        for (int i = 0; i < n4; i += 8) {
            long l4 = LittleEndianByteArray.load64(byArray, n + i);
            long l5 = Fingerprint2011.shiftMix(l4 * l2) * l2;
            l3 ^= l5;
            l3 *= l2;
        }
        if (n5 != 0) {
            long l6 = LittleEndianByteArray.load64Safely(byArray, n + n4, n5);
            l3 ^= l6;
            l3 *= l2;
        }
        l3 = Fingerprint2011.shiftMix(l3) * l2;
        l3 = Fingerprint2011.shiftMix(l3);
        return l3;
    }
}

