/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ForwardingGraph;
import com.google.common.graph.GraphConstants;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.StandardMutableValueGraph;

@ElementTypesAreNonnullByDefault
final class StandardMutableGraph<N>
extends ForwardingGraph<N>
implements MutableGraph<N> {
    private final MutableValueGraph<N, GraphConstants.Presence> backingValueGraph;

    StandardMutableGraph(AbstractGraphBuilder<? super N> abstractGraphBuilder) {
        this.backingValueGraph = new StandardMutableValueGraph<N, GraphConstants.Presence>(abstractGraphBuilder);
    }

    @Override
    BaseGraph<N> delegate() {
        return this.backingValueGraph;
    }

    @Override
    public boolean addNode(N n) {
        return this.backingValueGraph.addNode(n);
    }

    @Override
    public boolean putEdge(N n, N n2) {
        return this.backingValueGraph.putEdgeValue(n, n2, GraphConstants.Presence.EDGE_EXISTS) == null;
    }

    @Override
    public boolean putEdge(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.putEdge(endpointPair.nodeU(), endpointPair.nodeV());
    }

    @Override
    public boolean removeNode(N n) {
        return this.backingValueGraph.removeNode(n);
    }

    @Override
    public boolean removeEdge(N n, N n2) {
        return this.backingValueGraph.removeEdge(n, n2) != null;
    }

    @Override
    public boolean removeEdge(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.removeEdge(endpointPair.nodeU(), endpointPair.nodeV());
    }
}

