/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
final class DirectedGraphConnections<N, V>
implements GraphConnections<N, V> {
    private static final Object PRED = new Object();
    private final Map<N, Object> adjacentNodeValues;
    @CheckForNull
    private final List<NodeConnection<N>> orderedNodeConnections;
    private int predecessorCount;
    private int successorCount;

    private DirectedGraphConnections(Map<N, Object> map, @CheckForNull List<NodeConnection<N>> list, int n, int n2) {
        this.adjacentNodeValues = Preconditions.checkNotNull(map);
        this.orderedNodeConnections = list;
        this.predecessorCount = Graphs.checkNonNegative(n);
        this.successorCount = Graphs.checkNonNegative(n2);
        Preconditions.checkState(n <= map.size() && n2 <= map.size());
    }

    static <N, V> DirectedGraphConnections<N, V> of(ElementOrder<N> elementOrder) {
        ArrayList<NodeConnection<N>> arrayList;
        int n = 4;
        switch (elementOrder.type()) {
            case UNORDERED: {
                arrayList = null;
                break;
            }
            case STABLE: {
                arrayList = new ArrayList<NodeConnection<N>>();
                break;
            }
            default: {
                throw new AssertionError((Object)elementOrder.type());
            }
        }
        return new DirectedGraphConnections(new HashMap(n, 1.0f), arrayList, 0, 0);
    }

    static <N, V> DirectedGraphConnections<N, V> ofImmutable(N n, Iterable<EndpointPair<N>> iterable, Function<N, V> function) {
        Preconditions.checkNotNull(n);
        Preconditions.checkNotNull(function);
        HashMap<N, Object> hashMap = new HashMap<N, Object>();
        ImmutableList.Builder builder = ImmutableList.builder();
        int n2 = 0;
        int n3 = 0;
        for (EndpointPair<N> endpointPair : iterable) {
            Object object;
            N n4;
            if (endpointPair.nodeU().equals(n) && endpointPair.nodeV().equals(n)) {
                hashMap.put(n, new PredAndSucc(function.apply(n)));
                builder.add(new NodeConnection.Pred<N>(n));
                builder.add(new NodeConnection.Succ<N>(n));
                ++n2;
                ++n3;
                continue;
            }
            if (endpointPair.nodeV().equals(n)) {
                n4 = endpointPair.nodeU();
                object = hashMap.put(n4, PRED);
                if (object != null) {
                    hashMap.put(n4, new PredAndSucc(object));
                }
                builder.add(new NodeConnection.Pred<N>(n4));
                ++n2;
                continue;
            }
            Preconditions.checkArgument(endpointPair.nodeU().equals(n));
            n4 = endpointPair.nodeV();
            object = function.apply(n4);
            Object object2 = hashMap.put(n4, object);
            if (object2 != null) {
                Preconditions.checkArgument(object2 == PRED);
                hashMap.put(n4, new PredAndSucc(object));
            }
            builder.add(new NodeConnection.Succ<N>(n4));
            ++n3;
        }
        return new DirectedGraphConnections(hashMap, builder.build(), n2, n3);
    }

    @Override
    public Set<N> adjacentNodes() {
        if (this.orderedNodeConnections == null) {
            return Collections.unmodifiableSet(this.adjacentNodeValues.keySet());
        }
        return new AbstractSet<N>(){

            @Override
            public UnmodifiableIterator<N> iterator() {
                final Iterator iterator2 = DirectedGraphConnections.this.orderedNodeConnections.iterator();
                final HashSet hashSet = new HashSet();
                return new AbstractIterator<N>(this){

                    @Override
                    @CheckForNull
                    protected N computeNext() {
                        while (iterator2.hasNext()) {
                            NodeConnection nodeConnection = (NodeConnection)iterator2.next();
                            boolean bl = hashSet.add(nodeConnection.node);
                            if (!bl) continue;
                            return nodeConnection.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.adjacentNodeValues.size();
            }

            @Override
            public boolean contains(@CheckForNull Object object) {
                return DirectedGraphConnections.this.adjacentNodeValues.containsKey(object);
            }
        };
    }

    @Override
    public Set<N> predecessors() {
        return new AbstractSet<N>(){

            @Override
            public UnmodifiableIterator<N> iterator() {
                if (DirectedGraphConnections.this.orderedNodeConnections == null) {
                    final Iterator iterator2 = DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator();
                    return new AbstractIterator<N>(this){

                        @Override
                        @CheckForNull
                        protected N computeNext() {
                            while (iterator2.hasNext()) {
                                Map.Entry entry = (Map.Entry)iterator2.next();
                                if (!DirectedGraphConnections.isPredecessor(entry.getValue())) continue;
                                return entry.getKey();
                            }
                            return this.endOfData();
                        }
                    };
                }
                final Iterator iterator3 = DirectedGraphConnections.this.orderedNodeConnections.iterator();
                return new AbstractIterator<N>(this){

                    @Override
                    @CheckForNull
                    protected N computeNext() {
                        while (iterator3.hasNext()) {
                            NodeConnection nodeConnection = (NodeConnection)iterator3.next();
                            if (!(nodeConnection instanceof NodeConnection.Pred)) continue;
                            return nodeConnection.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.predecessorCount;
            }

            @Override
            public boolean contains(@CheckForNull Object object) {
                return DirectedGraphConnections.isPredecessor(DirectedGraphConnections.this.adjacentNodeValues.get(object));
            }
        };
    }

    @Override
    public Set<N> successors() {
        return new AbstractSet<N>(){

            @Override
            public UnmodifiableIterator<N> iterator() {
                if (DirectedGraphConnections.this.orderedNodeConnections == null) {
                    final Iterator iterator2 = DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator();
                    return new AbstractIterator<N>(this){

                        @Override
                        @CheckForNull
                        protected N computeNext() {
                            while (iterator2.hasNext()) {
                                Map.Entry entry = (Map.Entry)iterator2.next();
                                if (!DirectedGraphConnections.isSuccessor(entry.getValue())) continue;
                                return entry.getKey();
                            }
                            return this.endOfData();
                        }
                    };
                }
                final Iterator iterator3 = DirectedGraphConnections.this.orderedNodeConnections.iterator();
                return new AbstractIterator<N>(this){

                    @Override
                    @CheckForNull
                    protected N computeNext() {
                        while (iterator3.hasNext()) {
                            NodeConnection nodeConnection = (NodeConnection)iterator3.next();
                            if (!(nodeConnection instanceof NodeConnection.Succ)) continue;
                            return nodeConnection.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.successorCount;
            }

            @Override
            public boolean contains(@CheckForNull Object object) {
                return DirectedGraphConnections.isSuccessor(DirectedGraphConnections.this.adjacentNodeValues.get(object));
            }
        };
    }

    @Override
    public Iterator<EndpointPair<N>> incidentEdgeIterator(N n) {
        Preconditions.checkNotNull(n);
        final Iterator iterator2 = this.orderedNodeConnections == null ? Iterators.concat(Iterators.transform(this.predecessors().iterator(), object2 -> EndpointPair.ordered(object2, n)), Iterators.transform(this.successors().iterator(), object2 -> EndpointPair.ordered(n, object2))) : Iterators.transform(this.orderedNodeConnections.iterator(), nodeConnection -> {
            if (nodeConnection instanceof NodeConnection.Succ) {
                return EndpointPair.ordered(n, nodeConnection.node);
            }
            return EndpointPair.ordered(nodeConnection.node, n);
        });
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        return new AbstractIterator<EndpointPair<N>>(this){

            @Override
            @CheckForNull
            protected EndpointPair<N> computeNext() {
                while (iterator2.hasNext()) {
                    EndpointPair endpointPair = (EndpointPair)iterator2.next();
                    if (endpointPair.nodeU().equals(endpointPair.nodeV())) {
                        if (atomicBoolean.getAndSet(true)) continue;
                        return endpointPair;
                    }
                    return endpointPair;
                }
                return (EndpointPair)this.endOfData();
            }
        };
    }

    @Override
    @CheckForNull
    public V value(N n) {
        Preconditions.checkNotNull(n);
        Object object = this.adjacentNodeValues.get(n);
        if (object == PRED) {
            return null;
        }
        if (object instanceof PredAndSucc) {
            return (V)((PredAndSucc)object).successorValue;
        }
        return (V)object;
    }

    @Override
    public void removePredecessor(N n) {
        boolean bl;
        Preconditions.checkNotNull(n);
        Object object = this.adjacentNodeValues.get(n);
        if (object == PRED) {
            this.adjacentNodeValues.remove(n);
            bl = true;
        } else if (object instanceof PredAndSucc) {
            this.adjacentNodeValues.put(n, ((PredAndSucc)object).successorValue);
            bl = true;
        } else {
            bl = false;
        }
        if (bl) {
            Graphs.checkNonNegative(--this.predecessorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.remove(new NodeConnection.Pred<N>(n));
            }
        }
    }

    @Override
    @CheckForNull
    public V removeSuccessor(Object object) {
        Object object2;
        Preconditions.checkNotNull(object);
        Object object3 = this.adjacentNodeValues.get(object);
        if (object3 == null || object3 == PRED) {
            object2 = null;
        } else if (object3 instanceof PredAndSucc) {
            this.adjacentNodeValues.put(object, PRED);
            object2 = ((PredAndSucc)object3).successorValue;
        } else {
            this.adjacentNodeValues.remove(object);
            object2 = object3;
        }
        if (object2 != null) {
            Graphs.checkNonNegative(--this.successorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.remove(new NodeConnection.Succ<Object>(object));
            }
        }
        return (V)(object2 == null ? null : object2);
    }

    @Override
    public void addPredecessor(N n, V v) {
        boolean bl;
        Object object = this.adjacentNodeValues.put(n, PRED);
        if (object == null) {
            bl = true;
        } else if (object instanceof PredAndSucc) {
            this.adjacentNodeValues.put(n, object);
            bl = false;
        } else if (object != PRED) {
            this.adjacentNodeValues.put(n, new PredAndSucc(object));
            bl = true;
        } else {
            bl = false;
        }
        if (bl) {
            Graphs.checkPositive(++this.predecessorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.add(new NodeConnection.Pred<N>(n));
            }
        }
    }

    @Override
    @CheckForNull
    public V addSuccessor(N n, V v) {
        Object object;
        Object object2 = this.adjacentNodeValues.put(n, v);
        if (object2 == null) {
            object = null;
        } else if (object2 instanceof PredAndSucc) {
            this.adjacentNodeValues.put(n, new PredAndSucc(v));
            object = ((PredAndSucc)object2).successorValue;
        } else if (object2 == PRED) {
            this.adjacentNodeValues.put(n, new PredAndSucc(v));
            object = null;
        } else {
            object = object2;
        }
        if (object == null) {
            Graphs.checkPositive(++this.successorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.add(new NodeConnection.Succ<N>(n));
            }
        }
        return (V)(object == null ? null : object);
    }

    private static boolean isPredecessor(@CheckForNull Object object) {
        return object == PRED || object instanceof PredAndSucc;
    }

    private static boolean isSuccessor(@CheckForNull Object object) {
        return object != PRED && object != null;
    }

    private static abstract class NodeConnection<N> {
        final N node;

        NodeConnection(N n) {
            this.node = Preconditions.checkNotNull(n);
        }

        static final class Succ<N>
        extends NodeConnection<N> {
            Succ(N n) {
                super(n);
            }

            public boolean equals(@CheckForNull Object object) {
                if (object instanceof Succ) {
                    return this.node.equals(((Succ)object).node);
                }
                return false;
            }

            public int hashCode() {
                return Succ.class.hashCode() + this.node.hashCode();
            }
        }

        static final class Pred<N>
        extends NodeConnection<N> {
            Pred(N n) {
                super(n);
            }

            public boolean equals(@CheckForNull Object object) {
                if (object instanceof Pred) {
                    return this.node.equals(((Pred)object).node);
                }
                return false;
            }

            public int hashCode() {
                return Pred.class.hashCode() + this.node.hashCode();
            }
        }
    }

    private static final class PredAndSucc {
        private final Object successorValue;

        PredAndSucc(Object object) {
            this.successorValue = object;
        }
    }
}

