/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.NetworkConnections;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
abstract class AbstractUndirectedNetworkConnections<N, E>
implements NetworkConnections<N, E> {
    final Map<E, N> incidentEdgeMap;

    AbstractUndirectedNetworkConnections(Map<E, N> map) {
        this.incidentEdgeMap = Preconditions.checkNotNull(map);
    }

    @Override
    public Set<N> predecessors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<N> successors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<E> incidentEdges() {
        return Collections.unmodifiableSet(this.incidentEdgeMap.keySet());
    }

    @Override
    public Set<E> inEdges() {
        return this.incidentEdges();
    }

    @Override
    public Set<E> outEdges() {
        return this.incidentEdges();
    }

    @Override
    public N adjacentNode(E e) {
        return Objects.requireNonNull(this.incidentEdgeMap.get(e));
    }

    @Override
    @CheckForNull
    public N removeInEdge(E e, boolean bl) {
        if (!bl) {
            return this.removeOutEdge(e);
        }
        return null;
    }

    @Override
    public N removeOutEdge(E e) {
        N n = this.incidentEdgeMap.remove(e);
        return Objects.requireNonNull(n);
    }

    @Override
    public void addInEdge(E e, N n, boolean bl) {
        if (!bl) {
            this.addOutEdge(e, n);
        }
    }

    @Override
    public void addOutEdge(E e, N n) {
        N n2 = this.incidentEdgeMap.put(e, n);
        Preconditions.checkState(n2 == null);
    }
}

