/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.AbstractGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.InvalidatableSet;
import com.google.common.graph.Network;
import com.google.common.math.IntMath;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@Beta
public abstract class AbstractNetwork<N, E>
implements Network<N, E> {
    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(){

            @Override
            public Set<N> nodes() {
                return AbstractNetwork.this.nodes();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                if (AbstractNetwork.this.allowsParallelEdges()) {
                    return super.edges();
                }
                return new AbstractSet<EndpointPair<N>>(){

                    @Override
                    public Iterator<EndpointPair<N>> iterator() {
                        return Iterators.transform(AbstractNetwork.this.edges().iterator(), object -> AbstractNetwork.this.incidentNodes(object));
                    }

                    @Override
                    public int size() {
                        return AbstractNetwork.this.edges().size();
                    }

                    @Override
                    public boolean contains(@CheckForNull Object object) {
                        if (!(object instanceof EndpointPair)) {
                            return false;
                        }
                        EndpointPair endpointPair = (EndpointPair)object;
                        return this.isOrderingCompatible(endpointPair) && this.nodes().contains(endpointPair.nodeU()) && this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
                    }
                };
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return AbstractNetwork.this.nodeOrder();
            }

            @Override
            public ElementOrder<N> incidentEdgeOrder() {
                return ElementOrder.unordered();
            }

            @Override
            public boolean isDirected() {
                return AbstractNetwork.this.isDirected();
            }

            @Override
            public boolean allowsSelfLoops() {
                return AbstractNetwork.this.allowsSelfLoops();
            }

            @Override
            public Set<N> adjacentNodes(N n) {
                return AbstractNetwork.this.adjacentNodes(n);
            }

            @Override
            public Set<N> predecessors(N n) {
                return AbstractNetwork.this.predecessors(n);
            }

            @Override
            public Set<N> successors(N n) {
                return AbstractNetwork.this.successors(n);
            }
        };
    }

    @Override
    public int degree(N n) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.inEdges(n).size(), this.outEdges(n).size());
        }
        return IntMath.saturatedAdd(this.incidentEdges(n).size(), this.edgesConnecting(n, n).size());
    }

    @Override
    public int inDegree(N n) {
        return this.isDirected() ? this.inEdges(n).size() : this.degree(n);
    }

    @Override
    public int outDegree(N n) {
        return this.isDirected() ? this.outEdges(n).size() : this.degree(n);
    }

    @Override
    public Set<E> adjacentEdges(E e) {
        EndpointPair endpointPair = this.incidentNodes(e);
        Sets.SetView setView = Sets.union(this.incidentEdges(endpointPair.nodeU()), this.incidentEdges(endpointPair.nodeV()));
        return this.edgeInvalidatableSet(Sets.difference(setView, ImmutableSet.of(e)), e);
    }

    @Override
    public Set<E> edgesConnecting(N n, N n2) {
        Set set = this.outEdges(n);
        Set set2 = this.inEdges(n2);
        return this.nodePairInvalidatableSet(set.size() <= set2.size() ? Collections.unmodifiableSet(Sets.filter(set, this.connectedPredicate(n, n2))) : Collections.unmodifiableSet(Sets.filter(set2, this.connectedPredicate(n2, n))), n, n2);
    }

    @Override
    public Set<E> edgesConnecting(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.edgesConnecting(endpointPair.nodeU(), endpointPair.nodeV());
    }

    private Predicate<E> connectedPredicate(final N n, final N n2) {
        return new Predicate<E>(){

            @Override
            public boolean apply(E e) {
                return AbstractNetwork.this.incidentNodes(e).adjacentNode(n).equals(n2);
            }
        };
    }

    @Override
    public Optional<E> edgeConnecting(N n, N n2) {
        return Optional.ofNullable(this.edgeConnectingOrNull(n, n2));
    }

    @Override
    public Optional<E> edgeConnecting(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.edgeConnecting(endpointPair.nodeU(), endpointPair.nodeV());
    }

    @Override
    @CheckForNull
    public E edgeConnectingOrNull(N n, N n2) {
        Set<E> set = this.edgesConnecting(n, n2);
        switch (set.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return set.iterator().next();
            }
        }
        throw new IllegalArgumentException(String.format("Cannot call edgeConnecting() when parallel edges exist between %s and %s. Consider calling edgesConnecting() instead.", n, n2));
    }

    @Override
    @CheckForNull
    public E edgeConnectingOrNull(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.edgeConnectingOrNull(endpointPair.nodeU(), endpointPair.nodeV());
    }

    @Override
    public boolean hasEdgeConnecting(N n, N n2) {
        Preconditions.checkNotNull(n);
        Preconditions.checkNotNull(n2);
        return this.nodes().contains(n) && this.successors((Object)n).contains(n2);
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        if (!this.isOrderingCompatible(endpointPair)) {
            return false;
        }
        return this.hasEdgeConnecting(endpointPair.nodeU(), endpointPair.nodeV());
    }

    protected final void validateEndpoints(EndpointPair<?> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        Preconditions.checkArgument(this.isOrderingCompatible(endpointPair), "Mismatch: endpoints' ordering is not compatible with directionality of the graph");
    }

    protected final boolean isOrderingCompatible(EndpointPair<?> endpointPair) {
        return endpointPair.isOrdered() == this.isDirected();
    }

    @Override
    public final boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Network)) {
            return false;
        }
        Network network = (Network)object;
        return this.isDirected() == network.isDirected() && this.nodes().equals(network.nodes()) && AbstractNetwork.edgeIncidentNodesMap(this).equals(AbstractNetwork.edgeIncidentNodesMap(network));
    }

    @Override
    public final int hashCode() {
        return AbstractNetwork.edgeIncidentNodesMap(this).hashCode();
    }

    public String toString() {
        return "isDirected: " + this.isDirected() + ", allowsParallelEdges: " + this.allowsParallelEdges() + ", allowsSelfLoops: " + this.allowsSelfLoops() + ", nodes: " + this.nodes() + ", edges: " + AbstractNetwork.edgeIncidentNodesMap(this);
    }

    protected final <T> Set<T> edgeInvalidatableSet(Set<T> set, E e) {
        return InvalidatableSet.of(set, () -> this.edges().contains(e), () -> String.format("Edge %s that was used to generate this set is no longer in the graph.", e));
    }

    protected final <T> Set<T> nodeInvalidatableSet(Set<T> set, N n) {
        return InvalidatableSet.of(set, () -> this.nodes().contains(n), () -> String.format("Node %s that was used to generate this set is no longer in the graph.", n));
    }

    protected final <T> Set<T> nodePairInvalidatableSet(Set<T> set, N n, N n2) {
        return InvalidatableSet.of(set, () -> this.nodes().contains(n) && this.nodes().contains(n2), () -> String.format("Node %s or node %s that were used to generate this set are no longer in the graph.", n, n2));
    }

    private static <N, E> Map<E, EndpointPair<N>> edgeIncidentNodesMap(Network<N, E> network) {
        return Maps.asMap(network.edges(), network::incidentNodes);
    }
}

