/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ParametricNullness;
import com.google.common.math.LongMath;
import com.google.errorprone.annotations.InlineMe;
import com.google.errorprone.annotations.InlineMeValidationDisabled;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Streams {
    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).stream() : StreamSupport.stream(iterable.spliterator(), false);
    }

    @Deprecated
    @InlineMe(replacement="collection.stream()")
    public static <T> Stream<T> stream(Collection<T> collection) {
        return collection.stream();
    }

    public static <T> Stream<T> stream(Iterator<T> iterator2) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator2, 0), false);
    }

    public static <T> Stream<T> stream(com.google.common.base.Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    @Beta
    @InlineMe(replacement="optional.stream()")
    @InlineMeValidationDisabled(value="Java 9+ API only")
    public static <T> Stream<T> stream(Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    @Beta
    @InlineMe(replacement="optional.stream()")
    @InlineMeValidationDisabled(value="Java 9+ API only")
    public static IntStream stream(OptionalInt optionalInt) {
        return optionalInt.isPresent() ? IntStream.of(optionalInt.getAsInt()) : IntStream.empty();
    }

    @Beta
    @InlineMe(replacement="optional.stream()")
    @InlineMeValidationDisabled(value="Java 9+ API only")
    public static LongStream stream(OptionalLong optionalLong) {
        return optionalLong.isPresent() ? LongStream.of(optionalLong.getAsLong()) : LongStream.empty();
    }

    @Beta
    @InlineMe(replacement="optional.stream()")
    @InlineMeValidationDisabled(value="Java 9+ API only")
    public static DoubleStream stream(OptionalDouble optionalDouble) {
        return optionalDouble.isPresent() ? DoubleStream.of(optionalDouble.getAsDouble()) : DoubleStream.empty();
    }

    private static void closeAll(BaseStream<?, ?>[] baseStreamArray) {
        Exception exception = null;
        for (BaseStream<?, ?> baseStream : baseStreamArray) {
            try {
                baseStream.close();
            }
            catch (Exception exception2) {
                if (exception == null) {
                    exception = exception2;
                    continue;
                }
                exception.addSuppressed(exception2);
            }
        }
        if (exception != null) {
            Streams.sneakyThrow(exception);
        }
    }

    private static void sneakyThrow(Throwable throwable) {
        class SneakyThrower<T extends Throwable> {
            SneakyThrower() {
            }

            void throwIt(Throwable throwable) throws T {
                throw throwable;
            }
        }
        new SneakyThrower().throwIt(throwable);
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<? extends T> ... streamArray) {
        boolean bl = false;
        int n = 336;
        long l = 0L;
        ImmutableList.Builder builder = new ImmutableList.Builder(streamArray.length);
        for (Stream<T> stream : streamArray) {
            bl |= stream.isParallel();
            Spliterator spliterator2 = stream.spliterator();
            builder.add(spliterator2);
            n &= spliterator2.characteristics();
            l = LongMath.saturatedAdd(l, spliterator2.estimateSize());
        }
        return (Stream)StreamSupport.stream(CollectSpliterators.flatMap(((ImmutableList)builder.build()).spliterator(), spliterator -> spliterator, n, l), bl).onClose(() -> Streams.closeAll(streamArray));
    }

    public static IntStream concat(IntStream ... intStreamArray) {
        boolean bl = false;
        int n = 336;
        long l = 0L;
        ImmutableList.Builder builder = new ImmutableList.Builder(intStreamArray.length);
        for (IntStream intStream : intStreamArray) {
            bl |= intStream.isParallel();
            Spliterator.OfInt ofInt2 = intStream.spliterator();
            builder.add(ofInt2);
            n &= ofInt2.characteristics();
            l = LongMath.saturatedAdd(l, ofInt2.estimateSize());
        }
        return (IntStream)StreamSupport.intStream(CollectSpliterators.flatMapToInt(((ImmutableList)builder.build()).spliterator(), ofInt -> ofInt, n, l), bl).onClose(() -> Streams.closeAll(intStreamArray));
    }

    public static LongStream concat(LongStream ... longStreamArray) {
        boolean bl = false;
        int n = 336;
        long l = 0L;
        ImmutableList.Builder builder = new ImmutableList.Builder(longStreamArray.length);
        for (LongStream longStream : longStreamArray) {
            bl |= longStream.isParallel();
            Spliterator.OfLong ofLong2 = longStream.spliterator();
            builder.add(ofLong2);
            n &= ofLong2.characteristics();
            l = LongMath.saturatedAdd(l, ofLong2.estimateSize());
        }
        return (LongStream)StreamSupport.longStream(CollectSpliterators.flatMapToLong(((ImmutableList)builder.build()).spliterator(), ofLong -> ofLong, n, l), bl).onClose(() -> Streams.closeAll(longStreamArray));
    }

    public static DoubleStream concat(DoubleStream ... doubleStreamArray) {
        boolean bl = false;
        int n = 336;
        long l = 0L;
        ImmutableList.Builder builder = new ImmutableList.Builder(doubleStreamArray.length);
        for (DoubleStream doubleStream : doubleStreamArray) {
            bl |= doubleStream.isParallel();
            Spliterator.OfDouble ofDouble2 = doubleStream.spliterator();
            builder.add(ofDouble2);
            n &= ofDouble2.characteristics();
            l = LongMath.saturatedAdd(l, ofDouble2.estimateSize());
        }
        return (DoubleStream)StreamSupport.doubleStream(CollectSpliterators.flatMapToDouble(((ImmutableList)builder.build()).spliterator(), ofDouble -> ofDouble, n, l), bl).onClose(() -> Streams.closeAll(doubleStreamArray));
    }

    @Beta
    public static <A, B, R> Stream<R> zip(Stream<A> stream, Stream<B> stream2, final BiFunction<? super A, ? super B, R> biFunction) {
        Preconditions.checkNotNull(stream);
        Preconditions.checkNotNull(stream2);
        Preconditions.checkNotNull(biFunction);
        boolean bl = stream.isParallel() || stream2.isParallel();
        Spliterator spliterator = stream.spliterator();
        Spliterator spliterator2 = stream2.spliterator();
        int n = spliterator.characteristics() & spliterator2.characteristics() & 0x50;
        final Iterator iterator2 = Spliterators.iterator(spliterator);
        final Iterator iterator3 = Spliterators.iterator(spliterator2);
        return (Stream)((Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(Math.min(spliterator.estimateSize(), spliterator2.estimateSize()), n){

            @Override
            public boolean tryAdvance(Consumer<? super R> consumer) {
                if (iterator2.hasNext() && iterator3.hasNext()) {
                    consumer.accept(biFunction.apply(iterator2.next(), iterator3.next()));
                    return true;
                }
                return false;
            }
        }, bl).onClose(stream::close)).onClose(stream2::close);
    }

    @Beta
    public static <A, B> void forEachPair(Stream<A> stream, Stream<B> stream2, BiConsumer<? super A, ? super B> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        if (stream.isParallel() || stream2.isParallel()) {
            Streams.zip(stream, stream2, TemporaryPair::new).forEach(temporaryPair -> biConsumer.accept(temporaryPair.a, temporaryPair.b));
        } else {
            Iterator iterator2 = stream.iterator();
            Iterator iterator3 = stream2.iterator();
            while (iterator2.hasNext() && iterator3.hasNext()) {
                biConsumer.accept(iterator2.next(), iterator3.next());
            }
        }
    }

    public static <T, R> Stream<R> mapWithIndex(Stream<T> stream, final FunctionWithIndex<? super T, ? extends R> functionWithIndex) {
        Preconditions.checkNotNull(stream);
        Preconditions.checkNotNull(functionWithIndex);
        boolean bl = stream.isParallel();
        Spliterator spliterator = stream.spliterator();
        if (!spliterator.hasCharacteristics(16384)) {
            final Iterator iterator2 = Spliterators.iterator(spliterator);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(spliterator.estimateSize(), spliterator.characteristics() & 0x50){
                long index;
                {
                    super(l, n);
                    this.index = 0L;
                }

                @Override
                public boolean tryAdvance(Consumer<? super R> consumer) {
                    if (iterator2.hasNext()) {
                        consumer.accept(functionWithIndex.apply(iterator2.next(), this.index++));
                        return true;
                    }
                    return false;
                }
            }, bl).onClose(stream::close);
        }
        class Splitr
        extends MapWithIndexSpliterator<Spliterator<T>, R, Splitr>
        implements Consumer<T> {
            @CheckForNull
            T holder;
            final /* synthetic */ FunctionWithIndex val$function;

            Splitr(Spliterator<T> spliterator, long l) {
                this.val$function = var4_3;
                super(spliterator, l);
            }

            @Override
            public void accept(@ParametricNullness T t2) {
                this.holder = t2;
            }

            @Override
            public boolean tryAdvance(Consumer<? super R> consumer) {
                if (this.fromSpliterator.tryAdvance(this)) {
                    try {
                        consumer.accept(this.val$function.apply(NullnessCasts.uncheckedCastNullableTToT(this.holder), this.index++));
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.holder = null;
                    }
                }
                return false;
            }

            @Override
            Splitr createSplit(Spliterator<T> spliterator, long l) {
                return new Splitr(spliterator, l, this.val$function);
            }
        }
        return (Stream)StreamSupport.stream(new Splitr(spliterator, 0L, functionWithIndex), bl).onClose(stream::close);
    }

    public static <R> Stream<R> mapWithIndex(IntStream intStream, final IntFunctionWithIndex<R> intFunctionWithIndex) {
        Preconditions.checkNotNull(intStream);
        Preconditions.checkNotNull(intFunctionWithIndex);
        boolean bl = intStream.isParallel();
        Spliterator.OfInt ofInt = intStream.spliterator();
        if (!ofInt.hasCharacteristics(16384)) {
            final PrimitiveIterator.OfInt ofInt2 = Spliterators.iterator(ofInt);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(ofInt.estimateSize(), ofInt.characteristics() & 0x50){
                long index;
                {
                    super(l, n);
                    this.index = 0L;
                }

                @Override
                public boolean tryAdvance(Consumer<? super R> consumer) {
                    if (ofInt2.hasNext()) {
                        consumer.accept(intFunctionWithIndex.apply(ofInt2.nextInt(), this.index++));
                        return true;
                    }
                    return false;
                }
            }, bl).onClose(intStream::close);
        }
        class Splitr
        extends MapWithIndexSpliterator<Spliterator.OfInt, R, Splitr>
        implements Spliterator<R>,
        IntConsumer {
            int holder;
            final /* synthetic */ IntFunctionWithIndex val$function;

            Splitr(Spliterator.OfInt ofInt, long l) {
                this.val$function = var4_3;
                super(ofInt, l);
            }

            @Override
            public void accept(int n) {
                this.holder = n;
            }

            @Override
            public boolean tryAdvance(Consumer<? super R> consumer) {
                if (((Spliterator.OfInt)this.fromSpliterator).tryAdvance(this)) {
                    consumer.accept(this.val$function.apply(this.holder, this.index++));
                    return true;
                }
                return false;
            }

            @Override
            Splitr createSplit(Spliterator.OfInt ofInt, long l) {
                return new Splitr(ofInt, l, this.val$function);
            }
        }
        return (Stream)StreamSupport.stream(new Splitr(ofInt, 0L, intFunctionWithIndex), bl).onClose(intStream::close);
    }

    public static <R> Stream<R> mapWithIndex(LongStream longStream, final LongFunctionWithIndex<R> longFunctionWithIndex) {
        Preconditions.checkNotNull(longStream);
        Preconditions.checkNotNull(longFunctionWithIndex);
        boolean bl = longStream.isParallel();
        Spliterator.OfLong ofLong = longStream.spliterator();
        if (!ofLong.hasCharacteristics(16384)) {
            final PrimitiveIterator.OfLong ofLong2 = Spliterators.iterator(ofLong);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(ofLong.estimateSize(), ofLong.characteristics() & 0x50){
                long index;
                {
                    super(l, n);
                    this.index = 0L;
                }

                @Override
                public boolean tryAdvance(Consumer<? super R> consumer) {
                    if (ofLong2.hasNext()) {
                        consumer.accept(longFunctionWithIndex.apply(ofLong2.nextLong(), this.index++));
                        return true;
                    }
                    return false;
                }
            }, bl).onClose(longStream::close);
        }
        class Splitr
        extends MapWithIndexSpliterator<Spliterator.OfLong, R, Splitr>
        implements Spliterator<R>,
        LongConsumer {
            long holder;
            final /* synthetic */ LongFunctionWithIndex val$function;

            Splitr(Spliterator.OfLong ofLong, long l) {
                this.val$function = var4_3;
                super(ofLong, l);
            }

            @Override
            public void accept(long l) {
                this.holder = l;
            }

            @Override
            public boolean tryAdvance(Consumer<? super R> consumer) {
                if (((Spliterator.OfLong)this.fromSpliterator).tryAdvance(this)) {
                    consumer.accept(this.val$function.apply(this.holder, this.index++));
                    return true;
                }
                return false;
            }

            @Override
            Splitr createSplit(Spliterator.OfLong ofLong, long l) {
                return new Splitr(ofLong, l, this.val$function);
            }
        }
        return (Stream)StreamSupport.stream(new Splitr(ofLong, 0L, longFunctionWithIndex), bl).onClose(longStream::close);
    }

    public static <R> Stream<R> mapWithIndex(DoubleStream doubleStream, final DoubleFunctionWithIndex<R> doubleFunctionWithIndex) {
        Preconditions.checkNotNull(doubleStream);
        Preconditions.checkNotNull(doubleFunctionWithIndex);
        boolean bl = doubleStream.isParallel();
        Spliterator.OfDouble ofDouble = doubleStream.spliterator();
        if (!ofDouble.hasCharacteristics(16384)) {
            final PrimitiveIterator.OfDouble ofDouble2 = Spliterators.iterator(ofDouble);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(ofDouble.estimateSize(), ofDouble.characteristics() & 0x50){
                long index;
                {
                    super(l, n);
                    this.index = 0L;
                }

                @Override
                public boolean tryAdvance(Consumer<? super R> consumer) {
                    if (ofDouble2.hasNext()) {
                        consumer.accept(doubleFunctionWithIndex.apply(ofDouble2.nextDouble(), this.index++));
                        return true;
                    }
                    return false;
                }
            }, bl).onClose(doubleStream::close);
        }
        class Splitr
        extends MapWithIndexSpliterator<Spliterator.OfDouble, R, Splitr>
        implements Spliterator<R>,
        DoubleConsumer {
            double holder;
            final /* synthetic */ DoubleFunctionWithIndex val$function;

            Splitr(Spliterator.OfDouble ofDouble, long l) {
                this.val$function = var4_3;
                super(ofDouble, l);
            }

            @Override
            public void accept(double d) {
                this.holder = d;
            }

            @Override
            public boolean tryAdvance(Consumer<? super R> consumer) {
                if (((Spliterator.OfDouble)this.fromSpliterator).tryAdvance(this)) {
                    consumer.accept(this.val$function.apply(this.holder, this.index++));
                    return true;
                }
                return false;
            }

            @Override
            Splitr createSplit(Spliterator.OfDouble ofDouble, long l) {
                return new Splitr(ofDouble, l, this.val$function);
            }
        }
        return (Stream)StreamSupport.stream(new Splitr(ofDouble, 0L, doubleFunctionWithIndex), bl).onClose(doubleStream::close);
    }

    public static <T> Optional<T> findLast(Stream<T> stream) {
        class OptionalState {
            boolean set = false;
            @CheckForNull
            T value = null;

            OptionalState() {
            }

            void set(T t2) {
                this.set = true;
                this.value = t2;
            }

            T get() {
                return Objects.requireNonNull(this.value);
            }
        }
        OptionalState optionalState = new OptionalState();
        ArrayDeque arrayDeque = new ArrayDeque();
        arrayDeque.addLast(stream.spliterator());
        while (!arrayDeque.isEmpty()) {
            Spliterator<Object> spliterator;
            Spliterator<Object> spliterator2;
            block7: {
                block6: {
                    spliterator2 = (Spliterator<Object>)arrayDeque.removeLast();
                    if (spliterator2.getExactSizeIfKnown() == 0L) continue;
                    if (spliterator2.hasCharacteristics(16384)) {
                        while ((spliterator = spliterator2.trySplit()) != null && spliterator.getExactSizeIfKnown() != 0L) {
                            if (spliterator2.getExactSizeIfKnown() != 0L) continue;
                            spliterator2 = spliterator;
                            break;
                        }
                        spliterator2.forEachRemaining(optionalState::set);
                        return Optional.of(optionalState.get());
                    }
                    spliterator = spliterator2.trySplit();
                    if (spliterator == null) break block6;
                    if (spliterator.getExactSizeIfKnown() != 0L) break block7;
                }
                spliterator2.forEachRemaining(optionalState::set);
                if (!optionalState.set) continue;
                return Optional.of(optionalState.get());
            }
            arrayDeque.addLast(spliterator);
            arrayDeque.addLast(spliterator2);
        }
        return Optional.empty();
    }

    public static OptionalInt findLast(IntStream intStream) {
        Optional<Integer> optional = Streams.findLast(intStream.boxed());
        return optional.map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    public static OptionalLong findLast(LongStream longStream) {
        Optional<Long> optional = Streams.findLast(longStream.boxed());
        return optional.map(OptionalLong::of).orElse(OptionalLong.empty());
    }

    public static OptionalDouble findLast(DoubleStream doubleStream) {
        Optional<Double> optional = Streams.findLast(doubleStream.boxed());
        return optional.map(OptionalDouble::of).orElse(OptionalDouble.empty());
    }

    private Streams() {
    }

    public static interface DoubleFunctionWithIndex<R> {
        @ParametricNullness
        public R apply(double var1, long var3);
    }

    public static interface LongFunctionWithIndex<R> {
        @ParametricNullness
        public R apply(long var1, long var3);
    }

    public static interface IntFunctionWithIndex<R> {
        @ParametricNullness
        public R apply(int var1, long var2);
    }

    private static abstract class MapWithIndexSpliterator<F extends Spliterator<?>, R, S extends MapWithIndexSpliterator<F, R, S>>
    implements Spliterator<R> {
        final F fromSpliterator;
        long index;

        MapWithIndexSpliterator(F f, long l) {
            this.fromSpliterator = f;
            this.index = l;
        }

        abstract S createSplit(F var1, long var2);

        @CheckForNull
        public S trySplit() {
            Spliterator spliterator = this.fromSpliterator.trySplit();
            if (spliterator == null) {
                return null;
            }
            Spliterator spliterator2 = spliterator;
            S s2 = this.createSplit(spliterator2, this.index);
            this.index += spliterator2.getExactSizeIfKnown();
            return s2;
        }

        @Override
        public long estimateSize() {
            return this.fromSpliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.fromSpliterator.characteristics() & 0x4050;
        }
    }

    public static interface FunctionWithIndex<T, R> {
        @ParametricNullness
        public R apply(@ParametricNullness T var1, long var2);
    }

    private static class TemporaryPair<A, B> {
        @ParametricNullness
        final A a;
        @ParametricNullness
        final B b;

        TemporaryPair(@ParametricNullness A a, @ParametricNullness B b) {
            this.a = a;
            this.b = b;
        }
    }
}

