/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.JdkBackedImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap(ImmutableMap.EMPTY_ENTRY_ARRAY, null, 0);
    @VisibleForTesting
    static final double MAX_LOAD_FACTOR = 1.2;
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    @VisibleForTesting
    static final int MAX_HASH_BUCKET_LENGTH = 8;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    @CheckForNull
    private final transient @Nullable ImmutableMapEntry<K, V>[] table;
    private final transient int mask;
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    static <K, V> ImmutableMap<K, V> fromEntries(Map.Entry<K, V> ... entryArray) {
        return RegularImmutableMap.fromEntryArray(entryArray.length, entryArray, true);
    }

    static <K, V> ImmutableMap<K, V> fromEntryArray(int n,  @Nullable Map.Entry<K, V>[] entryArray, boolean bl) {
        Preconditions.checkPositionIndex(n, entryArray.length);
        if (n == 0) {
            ImmutableMap<Object, Object> immutableMap = EMPTY;
            return immutableMap;
        }
        try {
            return RegularImmutableMap.fromEntryArrayCheckingBucketOverflow(n, entryArray, bl);
        }
        catch (BucketOverflowException bucketOverflowException) {
            return JdkBackedImmutableMap.create(n, entryArray, bl);
        }
    }

    private static <K, V> ImmutableMap<K, V> fromEntryArrayCheckingBucketOverflow(int n,  @Nullable Map.Entry<K, V>[] entryArray, boolean bl) throws BucketOverflowException {
        int n2;
        Map.Entry<K, V>[] entryArray2 = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int n3 = Hashing.closedTableSize(n, 1.2);
        @Nullable ImmutableMapEntry<K, V>[] immutableMapEntryArray = ImmutableMapEntry.createEntryArray(n3);
        int n4 = n3 - 1;
        IdentityHashMap<ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>, Boolean> identityHashMap = null;
        int n5 = 0;
        for (n2 = n - 1; n2 >= 0; --n2) {
            Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[n2]);
            K k = entry.getKey();
            V v = entry.getValue();
            CollectPreconditions.checkEntryNotNull(k, v);
            int n6 = Hashing.smear(k.hashCode()) & n4;
            ImmutableMapEntry immutableMapEntry = immutableMapEntryArray[n6];
            ImmutableMapEntry immutableMapEntry2 = RegularImmutableMap.checkNoConflictInKeyBucket(k, v, immutableMapEntry, bl);
            if (immutableMapEntry2 == null) {
                immutableMapEntry2 = immutableMapEntry == null ? RegularImmutableMap.makeImmutable(entry, k, v) : new ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>(k, v, immutableMapEntry);
                immutableMapEntryArray[n6] = immutableMapEntry2;
            } else {
                if (identityHashMap == null) {
                    identityHashMap = new IdentityHashMap<ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>, Boolean>();
                }
                identityHashMap.put((ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>)immutableMapEntry2, true);
                ++n5;
                if (entryArray2 == entryArray) {
                    Map.Entry<K, V>[] entryArray3 = entryArray2;
                    entryArray2 = (Map.Entry[])entryArray3.clone();
                }
            }
            entryArray2[n2] = immutableMapEntry2;
        }
        if (identityHashMap != null && (n2 = Hashing.closedTableSize((entryArray2 = RegularImmutableMap.removeDuplicates(entryArray2, n, n - n5, identityHashMap)).length, 1.2)) != n3) {
            return RegularImmutableMap.fromEntryArrayCheckingBucketOverflow(entryArray2.length, entryArray2, true);
        }
        return new RegularImmutableMap<K, V>(entryArray2, immutableMapEntryArray, n4);
    }

    static <K, V> Map.Entry<K, V>[] removeDuplicates(Map.Entry<K, V>[] entryArray, int n, int n2, IdentityHashMap<Map.Entry<K, V>, Boolean> identityHashMap) {
        ImmutableMapEntry<K, V>[] immutableMapEntryArray = ImmutableMapEntry.createEntryArray(n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Map.Entry<K, V> entry = entryArray[i];
            Boolean bl = identityHashMap.get(entry);
            if (bl != null) {
                if (!bl.booleanValue()) continue;
                identityHashMap.put(entry, false);
            }
            immutableMapEntryArray[n3++] = entry;
        }
        return immutableMapEntryArray;
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry, K k, V v) {
        boolean bl = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
        return bl ? (ImmutableMapEntry)entry : new ImmutableMapEntry<K, V>(k, v);
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry) {
        return RegularImmutableMap.makeImmutable(entry, entry.getKey(), entry.getValue());
    }

    private RegularImmutableMap(Map.Entry<K, V>[] entryArray, @CheckForNull @Nullable ImmutableMapEntry<K, V>[] immutableMapEntryArray, int n) {
        this.entries = entryArray;
        this.table = immutableMapEntryArray;
        this.mask = n;
    }

    @CheckForNull
    @CanIgnoreReturnValue
    static <K, V> ImmutableMapEntry<K, V> checkNoConflictInKeyBucket(Object object, Object object2, @CheckForNull ImmutableMapEntry<K, V> immutableMapEntry, boolean bl) throws BucketOverflowException {
        int n = 0;
        while (immutableMapEntry != null) {
            if (immutableMapEntry.getKey().equals(object)) {
                if (bl) {
                    RegularImmutableMap.checkNoConflict(false, "key", immutableMapEntry, object + "=" + object2);
                } else {
                    return immutableMapEntry;
                }
            }
            if (++n > 8) {
                throw new BucketOverflowException();
            }
            immutableMapEntry = immutableMapEntry.getNextInKeyBucket();
        }
        return null;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object object) {
        return RegularImmutableMap.get(object, this.table, this.mask);
    }

    @CheckForNull
    static <V> V get(@CheckForNull Object object, @CheckForNull @Nullable ImmutableMapEntry<?, V>[] immutableMapEntryArray, int n) {
        if (object == null || immutableMapEntryArray == null) {
            return null;
        }
        int n2 = Hashing.smear(object.hashCode()) & n;
        for (ImmutableMapEntry<?, V> immutableMapEntry = immutableMapEntryArray[n2]; immutableMapEntry != null; immutableMapEntry = immutableMapEntry.getNextInKeyBucket()) {
            Object k = immutableMapEntry.getKey();
            if (!object.equals(k)) continue;
            return immutableMapEntry.getValue();
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        for (Map.Entry<K, V> entry : this.entries) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new KeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }

    @GwtCompatible(emulated=true)
    private static final class Values<K, V>
    extends ImmutableList<V> {
        final RegularImmutableMap<K, V> map;

        Values(RegularImmutableMap<K, V> regularImmutableMap) {
            this.map = regularImmutableMap;
        }

        @Override
        public V get(int n) {
            return this.map.entries[n].getValue();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }

        @GwtIncompatible
        @J2ktIncompatible
        private static class SerializedForm<V>
        implements Serializable {
            final ImmutableMap<?, V> map;
            @J2ktIncompatible
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<?, V> immutableMap) {
                this.map = immutableMap;
            }

            Object readResolve() {
                return this.map.values();
            }
        }
    }

    @GwtCompatible(emulated=true)
    private static final class KeySet<K>
    extends IndexedImmutableSet<K> {
        private final RegularImmutableMap<K, ?> map;

        KeySet(RegularImmutableMap<K, ?> regularImmutableMap) {
            this.map = regularImmutableMap;
        }

        @Override
        K get(int n) {
            return this.map.entries[n].getKey();
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            return this.map.containsKey(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }

        @GwtIncompatible
        @J2ktIncompatible
        private static class SerializedForm<K>
        implements Serializable {
            final ImmutableMap<K, ?> map;
            @J2ktIncompatible
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<K, ?> immutableMap) {
                this.map = immutableMap;
            }

            Object readResolve() {
                return this.map.keySet();
            }
        }
    }

    static class BucketOverflowException
    extends Exception {
        BucketOverflowException() {
        }
    }
}

