/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.JdkBackedImmutableSet;
import com.google.common.collect.RegularImmutableAsList;
import com.google.common.collect.RegularImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.SingletonImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.math.IntMath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collector;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    static final int SPLITERATOR_CHARACTERISTICS = 1297;
    static final int MAX_TABLE_SIZE = 0x40000000;
    private static final double DESIRED_LOAD_FACTOR = 0.7;
    private static final int CUTOFF = 0x2CCCCCCC;
    private static final long serialVersionUID = -889275714L;

    public static <E> Collector<E, ?, ImmutableSet<E>> toImmutableSet() {
        return CollectCollectors.toImmutableSet();
    }

    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E e) {
        return new SingletonImmutableSet<E>(e);
    }

    public static <E> ImmutableSet<E> of(E e, E e2) {
        return new RegularSetBuilderImpl<E>(2).add(e).add(e2).review().build();
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3) {
        return new RegularSetBuilderImpl<E>(3).add(e).add(e2).add(e3).review().build();
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3, E e4) {
        return new RegularSetBuilderImpl<E>(4).add(e).add(e2).add(e3).add(e4).review().build();
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3, E e4, E e5) {
        return new RegularSetBuilderImpl<E>(5).add(e).add(e2).add(e3).add(e4).add(e5).review().build();
    }

    @SafeVarargs
    public static <E> ImmutableSet<E> of(E e, E e2, E e3, E e4, E e5, E e6, E ... EArray) {
        Preconditions.checkArgument(EArray.length <= 0x7FFFFFF9, "the total number of elements must fit in an int");
        SetBuilderImpl setBuilderImpl = new RegularSetBuilderImpl<E>(6 + EArray.length);
        setBuilderImpl = setBuilderImpl.add(e).add(e2).add(e3).add(e4).add(e5).add(e6);
        for (int i = 0; i < EArray.length; ++i) {
            setBuilderImpl = setBuilderImpl.add(EArray[i]);
        }
        return setBuilderImpl.review().build();
    }

    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> collection) {
        Object[] objectArray;
        if (collection instanceof ImmutableSet && !(collection instanceof SortedSet)) {
            objectArray = (Object[])collection;
            if (!objectArray.isPartialView()) {
                return objectArray;
            }
        } else if (collection instanceof EnumSet) {
            return ImmutableSet.copyOfEnumSet((EnumSet)collection);
        }
        if (collection.isEmpty()) {
            return ImmutableSet.of();
        }
        objectArray = collection.toArray();
        int n = collection instanceof Set ? objectArray.length : ImmutableSet.estimatedSizeForUnknownDuplication(objectArray.length);
        return ImmutableSet.fromArrayWithExpectedSize(objectArray, n);
    }

    public static <E> ImmutableSet<E> copyOf(Iterable<? extends E> iterable) {
        return iterable instanceof Collection ? ImmutableSet.copyOf((Collection)iterable) : ImmutableSet.copyOf(iterable.iterator());
    }

    public static <E> ImmutableSet<E> copyOf(Iterator<? extends E> iterator2) {
        if (!iterator2.hasNext()) {
            return ImmutableSet.of();
        }
        E e = iterator2.next();
        if (!iterator2.hasNext()) {
            return ImmutableSet.of(e);
        }
        return ((Builder)((Builder)new Builder().add((Object)e)).addAll(iterator2)).build();
    }

    public static <E> ImmutableSet<E> copyOf(E[] EArray) {
        return ImmutableSet.fromArrayWithExpectedSize(EArray, ImmutableSet.estimatedSizeForUnknownDuplication(EArray.length));
    }

    private static <E> ImmutableSet<E> fromArrayWithExpectedSize(E[] EArray, int n) {
        switch (EArray.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(EArray[0]);
            }
        }
        SetBuilderImpl setBuilderImpl = new RegularSetBuilderImpl<E>(n);
        for (int i = 0; i < EArray.length; ++i) {
            setBuilderImpl = ((SetBuilderImpl)setBuilderImpl).add(EArray[i]);
        }
        return ((SetBuilderImpl)setBuilderImpl).review().build();
    }

    private static ImmutableSet copyOfEnumSet(EnumSet<?> enumSet) {
        return ImmutableEnumSet.asImmutable(EnumSet.copyOf(enumSet));
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    @J2ktIncompatible
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> Builder<E> builderWithExpectedSize(int n) {
        CollectPreconditions.checkNonnegative(n, "expectedSize");
        return new Builder(n);
    }

    static int chooseTableSize(int n) {
        if ((n = Math.max(n, 2)) < 0x2CCCCCCC) {
            int n2 = Integer.highestOneBit(n - 1) << 1;
            while ((double)n2 * 0.7 < (double)n) {
                n2 <<= 1;
            }
            return n2;
        }
        Preconditions.checkArgument(n < 0x40000000, "collection too large");
        return 0x40000000;
    }

    private static int estimatedSizeForUnknownDuplication(int n) {
        if (n < 4) {
            return n;
        }
        return Math.max(4, IntMath.sqrt(n, RoundingMode.CEILING));
    }

    private static final class JdkBackedSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private final Set<Object> delegate;

        JdkBackedSetBuilderImpl(SetBuilderImpl<E> setBuilderImpl) {
            super(setBuilderImpl);
            this.delegate = Sets.newHashSetWithExpectedSize(this.distinct);
            for (int i = 0; i < this.distinct; ++i) {
                this.delegate.add(Objects.requireNonNull(this.dedupedElements[i]));
            }
        }

        @Override
        SetBuilderImpl<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.delegate.add(e)) {
                this.addDedupedElement(e);
            }
            return this;
        }

        @Override
        SetBuilderImpl<E> copy() {
            return new JdkBackedSetBuilderImpl<E>(this);
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(Objects.requireNonNull(this.dedupedElements[0]));
                }
            }
            return new JdkBackedImmutableSet(this.delegate, ImmutableList.asImmutableList(this.dedupedElements, this.distinct));
        }
    }

    private static final class RegularSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        @CheckForNull
        private @Nullable Object[] hashTable;
        private int maxRunBeforeFallback;
        private int expandTableThreshold;
        private int hashCode;
        static final int MAX_RUN_MULTIPLIER = 13;

        RegularSetBuilderImpl(int n) {
            super(n);
            this.hashTable = null;
            this.maxRunBeforeFallback = 0;
            this.expandTableThreshold = 0;
        }

        RegularSetBuilderImpl(RegularSetBuilderImpl<E> regularSetBuilderImpl) {
            super(regularSetBuilderImpl);
            this.hashTable = regularSetBuilderImpl.hashTable == null ? null : (Object[])regularSetBuilderImpl.hashTable.clone();
            this.maxRunBeforeFallback = regularSetBuilderImpl.maxRunBeforeFallback;
            this.expandTableThreshold = regularSetBuilderImpl.expandTableThreshold;
            this.hashCode = regularSetBuilderImpl.hashCode;
        }

        @Override
        SetBuilderImpl<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.hashTable == null) {
                if (this.distinct == 0) {
                    this.addDedupedElement(e);
                    return this;
                }
                this.ensureTableCapacity(this.dedupedElements.length);
                Object object = this.dedupedElements[0];
                --this.distinct;
                return this.insertInHashTable(object).add(e);
            }
            return this.insertInHashTable(e);
        }

        private SetBuilderImpl<E> insertInHashTable(E e) {
            Objects.requireNonNull(this.hashTable);
            int n = e.hashCode();
            int n2 = Hashing.smear(n);
            int n3 = this.hashTable.length - 1;
            int n4 = n2;
            while (n4 - n2 < this.maxRunBeforeFallback) {
                int n5 = n4 & n3;
                Object object = this.hashTable[n5];
                if (object == null) {
                    this.addDedupedElement(e);
                    this.hashTable[n5] = e;
                    this.hashCode += n;
                    this.ensureTableCapacity(this.distinct);
                    return this;
                }
                if (object.equals(e)) {
                    return this;
                }
                ++n4;
            }
            return new JdkBackedSetBuilderImpl<E>(this).add(e);
        }

        @Override
        SetBuilderImpl<E> copy() {
            return new RegularSetBuilderImpl<E>(this);
        }

        @Override
        SetBuilderImpl<E> review() {
            if (this.hashTable == null) {
                return this;
            }
            int n = ImmutableSet.chooseTableSize(this.distinct);
            if (n * 2 < this.hashTable.length) {
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(n, this.dedupedElements, this.distinct);
                this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(n);
                this.expandTableThreshold = (int)(0.7 * (double)n);
            }
            return RegularSetBuilderImpl.hashFloodingDetected(this.hashTable) ? new JdkBackedSetBuilderImpl(this) : this;
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(Objects.requireNonNull(this.dedupedElements[0]));
                }
            }
            Object[] objectArray = this.distinct == this.dedupedElements.length ? this.dedupedElements : Arrays.copyOf(this.dedupedElements, this.distinct);
            return new RegularImmutableSet(objectArray, this.hashCode, Objects.requireNonNull(this.hashTable), this.hashTable.length - 1);
        }

        static @Nullable Object[] rebuildHashTable(int n, Object[] objectArray, int n2) {
            @Nullable Object[] objectArray2 = new Object[n];
            int n3 = objectArray2.length - 1;
            for (int i = 0; i < n2; ++i) {
                int n4;
                Object object = Objects.requireNonNull(objectArray[i]);
                int n5 = n4 = Hashing.smear(object.hashCode());
                while (true) {
                    int n6;
                    if (objectArray2[n6 = n5 & n3] == null) break;
                    ++n5;
                }
                objectArray2[n6] = object;
            }
            return objectArray2;
        }

        void ensureTableCapacity(int n) {
            int n2;
            if (this.hashTable == null) {
                n2 = ImmutableSet.chooseTableSize(n);
                this.hashTable = new Object[n2];
            } else if (n > this.expandTableThreshold && this.hashTable.length < 0x40000000) {
                n2 = this.hashTable.length * 2;
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(n2, this.dedupedElements, this.distinct);
            } else {
                return;
            }
            this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(n2);
            this.expandTableThreshold = (int)(0.7 * (double)n2);
        }

        static boolean hashFloodingDetected(@Nullable Object[] objectArray) {
            int n = RegularSetBuilderImpl.maxRunBeforeFallback(objectArray.length);
            int n2 = objectArray.length - 1;
            int n3 = 0;
            int n4 = 0;
            block0: while (n3 < objectArray.length) {
                if (n3 == n4 && objectArray[n3] == null) {
                    if (objectArray[n3 + n - 1 & n2] == null) {
                        n3 += n;
                    }
                    n4 = ++n3;
                    continue;
                }
                for (int i = n3 + n - 1; i >= n4; --i) {
                    if (objectArray[i & n2] != null) continue;
                    n4 = n3 + n;
                    n3 = i + 1;
                    continue block0;
                }
                return true;
            }
            return false;
        }

        static int maxRunBeforeFallback(int n) {
            return 13 * IntMath.log2(n, RoundingMode.UNNECESSARY);
        }
    }

    private static final class EmptySetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private static final EmptySetBuilderImpl<Object> INSTANCE = new EmptySetBuilderImpl();

        static <E> SetBuilderImpl<E> instance() {
            return INSTANCE;
        }

        private EmptySetBuilderImpl() {
            super(0);
        }

        @Override
        SetBuilderImpl<E> add(E e) {
            return new RegularSetBuilderImpl<E>(4).add(e);
        }

        @Override
        SetBuilderImpl<E> copy() {
            return this;
        }

        @Override
        ImmutableSet<E> build() {
            return ImmutableSet.of();
        }
    }

    private static abstract class SetBuilderImpl<E> {
        E[] dedupedElements;
        int distinct;

        SetBuilderImpl(int n) {
            this.dedupedElements = new Object[n];
            this.distinct = 0;
        }

        SetBuilderImpl(SetBuilderImpl<E> setBuilderImpl) {
            this.dedupedElements = Arrays.copyOf(setBuilderImpl.dedupedElements, setBuilderImpl.dedupedElements.length);
            this.distinct = setBuilderImpl.distinct;
        }

        private void ensureCapacity(int n) {
            if (n > this.dedupedElements.length) {
                int n2 = ImmutableCollection.Builder.expandedCapacity(this.dedupedElements.length, n);
                this.dedupedElements = Arrays.copyOf(this.dedupedElements, n2);
            }
        }

        final void addDedupedElement(E e) {
            this.ensureCapacity(this.distinct + 1);
            this.dedupedElements[this.distinct++] = e;
        }

        abstract SetBuilderImpl<E> add(E var1);

        final SetBuilderImpl<E> combine(SetBuilderImpl<E> setBuilderImpl) {
            SetBuilderImpl<E> setBuilderImpl2 = this;
            for (int i = 0; i < setBuilderImpl.distinct; ++i) {
                setBuilderImpl2 = setBuilderImpl2.add(Objects.requireNonNull(setBuilderImpl.dedupedElements[i]));
            }
            return setBuilderImpl2;
        }

        abstract SetBuilderImpl<E> copy();

        SetBuilderImpl<E> review() {
            return this;
        }

        abstract ImmutableSet<E> build();
    }

    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        @CheckForNull
        private SetBuilderImpl<E> impl;
        boolean forceCopy;

        public Builder() {
            this(0);
        }

        Builder(int n) {
            this.impl = n > 0 ? new RegularSetBuilderImpl(n) : EmptySetBuilderImpl.instance();
        }

        Builder(boolean bl) {
            this.impl = null;
        }

        @VisibleForTesting
        void forceJdk() {
            Objects.requireNonNull(this.impl);
            this.impl = new JdkBackedSetBuilderImpl<E>(this.impl);
        }

        final void copyIfNecessary() {
            if (this.forceCopy) {
                this.copy();
                this.forceCopy = false;
            }
        }

        void copy() {
            Objects.requireNonNull(this.impl);
            this.impl = this.impl.copy();
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E e) {
            Objects.requireNonNull(this.impl);
            Preconditions.checkNotNull(e);
            this.copyIfNecessary();
            this.impl = this.impl.add(e);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E ... EArray) {
            super.add(EArray);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            super.addAll(iterable);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> iterator2) {
            super.addAll(iterator2);
            return this;
        }

        @CanIgnoreReturnValue
        Builder<E> combine(Builder<E> builder) {
            Objects.requireNonNull(this.impl);
            Objects.requireNonNull(builder.impl);
            this.copyIfNecessary();
            this.impl = this.impl.combine(builder.impl);
            return this;
        }

        @Override
        public ImmutableSet<E> build() {
            Objects.requireNonNull(this.impl);
            this.forceCopy = true;
            this.impl = this.impl.review();
            return this.impl.build();
        }
    }

    @J2ktIncompatible
    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }
    }

    static abstract class Indexed<E>
    extends CachingAsList<E> {
        Indexed() {
        }

        abstract E get(int var1);

        @Override
        public UnmodifiableIterator<E> iterator() {
            return this.asList().iterator();
        }

        @Override
        public Spliterator<E> spliterator() {
            return CollectSpliterators.indexed(this.size(), 1297, this::get);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            Preconditions.checkNotNull(consumer);
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                consumer.accept(this.get(i));
            }
        }

        @Override
        int copyIntoArray(@Nullable Object[] objectArray, int n) {
            return this.asList().copyIntoArray(objectArray, n);
        }

        @Override
        ImmutableList<E> createAsList() {
            return new ImmutableAsList<E>(){

                @Override
                public E get(int n) {
                    return this.get(n);
                }

                @Override
                Indexed<E> delegateCollection() {
                    return this;
                }

                @Override
                @J2ktIncompatible
                @GwtIncompatible
                Object writeReplace() {
                    return super.writeReplace();
                }
            };
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }
    }

    @GwtCompatible
    static abstract class CachingAsList<E>
    extends ImmutableSet<E> {
        @LazyInit
        @CheckForNull
        @RetainedWith
        private transient ImmutableList<E> asList;

        CachingAsList() {
        }

        @Override
        public ImmutableList<E> asList() {
            ImmutableList<E> immutableList = this.asList;
            if (immutableList == null) {
                this.asList = this.createAsList();
                return this.asList;
            }
            return immutableList;
        }

        ImmutableList<E> createAsList() {
            return new RegularImmutableAsList(this, this.toArray());
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }
    }
}

