/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Range;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class GeneralRange<T>
implements Serializable {
    private final Comparator<? super T> comparator;
    private final boolean hasLowerBound;
    @CheckForNull
    private final T lowerEndpoint;
    private final BoundType lowerBoundType;
    private final boolean hasUpperBound;
    @CheckForNull
    private final T upperEndpoint;
    private final BoundType upperBoundType;
    @LazyInit
    @CheckForNull
    private transient GeneralRange<T> reverse;

    static <T extends Comparable> GeneralRange<T> from(Range<T> range) {
        T t2 = range.hasLowerBound() ? (T)range.lowerEndpoint() : null;
        BoundType boundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.OPEN;
        T t3 = range.hasUpperBound() ? (T)range.upperEndpoint() : null;
        BoundType boundType2 = range.hasUpperBound() ? range.upperBoundType() : BoundType.OPEN;
        return new GeneralRange<Object>(Ordering.natural(), range.hasLowerBound(), t2, boundType, range.hasUpperBound(), t3, boundType2);
    }

    static <T> GeneralRange<T> all(Comparator<? super T> comparator) {
        return new GeneralRange<Object>(comparator, false, null, BoundType.OPEN, false, null, BoundType.OPEN);
    }

    static <T> GeneralRange<T> downTo(Comparator<? super T> comparator, @ParametricNullness T t2, BoundType boundType) {
        return new GeneralRange<Object>((Comparator<Object>)comparator, true, t2, boundType, false, null, BoundType.OPEN);
    }

    static <T> GeneralRange<T> upTo(Comparator<? super T> comparator, @ParametricNullness T t2, BoundType boundType) {
        return new GeneralRange<Object>((Comparator<Object>)comparator, false, null, BoundType.OPEN, true, t2, boundType);
    }

    static <T> GeneralRange<T> range(Comparator<? super T> comparator, @ParametricNullness T t2, BoundType boundType, @ParametricNullness T t3, BoundType boundType2) {
        return new GeneralRange<T>(comparator, true, t2, boundType, true, t3, boundType2);
    }

    private GeneralRange(Comparator<? super T> comparator, boolean bl, @CheckForNull T t2, BoundType boundType, boolean bl2, @CheckForNull T t3, BoundType boundType2) {
        int n;
        this.comparator = Preconditions.checkNotNull(comparator);
        this.hasLowerBound = bl;
        this.hasUpperBound = bl2;
        this.lowerEndpoint = t2;
        this.lowerBoundType = Preconditions.checkNotNull(boundType);
        this.upperEndpoint = t3;
        this.upperBoundType = Preconditions.checkNotNull(boundType2);
        if (bl) {
            n = comparator.compare(NullnessCasts.uncheckedCastNullableTToT(t2), NullnessCasts.uncheckedCastNullableTToT(t2));
        }
        if (bl2) {
            n = comparator.compare(NullnessCasts.uncheckedCastNullableTToT(t3), NullnessCasts.uncheckedCastNullableTToT(t3));
        }
        if (bl && bl2) {
            n = comparator.compare(NullnessCasts.uncheckedCastNullableTToT(t2), NullnessCasts.uncheckedCastNullableTToT(t3));
            Preconditions.checkArgument(n <= 0, "lowerEndpoint (%s) > upperEndpoint (%s)", t2, t3);
            if (n == 0) {
                Preconditions.checkArgument(boundType != BoundType.OPEN || boundType2 != BoundType.OPEN);
            }
        }
    }

    Comparator<? super T> comparator() {
        return this.comparator;
    }

    boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    boolean isEmpty() {
        return this.hasUpperBound() && this.tooLow(NullnessCasts.uncheckedCastNullableTToT(this.getUpperEndpoint())) || this.hasLowerBound() && this.tooHigh(NullnessCasts.uncheckedCastNullableTToT(this.getLowerEndpoint()));
    }

    boolean tooLow(@ParametricNullness T t2) {
        if (!this.hasLowerBound()) {
            return false;
        }
        T t3 = NullnessCasts.uncheckedCastNullableTToT(this.getLowerEndpoint());
        int n = this.comparator.compare(t2, t3);
        return n < 0 | n == 0 & this.getLowerBoundType() == BoundType.OPEN;
    }

    boolean tooHigh(@ParametricNullness T t2) {
        if (!this.hasUpperBound()) {
            return false;
        }
        T t3 = NullnessCasts.uncheckedCastNullableTToT(this.getUpperEndpoint());
        int n = this.comparator.compare(t2, t3);
        return n > 0 | n == 0 & this.getUpperBoundType() == BoundType.OPEN;
    }

    boolean contains(@ParametricNullness T t2) {
        return !this.tooLow(t2) && !this.tooHigh(t2);
    }

    GeneralRange<T> intersect(GeneralRange<T> generalRange) {
        int n;
        boolean bl;
        Preconditions.checkNotNull(generalRange);
        Preconditions.checkArgument(this.comparator.equals(generalRange.comparator));
        boolean bl2 = this.hasLowerBound;
        T t2 = this.getLowerEndpoint();
        BoundType boundType = this.getLowerBoundType();
        if (!this.hasLowerBound()) {
            bl2 = generalRange.hasLowerBound;
            t2 = generalRange.getLowerEndpoint();
            boundType = generalRange.getLowerBoundType();
        } else if (generalRange.hasLowerBound() && ((bl = this.comparator.compare(this.getLowerEndpoint(), generalRange.getLowerEndpoint())) < false || !bl && generalRange.getLowerBoundType() == BoundType.OPEN)) {
            t2 = generalRange.getLowerEndpoint();
            boundType = generalRange.getLowerBoundType();
        }
        bl = this.hasUpperBound;
        T t3 = this.getUpperEndpoint();
        BoundType boundType2 = this.getUpperBoundType();
        if (!this.hasUpperBound()) {
            bl = generalRange.hasUpperBound;
            t3 = generalRange.getUpperEndpoint();
            boundType2 = generalRange.getUpperBoundType();
        } else if (generalRange.hasUpperBound() && ((n = this.comparator.compare(this.getUpperEndpoint(), generalRange.getUpperEndpoint())) > 0 || n == 0 && generalRange.getUpperBoundType() == BoundType.OPEN)) {
            t3 = generalRange.getUpperEndpoint();
            boundType2 = generalRange.getUpperBoundType();
        }
        if (bl2 && bl && ((n = this.comparator.compare(t2, t3)) > 0 || n == 0 && boundType == BoundType.OPEN && boundType2 == BoundType.OPEN)) {
            t2 = t3;
            boundType = BoundType.OPEN;
            boundType2 = BoundType.CLOSED;
        }
        return new GeneralRange<T>(this.comparator, bl2, t2, boundType, bl, t3, boundType2);
    }

    public boolean equals(@CheckForNull Object object) {
        if (object instanceof GeneralRange) {
            GeneralRange generalRange = (GeneralRange)object;
            return this.comparator.equals(generalRange.comparator) && this.hasLowerBound == generalRange.hasLowerBound && this.hasUpperBound == generalRange.hasUpperBound && this.getLowerBoundType().equals((Object)generalRange.getLowerBoundType()) && this.getUpperBoundType().equals((Object)generalRange.getUpperBoundType()) && Objects.equal(this.getLowerEndpoint(), generalRange.getLowerEndpoint()) && Objects.equal(this.getUpperEndpoint(), generalRange.getUpperEndpoint());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.comparator, this.getLowerEndpoint(), this.getLowerBoundType(), this.getUpperEndpoint(), this.getUpperBoundType()});
    }

    GeneralRange<T> reverse() {
        GeneralRange<Object> generalRange = this.reverse;
        if (generalRange == null) {
            generalRange = new GeneralRange(Ordering.from(this.comparator).reverse(), this.hasUpperBound, this.getUpperEndpoint(), this.getUpperBoundType(), this.hasLowerBound, this.getLowerEndpoint(), this.getLowerBoundType());
            generalRange.reverse = this;
            this.reverse = generalRange;
            return this.reverse;
        }
        return generalRange;
    }

    public String toString() {
        return this.comparator + ":" + (this.lowerBoundType == BoundType.CLOSED ? (char)'[' : '(') + (this.hasLowerBound ? this.lowerEndpoint : "-\u221e") + ',' + (this.hasUpperBound ? this.upperEndpoint : "\u221e") + (this.upperBoundType == BoundType.CLOSED ? (char)']' : ')');
    }

    @CheckForNull
    T getLowerEndpoint() {
        return this.lowerEndpoint;
    }

    BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    @CheckForNull
    T getUpperEndpoint() {
        return this.upperEndpoint;
    }

    BoundType getUpperBoundType() {
        return this.upperBoundType;
    }
}

