/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingSortedMap<K, V>
extends ForwardingMap<K, V>
implements SortedMap<K, V> {
    protected ForwardingSortedMap() {
    }

    @Override
    protected abstract SortedMap<K, V> delegate();

    @Override
    @CheckForNull
    public Comparator<? super K> comparator() {
        return this.delegate().comparator();
    }

    @Override
    @ParametricNullness
    public K firstKey() {
        return this.delegate().firstKey();
    }

    @Override
    public SortedMap<K, V> headMap(@ParametricNullness K k) {
        return this.delegate().headMap(k);
    }

    @Override
    @ParametricNullness
    public K lastKey() {
        return this.delegate().lastKey();
    }

    @Override
    public SortedMap<K, V> subMap(@ParametricNullness K k, @ParametricNullness K k2) {
        return this.delegate().subMap(k, k2);
    }

    @Override
    public SortedMap<K, V> tailMap(@ParametricNullness K k) {
        return this.delegate().tailMap(k);
    }

    static int unsafeCompare(@CheckForNull Comparator<?> comparator, @CheckForNull Object object, @CheckForNull Object object2) {
        if (comparator == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return comparator.compare(object, object2);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected boolean standardContainsKey(@CheckForNull Object object) {
        try {
            @Nullable ForwardingSortedMap forwardingSortedMap = this;
            Object object2 = forwardingSortedMap.tailMap(object).firstKey();
            return ForwardingSortedMap.unsafeCompare(this.comparator(), object2, object) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException runtimeException) {
            return false;
        }
    }

    protected SortedMap<K, V> standardSubMap(K k, K k2) {
        Preconditions.checkArgument(ForwardingSortedMap.unsafeCompare(this.comparator(), k, k2) <= 0, "fromKey must be <= toKey");
        return this.tailMap(k).headMap(k2);
    }

    protected class StandardKeySet
    extends Maps.SortedKeySet<K, V> {
        public StandardKeySet(ForwardingSortedMap forwardingSortedMap) {
            super(forwardingSortedMap);
        }
    }
}

