/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class CompactHashing {
    static final byte UNSET = 0;
    private static final int HASH_TABLE_BITS_MAX_BITS = 5;
    static final int MODIFICATION_COUNT_INCREMENT = 32;
    static final int HASH_TABLE_BITS_MASK = 31;
    static final int MAX_SIZE = 0x3FFFFFFF;
    static final int DEFAULT_SIZE = 3;
    private static final int MIN_HASH_TABLE_SIZE = 4;
    private static final int BYTE_MAX_SIZE = 256;
    private static final int BYTE_MASK = 255;
    private static final int SHORT_MAX_SIZE = 65536;
    private static final int SHORT_MASK = 65535;

    private CompactHashing() {
    }

    static int tableSize(int n) {
        return Math.max(4, Hashing.closedTableSize(n + 1, 1.0));
    }

    static Object createTable(int n) {
        if (n < 2 || n > 0x40000000 || Integer.highestOneBit(n) != n) {
            throw new IllegalArgumentException("must be power of 2 between 2^1 and 2^30: " + n);
        }
        if (n <= 256) {
            return new byte[n];
        }
        if (n <= 65536) {
            return new short[n];
        }
        return new int[n];
    }

    static void tableClear(Object object) {
        if (object instanceof byte[]) {
            Arrays.fill((byte[])object, (byte)0);
        } else if (object instanceof short[]) {
            Arrays.fill((short[])object, (short)0);
        } else {
            Arrays.fill((int[])object, 0);
        }
    }

    static int tableGet(Object object, int n) {
        if (object instanceof byte[]) {
            return ((byte[])object)[n] & 0xFF;
        }
        if (object instanceof short[]) {
            return ((short[])object)[n] & 0xFFFF;
        }
        return ((int[])object)[n];
    }

    static void tableSet(Object object, int n, int n2) {
        if (object instanceof byte[]) {
            ((byte[])object)[n] = (byte)n2;
        } else if (object instanceof short[]) {
            ((short[])object)[n] = (short)n2;
        } else {
            ((int[])object)[n] = n2;
        }
    }

    static int newCapacity(int n) {
        return (n < 32 ? 4 : 2) * (n + 1);
    }

    static int getHashPrefix(int n, int n2) {
        return n & ~n2;
    }

    static int getNext(int n, int n2) {
        return n & n2;
    }

    static int maskCombine(int n, int n2, int n3) {
        return n & ~n3 | n2 & n3;
    }

    static int remove(@CheckForNull Object object, @CheckForNull Object object2, int n, Object object3, int[] nArray, @Nullable Object[] objectArray, @CheckForNull @Nullable Object[] objectArray2) {
        int n2;
        int n3 = Hashing.smearedHash(object);
        int n4 = n3 & n;
        int n5 = CompactHashing.tableGet(object3, n4);
        if (n5 == 0) {
            return -1;
        }
        int n6 = CompactHashing.getHashPrefix(n3, n);
        int n7 = -1;
        do {
            int n8;
            if (CompactHashing.getHashPrefix(n2 = nArray[n8 = n5 - 1], n) == n6 && Objects.equal(object, objectArray[n8]) && (objectArray2 == null || Objects.equal(object2, objectArray2[n8]))) {
                int n9 = CompactHashing.getNext(n2, n);
                if (n7 == -1) {
                    CompactHashing.tableSet(object3, n4, n9);
                } else {
                    nArray[n7] = CompactHashing.maskCombine(nArray[n7], n9, n);
                }
                return n8;
            }
            n7 = n8;
        } while ((n5 = CompactHashing.getNext(n2, n)) != 0);
        return -1;
    }
}

