/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CompactHashing;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.ParametricNullness;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactHashSet<E>
extends AbstractSet<E>
implements Serializable {
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    private static final int MAX_HASH_BUCKET_LENGTH = 9;
    @CheckForNull
    private transient Object table;
    @CheckForNull
    private transient int[] entries;
    @CheckForNull
    @VisibleForTesting
    transient @Nullable Object[] elements;
    private transient int metadata;
    private transient int size;

    public static <E> CompactHashSet<E> create() {
        return new CompactHashSet<E>();
    }

    public static <E> CompactHashSet<E> create(Collection<? extends E> collection) {
        CompactHashSet<E> compactHashSet = CompactHashSet.createWithExpectedSize(collection.size());
        compactHashSet.addAll(collection);
        return compactHashSet;
    }

    @SafeVarargs
    public static <E> CompactHashSet<E> create(E ... EArray) {
        CompactHashSet<E> compactHashSet = CompactHashSet.createWithExpectedSize(EArray.length);
        Collections.addAll(compactHashSet, EArray);
        return compactHashSet;
    }

    public static <E> CompactHashSet<E> createWithExpectedSize(int n) {
        return new CompactHashSet<E>(n);
    }

    CompactHashSet() {
        this.init(3);
    }

    CompactHashSet(int n) {
        this.init(n);
    }

    void init(int n) {
        Preconditions.checkArgument(n >= 0, "Expected size must be >= 0");
        this.metadata = Ints.constrainToRange(n, 1, 0x3FFFFFFF);
    }

    @VisibleForTesting
    boolean needsAllocArrays() {
        return this.table == null;
    }

    @CanIgnoreReturnValue
    int allocArrays() {
        Preconditions.checkState(this.needsAllocArrays(), "Arrays already allocated");
        int n = this.metadata;
        int n2 = CompactHashing.tableSize(n);
        this.table = CompactHashing.createTable(n2);
        this.setHashTableMask(n2 - 1);
        this.entries = new int[n];
        this.elements = new Object[n];
        return n;
    }

    @CheckForNull
    @VisibleForTesting
    Set<E> delegateOrNull() {
        if (this.table instanceof Set) {
            return (Set)this.table;
        }
        return null;
    }

    private Set<E> createHashFloodingResistantDelegate(int n) {
        return new LinkedHashSet(n, 1.0f);
    }

    @VisibleForTesting
    @CanIgnoreReturnValue
    Set<E> convertToHashFloodingResistantImplementation() {
        Set<E> set = this.createHashFloodingResistantDelegate(this.hashTableMask() + 1);
        int n = this.firstEntryIndex();
        while (n >= 0) {
            set.add(this.element(n));
            n = this.getSuccessor(n);
        }
        this.table = set;
        this.entries = null;
        this.elements = null;
        this.incrementModCount();
        return set;
    }

    @VisibleForTesting
    boolean isUsingHashFloodingResistance() {
        return this.delegateOrNull() != null;
    }

    private void setHashTableMask(int n) {
        int n2 = 32 - Integer.numberOfLeadingZeros(n);
        this.metadata = CompactHashing.maskCombine(this.metadata, n2, 31);
    }

    private int hashTableMask() {
        return (1 << (this.metadata & 0x1F)) - 1;
    }

    void incrementModCount() {
        this.metadata += 32;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean add(@ParametricNullness E e) {
        Set<E> set;
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        if ((set = this.delegateOrNull()) != null) {
            return set.add(e);
        }
        int[] nArray = this.requireEntries();
        @Nullable Object[] objectArray = this.requireElements();
        int n = this.size;
        int n2 = n + 1;
        int n3 = Hashing.smearedHash(e);
        int n4 = this.hashTableMask();
        int n5 = n3 & n4;
        int n6 = CompactHashing.tableGet(this.requireTable(), n5);
        if (n6 == 0) {
            if (n2 > n4) {
                n4 = this.resizeTable(n4, CompactHashing.newCapacity(n4), n3, n);
            } else {
                CompactHashing.tableSet(this.requireTable(), n5, n + 1);
            }
        } else {
            int n7;
            int n8 = CompactHashing.getHashPrefix(n3, n4);
            int n9 = 0;
            do {
                int n10;
                if (CompactHashing.getHashPrefix(n7 = nArray[n10 = n6 - 1], n4) == n8 && com.google.common.base.Objects.equal(e, objectArray[n10])) {
                    return false;
                }
                n6 = CompactHashing.getNext(n7, n4);
                ++n9;
            } while (n6 != 0);
            if (n9 >= 9) {
                return this.convertToHashFloodingResistantImplementation().add(e);
            }
            if (n2 > n4) {
                n4 = this.resizeTable(n4, CompactHashing.newCapacity(n4), n3, n);
            } else {
                nArray[n10] = CompactHashing.maskCombine(n7, n + 1, n4);
            }
        }
        this.resizeMeMaybe(n2);
        this.insertEntry(n, e, n3, n4);
        this.size = n2;
        this.incrementModCount();
        return true;
    }

    void insertEntry(int n, @ParametricNullness E e, int n2, int n3) {
        this.setEntry(n, CompactHashing.maskCombine(n2, 0, n3));
        this.setElement(n, e);
    }

    private void resizeMeMaybe(int n) {
        int n2;
        int n3 = this.requireEntries().length;
        if (n > n3 && (n2 = Math.min(0x3FFFFFFF, n3 + Math.max(1, n3 >>> 1) | 1)) != n3) {
            this.resizeEntries(n2);
        }
    }

    void resizeEntries(int n) {
        this.entries = Arrays.copyOf(this.requireEntries(), n);
        this.elements = Arrays.copyOf(this.requireElements(), n);
    }

    @CanIgnoreReturnValue
    private int resizeTable(int n, int n2, int n3, int n4) {
        Object object = CompactHashing.createTable(n2);
        int n5 = n2 - 1;
        if (n4 != 0) {
            CompactHashing.tableSet(object, n3 & n5, n4 + 1);
        }
        Object object2 = this.requireTable();
        int[] nArray = this.requireEntries();
        for (int i = 0; i <= n; ++i) {
            int n6 = CompactHashing.tableGet(object2, i);
            while (n6 != 0) {
                int n7 = n6 - 1;
                int n8 = nArray[n7];
                int n9 = CompactHashing.getHashPrefix(n8, n) | i;
                int n10 = n9 & n5;
                int n11 = CompactHashing.tableGet(object, n10);
                CompactHashing.tableSet(object, n10, n6);
                nArray[n7] = CompactHashing.maskCombine(n9, n11, n5);
                n6 = CompactHashing.getNext(n8, n);
            }
        }
        this.table = object;
        this.setHashTableMask(n5);
        return n5;
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        int n;
        if (this.needsAllocArrays()) {
            return false;
        }
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            return set.contains(object);
        }
        int n2 = Hashing.smearedHash(object);
        int n3 = this.hashTableMask();
        int n4 = CompactHashing.tableGet(this.requireTable(), n2 & n3);
        if (n4 == 0) {
            return false;
        }
        int n5 = CompactHashing.getHashPrefix(n2, n3);
        do {
            int n6;
            if (CompactHashing.getHashPrefix(n = this.entry(n6 = n4 - 1), n3) != n5 || !com.google.common.base.Objects.equal(object, this.element(n6))) continue;
            return true;
        } while ((n4 = CompactHashing.getNext(n, n3)) != 0);
        return false;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean remove(@CheckForNull Object object) {
        if (this.needsAllocArrays()) {
            return false;
        }
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            return set.remove(object);
        }
        int n = this.hashTableMask();
        int n2 = CompactHashing.remove(object, null, n, this.requireTable(), this.requireEntries(), this.requireElements(), null);
        if (n2 == -1) {
            return false;
        }
        this.moveLastEntry(n2, n);
        --this.size;
        this.incrementModCount();
        return true;
    }

    void moveLastEntry(int n, int n2) {
        Object object = this.requireTable();
        int[] nArray = this.requireEntries();
        @Nullable Object[] objectArray = this.requireElements();
        int n3 = this.size() - 1;
        if (n < n3) {
            int n4;
            Object object2;
            objectArray[n] = object2 = objectArray[n3];
            objectArray[n3] = null;
            nArray[n] = nArray[n3];
            nArray[n3] = 0;
            int n5 = Hashing.smearedHash(object2) & n2;
            int n6 = CompactHashing.tableGet(object, n5);
            if (n6 == (n4 = n3 + 1)) {
                CompactHashing.tableSet(object, n5, n + 1);
            } else {
                int n7;
                int n8;
                while ((n6 = CompactHashing.getNext(n8 = nArray[n7 = n6 - 1], n2)) != n4) {
                }
                nArray[n7] = CompactHashing.maskCombine(n8, n + 1, n2);
            }
        } else {
            objectArray[n] = null;
            nArray[n] = 0;
        }
    }

    int firstEntryIndex() {
        return this.isEmpty() ? -1 : 0;
    }

    int getSuccessor(int n) {
        return n + 1 < this.size ? n + 1 : -1;
    }

    int adjustAfterRemove(int n, int n2) {
        return n - 1;
    }

    @Override
    public Iterator<E> iterator() {
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            return set.iterator();
        }
        return new Iterator<E>(){
            int expectedMetadata;
            int currentIndex;
            int indexToRemove;
            {
                this.expectedMetadata = CompactHashSet.this.metadata;
                this.currentIndex = CompactHashSet.this.firstEntryIndex();
                this.indexToRemove = -1;
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex >= 0;
            }

            @Override
            @ParametricNullness
            public E next() {
                this.checkForConcurrentModification();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.indexToRemove = this.currentIndex;
                Object object = CompactHashSet.this.element(this.currentIndex);
                this.currentIndex = CompactHashSet.this.getSuccessor(this.currentIndex);
                return object;
            }

            @Override
            public void remove() {
                this.checkForConcurrentModification();
                CollectPreconditions.checkRemove(this.indexToRemove >= 0);
                this.incrementExpectedModCount();
                CompactHashSet.this.remove(CompactHashSet.this.element(this.indexToRemove));
                this.currentIndex = CompactHashSet.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
                this.indexToRemove = -1;
            }

            void incrementExpectedModCount() {
                this.expectedMetadata += 32;
            }

            private void checkForConcurrentModification() {
                if (CompactHashSet.this.metadata != this.expectedMetadata) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public Spliterator<E> spliterator() {
        if (this.needsAllocArrays()) {
            return Spliterators.spliterator(new Object[0], 17);
        }
        Set<E> set = this.delegateOrNull();
        return set != null ? set.spliterator() : Spliterators.spliterator(this.requireElements(), 0, this.size, 17);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            set.forEach(consumer);
        } else {
            int n = this.firstEntryIndex();
            while (n >= 0) {
                consumer.accept(this.element(n));
                n = this.getSuccessor(n);
            }
        }
    }

    @Override
    public int size() {
        Set<E> set = this.delegateOrNull();
        return set != null ? set.size() : this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public @Nullable Object[] toArray() {
        if (this.needsAllocArrays()) {
            return new Object[0];
        }
        Set<E> set = this.delegateOrNull();
        return set != null ? set.toArray() : Arrays.copyOf(this.requireElements(), this.size);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> T[] toArray(T[] TArray) {
        if (this.needsAllocArrays()) {
            if (TArray.length > 0) {
                TArray[0] = null;
            }
            return TArray;
        }
        Set<E> set = this.delegateOrNull();
        return set != null ? set.toArray(TArray) : ObjectArrays.toArrayImpl(this.requireElements(), 0, this.size, TArray);
    }

    public void trimToSize() {
        int n;
        int n2;
        if (this.needsAllocArrays()) {
            return;
        }
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            Set<E> set2 = this.createHashFloodingResistantDelegate(this.size());
            set2.addAll(set);
            this.table = set2;
            return;
        }
        int n3 = this.size;
        if (n3 < this.requireEntries().length) {
            this.resizeEntries(n3);
        }
        if ((n2 = CompactHashing.tableSize(n3)) < (n = this.hashTableMask())) {
            this.resizeTable(n, n2, 0, 0);
        }
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.incrementModCount();
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            this.metadata = Ints.constrainToRange(this.size(), 3, 0x3FFFFFFF);
            set.clear();
            this.table = null;
            this.size = 0;
        } else {
            Arrays.fill(this.requireElements(), 0, this.size, null);
            CompactHashing.tableClear(this.requireTable());
            Arrays.fill(this.requireEntries(), 0, this.size, 0);
            this.size = 0;
        }
    }

    @J2ktIncompatible
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        for (E e : this) {
            objectOutputStream.writeObject(e);
        }
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n < 0) {
            throw new InvalidObjectException("Invalid size: " + n);
        }
        this.init(n);
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            this.add(object);
        }
    }

    private Object requireTable() {
        return Objects.requireNonNull(this.table);
    }

    private int[] requireEntries() {
        return Objects.requireNonNull(this.entries);
    }

    private @Nullable Object[] requireElements() {
        return Objects.requireNonNull(this.elements);
    }

    private E element(int n) {
        return (E)this.requireElements()[n];
    }

    private int entry(int n) {
        return this.requireEntries()[n];
    }

    private void setElement(int n, E e) {
        this.requireElements()[n] = e;
    }

    private void setEntry(int n, int n2) {
        this.requireEntries()[n] = n2;
    }
}

