/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.cbor;

import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;

public class CBORFactoryBuilder
extends TSFBuilder<CBORFactory, CBORFactoryBuilder> {
    protected int _formatParserFeatures;
    protected int _formatGeneratorFeatures;

    protected CBORFactoryBuilder() {
        this._formatParserFeatures = CBORFactory.DEFAULT_CBOR_PARSER_FEATURE_FLAGS;
        this._formatGeneratorFeatures = CBORFactory.DEFAULT_CBOR_GENERATOR_FEATURE_FLAGS;
    }

    public CBORFactoryBuilder(CBORFactory cBORFactory) {
        super(cBORFactory);
        this._formatParserFeatures = cBORFactory._formatParserFeatures;
        this._formatGeneratorFeatures = cBORFactory._formatGeneratorFeatures;
    }

    public CBORFactoryBuilder enable(CBORParser.Feature feature) {
        this._formatParserFeatures |= feature.getMask();
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder enable(CBORParser.Feature feature, CBORParser.Feature ... featureArray) {
        this._formatParserFeatures |= feature.getMask();
        for (CBORParser.Feature feature2 : featureArray) {
            this._formatParserFeatures |= feature2.getMask();
        }
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder disable(CBORParser.Feature feature) {
        this._formatParserFeatures &= ~feature.getMask();
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder disable(CBORParser.Feature feature, CBORParser.Feature ... featureArray) {
        this._formatParserFeatures &= ~feature.getMask();
        for (CBORParser.Feature feature2 : featureArray) {
            this._formatParserFeatures &= ~feature2.getMask();
        }
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder configure(CBORParser.Feature feature, boolean bl) {
        return bl ? this.enable(feature) : this.disable(feature);
    }

    public CBORFactoryBuilder enable(CBORGenerator.Feature feature) {
        this._formatGeneratorFeatures |= feature.getMask();
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder enable(CBORGenerator.Feature feature, CBORGenerator.Feature ... featureArray) {
        this._formatGeneratorFeatures |= feature.getMask();
        for (CBORGenerator.Feature feature2 : featureArray) {
            this._formatGeneratorFeatures |= feature2.getMask();
        }
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder disable(CBORGenerator.Feature feature) {
        this._formatGeneratorFeatures &= ~feature.getMask();
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder disable(CBORGenerator.Feature feature, CBORGenerator.Feature ... featureArray) {
        this._formatGeneratorFeatures &= ~feature.getMask();
        for (CBORGenerator.Feature feature2 : featureArray) {
            this._formatGeneratorFeatures &= ~feature2.getMask();
        }
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder configure(CBORGenerator.Feature feature, boolean bl) {
        return bl ? this.enable(feature) : this.disable(feature);
    }

    public int formatParserFeaturesMask() {
        return this._formatParserFeatures;
    }

    public int formatGeneratorFeaturesMask() {
        return this._formatGeneratorFeatures;
    }

    @Override
    public CBORFactory build() {
        return new CBORFactory(this);
    }
}

