/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.fasterxml.jackson.databind.ser.std.ByteArraySerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;

public class StdArraySerializers {
    protected static final HashMap<String, JsonSerializer<?>> _arraySerializers = new HashMap();

    protected StdArraySerializers() {
    }

    public static JsonSerializer<?> findStandardImpl(Class<?> clazz) {
        return _arraySerializers.get(clazz.getName());
    }

    static {
        _arraySerializers.put(boolean[].class.getName(), new BooleanArraySerializer());
        _arraySerializers.put(byte[].class.getName(), new ByteArraySerializer());
        _arraySerializers.put(char[].class.getName(), new CharArraySerializer());
        _arraySerializers.put(short[].class.getName(), new ShortArraySerializer());
        _arraySerializers.put(int[].class.getName(), new IntArraySerializer());
        _arraySerializers.put(long[].class.getName(), new LongArraySerializer());
        _arraySerializers.put(float[].class.getName(), new FloatArraySerializer());
        _arraySerializers.put(double[].class.getName(), new DoubleArraySerializer());
    }

    @JacksonStdImpl
    public static class DoubleArraySerializer
    extends ArraySerializerBase<double[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Double.TYPE);

        public DoubleArraySerializer() {
            super(double[].class);
        }

        protected DoubleArraySerializer(DoubleArraySerializer doubleArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(doubleArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new DoubleArraySerializer(this, beanProperty, bl);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, double[] dArray) {
            return dArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(double[] dArray) {
            return dArray.length == 1;
        }

        @Override
        public final void serialize(double[] dArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = dArray.length;
            if (n == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(dArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeArray(dArray, 0, dArray.length);
        }

        @Override
        public void serializeContents(double[] dArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeNumber(dArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class FloatArraySerializer
    extends TypedPrimitiveArraySerializer<float[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Float.TYPE);

        public FloatArraySerializer() {
            super(float[].class);
        }

        public FloatArraySerializer(FloatArraySerializer floatArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(floatArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new FloatArraySerializer(this, beanProperty, bl);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, float[] fArray) {
            return fArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(float[] fArray) {
            return fArray.length == 1;
        }

        @Override
        public final void serialize(float[] fArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = fArray.length;
            if (n == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(fArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeStartArray(fArray, n);
            this.serializeContents(fArray, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        }

        @Override
        public void serializeContents(float[] fArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeNumber(fArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class LongArraySerializer
    extends TypedPrimitiveArraySerializer<long[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Long.TYPE);

        public LongArraySerializer() {
            super(long[].class);
        }

        public LongArraySerializer(LongArraySerializer longArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(longArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new LongArraySerializer(this, beanProperty, bl);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, long[] lArray) {
            return lArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(long[] lArray) {
            return lArray.length == 1;
        }

        @Override
        public final void serialize(long[] lArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = lArray.length;
            if (n == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(lArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeArray(lArray, 0, lArray.length);
        }

        @Override
        public void serializeContents(long[] lArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeNumber(lArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number", true));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class IntArraySerializer
    extends ArraySerializerBase<int[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Integer.TYPE);

        public IntArraySerializer() {
            super(int[].class);
        }

        protected IntArraySerializer(IntArraySerializer intArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(intArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new IntArraySerializer(this, beanProperty, bl);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, int[] nArray) {
            return nArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(int[] nArray) {
            return nArray.length == 1;
        }

        @Override
        public final void serialize(int[] nArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = nArray.length;
            if (n == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(nArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeArray(nArray, 0, nArray.length);
        }

        @Override
        public void serializeContents(int[] nArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeNumber(nArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class CharArraySerializer
    extends StdSerializer<char[]> {
        public CharArraySerializer() {
            super(char[].class);
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, char[] cArray) {
            return cArray.length == 0;
        }

        @Override
        public void serialize(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                jsonGenerator.writeStartArray(cArray, cArray.length);
                this._writeArrayContents(jsonGenerator, cArray);
                jsonGenerator.writeEndArray();
            } else {
                jsonGenerator.writeString(cArray, 0, cArray.length);
            }
        }

        @Override
        public void serializeWithType(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            WritableTypeId writableTypeId;
            boolean bl = serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS);
            if (bl) {
                writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(cArray, JsonToken.START_ARRAY));
                this._writeArrayContents(jsonGenerator, cArray);
            } else {
                writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(cArray, JsonToken.VALUE_STRING));
                jsonGenerator.writeString(cArray, 0, cArray.length);
            }
            typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
        }

        private final void _writeArrayContents(JsonGenerator jsonGenerator, char[] cArray) throws IOException {
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeString(cArray, i, 1);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            ObjectNode objectNode2 = this.createSchemaNode("string");
            objectNode2.put("type", "string");
            return objectNode.set("items", objectNode2);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.STRING);
        }
    }

    @JacksonStdImpl
    public static class ShortArraySerializer
    extends TypedPrimitiveArraySerializer<short[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Short.TYPE);

        public ShortArraySerializer() {
            super(short[].class);
        }

        public ShortArraySerializer(ShortArraySerializer shortArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(shortArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new ShortArraySerializer(this, beanProperty, bl);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, short[] sArray) {
            return sArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(short[] sArray) {
            return sArray.length == 1;
        }

        @Override
        public final void serialize(short[] sArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = sArray.length;
            if (n == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(sArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeStartArray(sArray, n);
            this.serializeContents(sArray, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        }

        @Override
        public void serializeContents(short[] sArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeNumber((int)sArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            return objectNode.set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class BooleanArraySerializer
    extends ArraySerializerBase<boolean[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Boolean.class);

        public BooleanArraySerializer() {
            super(boolean[].class);
        }

        protected BooleanArraySerializer(BooleanArraySerializer booleanArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(booleanArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new BooleanArraySerializer(this, beanProperty, bl);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, boolean[] blArray) {
            return blArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(boolean[] blArray) {
            return blArray.length == 1;
        }

        @Override
        public final void serialize(boolean[] blArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = blArray.length;
            if (n == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(blArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeStartArray(blArray, n);
            this.serializeContents(blArray, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        }

        @Override
        public void serializeContents(boolean[] blArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                jsonGenerator.writeBoolean(blArray[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            objectNode.set("items", this.createSchemaNode("boolean"));
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.BOOLEAN);
        }
    }

    protected static abstract class TypedPrimitiveArraySerializer<T>
    extends ArraySerializerBase<T> {
        protected TypedPrimitiveArraySerializer(Class<T> clazz) {
            super(clazz);
        }

        protected TypedPrimitiveArraySerializer(TypedPrimitiveArraySerializer<T> typedPrimitiveArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(typedPrimitiveArraySerializer, beanProperty, bl);
        }

        @Override
        public final ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }
    }
}

