/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ArrayNode
extends ContainerNode<ArrayNode>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<JsonNode> _children;

    public ArrayNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
        this._children = new ArrayList<JsonNode>();
    }

    public ArrayNode(JsonNodeFactory jsonNodeFactory, int n) {
        super(jsonNodeFactory);
        this._children = new ArrayList<JsonNode>(n);
    }

    public ArrayNode(JsonNodeFactory jsonNodeFactory, List<JsonNode> list) {
        super(jsonNodeFactory);
        this._children = list;
    }

    @Override
    protected JsonNode _at(JsonPointer jsonPointer) {
        return this.get(jsonPointer.getMatchingIndex());
    }

    public ArrayNode deepCopy() {
        ArrayNode arrayNode = new ArrayNode(this._nodeFactory);
        for (JsonNode jsonNode : this._children) {
            arrayNode._children.add((JsonNode)jsonNode.deepCopy());
        }
        return arrayNode;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public boolean isEmpty() {
        return this._children.isEmpty();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    @Override
    public JsonNode get(int n) {
        if (n >= 0 && n < this._children.size()) {
            return this._children.get(n);
        }
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return null;
    }

    @Override
    public JsonNode path(String string) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(int n) {
        if (n >= 0 && n < this._children.size()) {
            return this._children.get(n);
        }
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode required(int n) {
        if (n >= 0 && n < this._children.size()) {
            return this._children.get(n);
        }
        return (JsonNode)this._reportRequiredViolation("No value at index #%d [0, %d) of `ArrayNode`", n, this._children.size());
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator, JsonNode jsonNode) {
        if (!(jsonNode instanceof ArrayNode)) {
            return false;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        int n = this._children.size();
        if (arrayNode.size() != n) {
            return false;
        }
        List<JsonNode> list = this._children;
        List<JsonNode> list2 = arrayNode._children;
        for (int i = 0; i < n; ++i) {
            if (list.get(i).equals(comparator, list2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List<JsonNode> list = this._children;
        int n = list.size();
        jsonGenerator.writeStartArray(this, n);
        for (int i = 0; i < n; ++i) {
            JsonNode jsonNode = list.get(i);
            ((BaseJsonNode)jsonNode).serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(this, JsonToken.START_ARRAY));
        for (JsonNode jsonNode : this._children) {
            ((BaseJsonNode)jsonNode).serialize(jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    @Override
    public JsonNode findValue(String string) {
        for (JsonNode jsonNode : this._children) {
            JsonNode jsonNode2 = jsonNode.findValue(string);
            if (jsonNode2 == null) continue;
            return jsonNode2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findValues(string, list);
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findValuesAsText(string, list);
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        for (JsonNode jsonNode : this._children) {
            JsonNode jsonNode2 = jsonNode.findParent(string);
            if (jsonNode2 == null) continue;
            return (ObjectNode)jsonNode2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findParents(string, list);
        }
        return list;
    }

    public JsonNode set(int n, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        if (n < 0 || n >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + n + ", array size " + this.size());
        }
        return this._children.set(n, jsonNode);
    }

    public ArrayNode add(JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._add(jsonNode);
        return this;
    }

    public ArrayNode addAll(ArrayNode arrayNode) {
        this._children.addAll(arrayNode._children);
        return this;
    }

    public ArrayNode addAll(Collection<? extends JsonNode> collection) {
        for (JsonNode jsonNode : collection) {
            this.add(jsonNode);
        }
        return this;
    }

    public ArrayNode insert(int n, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._insert(n, jsonNode);
        return this;
    }

    public JsonNode remove(int n) {
        if (n >= 0 && n < this._children.size()) {
            return this._children.remove(n);
        }
        return null;
    }

    @Override
    public ArrayNode removeAll() {
        this._children.clear();
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode arrayNode = this.arrayNode();
        this._add(arrayNode);
        return arrayNode;
    }

    public ObjectNode addObject() {
        ObjectNode objectNode = this.objectNode();
        this._add(objectNode);
        return objectNode;
    }

    public ArrayNode addPOJO(Object object) {
        return this._add(object == null ? this.nullNode() : this.pojoNode(object));
    }

    public ArrayNode addRawValue(RawValue rawValue) {
        return this._add(rawValue == null ? this.nullNode() : this.rawValueNode(rawValue));
    }

    public ArrayNode addNull() {
        return this._add(this.nullNode());
    }

    public ArrayNode add(short s2) {
        return this._add(this.numberNode(s2));
    }

    public ArrayNode add(Short s2) {
        return this._add(s2 == null ? this.nullNode() : this.numberNode((short)s2));
    }

    public ArrayNode add(int n) {
        return this._add(this.numberNode(n));
    }

    public ArrayNode add(Integer n) {
        return this._add(n == null ? this.nullNode() : this.numberNode((int)n));
    }

    public ArrayNode add(long l) {
        return this._add(this.numberNode(l));
    }

    public ArrayNode add(Long l) {
        return this._add(l == null ? this.nullNode() : this.numberNode((long)l));
    }

    public ArrayNode add(float f) {
        return this._add(this.numberNode(f));
    }

    public ArrayNode add(Float f) {
        return this._add(f == null ? this.nullNode() : this.numberNode(f.floatValue()));
    }

    public ArrayNode add(double d) {
        return this._add(this.numberNode(d));
    }

    public ArrayNode add(Double d) {
        return this._add(d == null ? this.nullNode() : this.numberNode((double)d));
    }

    public ArrayNode add(BigDecimal bigDecimal) {
        return this._add(bigDecimal == null ? this.nullNode() : this.numberNode(bigDecimal));
    }

    public ArrayNode add(BigInteger bigInteger) {
        return this._add(bigInteger == null ? this.nullNode() : this.numberNode(bigInteger));
    }

    public ArrayNode add(String string) {
        return this._add(string == null ? this.nullNode() : this.textNode(string));
    }

    public ArrayNode add(boolean bl) {
        return this._add(this.booleanNode(bl));
    }

    public ArrayNode add(Boolean bl) {
        return this._add(bl == null ? this.nullNode() : this.booleanNode(bl));
    }

    public ArrayNode add(byte[] byArray) {
        return this._add(byArray == null ? this.nullNode() : this.binaryNode(byArray));
    }

    public ArrayNode insertArray(int n) {
        ArrayNode arrayNode = this.arrayNode();
        this._insert(n, arrayNode);
        return arrayNode;
    }

    public ObjectNode insertObject(int n) {
        ObjectNode objectNode = this.objectNode();
        this._insert(n, objectNode);
        return objectNode;
    }

    public ArrayNode insertNull(int n) {
        return this._insert(n, this.nullNode());
    }

    public ArrayNode insertPOJO(int n, Object object) {
        return this._insert(n, object == null ? this.nullNode() : this.pojoNode(object));
    }

    public ArrayNode insertRawValue(int n, RawValue rawValue) {
        return this._insert(n, rawValue == null ? this.nullNode() : this.rawValueNode(rawValue));
    }

    public ArrayNode insert(int n, short s2) {
        return this._insert(n, this.numberNode(s2));
    }

    public ArrayNode insert(int n, Short s2) {
        return this._insert(n, s2 == null ? this.nullNode() : this.numberNode((short)s2));
    }

    public ArrayNode insert(int n, int n2) {
        return this._insert(n, this.numberNode(n2));
    }

    public ArrayNode insert(int n, Integer n2) {
        return this._insert(n, n2 == null ? this.nullNode() : this.numberNode((int)n2));
    }

    public ArrayNode insert(int n, long l) {
        return this._insert(n, this.numberNode(l));
    }

    public ArrayNode insert(int n, Long l) {
        return this._insert(n, l == null ? this.nullNode() : this.numberNode((long)l));
    }

    public ArrayNode insert(int n, float f) {
        return this._insert(n, this.numberNode(f));
    }

    public ArrayNode insert(int n, Float f) {
        return this._insert(n, f == null ? this.nullNode() : this.numberNode(f.floatValue()));
    }

    public ArrayNode insert(int n, double d) {
        return this._insert(n, this.numberNode(d));
    }

    public ArrayNode insert(int n, Double d) {
        return this._insert(n, d == null ? this.nullNode() : this.numberNode((double)d));
    }

    public ArrayNode insert(int n, BigDecimal bigDecimal) {
        return this._insert(n, bigDecimal == null ? this.nullNode() : this.numberNode(bigDecimal));
    }

    public ArrayNode insert(int n, BigInteger bigInteger) {
        return this._insert(n, bigInteger == null ? this.nullNode() : this.numberNode(bigInteger));
    }

    public ArrayNode insert(int n, String string) {
        return this._insert(n, string == null ? this.nullNode() : this.textNode(string));
    }

    public ArrayNode insert(int n, boolean bl) {
        return this._insert(n, this.booleanNode(bl));
    }

    public ArrayNode insert(int n, Boolean bl) {
        if (bl == null) {
            return this.insertNull(n);
        }
        return this._insert(n, this.booleanNode(bl));
    }

    public ArrayNode insert(int n, byte[] byArray) {
        if (byArray == null) {
            return this.insertNull(n);
        }
        return this._insert(n, this.binaryNode(byArray));
    }

    public ArrayNode setNull(int n) {
        return this._set(n, this.nullNode());
    }

    public ArrayNode setPOJO(int n, Object object) {
        return this._set(n, object == null ? this.nullNode() : this.pojoNode(object));
    }

    public ArrayNode setRawValue(int n, RawValue rawValue) {
        return this._set(n, rawValue == null ? this.nullNode() : this.rawValueNode(rawValue));
    }

    public ArrayNode set(int n, short s2) {
        return this._set(n, this.numberNode(s2));
    }

    public ArrayNode set(int n, Short s2) {
        return this._set(n, s2 == null ? this.nullNode() : this.numberNode((short)s2));
    }

    public ArrayNode set(int n, int n2) {
        return this._set(n, this.numberNode(n2));
    }

    public ArrayNode set(int n, Integer n2) {
        return this._set(n, n2 == null ? this.nullNode() : this.numberNode((int)n2));
    }

    public ArrayNode set(int n, long l) {
        return this._set(n, this.numberNode(l));
    }

    public ArrayNode set(int n, Long l) {
        return this._set(n, l == null ? this.nullNode() : this.numberNode((long)l));
    }

    public ArrayNode set(int n, float f) {
        return this._set(n, this.numberNode(f));
    }

    public ArrayNode set(int n, Float f) {
        return this._set(n, f == null ? this.nullNode() : this.numberNode(f.floatValue()));
    }

    public ArrayNode set(int n, double d) {
        return this._set(n, this.numberNode(d));
    }

    public ArrayNode set(int n, Double d) {
        return this._set(n, d == null ? this.nullNode() : this.numberNode((double)d));
    }

    public ArrayNode set(int n, BigDecimal bigDecimal) {
        return this._set(n, bigDecimal == null ? this.nullNode() : this.numberNode(bigDecimal));
    }

    public ArrayNode set(int n, BigInteger bigInteger) {
        return this._set(n, bigInteger == null ? this.nullNode() : this.numberNode(bigInteger));
    }

    public ArrayNode set(int n, String string) {
        return this._set(n, string == null ? this.nullNode() : this.textNode(string));
    }

    public ArrayNode set(int n, boolean bl) {
        return this._set(n, this.booleanNode(bl));
    }

    public ArrayNode set(int n, Boolean bl) {
        return this._set(n, bl == null ? this.nullNode() : this.booleanNode(bl));
    }

    public ArrayNode set(int n, byte[] byArray) {
        return this._set(n, byArray == null ? this.nullNode() : this.binaryNode(byArray));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ArrayNode) {
            return this._children.equals(((ArrayNode)object)._children);
        }
        return false;
    }

    protected boolean _childrenEqual(ArrayNode arrayNode) {
        return this._children.equals(arrayNode._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    protected ArrayNode _set(int n, JsonNode jsonNode) {
        if (n < 0 || n >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + n + ", array size " + this.size());
        }
        this._children.set(n, jsonNode);
        return this;
    }

    protected ArrayNode _add(JsonNode jsonNode) {
        this._children.add(jsonNode);
        return this;
    }

    protected ArrayNode _insert(int n, JsonNode jsonNode) {
        if (n < 0) {
            this._children.add(0, jsonNode);
        } else if (n >= this._children.size()) {
            this._children.add(jsonNode);
        } else {
            this._children.add(n, jsonNode);
        }
        return this;
    }
}

