/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.jdk14.JDK14Util;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class DefaultAccessorNamingStrategy
extends AccessorNamingStrategy {
    protected final MapperConfig<?> _config;
    protected final AnnotatedClass _forClass;
    protected final BaseNameValidator _baseNameValidator;
    protected final boolean _stdBeanNaming;
    protected final String _getterPrefix;
    protected final String _isGetterPrefix;
    protected final String _mutatorPrefix;

    protected DefaultAccessorNamingStrategy(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, String string, String string2, String string3, BaseNameValidator baseNameValidator) {
        this._config = mapperConfig;
        this._forClass = annotatedClass;
        this._stdBeanNaming = mapperConfig.isEnabled(MapperFeature.USE_STD_BEAN_NAMING);
        this._mutatorPrefix = string;
        this._getterPrefix = string2;
        this._isGetterPrefix = string3;
        this._baseNameValidator = baseNameValidator;
    }

    @Override
    public String findNameForIsGetter(AnnotatedMethod annotatedMethod, String string) {
        Class<?> clazz;
        if (this._isGetterPrefix != null && ((clazz = annotatedMethod.getRawType()) == Boolean.class || clazz == Boolean.TYPE) && string.startsWith(this._isGetterPrefix)) {
            return this._stdBeanNaming ? this.stdManglePropertyName(string, 2) : this.legacyManglePropertyName(string, 2);
        }
        return null;
    }

    @Override
    public String findNameForRegularGetter(AnnotatedMethod annotatedMethod, String string) {
        if (this._getterPrefix != null && string.startsWith(this._getterPrefix)) {
            if ("getCallbacks".equals(string) ? this._isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string) && this._isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            return this._stdBeanNaming ? this.stdManglePropertyName(string, this._getterPrefix.length()) : this.legacyManglePropertyName(string, this._getterPrefix.length());
        }
        return null;
    }

    @Override
    public String findNameForMutator(AnnotatedMethod annotatedMethod, String string) {
        if (this._mutatorPrefix != null && string.startsWith(this._mutatorPrefix)) {
            return this._stdBeanNaming ? this.stdManglePropertyName(string, this._mutatorPrefix.length()) : this.legacyManglePropertyName(string, this._mutatorPrefix.length());
        }
        return null;
    }

    @Override
    public String modifyFieldName(AnnotatedField annotatedField, String string) {
        return string;
    }

    protected String legacyManglePropertyName(String string, int n) {
        int n2 = string.length();
        if (n2 == n) {
            return null;
        }
        char c = string.charAt(n);
        if (this._baseNameValidator != null && !this._baseNameValidator.accept(c, string, n)) {
            return null;
        }
        char c2 = Character.toLowerCase(c);
        if (c == c2) {
            return string.substring(n);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 - n);
        stringBuilder.append(c2);
        for (int i = n + 1; i < n2; ++i) {
            c = string.charAt(i);
            if (c == (c2 = Character.toLowerCase(c))) {
                stringBuilder.append(string, i, n2);
                break;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    protected String stdManglePropertyName(String string, int n) {
        int n2 = string.length();
        if (n2 == n) {
            return null;
        }
        char c = string.charAt(n);
        if (this._baseNameValidator != null && !this._baseNameValidator.accept(c, string, n)) {
            return null;
        }
        char c2 = Character.toLowerCase(c);
        if (c == c2) {
            return string.substring(n);
        }
        if (n + 1 < n2 && Character.isUpperCase(string.charAt(n + 1))) {
            return string.substring(n);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 - n);
        stringBuilder.append(c2);
        stringBuilder.append(string, n + 1, n2);
        return stringBuilder.toString();
    }

    protected boolean _isCglibGetCallbacks(AnnotatedMethod annotatedMethod) {
        Class<?> clazz;
        String string;
        Class<?> clazz2 = annotatedMethod.getRawType();
        if (clazz2.isArray() && (string = (clazz = clazz2.getComponentType()).getName()).contains(".cglib")) {
            return string.startsWith("net.sf.cglib") || string.startsWith("org.hibernate.repackage.cglib") || string.startsWith("org.springframework.cglib");
        }
        return false;
    }

    protected boolean _isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        return annotatedMethod.getRawType().getName().startsWith("groovy.lang");
    }

    public static class RecordNaming
    extends DefaultAccessorNamingStrategy {
        protected final Set<String> _fieldNames = new HashSet<String>();

        public RecordNaming(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
            super(mapperConfig, annotatedClass, null, "get", "is", null);
            for (String string : JDK14Util.getRecordFieldNames(annotatedClass.getRawType())) {
                this._fieldNames.add(string);
            }
        }

        @Override
        public String findNameForRegularGetter(AnnotatedMethod annotatedMethod, String string) {
            if (this._fieldNames.contains(string)) {
                return string;
            }
            return super.findNameForRegularGetter(annotatedMethod, string);
        }
    }

    public static class FirstCharBasedValidator
    implements BaseNameValidator {
        private final boolean _allowLowerCaseFirstChar;
        private final boolean _allowNonLetterFirstChar;

        protected FirstCharBasedValidator(boolean bl, boolean bl2) {
            this._allowLowerCaseFirstChar = bl;
            this._allowNonLetterFirstChar = bl2;
        }

        public static BaseNameValidator forFirstNameRule(boolean bl, boolean bl2) {
            if (!bl && !bl2) {
                return null;
            }
            return new FirstCharBasedValidator(bl, bl2);
        }

        @Override
        public boolean accept(char c, String string, int n) {
            if (Character.isLetter(c)) {
                return this._allowLowerCaseFirstChar || !Character.isLowerCase(c);
            }
            return this._allowNonLetterFirstChar;
        }
    }

    public static class Provider
    extends AccessorNamingStrategy.Provider
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final String _setterPrefix;
        protected final String _withPrefix;
        protected final String _getterPrefix;
        protected final String _isGetterPrefix;
        protected final BaseNameValidator _baseNameValidator;

        public Provider() {
            this("set", "with", "get", "is", null);
        }

        protected Provider(Provider provider, String string, String string2, String string3, String string4) {
            this(string, string2, string3, string4, provider._baseNameValidator);
        }

        protected Provider(Provider provider, BaseNameValidator baseNameValidator) {
            this(provider._setterPrefix, provider._withPrefix, provider._getterPrefix, provider._isGetterPrefix, baseNameValidator);
        }

        protected Provider(String string, String string2, String string3, String string4, BaseNameValidator baseNameValidator) {
            this._setterPrefix = string;
            this._withPrefix = string2;
            this._getterPrefix = string3;
            this._isGetterPrefix = string4;
            this._baseNameValidator = baseNameValidator;
        }

        public Provider withSetterPrefix(String string) {
            return new Provider(this, string, this._withPrefix, this._getterPrefix, this._isGetterPrefix);
        }

        public Provider withBuilderPrefix(String string) {
            return new Provider(this, this._setterPrefix, string, this._getterPrefix, this._isGetterPrefix);
        }

        public Provider withGetterPrefix(String string) {
            return new Provider(this, this._setterPrefix, this._withPrefix, string, this._isGetterPrefix);
        }

        public Provider withIsGetterPrefix(String string) {
            return new Provider(this, this._setterPrefix, this._withPrefix, this._getterPrefix, string);
        }

        public Provider withFirstCharAcceptance(boolean bl, boolean bl2) {
            return this.withBaseNameValidator(FirstCharBasedValidator.forFirstNameRule(bl, bl2));
        }

        public Provider withBaseNameValidator(BaseNameValidator baseNameValidator) {
            return new Provider(this, baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forPOJO(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
            return new DefaultAccessorNamingStrategy(mapperConfig, annotatedClass, this._setterPrefix, this._getterPrefix, this._isGetterPrefix, this._baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forBuilder(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, BeanDescription beanDescription) {
            AnnotationIntrospector annotationIntrospector = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
            JsonPOJOBuilder.Value value = annotationIntrospector == null ? null : annotationIntrospector.findPOJOBuilderConfig(annotatedClass);
            String string = value == null ? this._withPrefix : value.withPrefix;
            return new DefaultAccessorNamingStrategy(mapperConfig, annotatedClass, string, this._getterPrefix, this._isGetterPrefix, this._baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forRecord(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
            return new RecordNaming(mapperConfig, annotatedClass);
        }
    }

    public static interface BaseNameValidator {
        public boolean accept(char var1, String var2, int var3);
    }
}

