/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;

public final class CreatorCandidate {
    protected final AnnotationIntrospector _intr;
    protected final AnnotatedWithParams _creator;
    protected final int _paramCount;
    protected final Param[] _params;

    protected CreatorCandidate(AnnotationIntrospector annotationIntrospector, AnnotatedWithParams annotatedWithParams, Param[] paramArray, int n) {
        this._intr = annotationIntrospector;
        this._creator = annotatedWithParams;
        this._params = paramArray;
        this._paramCount = n;
    }

    public static CreatorCandidate construct(AnnotationIntrospector annotationIntrospector, AnnotatedWithParams annotatedWithParams, BeanPropertyDefinition[] beanPropertyDefinitionArray) {
        int n = annotatedWithParams.getParameterCount();
        Param[] paramArray = new Param[n];
        for (int i = 0; i < n; ++i) {
            AnnotatedParameter annotatedParameter = annotatedWithParams.getParameter(i);
            JacksonInject.Value value = annotationIntrospector.findInjectableValue(annotatedParameter);
            paramArray[i] = new Param(annotatedParameter, beanPropertyDefinitionArray == null ? null : beanPropertyDefinitionArray[i], value);
        }
        return new CreatorCandidate(annotationIntrospector, annotatedWithParams, paramArray, n);
    }

    public AnnotatedWithParams creator() {
        return this._creator;
    }

    public int paramCount() {
        return this._paramCount;
    }

    public JacksonInject.Value injection(int n) {
        return this._params[n].injection;
    }

    public AnnotatedParameter parameter(int n) {
        return this._params[n].annotated;
    }

    public BeanPropertyDefinition propertyDef(int n) {
        return this._params[n].propDef;
    }

    public PropertyName paramName(int n) {
        BeanPropertyDefinition beanPropertyDefinition = this._params[n].propDef;
        if (beanPropertyDefinition != null) {
            return beanPropertyDefinition.getFullName();
        }
        return null;
    }

    public PropertyName explicitParamName(int n) {
        BeanPropertyDefinition beanPropertyDefinition = this._params[n].propDef;
        if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed()) {
            return beanPropertyDefinition.getFullName();
        }
        return null;
    }

    public PropertyName findImplicitParamName(int n) {
        String string = this._intr.findImplicitPropertyName(this._params[n].annotated);
        if (string != null && !string.isEmpty()) {
            return PropertyName.construct(string);
        }
        return null;
    }

    public int findOnlyParamWithoutInjection() {
        int n = -1;
        for (int i = 0; i < this._paramCount; ++i) {
            if (this._params[i].injection != null) continue;
            if (n >= 0) {
                return -1;
            }
            n = i;
        }
        return n;
    }

    public String toString() {
        return this._creator.toString();
    }

    public static final class Param {
        public final AnnotatedParameter annotated;
        public final BeanPropertyDefinition propDef;
        public final JacksonInject.Value injection;

        public Param(AnnotatedParameter annotatedParameter, BeanPropertyDefinition beanPropertyDefinition, JacksonInject.Value value) {
            this.annotated = annotatedParameter;
            this.propDef = beanPropertyDefinition;
            this.injection = value;
        }

        public PropertyName fullName() {
            if (this.propDef == null) {
                return null;
            }
            return this.propDef.getFullName();
        }

        public boolean hasFullName() {
            if (this.propDef == null) {
                return false;
            }
            PropertyName propertyName = this.propDef.getFullName();
            return propertyName.hasSimpleName();
        }
    }
}

